###############################################
## Univariate CFA tests for sweep 10 data #####
###############################################

# Packages
library(dplyr)
library(lavaan)

## Import and clean data
source("M:/A-matter-of-perspective-code/sw8-clean-function.R")
root <- "M:/GUS Data Files/GUStabs" # replace with your file system location
data <- sw8clean(root)

## General fit model

# f1 = conduct problems
# f2 = hyperactivity
# f3 = emotional problems
# f4 = peer problems
# f5 = pro social

##### 5 factor mode, teacher reported data
tpath <- '
  f1 =~ ThSDQ05 + ThSDQ07 + ThSDQ12 + ThSDQ18 + ThSDQ22
  f2 =~ ThSDQ02 + ThSDQ10 + ThSDQ15 + ThSDQ21 + ThSDQ25
  f3 =~ ThSDQ03 + ThSDQ08 + ThSDQ13 + ThSDQ16 + ThSDQ24
  f4 =~ ThSDQ06 + ThSDQ11 + ThSDQ14 + ThSDQ19 + ThSDQ23
  f5 =~ ThSDQ01 + ThSDQ04 + ThSDQ09 + ThSDQ17 + ThSDQ20
'
# Model fit
fit_tpath <- cfa(tpath, data=data, estimator="MLR")
summary(fit_tpath, standardized=TRUE, fit.measures=TRUE)
fitmeasures(fit_tpath, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr"))

# 5 factor model, parent reported data in Sweep 8
mpath <- '
  f1 =~ MhSDQ05 + MhSDQ07 + MhSDQ12 + MhSDQ18 + MhSDQ22
  f2 =~ MhSDQ02 + MhSDQ10 + MhSDQ15 + MhSDQ21 + MhSDQ25
  f3 =~ MhSDQ03 + MhSDQ08 + MhSDQ13 + MhSDQ16 + MhSDQ24
  f4 =~ MhSDQ06 + MhSDQ11 + MhSDQ14 + MhSDQ19 + MhSDQ23
  f5 =~ MhSDQ01 + MhSDQ04 + MhSDQ09 + MhSDQ17 + MhSDQ20
'
# Model fit
fit_mpath <- cfa(mpath, data=data, estimator="MLR")
summary(fit_mpath, standardized=TRUE, fit.measures=TRUE)
fitmeasures(fit_mpath, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr"))

##################################################################
#### Univariate CFA for each component         ###################
##################################################################

## teacher-reported pro-social
c1a <-'f5 =~ ThSDQ01 + ThSDQ04 + ThSDQ09 + ThSDQ17 + ThSDQ20'
onefac_pro_c <- cfa(c1a, data=data, estimator="MLR")
summary(onefac_pro_c, standardized=TRUE, fit.measures=TRUE)
fitmeasures(onefac_pro_c, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr"))

## Parent-reported pro-social
m1a <-'f5 =~ MhSDQ01 + MhSDQ04 + MhSDQ09 + MhSDQ17 + MhSDQ20'
onefac_pro_m <- cfa(m1a, data=data, estimator="MLR")
summary(onefac_pro_m, standardized=TRUE, fit.measures=TRUE)
fitmeasures(onefac_pro_m, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr"))

## teacher reported peer problems
c2a <- 'f4 =~ ThSDQ06 + ThSDQ11 + ThSDQ14 + ThSDQ19 + ThSDQ23'
onefac_peer_c <- cfa(c2a, data=data, estimator="MLR")
summary(onefac_peer_c, standardized=TRUE, fit.measures=TRUE)
fitmeasures(onefac_peer_c, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr"))

## Parent reported peer problems
m2a <- 'f4 =~ MhSDQ06 + MhSDQ11 + MhSDQ14 + MhSDQ19 + MhSDQ23'
onefac_peer_m <- cfa(m2a, data=data, estimator="MLR")
summary(onefac_peer_m, standardized=TRUE, fit.measures=TRUE)
fitmeasures(onefac_peer_m, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr"))

## teacher reported emotional difficulties
c3a <- 'f3 =~ ThSDQ03 + ThSDQ08 + ThSDQ13 + ThSDQ16 + ThSDQ24'
onefac_emo_c <- cfa(c3a, data=data, estimator="MLR")
summary(onefac_emo_c, standardized=TRUE, fit.measures=TRUE)
fitmeasures(onefac_emo_c, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr"))

## Parent reported emotional difficulties
m3a <- 'f3 =~ MhSDQ03 + MhSDQ08 + MhSDQ13 + MhSDQ16 + MhSDQ24'
onefac_emo_m <- cfa(m3a, data=data, estimator="MLR")
summary(onefac_emo_m, standardized=TRUE, fit.measures=TRUE)
fitmeasures(onefac_emo_m, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr"))

## teacher reported conduct problems
c4a <- 'f1 =~ ThSDQ05 + ThSDQ07 + ThSDQ12 + ThSDQ18 + ThSDQ22'
onefac_conduct_c <- cfa(c4a, data=data, estimator="MLR")
summary(onefac_conduct_c, standardized=TRUE, fit.measures=TRUE)
fitmeasures(onefac_conduct_c, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr"))

## Parent reported conduct problems
m4a <- 'f1 =~ MhSDQ05 + MhSDQ07 + MhSDQ12 + MhSDQ18 + MhSDQ22'
onefac_conduct_m <- cfa(m4a, data=data, estimator="MLR")
summary(onefac_conduct_m, standardized=TRUE, fit.measures=TRUE)
fitmeasures(onefac_conduct_m, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr")) 

## teacher reported hyperactivity
c5a <- 'f2 =~ ThSDQ02 + ThSDQ10 + ThSDQ15 + ThSDQ21 + ThSDQ25'
onefac_hyper_c <- cfa(c5a, data=data, estimator="MLR")
summary(onefac_hyper_c, standardized=TRUE, fit.measures=TRUE)
fitmeasures(onefac_hyper_c, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr"))

## Parent reported hyperactivity
m5a <- 'f2 =~ MhSDQ02 + MhSDQ10 + MhSDQ15 + MhSDQ21 + MhSDQ25'
onefac_hyper_m <- cfa(m5a, data=data, estimator="MLR")
summary(onefac_hyper_m, standardized=TRUE, fit.measures=TRUE)
fitmeasures(onefac_hyper_m, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr"))
