###############################################
## Univariate CFA tests for sweep 10 data #####
###############################################

# Packages
library(dplyr)
library(lavaan)

## Import and clean data
source("M:/A-matter-of-perspective-code/sw10-clean-function.R")
root <- "M:/GUS Data Files/GUStabs" # replace with your file system location
data <- sw10clean(root)

## General fit model

# f1 = conduct problems
# f2 = hyperactivity
# f3 = emotional problems
# f4 = peer problems
# f5 = pro social

#### 5 factor model, adolescent reported data
cpath <- '
  f1 =~ CjSDQ05 + CjSDQ07 + CjSDQ12 + CjSDQ18 + CjSDQ22
  f2 =~ CjSDQ02 + CjSDQ10 + CjSDQ15 + CjSDQ21 + CjSDQ25
  f3 =~ CjSDQ03 + CjSDQ08 + CjSDQ13 + CjSDQ16 + CjSDQ24
  f4 =~ CjSDQ06 + CjSDQ11 + CjSDQ14 + CjSDQ19 + CjSDQ23
  f5 =~ CjSDQ01 + CjSDQ04 + CjSDQ09 + CjSDQ17 + CjSDQ20
'
# Model fit
fit_cpath <- cfa(cpath, data=data, estimator="MLR")
summary(fit_cpath, standardized=TRUE, fit.measures=TRUE)
fitmeasures(fit_cpath, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr"))

#### 5 factor model, parent reported data in Sweep 10
mpath <- '
  f1 =~ MjSDQ05 + MjSDQ07 + MjSDQ12 + MjSDQ18 + MjSDQ22
  f2 =~ MjSDQ02 + MjSDQ10 + MjSDQ15 + MjSDQ21 + MjSDQ25
  f3 =~ MjSDQ03 + MjSDQ08 + MjSDQ13 + MjSDQ16 + MjSDQ24
  f4 =~ MjSDQ06 + MjSDQ11 + MjSDQ14 + MjSDQ19 + MjSDQ23
  f5 =~ MjSDQ01 + MjSDQ04 + MjSDQ09 + MjSDQ17 + MjSDQ20
'
# Model fit
fit_mpath <- cfa(mpath, data=data, estimator="MLR")
summary(fit_mpath, standardized=TRUE, fit.measures=TRUE)
fitmeasures(fit_mpath, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr"))


##################################################################
#### Univariate CFA for each component         ###################
##################################################################


## Adolescent-reported pro-social
c1a <-'f5 =~ CjSDQ01 + CjSDQ04 + CjSDQ09 + CjSDQ17 + CjSDQ20'
onefac_pro_c <- cfa(c1a, data=data, estimator="MLR")
summary(onefac_pro_c, standardized=TRUE, fit.measures=TRUE)
fitmeasures(onefac_pro_c, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr"))

## Parent-reported pro-social
m1a <-'f5 =~ MjSDQ01 + MjSDQ04 + MjSDQ09 + MjSDQ17 + MjSDQ20'
onefac_pro_m <- cfa(m1a, data=data, estimator="MLR")
summary(onefac_pro_m, standardized=TRUE, fit.measures=TRUE)
fitmeasures(onefac_pro_m, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr"))

## Adolescent reported peer problems
c2a <- 'f4 =~ CjSDQ06 + CjSDQ11 + CjSDQ14 + CjSDQ19 + CjSDQ23'
onefac_peer_c <- cfa(c2a, data=data, estimator="MLR")
summary(onefac_peer_c, standardized=TRUE, fit.measures=TRUE)
fitmeasures(onefac_peer_c, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr"))

## Parent reported peer problems
m2a <- 'f4 =~ MjSDQ06 + MjSDQ11 + MjSDQ14 + MjSDQ19 + MjSDQ23'
onefac_peer_m <- cfa(m2a, data=data, estimator="MLR")
summary(onefac_peer_m, standardized=TRUE, fit.measures=TRUE)
fitmeasures(onefac_peer_m, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr"))

## Adolescent reported emotional difficulties
c3a <- 'f3 =~ CjSDQ03 + CjSDQ08 + CjSDQ13 + CjSDQ16 + CjSDQ24'
onefac_emo_c <- cfa(c3a, data=data, estimator="MLR")
summary(onefac_emo_c, standardized=TRUE, fit.measures=TRUE)
fitmeasures(onefac_emo_c, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr"))

## Parent reported emotional difficulties
m3a <- 'f3 =~ MjSDQ03 + MjSDQ08 + MjSDQ13 + MjSDQ16 + MjSDQ24'
onefac_emo_m <- cfa(m3a, data=data, estimator="MLR")
summary(onefac_emo_m, standardized=TRUE, fit.measures=TRUE)
fitmeasures(onefac_emo_m, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr"))

## Adolescent reported conduct problems
c4a <- 'f1 =~ CjSDQ05 + CjSDQ07 + CjSDQ12 + CjSDQ18 + CjSDQ22'
onefac_conduct_c <- cfa(c4a, data=data, estimator="MLR")
summary(onefac_conduct_c, standardized=TRUE, fit.measures=TRUE)
fitmeasures(onefac_conduct_c, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr"))

## Parent reported conduct problems
m4a <- 'f1 =~ MjSDQ05 + MjSDQ07 + MjSDQ12 + MjSDQ18 + MjSDQ22'
onefac_conduct_m <- cfa(m4a, data=data, estimator="MLR")
summary(onefac_conduct_m, standardized=TRUE, fit.measures=TRUE)
fitmeasures(onefac_conduct_m, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr")) 

## Adolescent reported hyperactivity
c5a <- 'f2 =~ CjSDQ02 + CjSDQ10 + CjSDQ15 + CjSDQ21 + CjSDQ25'
onefac_hyper_c <- cfa(c5a, data=data, estimator="MLR")
summary(onefac_hyper_c, standardized=TRUE, fit.measures=TRUE)
fitmeasures(onefac_hyper_c, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr"))

## Parent reported hyperactivity
m5a <- 'f2 =~ MjSDQ02 + MjSDQ10 + MjSDQ15 + MjSDQ21 + MjSDQ25'
onefac_hyper_m <- cfa(m5a, data=data, estimator="MLR")
summary(onefac_hyper_m, standardized=TRUE, fit.measures=TRUE)
fitmeasures(onefac_hyper_m, fit.measures = c("cfi.scaled", "rmsea.scaled", "srmr"))
