clear
set more off
set mem 400m

**************
*For country level analysis: Germany and UK are calculated separately in some years as they are divided in subsamples, and subsequently merged. For cyprus, data on the occupied territories are excluded from the analysis. 

use "$data\92.3 - 2019\SN383.dta", clear
drop if country==31 //drop countries not incuded in analysis
drop if country>32

*generate a variable for internet use.
fre d62t
recode d62t (1 2=1 "uses internet") (3 4=0 "never, no acc., no access at all"), gen (inter) 
fre inter
*Table 1
svyset  [pweight=w23]
svy: ta   country inter, row

svyset  [pweight=w3]
svy: ta   inter if country==4 | country==14 
*generate other variables    
mvdecode d1, mv(97 98)
fre d1
mvdecode d70, mv(5)
fre  d8
gen edu=d8
replace edu=d11 if edu==98
mvdecode edu, mv(0 99)

replace edu=0 if d8==97 //no full time education
fre edu
fre  qa1a_1

mvdecode qa1a_1, mv(5)

recode qa1a_1 (1=4 "Very good" ) (2=3 "Rather good") (3=2  "Rather bad") (4=1 "Very bad"), gen(cntsit) //reverse scale for country situation

recode d70 (1=4 "Very satisfied" ) (2=3 "Fairly satisfied") (3=2  "Not very satisfied") (4=1 "Not at all satisfied"), gen(lifesat) //reverse scale for life satisfaction

*calculate relative coverage bias (tables A1-A3) (note, absolute coverage bias calculated subsequently on the analysis do file)
foreach var of varlist d10 d11 edu lifesat cntsit {

bysort country: egen t_`var'=mean( `var') if inter==0

bysort country: egen `var'_ni=max(t_`var')

bysort country: egen `var'_all=mean(`var')

gen rc_b`var'=(`var'_ni-`var'_all)/`var'_all
by  country: summarize rc_b`var'

 }
 *Germany
 svyset  [pweight=w3]
foreach var of varlist d10 d11 edu lifesat cntsit  {
svy: mean rc_b`var' if country==4 | country==14
 }

 *eu
 svyset  [pweight=w23]
 foreach var of varlist  d10 d11 edu lifesat cntsit  {
svy: mean rc_b`var'  
 }

 
save "$cleandata\2019-clean.dta", replace

**************
use "$data\90.3 - 2018\SI374.dta", clear
fre d62t
fre country
drop if country==31
drop if country>32

list netuse d62t d62_1 d62_2 d62_3 d62_4 in 1/30, table  
ta netuse d62t

recode d62t (1 2=1 "uses internet") (3 4=0 "never, no acc., no access at all"), gen (inter)

svyset  [pweight=w23]
svy: ta   country inter, row

svyset  [pweight=w3]
svy: ta   inter if country==4 | country==14

ta   country inter, row nofreq

fre d1 d70 d8

mvdecode d1, mv(97 98)
fre d1
mvdecode d70, mv(5)
fre  d8
gen edu=d8
replace edu=d11 if edu==98
mvdecode edu, mv(0 99)

replace edu=0 if d8==97 //no full time education
fre edu
fre  qa1a_1
mvdecode qa1a_1, mv(5)


recode qa1a_1 (1=4 "Very good" ) (2=3 "Rather good") (3=2  "Rather bad") (4=1 "Very bad"), gen(cntsit)

recode d70 (1=4 "Very satisfied" ) (2=3 "Fairly satisfied") (3=2  "Not very satisfied") (4=1 "Not at all satisfied"), gen(lifesat)


*gender
/*
bysort country: egen t=mean(d10) if nointer==1

bysort country: egen sex_ni=max(at)

bysort country: egen sex_all=mean(d10)

gen arc_bsex=(sex_ni-sex_all)/sex_all
by  country: summarize rc_bsex
*/
foreach var of varlist d10 d11 edu lifesat cntsit {

bysort country: egen t_`var'=mean( `var') if inter==0

bysort country: egen `var'_ni=max(t_`var')

bysort country: egen `var'_all=mean(`var')

gen rc_b`var'=(`var'_ni-`var'_all)/`var'_all
by  country: summarize rc_b`var'

 }
 *Germany
svyset  [pweight=w3]
foreach var of varlist d10 d11 edu lifesat cntsit {
svy: mean rc_b`var' if country==4 | country==14 
 }

 *eu
svyset  [pweight=w23]
 foreach var of varlist d10 d11 edu lifesat cntsit {
svy: mean rc_b`var'  
 }

 save "$cleandata\2018-clean.dta", replace




 
**************
use "$data\88.3 - 2017\SI365.dta", clear
drop if country==31
drop if country>32

fre d62t

list netuse d62t d62_1 d62_2 d62_3  in 1/30, table  
ta netuse d62t

recode d62t (1 2=1 "uses internet") (3 4=0 "never, no acc., no access at all"), gen (inter)

svyset  [pweight=w23]
svy: ta   country inter, row
*DE
svyset  [pweight=w3]
svy: ta   inter if country==4 | country==14
*UK
svyset  [pweight=w4]
svy: ta   inter if country==9 | country==10

ta   country inter, row nofreq

fre  d8
gen edu=d8
replace edu=d11 if edu==98
mvdecode edu, mv(0 99)

replace edu=0 if d8==97 //no full time education
fre edu

fre  qa1a_1
mvdecode qa1a_1, mv(5)
recode qa1a_1 (1=4 "Very good" ) (2=3 "Rather good") (3=2  "Rather bad") (4=1 "Very bad"), gen(cntsit)
mvdecode d70, mv(5)
recode d70 (1=4 "Very satisfied" ) (2=3 "Fairly satisfied") (3=2  "Not very satisfied") (4=1 "Not at all satisfied"), gen(lifesat)

*gender
/*
bysort country: egen t=mean(d10) if nointer==1

bysort country: egen sex_ni=max(at)

bysort country: egen sex_all=mean(d10)

gen arc_bsex=(sex_ni-sex_all)/sex_all
by  country: summarize rc_bsex
*/
foreach var of varlist d10 d11 edu lifesat cntsit {

bysort country: egen t_`var'=mean( `var') if inter==0

bysort country: egen `var'_ni=max(t_`var')

bysort country: egen `var'_all=mean(`var')

gen rc_b`var'=(`var'_ni-`var'_all)/`var'_all
by  country: summarize rc_b`var' if country!=4 & country!=9  & country!=10   & country!=14

 }
 *Germany
svyset  [pweight=w3]
foreach var of varlist d10 d11 edu lifesat cntsit {
svy: mean rc_b`var' if country==4 | country==14 
 }

 *UK
 svyset  [pweight=w4]
 foreach var of varlist d10 d11 edu lifesat cntsit {
svy: mean rc_b`var' if country==9 | country==10
 }
 
 *eu
svyset  [pweight=w23]
 foreach var of varlist d10 d11 edu lifesat cntsit {
svy: mean rc_b`var'  
 }
 
 save "$cleandata\2017-clean.dta", replace



**************
use "$data\86.2 -2016\SI359.dta" , clear
fre country
drop if country==31
drop if country>32

fre d62t1
list  d62t1 d62_1 d62_2 d62_3  in 1/30, table  

recode d62t1 (1 2=1 "uses internet") (3 4=0 "never, no acc., no access at all"), gen (inter)

svyset  [pweight=w23]
svy: ta   country inter, row
*DE
svyset  [pweight=w3]
svy: ta   inter if country==4 | country==14
*UK
svyset  [pweight=w4]
svy: ta   inter if country==9 | country==10

fre  d8

gen edu=d8
drop if edu==.a //different type of missing values
drop if edu==.b //different type of missing values
replace edu=d11 if edu==98
mvdecode edu, mv(0 99 )

replace edu=0 if d8==97 //no full time education

fre  qa1a_1
mvdecode qa1a_1, mv(5)
drop if qa1a_1==.a
recode qa1a_1 (1=4 "Very good" ) (2=3 "Rather good") (3=2  "Rather bad") (4=1 "Very bad"), gen(cntsit)
mvdecode d70, mv(5)
drop if d70==.a
recode d70 (1=4 "Very satisfied" ) (2=3 "Fairly satisfied") (3=2  "Not very satisfied") (4=1 "Not at all satisfied"), gen(lifesat)

*gender
/*
bysort country: egen t=mean(d10) if nointer==1

bysort country: egen sex_ni=max(at)

bysort country: egen sex_all=mean(d10)

gen arc_bsex=(sex_ni-sex_all)/sex_all
by  country: summarize rc_bsex
*/
foreach var of varlist d10 d11 edu lifesat cntsit {

bysort country: egen t_`var'=mean( `var') if inter==0

bysort country: egen `var'_ni=max(t_`var')

bysort country: egen `var'_all=mean(`var')

gen rc_b`var'=(`var'_ni-`var'_all)/`var'_all
by  country: summarize rc_b`var' if country!=4 & country!=9  & country!=10   & country!=14

 }
 *Germany
svyset  [pweight=w3]
foreach var of varlist d10 d11 edu lifesat cntsit {
svy: mean rc_b`var' if country==4 | country==14 
 }

 *UK
 svyset  [pweight=w4]
 foreach var of varlist d10 d11 edu lifesat cntsit {
svy: mean rc_b`var' if country==9 | country==10
 }
 
 *eu
svyset  [pweight=w23]
 foreach var of varlist d10 d11 edu lifesat cntsit {
svy: mean rc_b`var'  
 }
 save "$cleandata\2016-clean.dta", replace



**************
use "$data\84.3 - 2015\SI353.dta", clear
drop if country==31
drop if country>32

fre d62t1
list  d62t1 d62_1 d62_2 d62_3  in 1/30, table  
recode d62t1 (1 2=1 "uses internet") (3 4=0 "never, no acc., no access at all"), gen (inter)
svyset  [pweight=w23]
svy: ta   country inter, row

svyset  [pweight=w3]
svy: ta   inter if country==4 | country==14

svyset  [pweight=w4]
svy: ta   inter if country==9 | country==10

ta   country inter, row nofreq

fre  d8
gen edu=d8
drop if edu==.d //different type of missing values
drop if edu==.r //different type of missing values
replace edu=d11 if edu==98
replace edu=0 if d8==97 //no full time education

fre  qa1a_1
drop if qa1a_1==.d
recode qa1a_1 (1=4 "Very good" ) (2=3 "Rather good") (3=2  "Rather bad") (4=1 "Very bad"), gen(cntsit)
drop if d70==.d
recode d70 (1=4 "Very satisfied" ) (2=3 "Fairly satisfied") (3=2  "Not very satisfied") (4=1 "Not at all satisfied"), gen(lifesat)

*gender
/*
bysort country: egen t=mean(d10) if nointer==1

bysort country: egen sex_ni=max(at)

bysort country: egen sex_all=mean(d10)

gen arc_bsex=(sex_ni-sex_all)/sex_all
by  country: summarize rc_bsex
*/
foreach var of varlist d10 d11 edu lifesat cntsit {

bysort country: egen t_`var'=mean( `var') if inter==0

bysort country: egen `var'_ni=max(t_`var')

bysort country: egen `var'_all=mean(`var')

gen rc_b`var'=(`var'_ni-`var'_all)/`var'_all
by  country: summarize rc_b`var' if country!=4 & country!=9  & country!=10   & country!=14

 }
 *Germany
svyset  [pweight=w3]
foreach var of varlist d10 d11 edu lifesat cntsit {
svy: mean rc_b`var' if country==4 | country==14 
 }

 *UK
 svyset  [pweight=w4]
 foreach var of varlist d10 d11 edu lifesat cntsit {
svy: mean rc_b`var' if country==9 | country==10
 }
 
 *eu
svyset  [pweight=w23]
 foreach var of varlist d10 d11 edu lifesat cntsit {
svy: mean rc_b`var'  
 }
 save "$cleandata\2015-clean.dta", replace




**************
use "$data\82.3 - 2014\SI342.dta", clear
drop if country==31
drop if country>32

fre d62t1
list  d62t1 d62_1 d62_2 d62_3  in 1/30, table
recode d62t1 (1 2=1 "uses internet") (3 4=2 "never, no acc., no access at all"), gen (inter)
svyset  [pweight=w23]
svy: ta   country inter, row

svyset  [pweight=w3]
svy: ta   inter if country==4 | country==14

svyset  [pweight=w4]
svy: ta   inter if country==9 | country==10
ta   country inter, row nofreq


fre  d8
gen edu=d8
drop if edu==.d //different type of missing values
drop if edu==.r //different type of missing values
replace edu=d11 if edu==98
replace edu=0 if d8==97 //no full time education

fre  qa1a_1
drop if qa1a_1==.d
recode qa1a_1 (1=4 "Very good" ) (2=3 "Rather good") (3=2  "Rather bad") (4=1 "Very bad"), gen(cntsit)
drop if d70==.d
recode d70 (1=4 "Very satisfied" ) (2=3 "Fairly satisfied") (3=2  "Not very satisfied") (4=1 "Not at all satisfied"), gen(lifesat)

*gender
/*
bysort country: egen t=mean(d10) if nointer==1

bysort country: egen sex_ni=max(at)

bysort country: egen sex_all=mean(d10)

gen arc_bsex=(sex_ni-sex_all)/sex_all
by  country: summarize rc_bsex
*/
foreach var of varlist d10 d11 edu lifesat cntsit {

bysort country: egen t_`var'=mean( `var') if inter==0

bysort country: egen `var'_ni=max(t_`var')

bysort country: egen `var'_all=mean(`var')

gen rc_b`var'=(`var'_ni-`var'_all)/`var'_all
by  country: summarize rc_b`var' if country!=4 & country!=9  & country!=10   & country!=14

 }
 *Germany
svyset  [pweight=w3]
foreach var of varlist d10 d11 edu lifesat cntsit {
svy: mean rc_b`var' if country==4 | country==14 
 }

 *UK
 svyset  [pweight=w4]
 foreach var of varlist d10 d11 edu lifesat cntsit {
svy: mean rc_b`var' if country==9 | country==10
 }
 
 *eu
svyset  [pweight=w23]
 foreach var of varlist d10 d11 edu lifesat cntsit {
svy: mean rc_b`var'  
 }
 save "$cleandata\2014-clean.dta", replace






**************
use "$data\80.1 - 2013\SI331.dta", clear
fre country
drop if country==31
drop if country>32

fre d62t1
list  d62t1 d62_1 d62_2 d62_3  in 1/30, table
egen internet=rowmin(d62_1 d62_2 d62_3)
fre internet
list internet d62_1 d62_2 d62_3 in 1/10, nolab

recode internet (1/5=0 "uses internet") (6 7=1 "never, no acc., no access at all"), gen (nointer)
fre nointer

svyset  [pweight=w23]
svy: ta   country nointer, row

svyset  [pweight=w3]
svy: ta   nointer if country==4 | country==14

svyset  [pweight=w4]
svy: ta   nointer if country==9 | country==10

ta   country nointer, row nofreq

fre  d8

gen edu=d8
drop if edu==.d //different type of missing values
drop if edu==.r //different type of missing values
replace edu=d11 if edu==98
replace edu=0 if d8==97 //no full time education

fre   qa2a_1
drop if  qa2a_1==.d
recode  qa2a_1 (1=4 "Very good" ) (2=3 "Rather good") (3=2  "Rather bad") (4=1 "Very bad"), gen(cntsit)
drop if qa1==.d
recode qa1 (1=4 "Very satisfied" ) (2=3 "Fairly satisfied") (3=2  "Not very satisfied") (4=1 "Not at all satisfied"), gen(lifesat)

*gender
/*
bysort country: egen t=mean(d10) if nointer==1

bysort country: egen sex_ni=max(at)

bysort country: egen sex_all=mean(d10)

gen arc_bsex=(sex_ni-sex_all)/sex_all
by  country: summarize rc_bsex
*/
foreach var of varlist d10 d11 edu lifesat cntsit {

bysort country: egen t_`var'=mean( `var') if nointer==0

bysort country: egen `var'_ni=max(t_`var')

bysort country: egen `var'_all=mean(`var')

gen rc_b`var'=(`var'_ni-`var'_all)/`var'_all
by  country: summarize rc_b`var' if country!=4 & country!=9  & country!=10   & country!=14

 }
 *Germany
svyset  [pweight=w3]
foreach var of varlist d10 d11 edu lifesat cntsit {
svy: mean rc_b`var' if country==4 | country==14 
 }

 *UK
 svyset  [pweight=w4]
 foreach var of varlist d10 d11 edu lifesat cntsit {
svy: mean rc_b`var' if country==9 | country==10
 }
 
 *eu
svyset  [pweight=w23]
 foreach var of varlist d10 d11 edu lifesat cntsit {
svy: mean rc_b`var'  
 }

 save "$cleandata\2013-clean.dta", replace



**************
use "$data\78.1 - 2012\D_SI318.dta", clear
fre country
drop if country==31
drop if country>32
fre d62t1
list  d62t1 d62_1 d62_2 d62_3  in 1/30, table nolabel
egen internet=rowmin(d62_1 d62_2 d62_3)
fre internet
ta internet d62t1, miss
list internet d62_1 d62_2 d62_3 in 1/10, nolab

recode internet (1/5=0 "uses internet") (6 7=1 "never, no acc., no access at all"), gen (nointer)
fre nointer
fre country

svyset  [pweight=w23]
svy: ta   country nointer, row

svyset  [pweight=w3]
svy: ta   nointer if country==4 | country==14

svyset  [pweight=w4]
svy: ta   nointer if country==9 | country==10
ta   country nointer, row nofreq


fre  d8
gen edu=d8
drop if edu==.d //different type of missing values
drop if edu==.r //different type of missing values
replace edu=d11 if edu==98
replace edu=0 if d8==97 //no full time education

fre   qa3a_1
recode  qa3a_1 (1=4 "Very good" ) (2=3 "Rather good") (3=2  "Rather bad") (4=1 "Very bad"), gen(cntsit)
fre  qa1
recode qa1 (1=4 "Very satisfied" ) (2=3 "Fairly satisfied") (3=2  "Not very satisfied") (4=1 "Not at all satisfied"), gen(lifesat)

*gender
/*
bysort country: egen t=mean(d10) if nointer==1

bysort country: egen sex_ni=max(at)

bysort country: egen sex_all=mean(d10)

gen arc_bsex=(sex_ni-sex_all)/sex_all
by  country: summarize rc_bsex
*/
foreach var of varlist d10 d11 edu lifesat cntsit {

bysort country: egen t_`var'=mean( `var') if nointer==0

bysort country: egen `var'_ni=max(t_`var')

bysort country: egen `var'_all=mean(`var')

gen rc_b`var'=(`var'_ni-`var'_all)/`var'_all
by  country: summarize rc_b`var' if country!=4 & country!=9  & country!=10   & country!=14

 }
 *Germany
svyset  [pweight=w3]
foreach var of varlist d10 d11 edu lifesat cntsit {
svy: mean rc_b`var' if country==4 | country==14 
 }

 *UK
 svyset  [pweight=w4]
 foreach var of varlist d10 d11 edu lifesat cntsit {
svy: mean rc_b`var' if country==9 | country==10
 }
 
 *eu
svyset  [pweight=w23]
 foreach var of varlist d10 d11 edu lifesat cntsit {
svy: mean rc_b`var'  
 }

 save "$cleandata\2012-clean.dta", replace


**************
use "$data\76.3 - 2011\ZA5567_v1-0-0.dta", clear
drop if country==31
drop if country>32
fre d62t 
list  d62t d62_1 d62_2 d62_3  in 1/30, table nolabel
egen internet=rowmin(d62_1 d62_2 d62_3)
fre internet
ta internet d62t, miss
list internet d62_1 d62_2 d62_3 in 1/10, nolab
recode internet (1/5=0 "uses internet") (6 7=1 "never, no acc., no access at all"), gen (nointer)
fre nointer
svyset  [pweight=w25]
svy: ta   country nointer, row

svyset  [pweight=w3]
svy: ta   nointer if country==4 | country==14

svyset  [pweight=w4]
svy: ta   nointer if country==9 | country==10
ta   country nointer, row nofreq

fre  vd8
gen edu=vd8
drop if edu==98  
drop if edu==99  
replace edu=vd11 if edu==0
replace edu=0 if vd8==1 //no full time education

fre   qa4a_1
recode  qa4a_1 (1=4 "Very good" ) (2=3 "Rather good") (3=2  "Rather bad") (4=1 "Very bad") (5=.), gen(cntsit)
fre  qa1
recode qa1 (1=4 "Very satisfied" ) (2=3 "Fairly satisfied") (3=2  "Not very satisfied") (4=1 "Not at all satisfied") (5=.), gen(lifesat)

*gender
/*
bysort country: egen t=mean(d10) if nointer==1

bysort country: egen sex_ni=max(at)

bysort country: egen sex_all=mean(d10)

gen arc_bsex=(sex_ni-sex_all)/sex_all
by  country: summarize rc_bsex
*/
foreach var of varlist d10 vd11 edu lifesat cntsit {

bysort country: egen t_`var'=mean( `var') if nointer==0

bysort country: egen `var'_ni=max(t_`var')

bysort country: egen `var'_all=mean(`var')

gen rc_b`var'=(`var'_ni-`var'_all)/`var'_all
by  country: summarize rc_b`var' if country!=4 & country!=9  & country!=10   & country!=14

 }
 *Germany
svyset  [pweight=w3]
foreach var of varlist d10 vd11 edu lifesat cntsit {
svy: mean rc_b`var' if country==4 | country==14 
 }

 *UK
 svyset  [pweight=w4]
 foreach var of varlist d10 vd11 edu lifesat cntsit {
svy: mean rc_b`var' if country==9 | country==10
 }
 
 *eu
svyset  [pweight=w25]
 foreach var of varlist d10 vd11 edu lifesat cntsit {
svy: mean rc_b`var'  
 }
 

 save "$cleandata\2011-clean.dta", replace


**************
use "$data\74.2 - 2010\ZA5449_v2-2-0.dta", clear
drop if v6==31
drop if v6>32
fre v623 v624 v625
egen internet=rowmin(v623 v624 v625)
recode internet (1/5=0 "uses internet") (6 7=1 "never, no acc., no access at all"), gen (nointer)
fre nointer
svyset  [pweight=v40]
svy: ta   v6 nointer, row

svyset  [pweight=v12]
svy: ta   nointer if v6==4 | v6==14

svyset  [pweight=v10]
svy: ta   nointer if v6==9 | v6==10
ta    v6 nointer, row nofreq

fre  v600
gen edu=v600
drop if edu==.d  
drop if edu==.r  
replace edu=v603 if v600== 98
replace edu=0 if v600==97 //no full time education

fre   v96
recode  v96 (1=4 "Very good" ) (2=3 "Rather good") (3=2  "Rather bad") (4=1 "Very bad") (.d=.), gen(cntsit)
fre  v91
recode v91 (1=4 "Very satisfied" ) (2=3 "Fairly satisfied") (3=2  "Not very satisfied") (4=1 "Not at all satisfied") (.d=.), gen(lifesat)


recode v6 (1=1 "France") (2=2 "Belgium") (3=3 "The Netherlands") (4=4 " Germany West") (5=5 "Italy") (6=6 "Luxembourg") (7=7 "Denmark") (8=8 "Ireland") (9 =9 "Great Britain") (10=10 "Northern Ireland") ///
(11=11 "Greece") (12=12 "Spain") (13=13 "Portugal") (14=14 "Germany East") (16=16 "Finland") (17=17 "Sweden") (18=18 "Austria") ///
 (19=19 "Cyprus (Republic)" ) (20=20 "Czech Republic") (21=21 "Estonia") ///
(22=22 "Hungary") (23=23 "Latvia") (24=24 "Lithuania") (25=25 "Malta") (26=26 "Poland") (27=27 "Slovakia") (28=28 "Slovenia") (29=29 "Bulgaria") ///
(30=30 "Romania")  (32=32 "Croatia"), gen (cnt)

*gender
/*
bysort country: egen t=mean(d10) if nointer==1

bysort country: egen sex_ni=max(at)

bysort country: egen sex_all=mean(d10)

gen arc_bsex=(sex_ni-sex_all)/sex_all
by  country: summarize rc_bsex
*/
foreach var of varlist v602 v603 edu lifesat cntsit {

bysort cnt : egen t_`var'=mean( `var') if nointer==0

bysort cnt : egen `var'_ni=max(t_`var')

bysort cnt : egen `var'_all=mean(`var')

gen rc_b`var'=(`var'_ni-`var'_all)/`var'_all
by  cnt : summarize rc_b`var' if cnt!=4 & cnt!=9  & cnt!=10   & cnt!=14

 }
 *Germany
svyset  [pweight=v12]
foreach var of varlist v602 v603 edu lifesat cntsit {
svy: mean rc_b`var' if cnt ==4 | cnt ==14 
 }

 *UK
 svyset  [pweight=v10]
 foreach var of varlist v602 v603 edu lifesat cntsit {
svy: mean rc_b`var' if cnt ==9 | cnt ==10
 }
 
 *eu
svyset  [pweight=v40]
 foreach var of varlist v602 v603 edu lifesat cntsit {
svy: mean rc_b`var'  
 }
 
 save "$cleandata\2010-clean.dta", replace

