
clear
set more off
set mem 400m

log using "$data\results.smcl", replace
 
use "$data\dataset.dta", clear

foreach var of varlist bs_sex bs_age bs_edu bs_lifesat bs_cntsit {
gen abs_`var'=abs(`var')
}

recode year (2010=0) (2011=1) (2012=2) (2013=3) (2014=4) (2015=5) (2016=6) (2017=7) (2018=8) (2019=9) 

egen cyear=concat(year country)

*sex

*mixed abs_bs_sex year y2  ||  country:   ||  year: , mle var 
*est sto m1
*reg abs_bs_sex year y2 
*est sto m2


*mixed abs_bs_sex year   ||  country:   ||  cyear: , mle var 
*est sto m1
*esttab m1, b(3) se

*esttab m1 , se transform(ln*: exp(@) exp(@)) eqlabels("" "sd(tx)" "sd(Residual)")

*mixed abs_bs_sex year y2  || country: || cyear: , mle var  //
mixed abs_bs_sex year  || country: || cyear: , mle var  

mixed abs_bs_sex year  gdp lfrate gini inflation ger lifeexp pedur sedur urban || country: || cyear:   , mle var

*age

mixed abs_bs_age year y2  || country: || cyear:   , mle var

mixed abs_bs_age year  urban    || country: || cyear:   , mle var

mixed abs_bs_age year  urban    || country: || cyear:   , mle var

*edu
mixed abs_bs_edu year y2  || country: || cyear:   , mle var 
mixed abs_bs_edu year || country: || cyear:   , mle var 

mixed abs_bs_edu year  lfrate gini   lifeexp urban || country: || cyear:   , mle var

*lifesat
mixed abs_bs_lifesat year y2  || country: || cyear:   , mle var 
mixed abs_bs_lifesat year  || country: || cyear:   , mle var 

mixed abs_bs_lifesat year gdp lfrate  pedur  urban  || country: || cyear:   , mle var

*countrysit
mixed abs_bs_cntsit year y2  || country: || cyear:   , mle var 
mixed abs_bs_cntsit year  || country: || cyear:   , mle var 
 
mixed abs_bs_cntsit year  lfrate gini   || country: || cyear:   , mle var

*double check with all variables
mixed abs_bs_sex year y2 gdp gini inflation ger lifeexp pedur sedur urban lfrate  || country: || cyear: if year<2  , mle var
est store m1
esttab m1, b(3) se

mixed abs_bs_age year y2 gdp gini inflation ger lifeexp pedur sedur urban lfrate  || country: || cyear:   , mle var
est store m2
esttab m2, b(3) se
mixed abs_bs_edu year y2 gdp gini inflation ger lifeexp pedur sedur urban lfrate  || country: || cyear:   , mle var
est store m3
esttab m3, b(3) se
mixed abs_bs_lifesat year y2 gdp gini inflation ger lifeexp pedur sedur urban lfrate  || country: || cyear:   , mle var
est store m4
esttab m4, b(3) se
mixed abs_bs_cntsit year y2 gdp gini inflation ger lifeexp pedur sedur urban lfrate  || country: || cyear:   , mle var
est store m5
esttab m5, b(3) se

drop cyear  abs_bs_sex abs_bs_age abs_bs_edu abs_bs_lifesat abs_bs_cntsit

save "$data\dataset.dta", replace
log close