﻿* Encoding: UTF-8.
* Survey Climate Paper Code

DATASET ACTIVATE DataSet15.

*recording first outcome variable - accuracy of OS into three category one

RECODE StatAcc (8=3) (1 thru 2=1) (3 thru 4=2) INTO StatAccShort.
VARIABLE LABELS  StatAccShort 'outcome variable 1 accuracy'.
EXECUTE.

* recording second outcome variable - trust

RECODE TrstONS (8=3) (1 thru 2=1) (3 thru 4=2) INTO TrstONSShort.
VARIABLE LABELS  TrstONSShort 'outcome variable 2 trust'.
EXECUTE.

*recording third outcome variable - confidentiality

RECODE ConfNO (8=3) (1 thru 2=1) (3 thru 4=2) INTO ConfNOShort.
VARIABLE LABELS  ConfNOShort 'outcome variable 3 confidentiality'.
EXECUTE.

*outcome 1 into binary variable

RECODE StatAccShort (1=0) (2 thru 3=1) INTO StatAccOutcome.
VARIABLE LABELS  StatAccOutcome 'binary outcome accuracy with disagree and do not know combined'.
EXECUTE.

*outcome 2 into binary variable

RECODE TrstONSShort (1=0) (2 thru 3=1) INTO TrstONSOutcome.
VARIABLE LABELS  TrstONSOutcome 'binary outcome trust with disagree and do not know combined'.
EXECUTE.

*outcome 3 into binary variable

RECODE ConfNOShort (1=0) (2 thru 3=1) INTO ConfNOOutcome.
VARIABLE LABELS  ConfNOOutcome 'binary outcome confidential with disagree and do not know combined'.
EXECUTE.


*2014 dataset

DATASET ACTIVATE DataSet3.
*outcome for multinomial - accuracy

RECODE StatAcc (5=3) (1 thru 2=1) (3 thru 4=2) INTO StatAccShort.
VARIABLE LABELS  StatAccShort 'three categories for accuracy outcome 1'.
EXECUTE.

*binary outcome for accuracy

RECODE StatAccShort (1=0) (2 thru 3=1) INTO StatAccOutcome.
VARIABLE LABELS  StatAccOutcome 'binary outcome combining disagree and do not know for outcome 1 '+
    'accuracy'.
EXECUTE.

* recording second outcome variable - trust

RECODE TrstONS (8=3) (5=3) (1 thru 2=1) (3 thru 4=2) INTO TrstONSShort.
VARIABLE LABELS  TrstONSShort 'outcome variable 2 trust'.
EXECUTE.

*outcome 2 into binary variable

RECODE TrstONSShort (1=0) (2 thru 3=1) INTO TrstONSOutcome.
VARIABLE LABELS  TrstONSOutcome 'binary outcome trust with disagree and do not know combined'.
EXECUTE.

*recording third outcome variable - confidentiality

RECODE ONSConf (5=3) (1 thru 2=1) (3 thru 4=2) INTO ONSConfShort.
VARIABLE LABELS  ONSConfShort 'outcome variable 3 confidentiality'.
EXECUTE.

*outcome 3 into binary variable

RECODE ONSConfShort (1=0) (2 thru 3=1) INTO ONSConfOutcome.
VARIABLE LABELS  ONSConfOutcome 'binary outcome confidential with disagree and do not know combined'.
EXECUTE.

*2016 dataset

DATASET ACTIVATE DataSet10.

*outcome for multinomial - accuracy

RECODE StatAcc (5=3) (1 thru 2=1) (3 thru 4=2) INTO StatAccShort.
VARIABLE LABELS  StatAccShort 'three categories for accuracy outcome 1'.
EXECUTE.

*binary outcome for accuracy

RECODE StatAccShort (1=0) (2 thru 3=1) INTO StatAccOutcome.
VARIABLE LABELS  StatAccOutcome 'binary outcome combining disagree and do not know for outcome 1 '+
    'accuracy'.
EXECUTE.

* recording second outcome variable - trust

RECODE TrstONS (8=3) (5=3) (1 thru 2=1) (3 thru 4=2) INTO TrstONSShort.
VARIABLE LABELS  TrstONSShort 'outcome variable 2 trust'.
EXECUTE.

*outcome 2 into binary variable

RECODE TrstONSShort (1=0) (2 thru 3=1) INTO TrstONSOutcome.
VARIABLE LABELS  TrstONSOutcome 'binary outcome trust with disagree and do not know combined'.
EXECUTE.

*recording third outcome variable - confidentiality


IF  (ConfO=1 | ConfO=2 | ConfNO=1 | ConfNO=2) ConfShort=1.
EXECUTE.


IF  (ConfO=3 | ConfO=4 | ConfNO=3 | ConfNO=4) ConfShort=2.
EXECUTE.

IF  (ConfO=5 | ConfNO=5) ConfShort=3.
EXECUTE.

*outcome 3 into binary variable

RECODE ConfShort (1=0) (2 thru 3=1) INTO ConfOutcome.
VARIABLE LABELS  ConfOutcome 'binary outcome confidential with disagree and do not know combined'.
EXECUTE.

*2018 dataset

DATASET ACTIVATE DataSet5.

*outcome for multinomial - accuracy

RECODE StatAcc (5=3) (1 thru 2=1) (3 thru 4=2) INTO StatAccShort.
VARIABLE LABELS  StatAccShort 'three categories for accuracy outcome 1'.
EXECUTE.

*binary outcome for accuracy

RECODE StatAccShort (1=0) (2 thru 3=1) INTO StatAccOutcome.
VARIABLE LABELS  StatAccOutcome 'binary outcome combining disagree and do not know for outcome 1 '+
    'accuracy'.
EXECUTE.

* recording second outcome variable - trust

RECODE TrstONS (8=3) (5=3) (1 thru 2=1) (3 thru 4=2) INTO TrstONSShort.
VARIABLE LABELS  TrstONSShort 'outcome variable 2 trust'.
EXECUTE.

*outcome 2 into binary variable

RECODE TrstONSShort (1=0) (2 thru 3=1) INTO TrstONSOutcome.
VARIABLE LABELS  TrstONSOutcome 'binary outcome trust with disagree and do not know combined'.
EXECUTE.

*recording third outcome variable - confidentiality


IF  (ConfO=1 | ConfO=2 | ConfNO=1 | ConfNO=2) ConfShort=1.
EXECUTE.


IF  (ConfO=3 | ConfO=4 | ConfNO=3 | ConfNO=4) ConfShort=2.
EXECUTE.

IF  (ConfO=5 | ConfNO=5) ConfShort=3.
EXECUTE.

*outcome 3 into binary variable

RECODE ConfShort (1=0) (2 thru 3=1) INTO ConfOutcome.
VARIABLE LABELS  ConfOutcome 'binary outcome confidential with disagree and do not know combined'.
EXECUTE.

*recategorising age
*2014

DATASET ACTIVATE DataSet3.
RECODE RAgeCat2 (3=2) (4=3) (5=4) (6=5) (1 thru 2=1) INTO Age.
VARIABLE LABELS  Age 'age five categories'.
EXECUTE.

*2016

DATASET ACTIVATE DataSet10.
RECODE RAgeCat2 (3=2) (4=3) (5=4) (6=5) (1 thru 2=1) INTO Age.
VARIABLE LABELS  Age 'age five categories'.
EXECUTE.

*2018

DATASET ACTIVATE DataSet5.

RECODE RAgeCat2 (3=2) (4=3) (5=4) (6=5) (1 thru 2=1) INTO Age.
VARIABLE LABELS  Age 'age five categories'.
EXECUTE.

*number of children under 18 calculation

*2014

DATASET ACTIVATE DataSet3.
COMPUTE NCh018=NCh415+HhCh04+HhCh1617.
EXECUTE.

RECODE NCh018 (0=0) (1=1) (2 thru 5=2) INTO children018.
VARIABLE LABELS  children018 'categorical number of children under 18'.
EXECUTE.

*2016

DATASET ACTIVATE DataSet10.
COMPUTE NCh018=NCh415+HhCh04+HhCh1617.
EXECUTE.

RECODE NCh018 (0=0) (1=1) (2 thru 6=2) INTO children018.
VARIABLE LABELS  children018 'categorical number of children under 18'.
EXECUTE.

*2018

DATASET ACTIVATE DataSet5.
COMPUTE NCh018=NCh415e+HhCh04e+HhCh1617e.
EXECUTE.

RECODE NCh018 (0=0) (1=1) (2 thru 6=2) INTO children018.
VARIABLE LABELS  children018 'categorical number of children under 18'.
EXECUTE.

*religion

*2014



DATASET ACTIVATE DataSet3.


RECODE ReligSum (5=1) (1 thru 3=2) (4=3) INTO ReligionGr.
VARIABLE LABELS  ReligionGr 'grouped religion'.
EXECUTE.

*2016

DATASET ACTIVATE DataSet10.

RECODE ReligSum (5=1) (1 thru 3=2) (4=3) INTO ReligionGr.
VARIABLE LABELS  ReligionGr 'grouped religion'.
EXECUTE.

*2018

DATASET ACTIVATE DataSet5.
RECODE ReligSum (5=1) (1 thru 3=2) (4=3) INTO ReligionGr.
VARIABLE LABELS  ReligionGr 'grouped religion'.
EXECUTE.

*Ethnicity
*2014

DATASET ACTIVATE DataSet3.
RECODE RaceOri3 (9=1) (1 thru 8=2) (10 thru 11=2) INTO Ethnicity.
VARIABLE LABELS  Ethnicity 'two groups of ethicity'.
EXECUTE.

*2016

DATASET ACTIVATE DataSet10.
RECODE RaceOri3 (9=1) (1 thru 8=2) (10 thru 11=2) INTO Ethnicity.
VARIABLE LABELS  Ethnicity 'two groups of ethicity'.
EXECUTE.

*2018

DATASET ACTIVATE DataSet5.
RECODE RaceOri4 (3=1) (1 thru 2=2) (4 thru 5=2) INTO Ethnicity.
VARIABLE LABELS  Ethnicity 'two groups of ethicity'.
EXECUTE.

*Economic activity
*2014

DATASET ACTIVATE DataSet3.
RECODE REconPos (5=5) (6=5) (7=4) (8=5) (9=3) (1 thru 2=1) (3 thru 4=2) (10 thru 11=5) INTO 
    EconomicActivity.
VARIABLE LABELS  EconomicActivity 'current economic activity'.
EXECUTE.

*2016 

DATASET ACTIVATE DataSet10.

RECODE REconPos (5=5) (6=5) (7=4) (8=5) (9=3) (1 thru 2=1) (3 thru 4=2) (10 thru 11=5) INTO 
    EconomicActivity.
VARIABLE LABELS  EconomicActivity 'current economic activity'.
EXECUTE.

*2018 - no self-employed group, combined under working

DATASET ACTIVATE DataSet5.

RECODE REconSum (1=5) (2=1) (3=4) (4=3) (5=5) INTO 
    EconomicActivity.
VARIABLE LABELS  EconomicActivity 'current economic activity'.
EXECUTE.

*Education
*2021

DATASET ACTIVATE DataSet15.
RECODE hedqual_final (3=2) (6=4) (1 thru 2=1) (4 thru 5=3) INTO Education.
VARIABLE LABELS  Education 'education'.
EXECUTE.

*2014

DATASET ACTIVATE DataSet3.
RECODE HEdQual (3=2) (7=4) (1 thru 2=1) (4 thru 6=3) INTO Education.
VARIABLE LABELS  Education 'education'.
EXECUTE.

*2016

DATASET ACTIVATE DataSet10.

RECODE HEdQual (3=2) (7=4) (1 thru 2=1) (4 thru 6=3) INTO Education.
VARIABLE LABELS  Education 'education'.
EXECUTE.

*2018

DATASET ACTIVATE DataSet5.
RECODE HEdQual (3=2) (7=4) (1 thru 2=1) (4 thru 6=3) INTO Education.
VARIABLE LABELS  Education 'education'.
EXECUTE.

*Tenure
*2014

DATASET ACTIVATE DataSet3.


RECODE Tenure2 (1=1) (5=3) (9=3) (2 thru 4=2) INTO Tenure.
VARIABLE LABELS  Tenure 'tenure'.
EXECUTE.

*2016

DATASET ACTIVATE DataSet10.

RECODE Tenure2 (1=1) (5=3) (9=3) (2 thru 4=2) INTO Tenure.
VARIABLE LABELS  Tenure 'tenure'.
EXECUTE.

*2018

DATASET ACTIVATE DataSet5.
RECODE Tenure2e (1=1) (9=3) (2 thru 4=2) INTO Tenure.
VARIABLE LABELS  Tenure 'tenure'.
EXECUTE.

*no mode in 2014, 2016, 2018 

* binary logistic regression - statisical accuracy 2021 - forward LR
*tested many variables

DATASET ACTIVATE DataSet19.
LOGISTIC REGRESSION VARIABLES StatAccOutcome
  /METHOD=FSTEP(LR) Age_Archiving Sex HhlChl_ArchivingDV ReligionGrp EthnicityGrp econfw_archiving 
    Education TenureDv_archiving country_sample Mode ONSpa1 ONSaw_DV ONSSurv_DV 
  /CONTRAST (Age_Archiving)=Indicator(1)
  /CONTRAST (Sex)=Indicator(1)
  /CONTRAST (HhlChl_ArchivingDV)=Indicator(1)
  /CONTRAST (ReligionGrp)=Indicator(1)
  /CONTRAST (EthnicityGrp)=Indicator(1)
  /CONTRAST (econfw_archiving)=Indicator(1)
  /CONTRAST (Education)=Indicator(1)
  /CONTRAST (TenureDv_archiving)=Indicator(1)
  /CONTRAST (country_sample)=Indicator(1)
  /CONTRAST (Mode)=Indicator(1)
  /CONTRAST (ONSpa1)=Indicator(1)
  /CONTRAST (ONSaw_DV)=Indicator(1)
  /CONTRAST (ONSSurv_DV)=Indicator(1)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

*final model


LOGISTIC REGRESSION VARIABLES StatAccOutcome
  /METHOD=FSTEP(LR) ReligionGrp EthnicityGrp Education Mode ONSpa1 ONSaw_DV 
  /CONTRAST (ReligionGrp)=Indicator(1)
  /CONTRAST (EthnicityGrp)=Indicator(1)
  /CONTRAST (Education)=Indicator(1)
  /CONTRAST (Mode)=Indicator(1)
  /CONTRAST (ONSpa1)=Indicator(1)
  /CONTRAST (ONSaw_DV)=Indicator(1)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

*THE FINAL MODEL - after removal of do not knows

LOGISTIC REGRESSION VARIABLES StatAccOutcome
  /METHOD=FSTEP(LR) HhlChl_ArchivingDV ReligionGrp EthnicityGrp Mode ONSpa1 ONSaw_DV Education
  /CONTRAST (HhlChl_ArchivingDV)=Indicator(1)
  /CONTRAST (ReligionGrp)=Indicator(1)
  /CONTRAST (EthnicityGrp)=Indicator(1)
  /CONTRAST (Mode)=Indicator(1)
  /CONTRAST (ONSpa1)=Indicator(1)
  /CONTRAST (ONSaw_DV)=Indicator(1)
   /CONTRAST (Education)=Indicator(1)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

* trust ONS model 2021

LOGISTIC REGRESSION VARIABLES TrstONSOutcome
  /METHOD=FSTEP(LR) Age_Archiving Sex HhlChl_ArchivingDV ReligionGrp EthnicityGrp econfw_archiving 
    Education TenureDv_archiving country_sample Mode ONSpa1 ONSaw_DV ONSSurv_DV 
  /CONTRAST (Age_Archiving)=Indicator(1)
  /CONTRAST (Sex)=Indicator(1)
  /CONTRAST (HhlChl_ArchivingDV)=Indicator(1)
  /CONTRAST (ReligionGrp)=Indicator(1)
  /CONTRAST (EthnicityGrp)=Indicator(1)
  /CONTRAST (econfw_archiving)=Indicator(1)
  /CONTRAST (Education)=Indicator(1)
  /CONTRAST (TenureDv_archiving)=Indicator(1)
  /CONTRAST (country_sample)=Indicator(1)
  /CONTRAST (Mode)=Indicator(1)
  /CONTRAST (ONSpa1)=Indicator(1)
  /CONTRAST (ONSaw_DV)=Indicator(1)
  /CONTRAST (ONSSurv_DV)=Indicator(1)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

DATASET ACTIVATE DataSet20.
LOGISTIC REGRESSION VARIABLES TrstONSOutcome
  /METHOD=FSTEP(LR) Education TenureDv_archiving Mode ONSaw_DV 
  /CONTRAST (Education)=Indicator(1)
  /CONTRAST (TenureDv_archiving)=Indicator(1)
  /CONTRAST (Mode)=Indicator(1)
  /CONTRAST (ONSaw_DV)=Indicator(1)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

* ONS will keep information confidential

LOGISTIC REGRESSION VARIABLES ConfNOOutcome
  /METHOD=FSTEP(LR) Age_Archiving Sex HhlChl_ArchivingDV ReligionGrp EthnicityGrp econfw_archiving 
    Education TenureDv_archiving country_sample Mode ONSpa1 ONSaw_DV ONSSurv_DV 
  /CONTRAST (Age_Archiving)=Indicator(1)
  /CONTRAST (Sex)=Indicator(1)
  /CONTRAST (HhlChl_ArchivingDV)=Indicator(1)
  /CONTRAST (ReligionGrp)=Indicator(1)
  /CONTRAST (EthnicityGrp)=Indicator(1)
  /CONTRAST (econfw_archiving)=Indicator(1)
  /CONTRAST (Education)=Indicator(1)
  /CONTRAST (TenureDv_archiving)=Indicator(1)
  /CONTRAST (country_sample)=Indicator(1)
  /CONTRAST (Mode)=Indicator(1)
  /CONTRAST (ONSpa1)=Indicator(1)
  /CONTRAST (ONSaw_DV)=Indicator(1)
  /CONTRAST (ONSSurv_DV)=Indicator(1)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

DATASET ACTIVATE DataSet21.
LOGISTIC REGRESSION VARIABLES ConfNOOutcome
  /METHOD=FSTEP(LR) ReligionGrp Mode ONSaw_DV ONSSurv_DV 
  /CONTRAST (ReligionGrp)=Indicator(1)
  /CONTRAST (Mode)=Indicator(1)
  /CONTRAST (ONSaw_DV)=Indicator(1)
  /CONTRAST (ONSSurv_DV)=Indicator(1)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

* Pooled
* stat accuracy binary logistic regression

LOGISTIC REGRESSION VARIABLES StatAccOutcome
  /METHOD=FSTEP(LR) Age Sex Children Religion Ethnicity EconomicActivity Tenure KnowONS Census Mode Education 
  /CONTRAST (Age)=Indicator(1)
   /CONTRAST (Sex)=Indicator(1)
   /CONTRAST (Children)=Indicator(1)
  /CONTRAST (Religion)=Indicator(1)
  /CONTRAST (Ethnicity)=Indicator(1)
   /CONTRAST (EconomicActivity)=Indicator(1)
  /CONTRAST (Tenure)=Indicator(1)
  /CONTRAST (KnowONS)=Indicator(1)
  /CONTRAST (Census)=Indicator(1)
   /CONTRAST (Mode)=Indicator(1)
  /CONTRAST (Education)=Indicator(1)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

LOGISTIC REGRESSION VARIABLES StatAccOutcome
  /METHOD=FSTEP(LR) Age Sex Children Religion Ethnicity EconomicActivity Tenure KnowONS Census YearCat Education 
  /CONTRAST (Age)=Indicator(1)
   /CONTRAST (Sex)=Indicator(1)
   /CONTRAST (Children)=Indicator(1)
  /CONTRAST (Religion)=Indicator(1)
  /CONTRAST (Ethnicity)=Indicator(1)
   /CONTRAST (EconomicActivity)=Indicator(1)
  /CONTRAST (Tenure)=Indicator(1)
  /CONTRAST (KnowONS)=Indicator(1)
  /CONTRAST (Census)=Indicator(1)
   /CONTRAST (YearCat)=Indicator(1)
  /CONTRAST (Education)=Indicator(1)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

LOGISTIC REGRESSION VARIABLES StatAccOutcome
  /METHOD=FSTEP(LR) Age Religion Tenure KnowONS Census Mode Education 
  /CONTRAST (Age)=Indicator(1)
  /CONTRAST (Religion)=Indicator(1)
  /CONTRAST (Tenure)=Indicator(1)
  /CONTRAST (KnowONS)=Indicator(1)
  /CONTRAST (Census)=Indicator(1)
  /CONTRAST (Mode)=Indicator(3)
  /CONTRAST (Education)=Indicator(1)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

LOGISTIC REGRESSION VARIABLES StatAccOutcome
  /METHOD=FSTEP(LR) Age Religion Tenure KnowONS Census YearCat Education 
  /CONTRAST (Age)=Indicator(1)
  /CONTRAST (Religion)=Indicator(1)
  /CONTRAST (Tenure)=Indicator(1)
  /CONTRAST (KnowONS)=Indicator(1)
  /CONTRAST (Census)=Indicator(1)
  /CONTRAST (YearCat)=Indicator(1)
  /CONTRAST (Education)=Indicator(1)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

DATASET ACTIVATE DataSet15.
LOGISTIC REGRESSION VARIABLES StatAccOutcome
  /METHOD=FSTEP(LR) Age Religion Tenure KnowONS Census Year Education 
  /CONTRAST (Age)=Indicator(1)
  /CONTRAST (Religion)=Indicator(1)
  /CONTRAST (Tenure)=Indicator(1)
  /CONTRAST (KnowONS)=Indicator(1)
  /CONTRAST (Census)=Indicator(1)
  /CONTRAST (Education)=Indicator(1)
  /CONTRAST (Year)=Indicator
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

*stat accuracy pooled multinomial regression

NOMREG StatAccShort (BASE=FIRST ORDER=ASCENDING) BY Age Sex Religion Tenure Mode KnowONS Census 
    Education Year
  /CRITERIA CIN(95) DELTA(0) MXITER(100) MXSTEP(5) CHKSEP(20) LCONVERGE(0) PCONVERGE(0.000001) 
    SINGULAR(0.00000001)
  /MODEL
  /STEPWISE=PIN(.05) POUT(0.1) MINEFFECT(0) RULE(SINGLE) ENTRYMETHOD(LR) REMOVALMETHOD(LR)
  /INTERCEPT=INCLUDE
  /PRINT=PARAMETER SUMMARY LRT CPS STEP MFI.

* trust ONS pooled - binary logistic regression

LOGISTIC REGRESSION VARIABLES TrstONSOutcome
  /METHOD=FSTEP(LR) Age Sex Children Religion Ethnicity EconomicActivity Tenure KnowONS Census Mode Education 
  /CONTRAST (Age)=Indicator(1)
   /CONTRAST (Sex)=Indicator(1)
   /CONTRAST (Children)=Indicator(1)
  /CONTRAST (Religion)=Indicator(1)
  /CONTRAST (Ethnicity)=Indicator(1)
   /CONTRAST (EconomicActivity)=Indicator(1)
  /CONTRAST (Tenure)=Indicator(1)
  /CONTRAST (KnowONS)=Indicator(1)
  /CONTRAST (Census)=Indicator(1)
   /CONTRAST (Mode)=Indicator(1)
  /CONTRAST (Education)=Indicator(1)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

LOGISTIC REGRESSION VARIABLES TrstONSOutcome
  /METHOD=FSTEP(LR) Age Sex Children Religion Ethnicity EconomicActivity Tenure KnowONS Census YearCat Education 
  /CONTRAST (Age)=Indicator(1)
   /CONTRAST (Sex)=Indicator(1)
   /CONTRAST (Children)=Indicator(1)
  /CONTRAST (Religion)=Indicator(1)
  /CONTRAST (Ethnicity)=Indicator(1)
   /CONTRAST (EconomicActivity)=Indicator(1)
  /CONTRAST (Tenure)=Indicator(1)
  /CONTRAST (KnowONS)=Indicator(1)
  /CONTRAST (Census)=Indicator(1)
   /CONTRAST (YearCat)=Indicator(1)
  /CONTRAST (Education)=Indicator(1)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

DATASET ACTIVATE DataSet23.
LOGISTIC REGRESSION VARIABLES TrstONSOutcome
  /METHOD=FSTEP(LR) Age Religion Education Tenure Census KnowONS Mode 
  /CONTRAST (Age)=Indicator(1)
  /CONTRAST (Religion)=Indicator(1)
  /CONTRAST (Education)=Indicator(1)
  /CONTRAST (Tenure)=Indicator(1)
  /CONTRAST (Census)=Indicator(1)
  /CONTRAST (KnowONS)=Indicator(1)
  /CONTRAST (Mode)=Indicator(3)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

LOGISTIC REGRESSION VARIABLES TrstONSOutcome
  /METHOD=FSTEP(LR) Age Religion Education Tenure Census KnowONS YearCat 
  /CONTRAST (Age)=Indicator(1)
  /CONTRAST (Religion)=Indicator(1)
  /CONTRAST (Education)=Indicator(1)
  /CONTRAST (Tenure)=Indicator(1)
  /CONTRAST (Census)=Indicator(1)
  /CONTRAST (KnowONS)=Indicator(1)
  /CONTRAST (YearCat)=Indicator(1)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

*trust ONS multinomial



NOMREG TrstONSShort (BASE=FIRST ORDER=ASCENDING) BY Age Religion Ethnicity Education Tenure Census 
    KnowONS Mode Year
  /CRITERIA CIN(95) DELTA(0) MXITER(100) MXSTEP(5) CHKSEP(20) LCONVERGE(0) PCONVERGE(0.000001) 
    SINGULAR(0.00000001)
  /MODEL
  /STEPWISE=PIN(.05) POUT(0.1) MINEFFECT(0) RULE(SINGLE) ENTRYMETHOD(LR) REMOVALMETHOD(LR)
  /INTERCEPT=INCLUDE
  /PRINT=PARAMETER SUMMARY LRT CPS STEP MFI.


*pooled confidential binary logistic regression

LOGISTIC REGRESSION VARIABLES ConfOutcome
  /METHOD=FSTEP(LR) Age Sex Children Religion Ethnicity EconomicActivity Tenure KnowONS Census Mode Education 
  /CONTRAST (Age)=Indicator(1)
   /CONTRAST (Sex)=Indicator(1)
   /CONTRAST (Children)=Indicator(1)
  /CONTRAST (Religion)=Indicator(1)
  /CONTRAST (Ethnicity)=Indicator(1)
   /CONTRAST (EconomicActivity)=Indicator(1)
  /CONTRAST (Tenure)=Indicator(1)
  /CONTRAST (KnowONS)=Indicator(1)
  /CONTRAST (Census)=Indicator(1)
   /CONTRAST (Mode)=Indicator(1)
  /CONTRAST (Education)=Indicator(1)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

LOGISTIC REGRESSION VARIABLES ConfOutcome
  /METHOD=FSTEP(LR) Age Sex Children Religion Ethnicity EconomicActivity Tenure KnowONS Census YearCat Education 
  /CONTRAST (Age)=Indicator(1)
   /CONTRAST (Sex)=Indicator(1)
   /CONTRAST (Children)=Indicator(1)
  /CONTRAST (Religion)=Indicator(1)
  /CONTRAST (Ethnicity)=Indicator(1)
   /CONTRAST (EconomicActivity)=Indicator(1)
  /CONTRAST (Tenure)=Indicator(1)
  /CONTRAST (KnowONS)=Indicator(1)
  /CONTRAST (Census)=Indicator(1)
   /CONTRAST (YearCat)=Indicator(1)
  /CONTRAST (Education)=Indicator(1)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

DATASET ACTIVATE DataSet24.
LOGISTIC REGRESSION VARIABLES ConfOutcome
  /METHOD=FSTEP(LR) Religion EconomicActivity KnowONS Mode 
   /CONTRAST (Religion)=Indicator(1)
   /CONTRAST (EconomicActivity)=Indicator(1)
  /CONTRAST (KnowONS)=Indicator(1)
  /CONTRAST (Mode)=Indicator(3)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

DATASET ACTIVATE DataSet24.
LOGISTIC REGRESSION VARIABLES ConfOutcome
  /METHOD=FSTEP(LR) Religion EconomicActivity KnowONS YearCat Education
   /CONTRAST (Religion)=Indicator(1)
   /CONTRAST (EconomicActivity)=Indicator(1)
  /CONTRAST (KnowONS)=Indicator(1)
  /CONTRAST (YearCat)=Indicator(1)
   /CONTRAST (Education)=Indicator(1)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

* pooled confidential multinomial



NOMREG ConfShort (BASE=FIRST ORDER=ASCENDING) BY Census KnowONS Mode
  /CRITERIA CIN(95) DELTA(0) MXITER(100) MXSTEP(5) CHKSEP(20) LCONVERGE(0) PCONVERGE(0.000001) 
    SINGULAR(0.00000001)
  /MODEL
  /STEPWISE=PIN(.05) POUT(0.1) MINEFFECT(0) RULE(SINGLE) ENTRYMETHOD(LR) REMOVALMETHOD(LR)
  /INTERCEPT=INCLUDE
  /PRINT=PARAMETER SUMMARY LRT CPS STEP MFI.

*descriptive analysis
*2021


USE ALL.
COMPUTE filter_$=(HhlChl_ArchivingDV   >=  0 & Age_Archiving < 7 &econfw_archiving < 6 & 
    TrstONSOutcome >= 0 &TenureDv_archiving <= 3).
VARIABLE LABELS filter_$ 'HhlChl_ArchivingDV   >=  0 & Age_Archiving < 7 &econfw_archiving < 6 & '+
    'TrstONSOutcome >= 0 &TenureDv_archiving <= 3 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.



FREQUENCIES VARIABLES=StatAccOutcome TrstONSOutcome ConfNOOutcome Age_Archiving Sex 
    HhlChl_ArchivingDV ReligionGrp EthnicityGrp econfw_archiving hedqual_final Education 
    TenureDv_archiving country_sample Mode ONSpa1 ONSaw_DV ONSSurv_DV
  /ORDER=ANALYSIS.

*descirpitve statistics - pooled

DATASET ACTIVATE DataSet5.
USE ALL.
COMPUTE filter_$=(Children < 3 & Ethnicity < 3  & EconomicActivity < 6).
VARIABLE LABELS filter_$ 'Children < 3 & Ethnicity < 3  & EconomicActivity < 6 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.



FREQUENCIES VARIABLES=Age Sex Children Religion Ethnicity EconomicActivity Education Tenure Country 
    Census KnowONS Mode Year StatAccOutcome TrstONSOutcome ConfOutcome
  /ORDER=ANALYSIS.

* 2021 three final weighted binary regressions
    


DATASET ACTIVATE DataSet2.
LOGISTIC REGRESSION VARIABLES StatAccOutcome
  /METHOD=ENTER EthnicityGrp Education Mode ONSpa1 ONSaw_DV ReligionGrp 
  /CONTRAST (ReligionGrp)=Indicator(1)
  /CONTRAST (EthnicityGrp)=Indicator(1)
  /CONTRAST (Education)=Indicator(1)
  /CONTRAST (Mode)=Indicator(1)
  /CONTRAST (ONSpa1)=Indicator(1)
  /CONTRAST (ONSaw_DV)=Indicator(1)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).



DATASET ACTIVATE DataSet3.
LOGISTIC REGRESSION VARIABLES TrstONSOutcome
  /METHOD=ENTER Education TenureDv_archiving Mode ONSaw_DV country_sample 
  /CONTRAST (Education)=Indicator(1)
  /CONTRAST (TenureDv_archiving)=Indicator(1)
  /CONTRAST (country_sample)=Indicator(1)
  /CONTRAST (Mode)=Indicator(1)
  /CONTRAST (ONSaw_DV)=Indicator(1)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

DATASET ACTIVATE DataSet5.
LOGISTIC REGRESSION VARIABLES ConfNOOutcome
  /METHOD=ENTER ReligionGrp Mode ONSaw_DV country_sample 
  /CONTRAST (ReligionGrp)=Indicator(1)
  /CONTRAST (country_sample)=Indicator(1)
  /CONTRAST (Mode)=Indicator(1)
  /CONTRAST (ONSaw_DV)=Indicator(1)
  /CRITERIA=PIN(.05) POUT(.10) ITERATE(20) CUT(.5).

*Exploration of combining the three outcome variables
    
    
DATASET ACTIVATE DataSet1.
USE ALL.
COMPUTE filter_$=(StatAccShort ~= 3 | TrstONSShort ~= 3 | ConfNOShort ~= 3).
VARIABLE LABELS filter_$ 'StatAccShort ~= 3 | TrstONSShort ~= 3 | ConfNOShort ~= 3 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.

*KR-20
    
RELIABILITY
  /VARIABLES=StatAccShort TrstONSShort ConfNOShort
  /SCALE('ALL VARIABLES') ALL
  /MODEL=ALPHA.

*Multiple Correspondence Analysis (MCA)

MULTIPLE CORRES VARIABLES=StatAccShort TrstONSShort ConfNOShort
  /ANALYSIS=StatAccShort(WEIGHT=1) TrstONSShort(WEIGHT=1) ConfNOShort(WEIGHT=1) 
  /MISSING=StatAccShort(PASSIVE,MODEIMPU) TrstONSShort(PASSIVE,MODEIMPU) 
    ConfNOShort(PASSIVE,MODEIMPU) 
  /DIMENSION=2
  /NORMALIZATION=VPRINCIPAL
  /MAXITER=100
  /CRITITER=.00001
  /PRINT=CORR DISCRIM 
  /PLOT=OBJECT(20) DISCRIM(20).


