cd "S:\Projekt\Bortfallsanalys - Lundmark 2019\Analyses\National\"

****************** META-ANALYSES INDIVIDUAL CHARACTERISTICS ********************

use "Individ Riks-SOM 2015.dta", clear
gen year=2015
append using "Individ Riks-SOM 2016.dta", force
replace year=2016 if(year==.)
append using "Individ Riks-SOM 2017.dta", force
replace year=2017 if(year==.)
append using "Individ Riks-SOM 2018.dta", force
replace year=2018 if(year==.)
append using "Individ Riks-SOM 2019.dta", force
replace year=2019 if(year==.)
append using "Individ Riks-SOM 2020.dta", force
replace year=2020 if(year==.)
append using "Individ Riks-SOM 2021.dta", force
replace year=2021 if(year==.)
append using "Individ Riks-SOM 2022.dta", force
replace year=2022 if(year==.)
append using "Individ Riks-SOM 2023.dta", force
replace year=2023 if(year==.)

replace Foedelseaar=Fodelsear if(Foedelseaar==.)
gen cohort=Foedelseaar
recode cohort 1930/1939=1 1940/1949=2 1950/1959=3 1960/1969=4 1970/1979=5 1980/1989=6 1990/1999=7 2000/2009=8
label def cohort 1 "1930/1939" 2 "1940/1949" 3 "1950/1959" 4 "1960/1969" 5 "1970/1979" 6 "1980/1989" 7 "1990/1999" 8 "2000/2009"
label val cohort cohort
gen age=year-Foedelseaar
drop if(svarat==.)
drop svarat100
gen svarat100=svarat*100
tab immigrant, gen(immdum)
tab metro, gen(metrodum)
tab agecat, gen(agecatdum)
tab maritalstatus, gen(maritalstatuscatdum)
tab utsatt_riskgrupp_numeric, gen(utsatt_riskgrupp_numericdum)

****** R-Indicators *****
forval year=2015(1)2023 {
    *display `year'
	preserve
keep if(year== `year')
keep year svarat metro immigrant citizen female age maritalstatus utsatt_riskgrupp_numeric

quietly logit svarat i.metro i.immigrant i.citizen i.female i.age i.maritalstatus i.utsatt_riskgrupp_numeric if(year== `year'), vce(robust)
dis e(N)
gen sam=e(sample)
keep if(sam==1)
save "National for R (`year').dta", replace

quietly gen n=e(N)  
quietly predict xb 
quietly predict stdp  , stdp

quietly sum xb  , d
quietly gen pmean=r(mean)  
quietly gen p=(xb-pmean)^2 
quietly egen totalp=total(p)  
*fre xb stdp n pmean p totalp  
 dis  `year'
 dis 1-2*(sqrt(1/(n-1)*totalp))
quietly drop xb stdp n pmean p totalp

 restore
}

***** RESPONSE RATE OVER YEARS *****
tab svarat year, col chi

***** BREAK-OFF AND PARTIALS OVER YEARS *****
forval year=2015(1)2022 {
preserve
keep if(year== `year')
 dis  `year'
fre  rr5cat
  restore
}


******** ESTIMATING D* *********
tab cohort if(svarat==1&year==2015)
tab cohort if(year==2015)

tab cohort if(svarat==1&year==2016)
tab cohort if(year==2016)

tab cohort if(svarat==1&year==2017)
tab cohort if(year==2017)

tab cohort if(svarat==1&year==2018)
tab cohort if(year==2018)

tab cohort if(svarat==1&year==2019)
tab cohort if(year==2019)

tab cohort if(svarat==1&year==2020)
tab cohort if(year==2020)

tab cohort if(svarat==1&year==2021)
tab cohort if(year==2021)

tab cohort if(svarat==1&year==2022)
tab cohort if(year==2022)

tab cohort if(svarat==1&year==2023)
tab cohort if(year==2023)

*** FOREIGN BORN
tab immigrant if(svarat==1&year==2015)
tab immigrant if(year==2015)

tab immigrant if(svarat==1&year==2016)
tab immigrant if(year==2016)

tab immigrant if(svarat==1&year==2017)
tab immigrant if(year==2017)

tab immigrant if(svarat==1&year==2018)
tab immigrant if(year==2018)

tab immigrant if(svarat==1&year==2019)
tab immigrant if(year==2019)

tab immigrant if(svarat==1&year==2020)
tab immigrant if(year==2020)

tab immigrant if(svarat==1&year==2021)
tab immigrant if(year==2021)

tab immigrant if(svarat==1&year==2022)
tab immigrant if(year==2022)

tab immigrant if(svarat==1&year==2023)
tab immigrant if(year==2023)

tab immigrant svarat if(year==2018), row nofreq
tab immigrant svarat if(year==2019), row nofreq
tab immigrant svarat if(year==2020), row nofreq
tab immigrant svarat if(year==2021), row nofreq
tab immigrant svarat if(year==2022), row nofreq
tab immigrant svarat if(year==2023), row nofreq


preserve
 keep if(year==2015)
 *STANDARDIZING THE VARIABLES*
 egen stdsvarat = std(svarat)
 egen stdmetro = std(metro)
 egen stdcitizen = std(citizen)
 egen stdfemale = std(female)
 egen stdage = std(age)
 egen stdimmdum1 = std(immdum1)
 egen stdimmdum2 = std(immdum2)
 egen stdimmdum3 = std(immdum3)
 egen stdimmdum4 = std(immdum4)
 egen stdagecatdum1 = std(agecatdum1)
 egen stdagecatdum2 = std(agecatdum2)
 egen stdagecatdum3 = std(agecatdum3)
 egen stdagecatdum4 = std(agecatdum4)
 egen stdagecatdum5 = std(agecatdum5)
 egen stdagecatdum6 = std(agecatdum6)
 egen stdmaritalstatuscatdum1 = std(maritalstatuscatdum1)
 egen stdmaritalstatuscatdum2 = std(maritalstatuscatdum2)
 egen stdmaritalstatuscatdum3 = std(maritalstatuscatdum3)
 egen stdmaritalstatuscatdum4 = std(maritalstatuscatdum4)
 egen stdutsatt_riskgrupp_numeric1 = std(utsatt_riskgrupp_numericdum1)
 egen stdutsatt_riskgrupp_numeric2 = std(utsatt_riskgrupp_numericdum2)
 egen stdutsatt_riskgrupp_numeric3 = std(utsatt_riskgrupp_numericdum3)
 egen stdutsatt_riskgrupp_numeric4 = std(utsatt_riskgrupp_numericdum4)
reg stdsvarat  stdimmdum2 stdimmdum3 stdimmdum4 stdcitizen stdfemale stdagecatdum2 stdagecatdum3 stdagecatdum4 stdagecatdum5 stdagecatdum6 stdmaritalstatuscatdum2 stdmaritalstatuscatdum3 stdmaritalstatuscatdum4 stdmetro stdutsatt_riskgrupp_numeric2 stdutsatt_riskgrupp_numeric3 stdutsatt_riskgrupp_numeric4, vce(robust)
reg stdsvarat  stdimmdum2 stdimmdum3 stdimmdum4 stdcitizen stdfemale stdage stdmaritalstatuscatdum2 stdmaritalstatuscatdum3 stdmaritalstatuscatdum4 stdmetro stdutsatt_riskgrupp_numeric2 stdutsatt_riskgrupp_numeric3 stdutsatt_riskgrupp_numeric4, vce(robust)
 parmest, sav("parmest2015.dta", replace) label 
estat vif
restore 

 preserve
 keep if(year==2016)
 *STANDARDIZING THE VARIABLES*
 egen stdsvarat = std(svarat)
 egen stdmetro = std(metro)
 egen stdcitizen = std(citizen)
 egen stdfemale = std(female)
 egen stdage = std(age)
 egen stdimmdum1 = std(immdum1)
 egen stdimmdum2 = std(immdum2)
 egen stdimmdum3 = std(immdum3)
 egen stdimmdum4 = std(immdum4)
 egen stdagecatdum1 = std(agecatdum1)
 egen stdagecatdum2 = std(agecatdum2)
 egen stdagecatdum3 = std(agecatdum3)
 egen stdagecatdum4 = std(agecatdum4)
 egen stdagecatdum5 = std(agecatdum5)
 egen stdagecatdum6 = std(agecatdum6)
 egen stdmaritalstatuscatdum1 = std(maritalstatuscatdum1)
 egen stdmaritalstatuscatdum2 = std(maritalstatuscatdum2)
 egen stdmaritalstatuscatdum3 = std(maritalstatuscatdum3)
 egen stdmaritalstatuscatdum4 = std(maritalstatuscatdum4)
 egen stdutsatt_riskgrupp_numeric1 = std(utsatt_riskgrupp_numericdum1)
 egen stdutsatt_riskgrupp_numeric2 = std(utsatt_riskgrupp_numericdum2)
 egen stdutsatt_riskgrupp_numeric3 = std(utsatt_riskgrupp_numericdum3)
 egen stdutsatt_riskgrupp_numeric4 = std(utsatt_riskgrupp_numericdum4)
reg stdsvarat  stdimmdum2 stdimmdum3 stdimmdum4 stdcitizen stdfemale stdagecatdum2 stdagecatdum3 stdagecatdum4 stdagecatdum5 stdagecatdum6 stdmaritalstatuscatdum2 stdmaritalstatuscatdum3 stdmaritalstatuscatdum4 stdmetro stdutsatt_riskgrupp_numeric2 stdutsatt_riskgrupp_numeric3 stdutsatt_riskgrupp_numeric4, vce(robust)
reg stdsvarat  stdimmdum2 stdimmdum3 stdimmdum4 stdcitizen stdfemale stdage stdmaritalstatuscatdum2 stdmaritalstatuscatdum3 stdmaritalstatuscatdum4 stdmetro stdutsatt_riskgrupp_numeric2 stdutsatt_riskgrupp_numeric3 stdutsatt_riskgrupp_numeric4, vce(robust)
 parmest, sav("parmest2016.dta", replace) label 
estat vif
restore 

 preserve
 keep if(year==2017)
 *STANDARDIZING THE VARIABLES*
 egen stdsvarat = std(svarat)
 egen stdmetro = std(metro)
 egen stdcitizen = std(citizen)
 egen stdfemale = std(female)
 egen stdage = std(age)
 egen stdimmdum1 = std(immdum1)
 egen stdimmdum2 = std(immdum2)
 egen stdimmdum3 = std(immdum3)
 egen stdimmdum4 = std(immdum4)
 egen stdagecatdum1 = std(agecatdum1)
 egen stdagecatdum2 = std(agecatdum2)
 egen stdagecatdum3 = std(agecatdum3)
 egen stdagecatdum4 = std(agecatdum4)
 egen stdagecatdum5 = std(agecatdum5)
 egen stdagecatdum6 = std(agecatdum6)
 egen stdmaritalstatuscatdum1 = std(maritalstatuscatdum1)
 egen stdmaritalstatuscatdum2 = std(maritalstatuscatdum2)
 egen stdmaritalstatuscatdum3 = std(maritalstatuscatdum3)
 egen stdmaritalstatuscatdum4 = std(maritalstatuscatdum4)
 egen stdutsatt_riskgrupp_numeric1 = std(utsatt_riskgrupp_numericdum1)
 egen stdutsatt_riskgrupp_numeric2 = std(utsatt_riskgrupp_numericdum2)
 egen stdutsatt_riskgrupp_numeric3 = std(utsatt_riskgrupp_numericdum3)
 egen stdutsatt_riskgrupp_numeric4 = std(utsatt_riskgrupp_numericdum4)
reg stdsvarat stdimmdum2 stdimmdum3 stdimmdum4 stdcitizen stdfemale stdagecatdum2 stdagecatdum3 stdagecatdum4 stdagecatdum5 stdagecatdum6 stdmaritalstatuscatdum2 stdmaritalstatuscatdum3 stdmaritalstatuscatdum4 stdmetro stdutsatt_riskgrupp_numeric2 stdutsatt_riskgrupp_numeric3 stdutsatt_riskgrupp_numeric4, vce(robust)
reg stdsvarat  stdimmdum2 stdimmdum3 stdimmdum4 stdcitizen stdfemale stdage stdmaritalstatuscatdum2 stdmaritalstatuscatdum3 stdmaritalstatuscatdum4 stdmetro stdutsatt_riskgrupp_numeric2 stdutsatt_riskgrupp_numeric3 stdutsatt_riskgrupp_numeric4, vce(robust)
 parmest, sav("parmest2017.dta", replace) label 
estat vif
restore 

 preserve
 keep if(year==2018)
 *STANDARDIZING THE VARIABLES*
 egen stdsvarat = std(svarat)
 egen stdmetro = std(metro)
 egen stdcitizen = std(citizen)
 egen stdfemale = std(female)
 egen stdage = std(age)
 egen stdimmdum1 = std(immdum1)
 egen stdimmdum2 = std(immdum2)
 egen stdimmdum3 = std(immdum3)
 egen stdimmdum4 = std(immdum4)
 egen stdagecatdum1 = std(agecatdum1)
 egen stdagecatdum2 = std(agecatdum2)
 egen stdagecatdum3 = std(agecatdum3)
 egen stdagecatdum4 = std(agecatdum4)
 egen stdagecatdum5 = std(agecatdum5)
 egen stdagecatdum6 = std(agecatdum6)
 egen stdmaritalstatuscatdum1 = std(maritalstatuscatdum1)
 egen stdmaritalstatuscatdum2 = std(maritalstatuscatdum2)
 egen stdmaritalstatuscatdum3 = std(maritalstatuscatdum3)
 egen stdmaritalstatuscatdum4 = std(maritalstatuscatdum4)
 egen stdutsatt_riskgrupp_numeric1 = std(utsatt_riskgrupp_numericdum1)
 egen stdutsatt_riskgrupp_numeric2 = std(utsatt_riskgrupp_numericdum2)
 egen stdutsatt_riskgrupp_numeric3 = std(utsatt_riskgrupp_numericdum3)
 egen stdutsatt_riskgrupp_numeric4 = std(utsatt_riskgrupp_numericdum4)
reg stdsvarat stdimmdum2 stdimmdum3 stdimmdum4 stdcitizen stdfemale stdagecatdum2 stdagecatdum3 stdagecatdum4 stdagecatdum5 stdagecatdum6 stdmaritalstatuscatdum2 stdmaritalstatuscatdum3 stdmaritalstatuscatdum4 stdmetro stdutsatt_riskgrupp_numeric2 stdutsatt_riskgrupp_numeric3 stdutsatt_riskgrupp_numeric4, vce(robust)
reg stdsvarat  stdimmdum2 stdimmdum3 stdimmdum4 stdcitizen stdfemale stdage stdmaritalstatuscatdum2 stdmaritalstatuscatdum3 stdmaritalstatuscatdum4 stdmetro stdutsatt_riskgrupp_numeric2 stdutsatt_riskgrupp_numeric3 stdutsatt_riskgrupp_numeric4, vce(robust)
 parmest, sav("parmest2018.dta", replace) label 
estat vif
restore 

 preserve
 keep if(year==2019)
 *STANDARDIZING THE VARIABLES*
 egen stdsvarat = std(svarat)
 egen stdmetro = std(metro)
 egen stdcitizen = std(citizen)
 egen stdfemale = std(female)
 egen stdage = std(age)
 egen stdimmdum1 = std(immdum1)
 egen stdimmdum2 = std(immdum2)
 egen stdimmdum3 = std(immdum3)
 egen stdimmdum4 = std(immdum4)
 egen stdagecatdum1 = std(agecatdum1)
 egen stdagecatdum2 = std(agecatdum2)
 egen stdagecatdum3 = std(agecatdum3)
 egen stdagecatdum4 = std(agecatdum4)
 egen stdagecatdum5 = std(agecatdum5)
 egen stdagecatdum6 = std(agecatdum6)
 egen stdmaritalstatuscatdum1 = std(maritalstatuscatdum1)
 egen stdmaritalstatuscatdum2 = std(maritalstatuscatdum2)
 egen stdmaritalstatuscatdum3 = std(maritalstatuscatdum3)
 egen stdmaritalstatuscatdum4 = std(maritalstatuscatdum4)
 egen stdutsatt_riskgrupp_numeric1 = std(utsatt_riskgrupp_numericdum1)
 egen stdutsatt_riskgrupp_numeric2 = std(utsatt_riskgrupp_numericdum2)
 egen stdutsatt_riskgrupp_numeric3 = std(utsatt_riskgrupp_numericdum3)
 egen stdutsatt_riskgrupp_numeric4 = std(utsatt_riskgrupp_numericdum4)
reg stdsvarat stdimmdum2 stdimmdum3 stdimmdum4 stdcitizen stdfemale stdagecatdum2 stdagecatdum3 stdagecatdum4 stdagecatdum5 stdagecatdum6 stdmaritalstatuscatdum2 stdmaritalstatuscatdum3 stdmaritalstatuscatdum4 stdmetro stdutsatt_riskgrupp_numeric2 stdutsatt_riskgrupp_numeric3 stdutsatt_riskgrupp_numeric4, vce(robust)
reg stdsvarat  stdimmdum2 stdimmdum3 stdimmdum4 stdcitizen stdfemale stdage stdmaritalstatuscatdum2 stdmaritalstatuscatdum3 stdmaritalstatuscatdum4 stdmetro stdutsatt_riskgrupp_numeric2 stdutsatt_riskgrupp_numeric3 stdutsatt_riskgrupp_numeric4, vce(robust)
 parmest, sav("parmest2019.dta", replace) label 
estat vif
restore 

 preserve
 keep if(year==2020)
 *STANDARDIZING THE VARIABLES*
 egen stdsvarat = std(svarat)
 egen stdmetro = std(metro)
 egen stdcitizen = std(citizen)
 egen stdfemale = std(female)
 egen stdage = std(age)
 egen stdimmdum1 = std(immdum1)
 egen stdimmdum2 = std(immdum2)
 egen stdimmdum3 = std(immdum3)
 egen stdimmdum4 = std(immdum4)
 egen stdagecatdum1 = std(agecatdum1)
 egen stdagecatdum2 = std(agecatdum2)
 egen stdagecatdum3 = std(agecatdum3)
 egen stdagecatdum4 = std(agecatdum4)
 egen stdagecatdum5 = std(agecatdum5)
 egen stdagecatdum6 = std(agecatdum6)
 egen stdmaritalstatuscatdum1 = std(maritalstatuscatdum1)
 egen stdmaritalstatuscatdum2 = std(maritalstatuscatdum2)
 egen stdmaritalstatuscatdum3 = std(maritalstatuscatdum3)
 egen stdmaritalstatuscatdum4 = std(maritalstatuscatdum4)
 egen stdutsatt_riskgrupp_numeric1 = std(utsatt_riskgrupp_numericdum1)
 egen stdutsatt_riskgrupp_numeric2 = std(utsatt_riskgrupp_numericdum2)
 egen stdutsatt_riskgrupp_numeric3 = std(utsatt_riskgrupp_numericdum3)
 egen stdutsatt_riskgrupp_numeric4 = std(utsatt_riskgrupp_numericdum4)
reg stdsvarat stdimmdum2 stdimmdum3 stdimmdum4 stdcitizen stdfemale stdagecatdum2 stdagecatdum3 stdagecatdum4 stdagecatdum5 stdagecatdum6 stdmaritalstatuscatdum2 stdmaritalstatuscatdum3 stdmaritalstatuscatdum4 stdmetro stdutsatt_riskgrupp_numeric2 stdutsatt_riskgrupp_numeric3 stdutsatt_riskgrupp_numeric4, vce(robust)
reg stdsvarat  stdimmdum2 stdimmdum3 stdimmdum4 stdcitizen stdfemale stdage stdmaritalstatuscatdum2 stdmaritalstatuscatdum3 stdmaritalstatuscatdum4 stdmetro stdutsatt_riskgrupp_numeric2 stdutsatt_riskgrupp_numeric3 stdutsatt_riskgrupp_numeric4, vce(robust)
 parmest, sav("parmest2020.dta", replace) label 
estat vif
restore 

 preserve
 keep if(year==2021)
 *STANDARDIZING THE VARIABLES*
 egen stdsvarat = std(svarat)
 egen stdmetro = std(metro)
 egen stdcitizen = std(citizen)
 egen stdfemale = std(female)
 egen stdage = std(age)
 egen stdimmdum1 = std(immdum1)
 egen stdimmdum2 = std(immdum2)
 egen stdimmdum3 = std(immdum3)
 egen stdimmdum4 = std(immdum4)
 egen stdagecatdum1 = std(agecatdum1)
 egen stdagecatdum2 = std(agecatdum2)
 egen stdagecatdum3 = std(agecatdum3)
 egen stdagecatdum4 = std(agecatdum4)
 egen stdagecatdum5 = std(agecatdum5)
 egen stdagecatdum6 = std(agecatdum6)
 egen stdmaritalstatuscatdum1 = std(maritalstatuscatdum1)
 egen stdmaritalstatuscatdum2 = std(maritalstatuscatdum2)
 egen stdmaritalstatuscatdum3 = std(maritalstatuscatdum3)
 egen stdmaritalstatuscatdum4 = std(maritalstatuscatdum4)
 egen stdutsatt_riskgrupp_numeric1 = std(utsatt_riskgrupp_numericdum1)
 egen stdutsatt_riskgrupp_numeric2 = std(utsatt_riskgrupp_numericdum2)
 egen stdutsatt_riskgrupp_numeric3 = std(utsatt_riskgrupp_numericdum3)
 egen stdutsatt_riskgrupp_numeric4 = std(utsatt_riskgrupp_numericdum4)
reg stdsvarat stdimmdum2 stdimmdum3 stdimmdum4 stdcitizen stdfemale stdagecatdum2 stdagecatdum3 stdagecatdum4 stdagecatdum5 stdagecatdum6 stdmaritalstatuscatdum2 stdmaritalstatuscatdum3 stdmaritalstatuscatdum4 stdmetro stdutsatt_riskgrupp_numeric2 stdutsatt_riskgrupp_numeric3 stdutsatt_riskgrupp_numeric4, vce(robust)
reg stdsvarat  stdimmdum2 stdimmdum3 stdimmdum4 stdcitizen stdfemale stdage stdmaritalstatuscatdum2 stdmaritalstatuscatdum3 stdmaritalstatuscatdum4 stdmetro stdutsatt_riskgrupp_numeric2 stdutsatt_riskgrupp_numeric3 stdutsatt_riskgrupp_numeric4, vce(robust)
 parmest, sav("parmest2021.dta", replace) label 
estat vif
restore 

 preserve
 keep if(year==2022)
 *STANDARDIZING THE VARIABLES*
 egen stdsvarat = std(svarat)
 egen stdmetro = std(metro)
 egen stdcitizen = std(citizen)
 egen stdfemale = std(female)
 egen stdage = std(age)
 egen stdimmdum1 = std(immdum1)
 egen stdimmdum2 = std(immdum2)
 egen stdimmdum3 = std(immdum3)
 egen stdimmdum4 = std(immdum4)
 egen stdagecatdum1 = std(agecatdum1)
 egen stdagecatdum2 = std(agecatdum2)
 egen stdagecatdum3 = std(agecatdum3)
 egen stdagecatdum4 = std(agecatdum4)
 egen stdagecatdum5 = std(agecatdum5)
 egen stdagecatdum6 = std(agecatdum6)
 egen stdmaritalstatuscatdum1 = std(maritalstatuscatdum1)
 egen stdmaritalstatuscatdum2 = std(maritalstatuscatdum2)
 egen stdmaritalstatuscatdum3 = std(maritalstatuscatdum3)
 egen stdmaritalstatuscatdum4 = std(maritalstatuscatdum4)
 egen stdutsatt_riskgrupp_numeric1 = std(utsatt_riskgrupp_numericdum1)
 egen stdutsatt_riskgrupp_numeric2 = std(utsatt_riskgrupp_numericdum2)
 egen stdutsatt_riskgrupp_numeric3 = std(utsatt_riskgrupp_numericdum3)
 egen stdutsatt_riskgrupp_numeric4 = std(utsatt_riskgrupp_numericdum4)
reg stdsvarat stdimmdum2 stdimmdum3 stdimmdum4 stdcitizen stdfemale stdagecatdum2 stdagecatdum3 stdagecatdum4 stdagecatdum5 stdagecatdum6 stdmaritalstatuscatdum2 stdmaritalstatuscatdum3 stdmaritalstatuscatdum4 stdmetro stdutsatt_riskgrupp_numeric2 stdutsatt_riskgrupp_numeric3 stdutsatt_riskgrupp_numeric4, vce(robust)
reg stdsvarat stdimmdum2 stdimmdum3 stdimmdum4 stdcitizen stdfemale stdage stdmaritalstatuscatdum2 stdmaritalstatuscatdum3 stdmaritalstatuscatdum4 stdmetro stdutsatt_riskgrupp_numeric2 stdutsatt_riskgrupp_numeric3 stdutsatt_riskgrupp_numeric4, vce(robust)
 parmest, sav("parmest2022.dta", replace) label 
estat vif
restore 


 preserve
 keep if(year==2023)
 *STANDARDIZING THE VARIABLES*
 egen stdsvarat = std(svarat)
 egen stdmetro = std(metro)
 egen stdcitizen = std(citizen)
 egen stdfemale = std(female)
 egen stdage = std(age)
 egen stdimmdum1 = std(immdum1)
 egen stdimmdum2 = std(immdum2)
 egen stdimmdum3 = std(immdum3)
 egen stdimmdum4 = std(immdum4)
 egen stdagecatdum1 = std(agecatdum1)
 egen stdagecatdum2 = std(agecatdum2)
 egen stdagecatdum3 = std(agecatdum3)
 egen stdagecatdum4 = std(agecatdum4)
 egen stdagecatdum5 = std(agecatdum5)
 egen stdagecatdum6 = std(agecatdum6)
 egen stdmaritalstatuscatdum1 = std(maritalstatuscatdum1)
 egen stdmaritalstatuscatdum2 = std(maritalstatuscatdum2)
 egen stdmaritalstatuscatdum3 = std(maritalstatuscatdum3)
 egen stdmaritalstatuscatdum4 = std(maritalstatuscatdum4)
 egen stdutsatt_riskgrupp_numeric1 = std(utsatt_riskgrupp_numericdum1)
 egen stdutsatt_riskgrupp_numeric2 = std(utsatt_riskgrupp_numericdum2)
 egen stdutsatt_riskgrupp_numeric3 = std(utsatt_riskgrupp_numericdum3)
 egen stdutsatt_riskgrupp_numeric4 = std(utsatt_riskgrupp_numericdum4)
reg stdsvarat stdimmdum2 stdimmdum3 stdimmdum4 stdcitizen stdfemale stdagecatdum2 stdagecatdum3 stdagecatdum4 stdagecatdum5 stdagecatdum6 stdmaritalstatuscatdum2 stdmaritalstatuscatdum3 stdmaritalstatuscatdum4 stdmetro stdutsatt_riskgrupp_numeric2 stdutsatt_riskgrupp_numeric3 stdutsatt_riskgrupp_numeric4, vce(robust)
reg stdsvarat stdimmdum2 stdimmdum3 stdimmdum4 stdcitizen stdfemale stdage stdmaritalstatuscatdum2 stdmaritalstatuscatdum3 stdmaritalstatuscatdum4 stdmetro stdutsatt_riskgrupp_numeric2 stdutsatt_riskgrupp_numeric3 stdutsatt_riskgrupp_numeric4, vce(robust)
 parmest, sav("parmest2023.dta", replace) label 
estat vif
restore 

preserve
use "parmest2015.dta", clear
gen year=2015
append using "parmest2016.dta"
replace year=2016 if(year==.)
append using "parmest2017.dta"
replace year=2017 if(year==.)
append using "parmest2018.dta"
replace year=2018 if(year==.)
append using "parmest2019.dta"
replace year=2019 if(year==.)
append using "parmest2020.dta"
replace year=2020 if(year==.)
append using "parmest2021.dta"
replace year=2021 if(year==.)
append using "parmest2022.dta"
replace year=2022 if(year==.)
append using "parmest2023.dta"
replace year=2023 if(year==.)

drop if(estimate==0)
replace label="Risk of becoming socially disadvantaged" if(parm=="stdutsatt_riskgrupp_numeric3")
replace label="Socially disadvantaged" if(parm=="stdutsatt_riskgrupp_numeric2")
replace label="Extremely socially disadvantaged" if(parm=="stdutsatt_riskgrupp_numeric4")
replace label="Swedish citizen" if(parm=="stdcitizen") 
replace label="Female" if(parm=="stdfemale") 
replace label="Age" if(parm=="stdage") 
replace label="Age 25-34" if(parm=="stdagecatdum2") 
replace label="Age 35-44" if(parm=="stdagecatdum3") 
replace label="Age 45-54" if(parm=="stdagecatdum4") 
*replace label="Age 55-64" if(parm=="stdagecatdum5") 
*replace label="Age 65 or older" if(parm=="stdagecatdum6") 
replace label="Divorced" if(parm=="stdmaritalstatuscatdum2") 
replace label="Widow/Widower" if(parm=="stdmaritalstatuscatdum3") 
replace label="Married" if(parm=="stdmaritalstatuscatdum4") 
replace label="Born in the Nordics" if(parm=="stdimmdum2") 
replace label="Born somewhere else in Europe" if(parm=="stdimmdum3") 
replace label="Born somewhere outside Europe" if(parm=="stdimmdum4") 
replace label="Metropolitan area" if(parm=="stdmetro") 
replace parm="Risk of becoming socially disadvantaged" if(parm=="stdutsatt_riskgrupp_numeric3")
replace parm="Socially disadvantaged" if(parm=="stdutsatt_riskgrupp_numeric2")
replace parm="Extremely socially disadvantaged" if(parm=="stdutsatt_riskgrupp_numeric4")
replace parm="Swedish citizen" if(parm=="stdcitizen") 
replace parm="Female" if(parm=="stdfemale") 
replace parm="Age" if(parm=="stdage") 
*replace parm="Age 25-34" if(parm=="stdagecatdum2") 
*replace parm="Age 35-44" if(parm=="stdagecatdum3") 
*replace parm="Age 45-54" if(parm=="stdagecatdum4") 
*replace parm="Age 55-64" if(parm=="stdagecatdum5") 
*replace parm="Age 65 or older" if(parm=="stdagecatdum6") 
replace parm="Divorced" if(parm=="stdmaritalstatuscatdum2") 
replace parm="Widow/Widower" if(parm=="stdmaritalstatuscatdum3") 
replace parm="Married" if(parm=="stdmaritalstatuscatdum4") 
replace parm="Born in the Nordics" if(parm=="stdimmdum2") 
replace parm="Born somewhere else in Europe" if(parm=="stdimmdum3") 
replace parm="Born somewhere outside Europe" if(parm=="stdimmdum4") 
replace parm="Metropolitan area" if(parm=="stdmetro") 
replace parm="Born in the Nordics (not Sweden)" if(parm=="stdimmdum2") 
replace parm="Born somewhere else in Europe" if(parm=="stdimmdum3") 
replace parm="Born somewhere outside Europe" if(parm=="stdimmdum4") 
replace parm="Metropolitan area" if(parm=="stdmetro") 
label var parm "Sub-group overall meta-analytical effects on response rates"
clonevar parm2=parm

set scheme som

**** FIGURE 2 *****
drop if(parm=="_cons")
metan estimate stderr , by(parm) random effect(Standardized RR1)  diamopt(lcolor(black))  nowt nooverall  texts(115) ilevel(95) olevel(95)  xlab(-0.30(0.15)0.3) lcols(parm2)  summaryonly note("") hetstat(I2 Q p)
mat list r(bystats)
graph export "Figure 2 - Meta-analyses Sample 1.png", replace
graph export "Figure 2 - Meta-analyses Sample 1.svg", replace

**** FIGURE 3 *****
twoway ///
(scatter estimate year if(parm=="Born in the Nordics"), msymbol(O) mcolor(orange%30)) (lfit estimate year if(parm=="Born in the Nordics"), lcolor(orange%30) lwidth(thick)) (rcap min95 max95 year if(parm=="Born in the Nordics"), lcolor(orange)) ///
(scatter estimate year if(parm=="Born somewhere else in Europe"), msymbol(O) mcolor(orange%60)) (lfit estimate year if(parm=="Born somewhere else in Europe"), lcolor(orange%60) lwidth(thick)) (rcap min95 max95 year if(parm=="Born somewhere else in Europe"), lcolor(orange)) ///
(scatter estimate year if(parm=="Born somewhere outside Europe"), msymbol(O) mcolor(orange%90)) (lfit estimate year if(parm=="Born somewhere outside Europe"), lcolor(orange%90) lwidth(thick)) (rcap min95 max95 year if(parm=="Born somewhere outside Europe"), lcolor(orange)) ///
(scatter estimate year if(parm=="Age"), msymbol(O) mcolor(green%50)) (lfit estimate year if(parm=="Age"), lcolor(green%50) lwidth(thick)) (rcap min95 max95 year if(parm=="Age"), lcolor(green)) ///
, ylab(0.30(0.15)-0.30) ytitle("Proposensity to respond" " ") xtitle(" " "Year", size(med)) xlab(2014.5 " " 2015(1)2023 2023.5 " ") legend(order(10 1 4 7) size(small) label(1 "Born in the Nordics (not Sweden)") label(4 "Born somewhere else in Europe") label(7 "Born somewhere outside Europe") label(10 "Age")) graphregion(margin(medium)) yline(0, lcolor(gray))
graph export "Figure 3 - Fitted line over years.svg", replace
graph export "Figure 3 - Fitted line over years.png", replace
reg estimate year if(parm=="Born in the Nordics")
reg estimate year if(parm=="Born somewhere else in Europe")
reg estimate year if(parm=="Born somewhere outside Europe") 
reg estimate year if(parm=="Age") 

**** FIGURE S1 *****
metan estimate stderr if(parm=="Age"), random effect(Standardized RR1)  diamopt(lcolor(black))  nowt  texts(105) ilevel(95) olevel(95) xlab(-0.30(0.15)0.3) lcols(year)  note("") 
graph export "Figure S1.1. Age only.svg", replace

metan estimate stderr if(parm=="Born somewhere outside Europe"|parm=="Born somewhere else in Europe"|parm=="Born in the Nordics") , by(parm) random effect(Standardized RR1)  diamopt(lcolor(black))  nowt nooverall  texts(105) ilevel(95) olevel(95) xlab(-0.30(0.15)0.3) lcols(year) note("") 
graph export "Figure S1.1. foreign-born only.svg", replace

metan estimate stderr if(parm=="Swedish citizen"|parm=="Female") , by(parm) random effect(Standardized RR1)  diamopt(lcolor(black))  nowt nooverall  texts(105) ilevel(95) olevel(95) xlab(-0.30(0.15)0.3) lcols(year)  note("") 
graph export "Figure S1.1. Citizen and Female only.svg", replace

metan estimate stderr if(parm=="Divorced"|parm=="Widow/Widower"|parm=="Married") , by(parm) random effect(Standardized RR1)  diamopt(lcolor(black))  nowt nooverall  texts(105) ilevel(95) olevel(95) xlab(-0.30(0.15)0.3) lcols(year)  note("") 
graph export "Figure S1.1. Marital Status only.svg", replace

metan estimate stderr if(parm=="Metropolitan area"|parm=="Socially disadvantaged"|parm=="Risk of becoming socially disadvantaged"|parm=="Extremely socially disadvantaged")  , by(parm) random effect(Standardized RR1)  diamopt(lcolor(black))  nowt nooverall  texts(105) ilevel(95) olevel(95) xlab(-0.30(0.15)0.3) lcols(year)  note("") 
graph export "Figure S1.1. Contextual only.svg", replace


****** ROBUSTNESS CHECKS **********
gen incentive=0
replace incentive=1 if(year>2016)

mixed svarat i.metro i.immigrant i.citizen i.female c.age i.maritalstatus i.utsatt_riskgrupp_numeric i.incentive || year: , 
est store a

esttab a using "Robustness Check - Multilevel Model.rtf",  substitute("\fonttbl{\f0\fnil Times New Roman" "\fonttbl{\f0\fnil Arial" "\fs24" "\fs20" "\fs20" "\fs20" "\super " "" "\trowd" "\trowd\intbl\trautofit1" "#" "{\b x}" "ref." "" ) ///
mgroups("Submitted the questionnaire", pattern(1 0 0 0)) ///
mtitles("Contextual variables" "Individual characteristics" "Contextual and individual characteristics") ///
title("{\b Table SX.} Multilevel regression results.") ///
order(1.incentive 1.female age 1.maritalstatus 2.maritalstatus 3.maritalstatus  1.immigrant 2.immigrant 1.citizen  1.metro 1.utsatt_riskgrupp_numeric 2.utsatt_riskgrupp_numeric 3.utsatt_riskgrupp_numeric) ///
b(2)  se(2) nogaps l nonumbers nobase noomitted onecell nodepvars noobs replace star(+ 0.1 * 0.05 ** 0.01 *** 0.001) ///
nonotes addnotes("{\i Notes. N} = 197,536. Nine groups. Observations per group: Minimum = 17,000; Maximum = 25,612; Average = 21,948.4. Entries are unstandardized regression coefficients. Standard errors in parentheses.  \line + {\i p} < .1. \line * {\i p} < .05. \line ** {\i p} < .01. \line *** {\i p} < .001.") ///
incelldelimiter(" ") alignment(c) ///
refcat(1.incentive "{\b Survey protocol changes} \l\ul Added incentive\ul0" 1.female "{\b Individual characteristics} \l\ul Sex\ul0" age "\l\ul Age\ul0" 1.utsatt_riskgrupp_numeric "\l\ul Socially impoverished area\ul0" 1.metro "{\b Contextual variables} \l\ul Metropolitan or not\ul0" 1.immigrant "\l\ul Country of birth\ul0" 1.maritalstatus "\l\ul Marital status\ul0" 1.citizen "\l\ul Citizenship\ul0") 
