***** SAMPLE 2 ANALYSES ******
use "R:\Gemensam\SNES Data Vault\Data\VU 2022\vu22_v5.dta" , clear

ds, has (type string)

**** Removing stringvariables and other mtidn2 f2b f2a samprob2 samprob3 anparti anideologi_txt anparti2 angrupp anspraak_txt anspraak anutb ansex_txt ssyk ssyk96 f137sing rparti lparti fackforb
recode q1a q1b q1c q1d q1e q2a q2b q2c q2d q3 q3a q3b q3c q3d q4 q5 q6 q7 q8 q9 q10 q11 q12 q13 q14a q14b q14c q14d q15a q15b q15c q16a q16b q16c q16d q16e q16f q16g q16h q17a q17b q17c q17d q17e q17f q17g q17h q17i q18a q18b q18c q18d q18e q18f q18g q18h q18i q18j q18k q18l q18m q18n q18o q18p q18q q18r q19_vf1 q20a q20b q20c q21a q21b q22 q23 q24 q25  q26  q27a q27b q27c q27d q27e q27f q27g q27h q27i q27j q27k  q28  q30a q30b q32a q32b q32c q32d q32e q32f q32g q32h q32i q32j q32k q32l q32m q32n q32o q32p q32q q32r q33 q34a q34b q34c q34d q34e q34f q34g q34h q35a q35b  q36a q36b q36c q36d q36e q36f q36g q36h q36i q36j  q37a q37b q37c q37d q37e q37f q37g q37h q38a q38b q38c q38d q38e q38f q38g q38h q40a q40b q40c q40d q40e q40f q40g q40h q41a q41b q43 q44a q44b q45 q46 q47a q47b q47c q47d q47e q47f q47g q47h q48 q49 q50 q51a q51b q51c q51d q51e q51f q52 q53a q53b q53c q53d q53e q53f q53g q53h q54a q54b q54c q54d q54e q54f q54g q54h q55 q56a q56b q56c q56d q56e q56f q56g q56h q61a q61b q61c q61d q61e q62a q62b q62c q62d  q64  q65 q66 q67 q68  q72a q72b q72c q72d q72e q72f q72g q72h q73 q74a q74b q74c q74d q74e q74f q74g q74h q75 q76a q76b q76c q76d q76e q76f q77a q77b q77c q77d q77e q77f q78a q78b q78c q78d q78e q78f q78g q78h q78i q78j q78k q78l q78m q78n q78o q78p q78q q78r q78s q78t q78u q78v q78w q78x q78y q78z q78aa q78ab q78ac q78ad q78ae q78af q78ag q78ah q78ai q78aj q78ak q78al q78am q78an q78ao q78ap q78aq q79 q80 q81 q82a q82b q83a q83b q83c q83d q83e q83f q83g q83h q83i q83j q83k q83l q83m q83n q85 q86a q86b q87a q87b q88 q89a q89b q89c q89d q89e q90 q91 q92a q92b q92c q92d q92e q93 q94 q95a q95b q95c q96  q99 q100 q101 q102 q103  q104 q105 q106a q106b q106c q107 q108 q109 q110 q111 q112a q113 q114 q115 q116 q117a q117b q117c q117d q117e q117f q117g q117h q117i q117j q117k q301 q302a q302b q302c q302d q302e q302f q303 q304 q305a q305b q305c q305d q306a q306b q306c q307 q308a q308b q308c q308d q308e q308f q308g q308h q309 q310 q312a q312b q313 q314 q315 q316 q317 q318 q319 q320a q320b q320c q320d q320e q320f q320g q320h q320i q320j q320k q321a q321b q322 q323a q323b  q324 q325a q325b q325c q325d q325e q325f q325g q325h q326a q326b q326c q326d q326e q326f q326g q326h q326i q327a q327b q327c q327d q327e q327f q327g q327h q328 q329a q329b q329c q329d q329e q329f q330 q331 q332a q332b q332c  q332d q333 q334  q335 q336 q337a q337b q338 q339a q339b q339c q339d q339e q339f q339g q339h q339i q339j q339k q339l q339m q339n q339o q339p q340 q341 q342a q342b q342c q342d q342e q343 q344 q345 q346 q347 q348 q349 q350 q351a q351b q351c q351d q351e q351f q351g q352 q352_ssyk q353 q354 q355 q356 q357 q358 q359 q360 q361a q361b q361c q362 q363 q364  q365a q365ba q365bb q365bc q365c q365da q365db q365dc q365dd q366  q367 q368 q369 q370 q371a q371b q371c q371d q371e q371f q371g q371h q371i q371j q371k (.d=-98) (.h=-99) (.v=-97)  (.n=-96) (.u=-100)
 
 egen response2 = anycount(q1a q1b q1c q1d q1e q2a q2b q2c q2d q3 q3a q3b q3c q3d q4 q5 q6 q7 q8 q9 q10 q11 q12 q13 q14a q14b q14c q14d q15a q15b q15c q16a q16b q16c q16d q16e q16f q16g q16h q17a q17b q17c q17d q17e q17f q17g q17h q17i q18a q18b q18c q18d q18e q18f q18g q18h q18i q18j q18k q18l q18m q18n q18o q18p q18q q18r q19_vf1 q20a q20b q20c q21a q21b q22 q23 q24 q25  q26  q27a q27b q27c q27d q27e q27f q27g q27h q27i q27j q27k  q28  q30a q30b q32a q32b q32c q32d q32e q32f q32g q32h q32i q32j q32k q32l q32m q32n q32o q32p q32q q32r q33 q34a q34b q34c q34d q34e q34f q34g q34h q35a q35b  q36a q36b q36c q36d q36e q36f q36g q36h q36i q36j  q37a q37b q37c q37d q37e q37f q37g q37h q38a q38b q38c q38d q38e q38f q38g q38h q40a q40b q40c q40d q40e q40f q40g q40h q41a q41b q43 q44a q44b q45 q46 q47a q47b q47c q47d q47e q47f q47g q47h q48 q49 q50 q51a q51b q51c q51d q51e q51f q52 q53a q53b q53c q53d q53e q53f q53g q53h q54a q54b q54c q54d q54e q54f q54g q54h q55 q56a q56b q56c q56d q56e q56f q56g q56h q61a q61b q61c q61d q61e q62a q62b q62c q62d  q64  q65 q66 q67 q68  q72a q72b q72c q72d q72e q72f q72g q72h q73 q74a q74b q74c q74d q74e q74f q74g q74h q75 q76a q76b q76c q76d q76e q76f q77a q77b q77c q77d q77e q77f q78a q78b q78c q78d q78e q78f q78g q78h q78i q78j q78k q78l q78m q78n q78o q78p q78q q78r q78s q78t q78u q78v q78w q78x q78y q78z q78aa q78ab q78ac q78ad q78ae q78af q78ag q78ah q78ai q78aj q78ak q78al q78am q78an q78ao q78ap q78aq q79 q80 q81 q82a q82b q83a q83b q83c q83d q83e q83f q83g q83h q83i q83j q83k q83l q83m q83n q85 q86a q86b q87a q87b q88 q89a q89b q89c q89d q89e q90 q91 q92a q92b q92c q92d q92e q93 q94 q95a q95b q95c q96  q99 q100 q101 q102 q103  q104 q105 q106a q106b q106c q107 q108 q109 q110 q111 q112a q113 q114 q115 q116 q117a q117b q117c q117d q117e q117f q117g q117h q117i q117j q117k q301 q302a q302b q302c q302d q302e q302f q303 q304 q305a q305b q305c q305d q306a q306b q306c q307 q308a q308b q308c q308d q308e q308f q308g q308h q309 q310 q312a q312b q313 q314 q315 q316 q317 q318 q319 q320a q320b q320c q320d q320e q320f q320g q320h q320i q320j q320k q321a q321b q322 q323a q323b  q324 q325a q325b q325c q325d q325e q325f q325g q325h q326a q326b q326c q326d q326e q326f q326g q326h q326i q327a q327b q327c q327d q327e q327f q327g q327h q328 q329a q329b q329c q329d q329e q329f q330 q331 q332a q332b q332c  q332d q333 q334  q335 q336 q337a q337b q338 q339a q339b q339c q339d q339e q339f q339g q339h q339i q339j q339k q339l q339m q339n q339o q339p q340 q341 q342a q342b q342c q342d q342e q343 q344 q345 q346 q347 q348 q349 q350 q351a q351b q351c q351d q351e q351f q351g q352 q352_ssyk q353 q354 q355 q356 q357 q358 q359 q360 q361a q361b q361c q362 q363 q364  q365a q365ba q365bb q365bc q365c q365da q365db q365dc q365dd q366  q367 q368 q369 q370 q371a q371b q371c q371d q371e q371f q371g q371h q371i q371j q371k), values (-97 -99)

egen numbq = rownonmiss(q1a q1b q1c q1d q1e q2a q2b q2c q2d q3 q3a q3b q3c q3d q4 q5 q6 q7 q8 q9 q10 q11 q12 q13 q14a q14b q14c q14d q15a q15b q15c q16a q16b q16c q16d q16e q16f q16g q16h q17a q17b q17c q17d q17e q17f q17g q17h q17i q18a q18b q18c q18d q18e q18f q18g q18h q18i q18j q18k q18l q18m q18n q18o q18p q18q q18r q19_vf1 q20a q20b q20c q21a q21b q22 q23 q24 q25  q26  q27a q27b q27c q27d q27e q27f q27g q27h q27i q27j q27k  q28  q30a q30b q32a q32b q32c q32d q32e q32f q32g q32h q32i q32j q32k q32l q32m q32n q32o q32p q32q q32r q33 q34a q34b q34c q34d q34e q34f q34g q34h q35a q35b  q36a q36b q36c q36d q36e q36f q36g q36h q36i q36j  q37a q37b q37c q37d q37e q37f q37g q37h q38a q38b q38c q38d q38e q38f q38g q38h q40a q40b q40c q40d q40e q40f q40g q40h q41a q41b q43 q44a q44b q45 q46 q47a q47b q47c q47d q47e q47f q47g q47h q48 q49 q50 q51a q51b q51c q51d q51e q51f q52 q53a q53b q53c q53d q53e q53f q53g q53h q54a q54b q54c q54d q54e q54f q54g q54h q55 q56a q56b q56c q56d q56e q56f q56g q56h q61a q61b q61c q61d q61e q62a q62b q62c q62d  q64  q65 q66 q67 q68  q72a q72b q72c q72d q72e q72f q72g q72h q73 q74a q74b q74c q74d q74e q74f q74g q74h q75 q76a q76b q76c q76d q76e q76f q77a q77b q77c q77d q77e q77f q78a q78b q78c q78d q78e q78f q78g q78h q78i q78j q78k q78l q78m q78n q78o q78p q78q q78r q78s q78t q78u q78v q78w q78x q78y q78z q78aa q78ab q78ac q78ad q78ae q78af q78ag q78ah q78ai q78aj q78ak q78al q78am q78an q78ao q78ap q78aq q79 q80 q81 q82a q82b q83a q83b q83c q83d q83e q83f q83g q83h q83i q83j q83k q83l q83m q83n q85 q86a q86b q87a q87b q88 q89a q89b q89c q89d q89e q90 q91 q92a q92b q92c q92d q92e q93 q94 q95a q95b q95c q96  q99 q100 q101 q102 q103  q104 q105 q106a q106b q106c q107 q108 q109 q110 q111 q112a q113 q114 q115 q116 q117a q117b q117c q117d q117e q117f q117g q117h q117i q117j q117k q301 q302a q302b q302c q302d q302e q302f q303 q304 q305a q305b q305c q305d q306a q306b q306c q307 q308a q308b q308c q308d q308e q308f q308g q308h q309 q310 q312a q312b q313 q314 q315 q316 q317 q318 q319 q320a q320b q320c q320d q320e q320f q320g q320h q320i q320j q320k q321a q321b q322 q323a q323b  q324 q325a q325b q325c q325d q325e q325f q325g q325h q326a q326b q326c q326d q326e q326f q326g q326h q326i q327a q327b q327c q327d q327e q327f q327g q327h q328 q329a q329b q329c q329d q329e q329f q330 q331 q332a q332b q332c  q332d q333 q334  q335 q336 q337a q337b q338 q339a q339b q339c q339d q339e q339f q339g q339h q339i q339j q339k q339l q339m q339n q339o q339p q340 q341 q342a q342b q342c q342d q342e q343 q344 q345 q346 q347 q348 q349 q350 q351a q351b q351c q351d q351e q351f q351g q352 q352_ssyk q353 q354 q355 q356 q357 q358 q359 q360 q361a q361b q361c q362 q363 q364  q365a q365ba q365bb q365bc q365c q365da q365db q365dc q365dd q366  q367 q368 q369 q370 q371a q371b q371c q371d q371e q371f q371g q371h q371i q371j q371k)

egen notpart96 = anycount(q1a q1b q1c q1d q1e q2a q2b q2c q2d q3 q3a q3b q3c q3d q4 q5 q6 q7 q8 q9 q10 q11 q12 q13 q14a q14b q14c q14d q15a q15b q15c q16a q16b q16c q16d q16e q16f q16g q16h q17a q17b q17c q17d q17e q17f q17g q17h q17i q18a q18b q18c q18d q18e q18f q18g q18h q18i q18j q18k q18l q18m q18n q18o q18p q18q q18r q19_vf1 q20a q20b q20c q21a q21b q22 q23 q24 q25  q26  q27a q27b q27c q27d q27e q27f q27g q27h q27i q27j q27k  q28  q30a q30b q32a q32b q32c q32d q32e q32f q32g q32h q32i q32j q32k q32l q32m q32n q32o q32p q32q q32r q33 q34a q34b q34c q34d q34e q34f q34g q34h q35a q35b  q36a q36b q36c q36d q36e q36f q36g q36h q36i q36j  q37a q37b q37c q37d q37e q37f q37g q37h q38a q38b q38c q38d q38e q38f q38g q38h q40a q40b q40c q40d q40e q40f q40g q40h q41a q41b q43 q44a q44b q45 q46 q47a q47b q47c q47d q47e q47f q47g q47h q48 q49 q50 q51a q51b q51c q51d q51e q51f q52 q53a q53b q53c q53d q53e q53f q53g q53h q54a q54b q54c q54d q54e q54f q54g q54h q55 q56a q56b q56c q56d q56e q56f q56g q56h q61a q61b q61c q61d q61e q62a q62b q62c q62d  q64  q65 q66 q67 q68  q72a q72b q72c q72d q72e q72f q72g q72h q73 q74a q74b q74c q74d q74e q74f q74g q74h q75 q76a q76b q76c q76d q76e q76f q77a q77b q77c q77d q77e q77f q78a q78b q78c q78d q78e q78f q78g q78h q78i q78j q78k q78l q78m q78n q78o q78p q78q q78r q78s q78t q78u q78v q78w q78x q78y q78z q78aa q78ab q78ac q78ad q78ae q78af q78ag q78ah q78ai q78aj q78ak q78al q78am q78an q78ao q78ap q78aq q79 q80 q81 q82a q82b q83a q83b q83c q83d q83e q83f q83g q83h q83i q83j q83k q83l q83m q83n q85 q86a q86b q87a q87b q88 q89a q89b q89c q89d q89e q90 q91 q92a q92b q92c q92d q92e q93 q94 q95a q95b q95c q96  q99 q100 q101 q102 q103  q104 q105 q106a q106b q106c q107 q108 q109 q110 q111 q112a q113 q114 q115 q116 q117a q117b q117c q117d q117e q117f q117g q117h q117i q117j q117k q301 q302a q302b q302c q302d q302e q302f q303 q304 q305a q305b q305c q305d q306a q306b q306c q307 q308a q308b q308c q308d q308e q308f q308g q308h q309 q310 q312a q312b q313 q314 q315 q316 q317 q318 q319 q320a q320b q320c q320d q320e q320f q320g q320h q320i q320j q320k q321a q321b q322 q323a q323b  q324 q325a q325b q325c q325d q325e q325f q325g q325h q326a q326b q326c q326d q326e q326f q326g q326h q326i q327a q327b q327c q327d q327e q327f q327g q327h q328 q329a q329b q329c q329d q329e q329f q330 q331 q332a q332b q332c  q332d q333 q334  q335 q336 q337a q337b q338 q339a q339b q339c q339d q339e q339f q339g q339h q339i q339j q339k q339l q339m q339n q339o q339p q340 q341 q342a q342b q342c q342d q342e q343 q344 q345 q346 q347 q348 q349 q350 q351a q351b q351c q351d q351e q351f q351g q352 q352_ssyk q353 q354 q355 q356 q357 q358 q359 q360 q361a q361b q361c q362 q363 q364  q365a q365ba q365bb q365bc q365c q365da q365db q365dc q365dd q366  q367 q368 q369 q370 q371a q371b q371c q371d q371e q371f q371g q371h q371i q371j q371k), values (-96)

replace numbq=numbq-10 if(q36==1)
replace numbq=numbq-8 if(q37==1)
replace numbq=numbq-1 if(q303==1)

replace notpart96=. if(svarande==0)
replace numbq=numbq-notpart96
replace numbq=. if(svarande==0)

gen percentanswer=1-(response2/numbq)

fre percentanswer 

gen rr5cat1=percentanswer 
recode rr5cat1 (0/.4999999999=0 "Breakoff") (0.5/0.8=1 "Partial") (0.80000000000001/1=2 "Complete"), gen (rr5cat)
la var rr5cat "rr5cat"

fre rr5cat
replace rr5cat=. if(svarande==0)
replace svarande=0 if(etapp_edition_svar==10)
gen svarat=svarande
replace svarat=0 if(rr5cat==0|rr5cat==1)

**** RESPONSE VARIABLE *****
gen svarat100=svarat*100
*** Dropping duplicate cases ***
*drop if(dubblett==1)
*** Dropping avlidna ***
*drop if(urvalskoll==3|urvalskoll==4|urvalskoll==5)
*** Dropping om flyttat från Göteborg ***
*drop if(urvalskoll_flytt!=.)
*** DROPPING IF NATURLIGT BORTFALL ***
*drop if(bortfall==0)

*** FÖDELSELAND ***
** CLASSIFICATION ACCORDING TO https://www.un.org/dgacm/en/content/regional-groups **

encode reg_FodLandGrp_EU28, gen(immigrant)
fre immigrant
recode immigrant 1=3 2=3 3=2 4=2 5=3 6=1 7=3 8=3 9=2 10=0 11=3

**** ONLY CITIZENS INCLUDED IN DATA *****
/*
**** CITIZENSHIP ****
encode MedborgarskapslandKod, gen(citizen)
fre citizen, all
recode citizen 1/105=0 106=1 107/190=0
label def cit 0 "Not Swedish citizen" 1 "Swedish citizen"
label val citizen cit
*/

*** KÖN ***
gen female=v7100
recode female 1=0 2=1
*** ÅLDER ***
gen agereg=(2022-reg_fodelsear)/85
gen agecat=2022-reg_fodelsear
recode agecat 16/17=1 18/24=1 25/34=2 35/44=3 45/54=4 55/64=5 65/90=6
label def agecat 1 "16 to 24" 2 "25 to 34" 3 "35 to 44" 4 "45 to 54" 5 "55 to 64"  6 "65 or older"
label val agecat agecat

*** MARITAL STATUS ***
encode reg_Civil_2021, gen(maritalstatus)
recode maritalstatus 1=3 2=0 3=3 4=1 5=1 6=2

**** METROPOLITAN AREAS ****
gen metro=0
replace metro=1 if(v7503=="Stockholm")
replace metro=1 if(v7503=="Göteborg")
replace metro=1 if(v7503=="Malmö")
**** EDUCATION ****
gen edu=v7302
recode edu 5/6=5

*** LABEL VARIABLES ***
label var agereg "Age"
label def s 1 "Female" 0 "Male"
label val female s
label def im 0 "Born in Sweden" 1 "Born in the Nordics" 2 "Born somewhere else in Europe" 3 "Born somewhere outside Europe"
label val immigrant im
label def maritalstatus 0 "Single" 1 "Divorced" 2 "Widow/Widower" 3 "Married", modify
label val maritalstatus maritalstatus
label def metro 0 "Not metropolitan area" 1 "Metropolitan area"
label val metro metro
label def svarat 0 "Did not submit the questionnaire" 1 "Submitted the questionnaire", modify
label def edu 1 "Did not finish elementary (less than 9 years)" 2 "Elementary (completed)" 3 "Upper-secondary (started or completed)" 4 "Post-upper-secondary (less than 2 years)" 5 "Post-upper-secondary (2 years or longer)" 
label val edu edu
*save "T:\Projekt\Bortfallsanalys - Lundmark 2019\Analyses\SNES\SNES 2022.dta", replace

cd "T:\Projekt\Bortfallsanalys - Lundmark 2019\Analyses\SNES\"

gen cohort=reg_fodelsear
recode cohort 1930/1939=1 1940/1949=2 1950/1959=3 1960/1969=4 1970/1979=5 1980/1989=6 1990/1999=7 2000/2009=8
label def cohort 1 "1930/1939" 2 "1940/1949" 3 "1950/1959" 4 "1960/1969" 5 "1970/1979" 6 "1980/1989" 7 "1990/1999" 8 "2000/2009"
label val cohort cohort
gen age=2022-reg_fodelsear
drop if(svarat==.)
drop svarat100
gen svarat100=svarat*100
tab immigrant, gen(immdum)
tab metro, gen(metrodum)
tab agecat, gen(agecatdum)
tab maritalstatus, gen(maritalstatuscatdum)
tab edu, gen(edudum)
*tab utsatt_riskgrupp_numeric, gen(utsatt_riskgrupp_numericdum)

**** DROPPING THOSE AGED 86 AND OLDER *****
drop if(age>85)

****** R-Indicators *****
forval edition_urval=1(1)3 {
    display `edition_urval'
	preserve
keep if(edition_urval==`edition_urval')
quietly logit svarat i.metro i.immigrant i.female i.age i.maritalstatus i.edu if(edition_urval== `edition_urval'), vce(robust)
gen sam=e(sample)
keep if(sam==1)
keep svarat metro immigrant female age maritalstatus edu edition_urval
 *dis e(N)
 save "R:\Gemensam\SNES Data Vault\Personal files\Sebastian Lundmark\SNES 2022 edition `edition_urval' for R.dta", replace
quietly gen n=e(N)  
quietly predict xb 
quietly predict stdp  , stdp

quietly sum xb  , d
quietly gen pmean=r(mean)  
quietly gen p=(xb-pmean)^2 
quietly egen totalp=total(p)  
*fre xb stdp n pmean p totalp  
 dis  `year'
 dis 1-2*(sqrt(1/(n-1)*totalp))
quietly drop xb stdp n pmean p totalp
 restore
}

***** RESPONSE RATE OVER YEARS *****
tab svarat edition_urval, col chi

***** EDUCATION ********
preserve
 keep if(edition_urval==1)
 *STANDARDIZING THE VARIABLES*
 egen stdsvarat = std(svarat)
  egen stdsvarande = std(svarande)
 egen stdmetro = std(metro)
*egen stdcitizen = std(citizen)
 egen stdfemale = std(female)
 egen stdage = std(age)
 egen stdimmdum1 = std(immdum1)
 egen stdimmdum2 = std(immdum2)
 egen stdimmdum3 = std(immdum3)
 egen stdimmdum4 = std(immdum4)
 egen stdagecatdum1 = std(agecatdum1)
 egen stdagecatdum2 = std(agecatdum2)
 egen stdagecatdum3 = std(agecatdum3)
 egen stdagecatdum4 = std(agecatdum4)
 egen stdagecatdum5 = std(agecatdum5)
 egen stdagecatdum6 = std(agecatdum6)
 egen stdmaritalstatuscatdum1 = std(maritalstatuscatdum1)
 egen stdmaritalstatuscatdum2 = std(maritalstatuscatdum2)
 egen stdmaritalstatuscatdum3 = std(maritalstatuscatdum3)
 egen stdmaritalstatuscatdum4 = std(maritalstatuscatdum4)
*egen stdutsatt_riskgrupp_numeric1 = std(utsatt_riskgrupp_numericdum1)
*egen stdutsatt_riskgrupp_numeric2 = std(utsatt_riskgrupp_numericdum2)
*egen stdutsatt_riskgrupp_numeric3 = std(utsatt_riskgrupp_numericdum3)
*egen stdutsatt_riskgrupp_numeric4 = std(utsatt_riskgrupp_numericdum4)
 egen stdedu1 = std(edudum1)
 egen stdedu2 = std(edudum2)
 egen stdedu3 = std(edudum3)
 egen stdedu4 = std(edudum4)
 egen stdedu5 = std(edudum5)

reg stdsvarat  stdimmdum2-stdimmdum4 stdfemale stdage stdmaritalstatuscatdum2-stdmaritalstatuscatdum4 stdmetro stdedu2-stdedu5, vce(robust)
 parmest, sav("parmest2015.dta", replace) label 
estat vif
restore 

preserve
 keep if(edition_urval==2)
 *STANDARDIZING THE VARIABLES*
 egen stdsvarat = std(svarat)
  egen stdsvarande = std(svarande)
 egen stdmetro = std(metro)
*egen stdcitizen = std(citizen)
 egen stdfemale = std(female)
 egen stdage = std(age)
 egen stdimmdum1 = std(immdum1)
 egen stdimmdum2 = std(immdum2)
 egen stdimmdum3 = std(immdum3)
 egen stdimmdum4 = std(immdum4)
 egen stdagecatdum1 = std(agecatdum1)
 egen stdagecatdum2 = std(agecatdum2)
 egen stdagecatdum3 = std(agecatdum3)
 egen stdagecatdum4 = std(agecatdum4)
 egen stdagecatdum5 = std(agecatdum5)
 egen stdagecatdum6 = std(agecatdum6)
 egen stdmaritalstatuscatdum1 = std(maritalstatuscatdum1)
 egen stdmaritalstatuscatdum2 = std(maritalstatuscatdum2)
 egen stdmaritalstatuscatdum3 = std(maritalstatuscatdum3)
 egen stdmaritalstatuscatdum4 = std(maritalstatuscatdum4)
*egen stdutsatt_riskgrupp_numeric1 = std(utsatt_riskgrupp_numericdum1)
*egen stdutsatt_riskgrupp_numeric2 = std(utsatt_riskgrupp_numericdum2)
*egen stdutsatt_riskgrupp_numeric3 = std(utsatt_riskgrupp_numericdum3)
*egen stdutsatt_riskgrupp_numeric4 = std(utsatt_riskgrupp_numericdum4)
 egen stdedu1 = std(edudum1)
 egen stdedu2 = std(edudum2)
 egen stdedu3 = std(edudum3)
 egen stdedu4 = std(edudum4)
 egen stdedu5 = std(edudum5)

reg stdsvarat  stdimmdum2-stdimmdum4 stdfemale stdage stdmaritalstatuscatdum2-stdmaritalstatuscatdum4 stdmetro stdedu2-stdedu5, vce(robust)
 parmest, sav("parmest2016.dta", replace) label 
estat vif
restore 

preserve
 keep if(edition_urval==3)
 *STANDARDIZING THE VARIABLES*
 egen stdsvarat = std(svarat)
  egen stdsvarande = std(svarande)
 egen stdmetro = std(metro)
*egen stdcitizen = std(citizen)
 egen stdfemale = std(female)
 egen stdage = std(age)
 egen stdimmdum1 = std(immdum1)
 egen stdimmdum2 = std(immdum2)
 egen stdimmdum3 = std(immdum3)
 egen stdimmdum4 = std(immdum4)
 egen stdagecatdum1 = std(agecatdum1)
 egen stdagecatdum2 = std(agecatdum2)
 egen stdagecatdum3 = std(agecatdum3)
 egen stdagecatdum4 = std(agecatdum4)
 egen stdagecatdum5 = std(agecatdum5)
 egen stdagecatdum6 = std(agecatdum6)
 egen stdmaritalstatuscatdum1 = std(maritalstatuscatdum1)
 egen stdmaritalstatuscatdum2 = std(maritalstatuscatdum2)
 egen stdmaritalstatuscatdum3 = std(maritalstatuscatdum3)
 egen stdmaritalstatuscatdum4 = std(maritalstatuscatdum4)
*egen stdutsatt_riskgrupp_numeric1 = std(utsatt_riskgrupp_numericdum1)
*egen stdutsatt_riskgrupp_numeric2 = std(utsatt_riskgrupp_numericdum2)
*egen stdutsatt_riskgrupp_numeric3 = std(utsatt_riskgrupp_numericdum3)
*egen stdutsatt_riskgrupp_numeric4 = std(utsatt_riskgrupp_numericdum4)
 egen stdedu1 = std(edudum1)
 egen stdedu2 = std(edudum2)
 egen stdedu3 = std(edudum3)
 egen stdedu4 = std(edudum4)
 egen stdedu5 = std(edudum5)

reg stdsvarat  stdimmdum2-stdimmdum4 stdfemale stdage stdmaritalstatuscatdum2-stdmaritalstatuscatdum4 stdmetro stdedu2-stdedu5, vce(robust)
 parmest, sav("parmest2017.dta", replace) label 
estat vif
restore 

preserve
use "parmest2015.dta", clear
gen edition=1
append using "parmest2016.dta"
replace edition=2 if(edition==.)
append using "parmest2017.dta"
replace edition=3 if(edition==.)

drop if(estimate==0)
replace label="Risk of becoming socially disadvantaged" if(parm=="stdutsatt_riskgrupp_numeric3")
replace label="Socially disadvantaged" if(parm=="stdutsatt_riskgrupp_numeric2")
replace label="Extremely socially disadvantaged" if(parm=="stdutsatt_riskgrupp_numeric4")
replace label="Swedish citizen" if(parm=="stdcitizen") 
replace label="Female" if(parm=="stdfemale") 
replace label="Metropolitan area" if(parm=="stdmetro") 
replace label="Age" if(parm=="stdage") 
replace label="Age 25-34" if(parm=="stdagecatdum2") 
replace label="Age 35-44" if(parm=="stdagecatdum3") 
replace label="Age 45-54" if(parm=="stdagecatdum4") 
*replace label="Age 55-64" if(parm=="stdagecatdum5") 
*replace label="Age 65 or older" if(parm=="stdagecatdum6") 
replace label="Divorced" if(parm=="stdmaritalstatuscatdum2") 
replace label="Widow/Widower" if(parm=="stdmaritalstatuscatdum3") 
replace label="Married" if(parm=="stdmaritalstatuscatdum4") 
replace label="Born in the Nordics" if(parm=="stdimmdum2") 
replace label="Born somewhere else in Europe" if(parm=="stdimmdum3") 
replace label="Born somewhere outside Europe" if(parm=="stdimmdum4") 
replace label="Metropolitan area" if(parm=="stdmetro") 
replace label="Did not finish elementary (less than 9 years)" if(parm=="stdedu1")
replace label="Elementary (completed)" if(parm=="stdedu2")
replace label="Upper-secondary (started or completed)" if(parm=="stdedu3")
replace label="Post-upper-secondary (less than 2 years)" if(parm=="stdedu4")
replace label="University (2 years or longer)"  if(parm=="stdedu5")
replace parm="Did not finish elementary (less than 9 years)" if(parm=="stdedu1")
replace parm="Elementary (completed)" if(parm=="stdedu2")
replace parm="Upper-secondary (started or completed)" if(parm=="stdedu3")
replace parm="Post-upper-secondary (less than 2 years)" if(parm=="stdedu4")
replace parm="Post-upper-secondary (2 years or longer)"  if(parm=="stdedu5")
replace parm="" if(parm=="stdedu9")
replace parm="Risk of becoming socially disadvantaged" if(parm=="stdutsatt_riskgrupp_numeric3")
replace parm="Socially disadvantaged" if(parm=="stdutsatt_riskgrupp_numeric2")
replace parm="Extremely socially disadvantaged" if(parm=="stdutsatt_riskgrupp_numeric4")
replace parm="Swedish citizen" if(parm=="stdcitizen") 
replace parm="Female" if(parm=="stdfemale") 
replace parm="Age" if(parm=="stdage") 
*replace parm="Age 25-34" if(parm=="stdagecatdum2") 
*replace parm="Age 35-44" if(parm=="stdagecatdum3") 
*replace parm="Age 45-54" if(parm=="stdagecatdum4") 
*replace parm="Age 55-64" if(parm=="stdagecatdum5") 
*replace parm="Age 65 or older" if(parm=="stdagecatdum6") 
replace parm="Divorced" if(parm=="stdmaritalstatuscatdum2") 
replace parm="Widow/Widower" if(parm=="stdmaritalstatuscatdum3") 
replace parm="Married" if(parm=="stdmaritalstatuscatdum4") 
replace parm="Born in the Nordics" if(parm=="stdimmdum2") 
replace parm="Born somewhere else in Europe" if(parm=="stdimmdum3") 
replace parm="Born somewhere outside Europe" if(parm=="stdimmdum4") 
replace parm="Metropolitan area" if(parm=="stdmetro") 
replace parm="Born in the Nordics (not Sweden)" if(parm=="stdimmdum2") 
replace parm="Born somewhere else in Europe" if(parm=="stdimmdum3") 
replace parm="Born somewhere outside Europe" if(parm=="stdimmdum4") 
replace parm="Metropolitan area" if(parm=="stdmetro") 
label var parm "Sub-group overall meta-analytical effects on response rates"
clonevar parm2=parm

set scheme som

drop if(parm=="_cons")

***** FIGURE 4 ******
metan estimate stderr,  by(parm) random effect(Standardized RR1)  diamopt(lcolor(black))  nowt nooverall  texts(115) ilevel(95) olevel(95)  xlab(-0.30(0.15)0.3) lcols(parm2)  summaryonly note("") hetstat(I2 Q p)
graph export "Figure 4 - Meta-analyses SNES including edu.svg", replace
graph export "Figure 4 - Meta-analyses SNES including edu.png", replace

replace label="Version 1" if(edition==1)
replace label="Version 2" if(edition==2)
replace label="Version 3" if(edition==3)

**** FIGURE S2 *****
metan estimate stderr if(parm=="Age"|parm=="Female") , by(parm) random effect(Standardized RR1)  diamopt(lcolor(black))  nowt nooverall  texts(105) ilevel(95) olevel(95) xlab(-0.30(0.15)0.3) lcols(label)  note("") 
graph export "Figure S1.2. Age and Female only.svg", replace

metan estimate stderr if(parm=="Born somewhere outside Europe"|parm=="Born somewhere else in Europe"|parm=="Born in the Nordics") , by(parm) random effect(Standardized RR1)  diamopt(lcolor(black))  nowt nooverall  texts(105) ilevel(95) olevel(95) xlab(-0.30(0.15)0.3) lcols(label)  note("") 
graph export "Figure S1.2. Immigrant only.svg", replace

metan estimate stderr if(parm=="Divorced"|parm=="Widow/Widower"|parm=="Married") , by(parm) random effect(Standardized RR1)  diamopt(lcolor(black))  nowt nooverall  texts(105) ilevel(95) olevel(95) xlab(-0.30(0.15)0.3) lcols(label)  note("")  
graph export "Figure S1.2. Marital Status only.svg", replace

metan estimate stderr if(parm=="Metropolitan area") , random effect(Standardized RR1)  diamopt(lcolor(black)) nowt texts(105) ilevel(95) olevel(95) xlab(-0.30(0.15)0.3) lcols(label)  note("")  
graph export "Figure S1.2. Contextual only.svg", replace

metan estimate stderr if(parm=="Did not finish elementary (less than 9 years)"|parm=="Elementary (completed)"|parm=="Upper-secondary (started or completed)"|parm=="Post-upper-secondary (less than 2 years)"|parm=="Post-upper-secondary (2 years or longer)") , by(parm) random effect(Standardized RR1)  diamopt(lcolor(black))  nowt nooverall  texts(105) ilevel(95) olevel(95) xlab(-0.30(0.15)0.3) lcols(label)  note("") 
graph export "Figure S1.2. education only.svg", replace
restore


**** GRAPHING R-INDICATORS FOR Lundmark & Backström (2024) Predicting Survey Nonresponse with Registry Data in  Sweden between 1992 to 2022: Cohort Replacement or a Deteriorating Survey Climate? ****

**** SAMPLE 2 ****
import excel using "T:\Projekt\Bortfallsanalys - Lundmark 2019\Analyses\SNES\Sample 2 - Graph of R-indicators and RR1.xlsx", first clear

set scheme som

format adjusted_r_indicators rr1 %9.2g
pwcorr adjusted_r_indicators rr1
reg adjusted_r_indicators edition

**** FIGURE 5 *****
twoway ///
(scatter adjusted_r_indicators edition, mlab(adjusted_r_indicators) mlabposition(12)  mlabgap(2) lcolor(orange) mcolor(orange) msymbol(O) lwidth(medthick)) /// 
(rcap r_lowerci r_upperci edition, lcolor(orange) lwidth(medthin)) ///
(scatter rr1 edition, mlab(rr1) mlabposition(12) mlabgap(2) mlabcolor(black) lcolor(black) mcolor(black) msymbol(O) lwidth(medthick)) /// 
, ylab(0(.20).8, labsize(small) format(%9.2g))  ytitle() xtitle(" " "Edition", size(small)) xlab(0.5 " " 1(1)3 3.5 " ", labsize(small)) legend(order(1 3) size(small) label(1 "Adjusted R indicators") label(3 "Response Rate (RR1, AAPOR 2023)")) graphregion(margin(medium)) yline(0, lcolor(gray))
graph export "Figure 6 - R-indicators Sample 2.svg", replace
graph export "Figure 6 - R-indicators Sample 2.png", replace

****** ROBUSTNESS CHECKS NOT IN THE MANUSCRIPT ************
****** EXLUDING EDUCATION PREDICTOR ******
preserve
 keep if(edition_urval==1)
 *STANDARDIZING THE VARIABLES*
 egen stdsvarat = std(svarat)
  egen stdsvarande = std(svarande)
 egen stdmetro = std(metro)
*egen stdcitizen = std(citizen)
 egen stdfemale = std(female)
 egen stdage = std(age)
 egen stdimmdum1 = std(immdum1)
 egen stdimmdum2 = std(immdum2)
 egen stdimmdum3 = std(immdum3)
 egen stdimmdum4 = std(immdum4)
 egen stdagecatdum1 = std(agecatdum1)
 egen stdagecatdum2 = std(agecatdum2)
 egen stdagecatdum3 = std(agecatdum3)
 egen stdagecatdum4 = std(agecatdum4)
 egen stdagecatdum5 = std(agecatdum5)
 egen stdagecatdum6 = std(agecatdum6)
 egen stdmaritalstatuscatdum1 = std(maritalstatuscatdum1)
 egen stdmaritalstatuscatdum2 = std(maritalstatuscatdum2)
 egen stdmaritalstatuscatdum3 = std(maritalstatuscatdum3)
 egen stdmaritalstatuscatdum4 = std(maritalstatuscatdum4)
*egen stdutsatt_riskgrupp_numeric1 = std(utsatt_riskgrupp_numericdum1)
*egen stdutsatt_riskgrupp_numeric2 = std(utsatt_riskgrupp_numericdum2)
*egen stdutsatt_riskgrupp_numeric3 = std(utsatt_riskgrupp_numericdum3)
*egen stdutsatt_riskgrupp_numeric4 = std(utsatt_riskgrupp_numericdum4)
reg stdsvarat  stdimmdum2 stdimmdum3 stdimmdum4 stdfemale stdage stdmaritalstatuscatdum2 stdmaritalstatuscatdum3 stdmaritalstatuscatdum4 stdmetro, vce(robust)
 parmest, sav("parmest2015.dta", replace) label 
estat vif
restore 

preserve
 keep if(edition_urval==2)
 *STANDARDIZING THE VARIABLES*
 egen stdsvarat = std(svarat)
   egen stdsvarande = std(svarande)
 egen stdmetro = std(metro)
*egen stdcitizen = std(citizen)
 egen stdfemale = std(female)
 egen stdage = std(age)
 egen stdimmdum1 = std(immdum1)
 egen stdimmdum2 = std(immdum2)
 egen stdimmdum3 = std(immdum3)
 egen stdimmdum4 = std(immdum4)
 egen stdagecatdum1 = std(agecatdum1)
 egen stdagecatdum2 = std(agecatdum2)
 egen stdagecatdum3 = std(agecatdum3)
 egen stdagecatdum4 = std(agecatdum4)
 egen stdagecatdum5 = std(agecatdum5)
 egen stdagecatdum6 = std(agecatdum6)
 egen stdmaritalstatuscatdum1 = std(maritalstatuscatdum1)
 egen stdmaritalstatuscatdum2 = std(maritalstatuscatdum2)
 egen stdmaritalstatuscatdum3 = std(maritalstatuscatdum3)
 egen stdmaritalstatuscatdum4 = std(maritalstatuscatdum4)
*egen stdutsatt_riskgrupp_numeric1 = std(utsatt_riskgrupp_numericdum1)
*egen stdutsatt_riskgrupp_numeric2 = std(utsatt_riskgrupp_numericdum2)
*egen stdutsatt_riskgrupp_numeric3 = std(utsatt_riskgrupp_numericdum3)
*egen stdutsatt_riskgrupp_numeric4 = std(utsatt_riskgrupp_numericdum4)
reg stdsvarat  stdimmdum2 stdimmdum3 stdimmdum4 stdfemale stdage stdmaritalstatuscatdum2 stdmaritalstatuscatdum3 stdmaritalstatuscatdum4 stdmetro, vce(robust)
 parmest, sav("parmest2016.dta", replace) label 
estat vif
restore 

preserve
 keep if(edition_urval==3)
 *STANDARDIZING THE VARIABLES*
 egen stdsvarat = std(svarat)
   egen stdsvarande = std(svarande)
 egen stdmetro = std(metro)
*egen stdcitizen = std(citizen)
 egen stdfemale = std(female)
 egen stdage = std(age)
 egen stdimmdum1 = std(immdum1)
 egen stdimmdum2 = std(immdum2)
 egen stdimmdum3 = std(immdum3)
 egen stdimmdum4 = std(immdum4)
 egen stdagecatdum1 = std(agecatdum1)
 egen stdagecatdum2 = std(agecatdum2)
 egen stdagecatdum3 = std(agecatdum3)
 egen stdagecatdum4 = std(agecatdum4)
 egen stdagecatdum5 = std(agecatdum5)
 egen stdagecatdum6 = std(agecatdum6)
 egen stdmaritalstatuscatdum1 = std(maritalstatuscatdum1)
 egen stdmaritalstatuscatdum2 = std(maritalstatuscatdum2)
 egen stdmaritalstatuscatdum3 = std(maritalstatuscatdum3)
 egen stdmaritalstatuscatdum4 = std(maritalstatuscatdum4)
*egen stdutsatt_riskgrupp_numeric1 = std(utsatt_riskgrupp_numericdum1)
*egen stdutsatt_riskgrupp_numeric2 = std(utsatt_riskgrupp_numericdum2)
*egen stdutsatt_riskgrupp_numeric3 = std(utsatt_riskgrupp_numericdum3)
*egen stdutsatt_riskgrupp_numeric4 = std(utsatt_riskgrupp_numericdum4)
reg stdsvarat  stdimmdum2 stdimmdum3 stdimmdum4 stdfemale stdage stdmaritalstatuscatdum2 stdmaritalstatuscatdum3 stdmaritalstatuscatdum4 stdmetro, vce(robust)
 parmest, sav("parmest2017.dta", replace) label 
estat vif
restore 

preserve
use "parmest2015.dta", clear
gen edition=1
append using "parmest2016.dta"
replace edition=2 if(edition==.)
append using "parmest2017.dta"
replace edition=3 if(edition==.)

drop if(estimate==0)
replace label="Risk of becoming socially disadvantaged" if(parm=="stdutsatt_riskgrupp_numeric3")
replace label="Socially disadvantaged" if(parm=="stdutsatt_riskgrupp_numeric2")
replace label="Extremely socially disadvantaged" if(parm=="stdutsatt_riskgrupp_numeric4")
replace label="Swedish citizen" if(parm=="stdcitizen") 
replace label="Female" if(parm=="stdfemale") 
replace label="Age" if(parm=="stdage") 
replace label="Age 25-34" if(parm=="stdagecatdum2") 
replace label="Age 35-44" if(parm=="stdagecatdum3") 
replace label="Age 45-54" if(parm=="stdagecatdum4") 
*replace label="Age 55-64" if(parm=="stdagecatdum5") 
*replace label="Age 65 or older" if(parm=="stdagecatdum6") 
replace label="Divorced" if(parm=="stdmaritalstatuscatdum2") 
replace label="Widow/Widower" if(parm=="stdmaritalstatuscatdum3") 
replace label="Married" if(parm=="stdmaritalstatuscatdum4") 
replace label="Born in the Nordics" if(parm=="stdimmdum2") 
replace label="Born somewhere else in Europe" if(parm=="stdimmdum3") 
replace label="Born somewhere outside Europe" if(parm=="stdimmdum4") 
replace label="Metropolitan area" if(parm=="stdmetro") 
replace parm="Risk of becoming socially disadvantaged" if(parm=="stdutsatt_riskgrupp_numeric3")
replace parm="Socially disadvantaged" if(parm=="stdutsatt_riskgrupp_numeric2")
replace parm="Extremely socially disadvantaged" if(parm=="stdutsatt_riskgrupp_numeric4")
replace parm="Swedish citizen" if(parm=="stdcitizen") 
replace parm="Female" if(parm=="stdfemale") 
replace parm="Age" if(parm=="stdage") 
*replace parm="Age 25-34" if(parm=="stdagecatdum2") 
*replace parm="Age 35-44" if(parm=="stdagecatdum3") 
*replace parm="Age 45-54" if(parm=="stdagecatdum4") 
*replace parm="Age 55-64" if(parm=="stdagecatdum5") 
*replace parm="Age 65 or older" if(parm=="stdagecatdum6") 
replace parm="Divorced" if(parm=="stdmaritalstatuscatdum2") 
replace parm="Widow/Widower" if(parm=="stdmaritalstatuscatdum3") 
replace parm="Married" if(parm=="stdmaritalstatuscatdum4") 
replace parm="Born in the Nordics" if(parm=="stdimmdum2") 
replace parm="Born somewhere else in Europe" if(parm=="stdimmdum3") 
replace parm="Born somewhere outside Europe" if(parm=="stdimmdum4") 
replace parm="Metropolitan area" if(parm=="stdmetro") 
replace parm="Born in the Nordics (not Sweden)" if(parm=="stdimmdum2") 
replace parm="Born somewhere else in Europe" if(parm=="stdimmdum3") 
replace parm="Born somewhere outside Europe" if(parm=="stdimmdum4") 
replace parm="Metropolitan area" if(parm=="stdmetro") 
label var parm "Sub-group overall meta-analytical effects on response rates"
clonevar parm2=parm

set scheme som

drop if(parm=="_cons")
metan estimate stderr , by(parm)  random effect(Standardized response propensities)  diamopt(lcolor(black))  nowt nooverall  texts(120) ilevel(95) olevel(95)  xlab(-0.30, -0.15, 0.15, 0.3) lcols(parm2)  summaryonly
graph export "Meta-analyses SNES all.svg", replace
