
*----[Stata Version & Settings]-------------------------------------------------
version 17
clear               
clear matrix
clear mata        
set more off        
set maxvar 32000
set scrollbufsize 2000000  
set scheme s1mono 


*----[Define paths]-------------------------------------------------------------

*** Path of own data
global data "<<specify own folder>>"

*** Path of output
global output "<<specify own folder>>"



********************************************************************************
*** I) Multivariate analyses of determinants
********************************************************************************

use "${data}/w8_do_analyses.dta", clear


****************************************************
** Logit model: income
****************************************************
sum hhinc_2_br hhinc_2_br_new ///
	agecat female educ_2 alone born /// socio-demographics
	urban makeend_2 act /// living conditions & social activities
	health adl2 iadl2 recall_avg num_avg /// health-related outcomes (physical+cognitive)
	conf_science /// confidence in organisations
	survey_imp survey_use survey_waste survey_trust survey_think survey_pers /// value+content
	survey_joy survey_exh survey_boring /// enjoyment+burden
	concern_priv concern_theft concern_leak	/// privacy/data protection concerns
	embar notalk /// income-related concerns
	de_mode /// paradata
	if hhinc_2_br!=.

logit hhinc_2_br agecat1 agecat3 female educ_2 alone born /// socio-demographics
	urban makeend_2 /// living conditions
	survey_imp /// survey value
	survey_joy /// survey enjoyment
	survey_exh /// survey burden
	survey_think /// survey content
	conf_science concern_priv concern_leak /// privacy/data protection concerns
	notalk /// income-related
	[pw=wgt_do], vce(robust)
// 647 obs., R²=.15

center agecat1 agecat3 female educ_2 alone born ///
	urban makeend_2 ///
	survey_imp survey_joy survey_exh survey_think ///
	conf_science concern_priv concern_leak ///
	notalk ///
	if e(sample) [aw=wgt_do], st replace
sum c_* if e(sample) [aw=wgt_do]
// n=647

eststo clear
logit hhinc_2_br c_agecat1 c_agecat3 c_female c_educ_2 c_alone c_born ///
	c_urban c_makeend_2 ///
	c_conf_science c_concern_priv c_concern_leak c_notalk ///
	c_survey_imp c_survey_think c_survey_joy c_survey_exh ///
	[pw=wgt_do], vce(robust)
eststo inc: margins, dydx(*) post
esttab using $output\Tab1_logit_income.rtf, replace ///
	b(%8.3f) t(%8.2f) nonum compress nogaps varwidth(20) modelwidth(10)
coefplot(inc, if(@ll>0 | @ul<0) lab("") mcol(orange) msize(small) ciopts(lcol(orange))) ///
	(inc, if(@ll<0 & @ul>0) lab("") mcol(gs0) msize(small) ciopts(lcol(gs0))), ///
	drop(_cons) nooffset legend(off) xline(0, lwidth(thin) lcol(gs0) lpattern(dash)) ///
	xtitle("Effect on Pr(Income non-response)", size(2.7)) ///
	coeflabels(c_agecat1="Age (50-64)" c_agecat3="Age (80+)" ///
		c_female="{bf:Gender: Female}" ///
		c_educ_2="{bf:Level of education: High}" ///
		c_alone="{bf:Living alone}" ///
		c_born="{bf:Born abroad}" ///
		c_urban="{bf:Area of living: Urban area}" ///
		c_makeend_2="{bf:Make ends meet easily}" ///
		c_act="{bf:Any activities in last year}" ///
		c_consent_written="{bf:Consent to record linkage}" ///
		c_health32="Good" c_health33="Very good/excellent" ///
		c_adl2="{bf:>1 Limitations in ADL}" ///
		c_iadl2="{bf:>1 Limitations in IADL}" ///
		c_recall_avg="{bf:Good cognitive perfomance (Word recall test)}" ///
		c_conf_science="Trust in scientific institutes to keep data safe" /// 
		c_survey_imp="Surveys are important for society" ///
		c_survey_think="Questions in SHARE made me reflect" ///
		c_survey_joy="I really enjoyed to participate in SHARE" ///
		c_survey_exh="It is exhausting to answer many questions in a survey" /// 
		c_concern_priv="Concerns about data privacy in general" ///
		c_concern_leak="Concerns about data leak in SHARE" ///
		c_notalk="Concerns when talking about income", ///
		notick labsize(2.5) labcol(gs0) labgap(.5)) ///
	headings(c_agecat1="{bf:Age categories (ref.: 65-79)}" ///
		c_health32="{bf:Self-rated health (ref.: Poor/fair)}" ///
		c_conf_science="{bf:Trust, concerns & attitudes towards surveys & SHARE}", gap(.2)) ///
	xlab(-.1(.05).1, labs(2.5)) ///
	scheme(s2color) graphregion(color(white)) ///
	note("Data: SHARE Wave 8 Drop-off, Release 9-0-0 for Germany (n=647; weighted) with 95%-confidence intervals.", size(2.2) span)
graph save $output\Fig2_Non-response_upd.gph, replace
graph export $output\Fig2_Non-responsee_upd.emf, replace
graph export $output\Fig2_Non-response_upd.png, replace


* Robustness check
tab hhinc_2_br hhinc_2_br_new, m

logit hhinc_2_br_new agecat1 agecat3 female educ_2 alone born /// socio-demographics
	urban makeend_2 /// living conditions
	survey_imp /// survey value
	survey_joy /// survey enjoyment
	survey_exh /// survey burden
	survey_think /// survey content
	conf_science concern_priv concern_leak /// privacy/data protection concerns
	notalk_2 /// income-related
	[pw=wgt_do], vce(robust)
// 647 obs., R²=.21

center agecat1 agecat3 female educ_2 alone born ///
	urban makeend_2 ///
	survey_imp survey_joy survey_exh survey_think ///
	conf_science concern_priv concern_leak ///
	notalk ///
	if e(sample) [aw=wgt_do], st replace
sum c_* if e(sample) [aw=wgt_do]
// n=647

eststo clear
logit hhinc_2_br_new c_agecat1 c_agecat3 c_female c_educ_2 c_alone c_born ///
	c_urban c_makeend_2 ///
	c_conf_science c_concern_priv c_concern_leak c_notalk ///
	c_survey_imp c_survey_think c_survey_joy c_survey_exh ///
	[pw=wgt_do], vce(robust)
eststo inc: margins, dydx(*) post
esttab using $output\Tab1_logit_income2.rtf, replace ///
	b(%8.3f) t(%8.2f) nonum compress nogaps varwidth(20) modelwidth(10)
coefplot(inc, if(@ll>0 | @ul<0) lab("") mcol(orange) msize(small) ciopts(lcol(orange))) ///
	(inc, if(@ll<0 & @ul>0) lab("") mcol(gs0) msize(small) ciopts(lcol(gs0))), ///
	drop(_cons) nooffset legend(off) xline(0, lwidth(thin) lcol(gs0) lpattern(dash)) ///
	xtitle("Effect on Pr(Income non-response)", size(2.7)) ///
	coeflabels(c_agecat1="Age (50-64)" c_agecat3="Age (80+)" ///
		c_female="{bf:Gender: Female}" ///
		c_educ_2="{bf:Level of education: High}" ///
		c_alone="{bf:Living alone}" ///
		c_born="{bf:Born abroad}" ///
		c_urban="{bf:Area of living: Urban area}" ///
		c_makeend_2="{bf:Make ends meet easily}" ///
		c_act="{bf:Any activities in last year}" ///
		c_consent_written="{bf:Consent to record linkage}" ///
		c_health32="Good" c_health33="Very good/excellent" ///
		c_adl2="{bf:>1 Limitations in ADL}" ///
		c_iadl2="{bf:>1 Limitations in IADL}" ///
		c_recall_avg="{bf:Good cognitive perfomance (Word recall test)}" ///
		c_conf_science="Trust in scientific institutes to keep data safe" /// 
		c_survey_imp="Surveys are important for society" ///
		c_survey_think="Questions in SHARE made me reflect" ///
		c_survey_joy="I really enjoyed to participate in SHARE" ///
		c_survey_exh="It is exhausting to answer many questions in a survey" ///
		c_concern_priv="Concerns about data privacy in general" ///
		c_concern_leak="Concerns about data leak in SHARE" ///
		c_notalk="Concerns when talking about income", ///
		notick labsize(2.5) labcol(gs0) labgap(.5)) ///
	headings(c_agecat1="{bf:Age categories (ref.: 65-79)}" ///
		c_health32="{bf:Self-rated health (ref.: Poor/fair)}" ///
		c_conf_science="{bf:Trust, concerns & attitudes towards surveys & SHARE}", gap(.2)) ///
	xlab(-.04(.02).04, labs(2.5)) ///
	scheme(s2color) graphregion(color(white)) ///
	note("Data: SHARE Wave 8 Drop-off, Release 9-0-0 for Germany (n=647; weighted) with 95%-confidence intervals.", size(2.2) span)
graph save $output\Fig3_Non-response_robustness_upd.gph, replace
graph export $output\Fig3_Non-response_robustness_upd.emf, replace
graph export $output\Fig3_Non-response_robustness_upd.png, replace


