
*----[Stata Version & Settings]-------------------------------------------------
version 17  
clear               
clear matrix
clear mata        
set more off        
set maxvar 32000
set scrollbufsize 2000000  


*----[Define paths]-------------------------------------------------------------

*** Path of own data
global data "<<specify own folder>>"



******************************
** a) Consent
******************************

use "${data}/w8_do_analyses.dta", clear

sum noconsent // 36.2%, 737 drop-off interviews
sum noconsent [aw=wgt_do] // 37.8%, 737 drop-off interviews 

sum survey_imp_2 survey_think_2 survey_joy_2 survey_exh_2 ///
	conf_science_2 concern_priv_2 concern_leak_2 notalk_2 noconsent
// not weighted means
sum survey_imp_2 survey_think_2 survey_joy_2 survey_exh_2 ///
	conf_science_2 concern_priv_2 concern_leak_2 notalk_2 noconsent [aw=wgt_do]
// weighted means

foreach iv of varlist survey_imp_2 survey_think_2 survey_joy_2 survey_exh_2 ///
	conf_science_2 concern_priv_2 concern_leak_2 notalk_2 {
	dis as error "`iv'"
	tab noconsent `iv', col chi nokey
	qui reg noconsent `iv' [pw=wgt_do], vce(robust)
	margins, over(`iv')
	margins, dydx(`iv')
	dis ""
}



******************************
** b) Income
******************************

use "${data}/w8_do_analyses.dta", clear

sum hhinc_2_br					// 11.5%, 736 drop-off interviews 
sum hhinc_2_br [aw=wgt_do]		// 12.9%, 736 drop-off interviews 
sum hhinc_2_br_new				//  4.8%, 736 drop-off interviews 
sum hhinc_2_br_new [aw=wgt_do]	//  5.0%, 736 drop-off interviews 

sum survey_imp_2 survey_think_2 survey_joy_2 survey_exh_2 ///
	conf_science_2 concern_priv_2 concern_leak_2 notalk_2 hhinc_2_br
// not weighted means
sum survey_imp_2 survey_think_2 survey_joy_2 survey_exh_2 ///
	conf_science_2 concern_priv_2 concern_leak_2 notalk_2 hhinc_2_br [aw=wgt_do]
// weighted means
	
foreach iv of varlist survey_imp_2 survey_think_2 survey_joy_2 survey_exh_2 ///
	conf_science_2 concern_priv_2 concern_leak_2 notalk_2 {
	dis as error "`iv'"
	tab hhinc_2_br `iv', col chi
	qui reg hhinc_2_br `iv' [pw=wgt_do], vce(robust)
	margins, over(`iv')
	margins, dydx(`iv')
	dis ""
}



