
*----[Stata Version & Settings]-------------------------------------------------
version 17      
clear               
clear matrix
clear mata        
set more off        
set maxvar 32000
set scrollbufsize 2000000   


*----[Define paths]-------------------------------------------------------------

*** released data in w8
global w8 "<<SHARE Wave 8. Release version: 9.0.0. SHARE-ERIC. Data set. https://doi.org/10.6103/SHARE.w8.900>>"

*** internal drop-off with consent variable
global do "<<SHARE Wave 8. Linkage Data DE. Release version: 1. Internal data set>>"

*** Path of own data
global data "<<specify own folder>>"



********************************************************************************
*** I) Prepare data & merge modules
********************************************************************************

*** Internal consent data
use "${do}/internal data set.dta", clear
	keep mergeid consent_written
save "${data}\sharew8_internal_release_consent.dta", replace


*** Drop-off data
use "${w8}/sharew8_rel9-0-0_dropoff.dta", clear

keep if country==12
drop at_* be_* ch_* cz_* dk_* ee_* eg_* es_* fi_* fr_* il_* it_* lu_* pl_* ro_* si_* 
numlabel _all, add force

tab de_mode, m	// n=769


*** Merge modules

** ac
merge 1:1 mergeid using "${w8}/sharew8_rel9-0-0_ac.dta", ///
	nogen keep(1 3) keepus(ac035dno)

** co
merge 1:1 mergeid using "${w8}/sharew8_rel9-0-0_co.dta", ///
	nogen keep(1 3) keepus(co007_)

** cv_r
merge 1:1 mergeid using "${w8}/sharew8_rel9-0-0_cv_r.dta", ///
	nogen keep(1 3) keepus(age_int gender partnerinhh hhsize)

** dn
merge 1:1 mergeid using "${w8}/sharew8_rel9-0-0_dn.dta", ///
	nogen keep(1 3) keepus(dn004_)

** ep
merge 1:1 mergeid using "${w8}/sharew8_rel9-0-0_ep.dta", ///
	nogen keep(1 3) keepus(ep005_ ep009_)

** hh
merge 1:1 mergeid using "${w8}/sharew8_rel9-0-0_hh.dta", ///
	nogen keep(1 3) keepus(hh017*)

** ho
merge 1:1 mergeid using "${w8}/sharew8_rel9-0-0_ho.dta", ///
	nogen keep(1 3) keepus(ho037_)

** it
merge 1:1 mergeid using "${w8}/sharew8_rel9-0-0_it.dta", ///
	nogen keep(1 3) keepus(it003_ it004_)

** gv_big5
merge 1:1 mergeid using "${w8}/sharew8_rel9-0-0_gv_big5.dta", ///
	nogen keep(1 3) keepus(bfi10_*)

** gv_health
merge 1:1 mergeid using "${w8}/sharew8_rel9-0-0_gv_health.dta", ///
	nogen keep(1 3) keepus(sphus adl adl2 iadl iadl2 gali chronic2w8 ///
		cf008tot cf016tot orienti numeracy numeracy2 eurodcat loneliness casp)

** gv_housing
merge 1:1 mergeid using "${w8}/sharew8_rel9-0-0_gv_housing.dta", ///
	nogen keep(1 3) keepus(areabldgi nuts1_2016)
tab nuts1, m // 11 missings -> replace with gross sample data 
list mergeid if nuts1==""
replace nuts1 = "DE4 Brandenburg" if mergeid=="DE-332490-01"
replace nuts1 = "DE4 Brandenburg" if mergeid=="DE-332490-02"
replace nuts1 = "DE4 Brandenburg" if mergeid=="DE-360868-01"
replace nuts1 = "DE4 Brandenburg" if mergeid=="DE-478831-01"
replace nuts1 = "DE4 Brandenburg" if mergeid=="DE-478831-02"
replace nuts1 = "DE4 Brandenburg" if mergeid=="DE-515776-01"
replace nuts1 = "DE4 Brandenburg" if mergeid=="DE-515776-02"
replace nuts1 = "DEB Rheinland-Pfalz" if mergeid=="DE-721755-01"
replace nuts1 = "DE4 Brandenburg" if mergeid=="DE-814220-01"
replace nuts1 = "DE4 Brandenburg" if mergeid=="DE-908968-01"
replace nuts1 = "DE4 Brandenburg" if mergeid=="DE-912164-02"
tab nuts1, m // ok!

** gv_isced
merge 1:1 mergeid using "${w8}/sharew8_rel9-0-0_gv_isced.dta", ///
	nogen keep(1 3) keepus(isced1997_r)

** gv_weights
merge 1:1 mergeid using "${w8}/sharew8_rel9-0-0_gv_weights.dta", ///
	nogen keep(1 3) keepus(dw_w8 cciw_w8_main)
	
save "${data}/w8_do_modules.dta", replace


** constructed weights for drop-off data based on SHARE ado (downloadad from SHARE website)
merge 1:1 mergeid using "${data}/wgt_do_w8.dta", ///
	nogen keep(1 3) keepus(wgt_do)
sum dw_w8 cciw_w8_main wgt_do 

** consent data
merge 1:1 mergeid using "${data}/sharew8_internal_release_consent.dta", ///
	nogen keep(1 3) keepus(consent_written)

save "${data}/w8_do_modules_consent.dta", replace





********************************************************************************
*** II) Operationalize variables
********************************************************************************

use "${data}/w8_do_modules_consent.dta", clear

numlabel _all, add

* Age
list age_int yrbirth_do
tab age_int, m
recode age_int (min/64=1)(65/79=2)(80/max=3), gen(agecat)
tab age_int agecat, m
drop if age_int<50	// 21 obs.
lab def agecat 1 "50-64" 2 "65-79" 3 "80+"
lab val agecat agecat
numlabel agecat, add
tab agecat, m
tab agecat, gen(agecat)


* Gender
tab gender, m
recode gender (1=0)(2=1), gen(female)
tab gender female, m
lab var female "Sex: female"
lab def noyes 0 "no" 1 "yes"
lab val female noyes
numlabel noyes, add
tab female, m


* Educational level
tab isced1997_r, m
recode isced1997_r (-2=.b)(-1=.a)(0/2=1)(3 95 97=2)(4/6=3), gen(educ)
tab isced1997_r educ, m
lab var educ "Education"
lab def educ 1 "primary" 2 "secondary" 3 "post-secondary", replace
lab val educ educ
numlabel educ, add
tab educ, m

tab educ, gen(educ)
tab1 educ?, m

recode isced1997_r (-2=.b)(-1=.a)(min/3=0 "low")(4/max=1 "high"), gen(educ_2)
tab isced1997_r educ_2, m
lab var educ_2 "Education (dichotomized)"
numlabel educ_2, add
tab educ_2, m


* Living alone
tab partnerinhh, m
recode partnerinhh (3=1)(1=0), gen(alone)
tab partnerinhh alone, m
lab var alone "Living alone"
lab val alone noyes
numlabel noyes, add
tab alone, m


* Migration
tab dn004_, m
recode dn004_ (1=0)(5=1), gen(born)
tab dn004_ born, m
lab var born "Born abroad"
lab def born 0 "No" 1 "Yes", replace
lab val born born
numlabel born, add
tab born, m
drop dn004_


* Urban/rural
tab areabldgi, m
recode areabldgi (-2=.b)(-1=.a)(1=5)(2=4)(3=3)(4=2)(5=1), gen(area)
tab area areabldgi, m
lab def area 1 "rural area/village" 2 "small town" 3 "large town" ///
	4 "suburbs/outskirts of a big city" 5 "big city", replace
lab val area area
numlabel area, add
tab area, m
recode area (1/2=0)(3/5=1), gen(urban)
lab var urban "Urbanization"
lab def urban 0 "rural" 1 "urban", replace
lab val urban urban
numlabel urban, add
tab area urban, m
tab urban, m
drop areabldgi area


** Make ends meet
tab co007_, m
mvdecode co007_, mv(-2=.b\-1=.a\-9=.c)
tab co007_, m

sort mergeid
list mergeid co007_ in 1/100, sepby(hhid8)
bysort hhid8 (mergeid): egen help = max(co007_)
list mergeid co007_ help in 1/100, sepby(hhid8)
gen makeend = co007_
replace makeend = help if co007_>=. & help!=.
list mergeid co007_ makeend help in 1/100, sepby(hhid8)
lab var makeend "Make ends meet"
lab def makeend 1 "With great difficulty" 2 "With some difficulty" ///
	3 "Fairly easily" 4 "Easily"
lab val makeend makeend
numlabel makeend makeend, add
tab makeend, m
drop help

tab makeend, gen(make)
tab1 make?

recode makeend (1/3=0)(4=1), gen(makeend_2)
tab makeend makeend_2, m
lab var makeend_2 "Make ends meet"
lab def makeend_2 0 "With great/some difficulty, fairly easily" 1 "Easily"
lab val makeend_2 makeend_2
numlabel makeend_2, add
tab makeend_2, m


** Working status
tab1 ep005_ ep009_, m
tab ep005_ ep009_, m
recode ep005_ (-2=.b)(-1=.a)(1=1)(2=2)(3/max=4), gen(empl)
replace empl = 3 if ep005_==2 & ep009_==3
tab ep005_ empl, m
lab def empl 1 "retired" 2 "employed" 3 "self-employed" 4 "other", replace
lab val empl empl
numlabel empl, add
tab empl, m

tab empl, gen(empl)
tab1 empl?, m


** Self-rated health
tab sphus, m
recode sphus (-2=.b)(-1=.a)(5=0)(4=1)(3=2)(2=3)(1=4), gen(health)
tab sphus health, m
lab def health 0 "poor" 1 "fair" 2 "good" 3 "very good" 4 "excellent", replace
lab val health health
numlabel health, add
tab health, m

recode health (0/1=0)(2=1)(3 4=2), gen(health3)
tab health health3, m
lab var health3 "Self-rated health (poor/fair & very good/excellent collapsed)"
lab def health3 0 "poor/fair" 1 "good" 2 "very good/excellent", replace
lab val health3 health3
numlabel health3, add
tab health3, m

tab health3, gen(health3)
tab1 health3?, m


** ADL
tab adl adl2, m
mvdecode adl adl2, mv(-2=.b)
tab adl2, m
order adl2, last


** IADL
tab iadl iadl2, m
mvdecode iadl iadl2, mv(-2=.b)
tab iadl2, m
order iadl2, last


** GALI
tab gali, m
order gali, last


** Diseases
tab1 chronic2w8, m
mvdecode chronic2w8, mv(-1=.a)
rename chronic2w8 disease
tab disease, m
order disease, last


** Activities
tab ac035dno, m
recode ac035dno (-2=.b)(-1=.a)(0=1)(1=0), gen(act)
tab ac035dno act, m
lab var act "Social activities"
lab def act 0 "No" 1 "Yes"
lab val act act
numlabel act, add
tab act, m


** Mental health issues
tab1 eurodcat loneliness, m
order eurodcat, last
recode loneliness (-2=.b)(-1=.a)(3=1)(4/max=0), gen(lonely)
tab loneliness lonely, m
lab var lonely "Loneliness (dichotomized)"
lab def lonely 0 "No" 1 "Yes", replace
lab val lonely lonely
numlabel lonely, add
tab lonely, m


** Cognitive performance

* Word recall
tab1 cf008tot cf016tot, m
rename cf008tot recall
rename cf016tot recall2
order recall*, last
egen recall_avg = rowmean(recall*)
list recall*
lab var recall_avg "Word recall (avg.)"
tab recall_avg, m
sum recall_avg, d

recode recall_avg (min/5=0)(5.5/max=1), gen(recall_2)
tab recall_avg recall_2, m

recode recall_avg (min/4.5=0)(5/6=1)(6.5/max=2), gen(recall_3)
tab recall_avg recall_3, m


* Numeracy
tab1 numeracy*, m
gen num_per = numeracy-1
gen num_sub = numeracy2
tab1 num_*, m
egen num_avg = rowmean(num_*)
list num_*
lab var num_avg "Numeracy (avg.)"
tab num_avg, m
sum num_avg, d
recode num_avg (min/3.5=0)(4/max=1), gen(num_2)
tab num_avg num_2, m


* Orientation
tab orienti, m
rename orienti orient
tab orient, m
order orient, last
recode orient (0/3=0)(4=1), gen(orient_2)
tab orient orient_2, m


** Big 5
tab1 bfi10_*, m
gen extra = bfi10_extra-1
gen agree = bfi10_agree-1
gen consc = bfi10_consc-1
gen neuro = bfi10_neuro-1
gen open  = bfi10_open-1

tab extra
gen extra_2 = 0 if extra<=2.5
replace extra_2 = 1 if extra>=3 & extra<.
tab extra extra_2, m

tab agree
gen agree_2 = 0 if agree<=2.5
replace agree_2 = 1 if agree>=3 & agree<.
tab agree agree_2, m

tab consc
gen consc_2 = 0 if consc<=3
replace consc_2 = 1 if consc>=3.5 & consc<.
tab consc consc_2, m

tab neuro
gen neuro_2 = 0 if neuro<=1.5
replace neuro_2 = 1 if neuro>=2 & neuro<.
tab neuro neuro_2, m

tab open
gen open_2 = 0 if open<=2.5
replace open_2 = 1 if open>=3 & open<.
tab open open_2, m


** IT skill & usage
tab it003_, m
recode it003_ (-2=.b)(-1=.a)(6=0)(5=1)(4=2)(3=3)(2=4)(1=5), gen(it_skills)
tab it003_ it_skills, m
lab var it_skills "IT skills"
lab def it_skills 0 "never used a computer" 5 "excellent"
lab val it_skills it_skills
numlabel it_skills, add
tab it_skills, m

tab it004_, m
recode it004_ (-2=.b)(-1=.a)(5=0), gen(webuse)
tab it004_ webuse, m


** Income

* transfer income to hh
tab hh017e, m
list mergeid hh017e in 1/100, sepby(hhid8)
bysort hhid8 (mergeid): egen help = max(hh017e)
list mergeid hh017e help in 1/100, sepby(hhid8)
replace hh017e = help if (hh017e==. | hh017e<0) & help!=.
recode hh017e (-9999999=.)(-9999992=.b)(-9999991=.a), gen(hhinc)
tab hhinc if hhinc<10, m
recode hhinc (min/1=1)
tab hhinc, m
sum hhinc, d
sum hhinc
drop help

* compile income quartiles with missing categories
sum hhinc, d
recode hhinc (min/`r(p25)'=1)(`r(p25)'/`r(p50)'=2)(`r(p50)'/`r(p75)'=3) ///
	(`r(p75)'/max=4)(.a=5)(.b=6), gen(hhinc_cat)
list mergeid hh017e hhinc hhinc_cat in 1/100, sepby(hhid8)
tab hhinc_cat, m
replace hhinc_cat = . if hhinc_cat==0
lab var hhinc_cat "Total household income (cat.)"
lab def hhinc_cat 1 "1st quartile" 2 "2nd quartile" 3 "3rd quartile" ///
	4 "4th quartile" 5 "dk" 6 "rf", replace
lab val hhinc_cat hhinc_cat
numlabel hhinc_cat, add
tab hhinc_cat, m

recode hhinc_cat (1/4=0)(5 6=1), gen(hhinc_2)
lab var hhinc_2 "Income non-response"
tab hhinc_cat hhinc_2, m

* include bracket answers
tab1 hh017ub, m
list mergeid hh017e hhinc_cat hh017ub in 1/100
recode hh017ub (-1 .=1)(1/7=0) if hhinc_cat==5, gen(br_dk)
recode hh017ub (-2 .=1)(1/7=0) if hhinc_cat==6, gen(br_ref)
tab hh017ub br_dk, m
tab hh017ub br_ref, m
tab br_dk br_ref, m
tab hhinc_cat br_dk, m
tab hhinc_cat br_ref, m
bysort hhinc_cat: list mergeid hh017e hhinc_cat hh017ub br_dk br_ref ///
	if hhinc_cat==5 | hhinc_cat==6
sort mergeid

clonevar hhinc_cat_br = hhinc_cat
tab hhinc_cat_br, m
replace hhinc_cat_br = 7 if br_dk==1
replace hhinc_cat_br = 8 if br_ref==1
lab def hhinc_cat 7 "dk bracket" 8 "ref bracket", add
lab val hhinc_cat_br hhinc_cat
numlabel hhinc_cat, add force
tab hhinc_cat_br, m
bysort hhinc_cat_br: list mergeid hh017e hhinc_cat hhinc_cat_br hh017ub br_dk br_ref
sort mergeid

recode hhinc_cat_br (1/4=0)(5/8=1), gen(hhinc_2_br)
lab def hhinc_2_br 1 "ref/dk + bracket answer" 0 "substantive answer", add
lab var hhinc_2_br "Income non-response (ref/dk + bracket answer)"
lab val hhinc_2_br hhinc_2_br
numlabel hhinc_2_br, add force
tab hhinc_2_br, m

recode hhinc_cat_br (1/6=0)(7 8=1), gen(hhinc_2_br_new)
lab def hhinc_2_br_new 1 "ref/dk" 0 "substantive answer + bracket answer", add
lab var hhinc_2_br_new "Income non-response (ref/dk)"
lab val hhinc_2_br_new hhinc_2_br
numlabel hhinc_2_br_new, add force
tab hhinc_2_br_new, m


** Consent to linkage
tab consent_written, m
recode consent_written (-5 0=1)(1=0), gen(noconsent)
lab var noconsent "Non-consent"
lab def yesno 0 "No" 1 "Yes", replace
lab val noconsent yesno
numlabel yesno, add
tab noconsent, m


** Drop-off questions
mvdecode de_q*, mv(-99=.c\-2=.b\-1=.a)

* Importance of surveys for society
tab de_q1, m
recode de_q1 (5=0 "totally disagree")(4=1)(3 .a=2)(2=3)(1=4 "totally agree"), ///
	gen(survey_imp)
tab de_q1 survey_imp, m
lab var survey_imp "Importance of surveys"
numlabel survey_imp, add
tab survey_imp

recode survey_imp (0/2=0)(3/4=1), gen(survey_imp_2)
tab survey_imp survey_imp_2, m

* Results of surveys are mostly trustworthy
tab de_q4, m
recode de_q4 (5=0 "totally disagree")(4=1)(3 .a=2)(2=3)(1=4 "totally agree"), ///
	gen(survey_trust)
tab de_q4 survey_trust, m
lab var survey_trust "Results of surveys are mostly trustworthy"
numlabel survey_trust, add
tab survey_trust, m

recode survey_trust (0/2=0)(3/4=1), gen(survey_trust_2)
tab survey_trust survey_trust_2, m

* Surveys are wasted time
tab de_q2, m
recode de_q2 (5=0 "totally disagree")(4=1)(3 .a=2)(2=3)(1=4 "totally agree"), ///
	gen(survey_waste)
tab de_q2 survey_waste, m
lab var survey_waste "Surveys are wasted time"
numlabel survey_waste, add
tab survey_waste, m

recode survey_waste (0/2=0)(3/4=1), gen(survey_waste_2)
tab survey_waste survey_waste_2, m

* Answering surveys is exhausting
tab de_q3, m
recode de_q3 (5=0 "totally disagree")(4=1)(3 .a=2)(2=3)(1=4 "totally agree"), ///
	gen(survey_exh)
tab de_q3 survey_exh, m
lab var survey_exh "Answering many questions is exhausting"
numlabel survey_exh, add
tab survey_exh, m

recode survey_exh (0/2=0)(3/4=1), gen(survey_exh_2)
tab survey_exh survey_exh_2, m

* Usefulness of SHARE
tab de_q16, m
recode de_q16 (5=0 "totally disagree")(4=1)(3 .a=2)(2=3)(1=4 "totally agree"), ///
	gen(survey_use)
tab de_q16 survey_use, m
lab var survey_use "A lot can be learned from the information collected"
numlabel survey_use, add
tab survey_use, m

recode survey_use (0/2=0)(3/4=1), gen(survey_use_2)
tab survey_use survey_use_2, m

* SHARE made me reflect
tab de_q19, m
recode de_q19 (5=0 "totally disagree")(4=1)(3 .a=2)(2=3)(1=4 "totally agree"), ///
	gen(survey_think)
tab de_q19 survey_think, m
lab var survey_think "Questions in the SHARE did get me thinking about things"
numlabel survey_think, add
tab survey_think, m

recode survey_think (0/2=0)(3/4=1), gen(survey_think_2)
tab survey_think survey_think_2, m

* Enjoyed participating in SHARE
tab de_q20, m
recode de_q20 (5=0 "totally disagree")(4=1)(3 .a=2)(2=3)(1=4 "totally agree"), ///
	gen(survey_joy)
tab de_q20 survey_joy, m
lab var survey_joy "I enjoyed to participate in SHARE "
numlabel survey_joy, add
tab survey_joy, m

recode survey_joy (0/2=0)(3/4=1), gen(survey_joy_2)
tab survey_joy survey_joy_2, m

* Questions in SHARE are too personal
tab de_q17, m
recode de_q17 (5=0 "totally disagree")(4=1)(3 .a=2)(2=3)(1=4 "totally agree"), ///
	gen(survey_pers)
tab de_q17 survey_pers, m
lab var survey_pers "Questions in SHARE are too personal"
numlabel survey_pers, add
tab survey_pers, m

recode survey_pers (0/2=0)(3/4=1), gen(survey_pers_2)
tab survey_pers survey_pers_2, m

* Questions in SHARE are boring
tab de_q18, m
recode de_q18 (5=0 "totally disagree")(4=1)(3 .a=2)(2=3)(1=4 "totally agree"), ///
	gen(survey_boring)
tab de_q18 survey_boring, m
lab var survey_boring "Questions in SHARE are boring"
numlabel survey_boring, add
tab survey_boring, m

recode survey_boring (0/2=0)(3/4=1), gen(survey_boring_2)
tab survey_boring survey_boring_2, m

* Importance of knowing the organisations
tab de_q5, m
recode de_q5 (5=0 "not important")(4=1)(3 .a=2)(2=3)(1=4 "very important"), ///
	gen(imp_org)
tab de_q5 imp_org, m
lab var imp_org "Importance of knowing the organisations"
numlabel imp_org, add
tab imp_org, m

* Confidence in different organisations
tab1 de_q6 de_q7 de_q8, m
local n = 1
foreach var of varlist de_q6 de_q7 de_q8 {
	recode `var' (5=0 "complete suspiciousness")(4=1)(3 .a=2)(2=3)(1=4 "complete confidence"), ///
		gen(conf`n')
	local n = `n'+1
}
numlabel conf1 conf2 conf3, add
rename conf1 conf_science
rename conf2 conf_pubop
rename conf3 conf_gov
tab1 conf_*, m
sum conf_*

recode conf_science (0/2=0)(3/4=1), gen(conf_science_2)
tab conf_science conf_science_2, m

recode conf_pubop (0/2=0)(3/4=1), gen(conf_pubop_2)
tab conf_pubop conf_pubop_2, m

recode conf_gov (0/2=0)(3/4=1), gen(conf_gov_2)
tab conf_gov conf_gov_2, m


* Concerns
tab1 de_q9 de_q10 de_q11 de_q22 de_q23 de_q24, m
local n = 1
foreach var of varlist de_q9 de_q10 de_q11 de_q22 de_q23 de_q24 {
	recode `var' (5=0 "not concerned at all")(4=1)(3 .a=2)(2=3)(1=4 "very concerned"), ///
		gen(concern`n')
	local n = `n'+1
}
numlabel concern1 concern2 concern3 concern4 concern5 concern6, add
tab1 concern?, m
rename concern1 concern_priv
rename concern2 concern_theft
rename concern4 concern_leak
rename concern5 concern_adv
tab1 concern_*, m

recode concern_priv (0/2=0)(3/4=1), gen(concern_priv_2)
tab concern_priv concern_priv_2, m

recode concern_theft (0/2=0)(3/4=1), gen(concern_theft_2)
tab concern_theft concern_theft_2, m

recode concern_leak (0/2=0)(3/4=1), gen(concern_leak_2)
tab concern_leak concern_leak_2, m

recode concern_adv (0/2=0)(3/4=1), gen(concern_adv_2)
tab concern_adv concern_adv_2, m

pca concern_priv concern_theft concern_leak concern_adv
predict pca_concern
sum pca_concern
gen pca_concern_2 = 0 if pca_concern<0
replace pca_concern_2 = 1 if pca_concern>=0 & pca_concern<.
tab pca_concern_2, m


* Trust
tab de_q12, m
mvdecode de_q12, mv(-99=.c\-1=.a)
recode de_q12 (5=0 "You can´t be too careful")(4=1)(3 .a=2)(2=3)(1=4 "People can be trusted"), ///
	gen(trust)
tab de_q12 trust, m
lab var trust "Trust in other people"
numlabel trust, add
tab trust, m
tab trust

recode trust (0 1=0)(2/4=1), gen(trust_2)
tab trust trust_2, m


* Embarassement
tab de_q13, m
mvdecode de_q13, mv(-99=.c\-1=.a)
recode de_q13 (5=0 "totally disagree")(4=1)(3 .a=2)(2=3)(1=4 "totally agree"), ///
	gen(embar)
tab de_q13 embar, m
lab var embar "Embarassed to share income"
numlabel embar, add
tab embar, m

recode embar (0/2=0)(3/4=1), gen(embar_2)
tab embar embar_2, m


* Don't talk about income/money
tab de_q14, m
mvdecode de_q14, mv(-99=.c\-1=.a)
recode de_q14 (5=0 "totally disagree")(4=1)(3 .a=2)(2=3)(1=4 "totally agree"), ///
	gen(notalk)
tab de_q14 notalk, m
lab var notalk "Should not talk about income"
numlabel notalk, add
tab notalk, m

recode notalk (0/2=0)(3/4=1), gen(notalk_2)
tab notalk notalk_2, m


* Would give response to future income question
tab de_q15, m
mvdecode de_q15, mv(-99=.c\-1=.a)
recode de_q15 (5=0 "no")(4=1 "dk: other")(3=2 "dk: varies")(2=3 "dk: changes")(1=4 "yes"), ///
	gen(resp)
tab de_q15 resp, m
lab var resp "Would give response to future income question"
numlabel resp, add
tab resp, m
tab resp, gen(resp)
tab1 resp?, m
recode resp (0=0)(4=1)(else=.), gen(resp_2)
tab resp resp_2, m

* Modus
tab de_mode, m
recode de_mode (-3=.c)
tab de_mode	// 60% of respondents filled out drop-off directly


** Clean up dataset
keep mergeid hhid noconsent ///
	age_int agecat-resp_2 ///
	nuts1_2016 de_mode wgt_do dw_w8 cciw_w8_main
sum age_int agecat-resp_2 de_mode wgt_do dw_w8 cciw_w8_main
order noconsent hhinc_2 hhinc_2_br*, after(de_mode)
order wgt_do dw_w8 cciw_w8_main, after(resp_2)

save "${data}/w8_do_analyses.dta", replace



