###TITLE
###Authors: Zoltán Kmetty, Ádám Stefkovics

##Study Pre-registration: 
##Data files: surveytrust_20231105.Rdta

#R version 4.2.3 (2023-03-15)
#Platform: x86_64-apple-darwin17.0 (64-bit)
#Running under: macOS Monterey 12.5.1

##Last updated: 05/12/2023

#Packages

library(sjmisc)
library(sjPlot)
library(sjstats)
library(sjlabelled)
library(lme4)
library(lmerTest)
library(ordinal)
library(dplyr)


##Loading data files

load("surveytrust_20231105.Rdata")

##Creating Hungarian Vignette level data file

#Education
frq(hudata$D3_HU)
hudata$educ2 <- rec(hudata$D3_HU, rec="1:3=1 [High School or lower]; 4=2 [Diploma]")
hudata$educ2 <- set_label(hudata$educ2,"Education")

#SNS scale
hudata %>% 
  select(., c(P9_1, P10_1, P11_1, P12_1, P13_1, P14_1, P16_1)) %>% 
  tab_itemscale(.)

hudata$sns <-  hudata %>% 
  select(., c(P9_1, P10_1, P11_1, P12_1, P13_1, P14_1, P16_1)) %>% 
  apply(., 1, mean)

hudata$sns2 <- rec(hudata$sns, rec="1:4.2=1 [Lower]; 4.21:6=2 [Higher]")


#Trust questions
hudata$P1_1 <- set_na(hudata$P1_1, na=9)
hudata$P1_2 <- set_na(hudata$P1_2, na=9)
hudata$P1_3 <- set_na(hudata$P1_3, na=9)
hudata$P1_4 <- set_na(hudata$P1_4, na=9)

hudata %>% 
  select(., c(P1_1, P1_2, P1_3, P1_4)) %>% 
  tab_itemscale(.)

#Imputation of missing scientif trust, with the mean of other trust variables
hudata$P1_mean <- hudata %>% 
  select(., c(P1_1, P1_2, P1_3, P1_4)) %>% 
  apply(., 1, function(x) mean(x, na.rm=T))

hudata$P1_1[which(is.na(hudata$P1_1))] <- hudata$P1_mean[which(is.na(hudata$P1_1))]
hudata$P1_1 <- set_label(hudata$P1_1,"Trust in science")

##Left-Right
frq(hudata$P5_1)

hudata$lr3 <- rec(hudata$P5_1, rec="1:3=1 [Left]; 5:7=3 [Right];4,9=2 [Middle, DK]")
hudata$lr3  <- as_factor(hudata$lr3)
hudata$lr3 <- set_label(hudata$lr3,"Left-Right")


#Evaluation of migration (3 categories)
frq(hudata$P6_1)
hudata$mig_v1 <- rec(hudata$P6_1, rec="0:3=1; 4:6=2; 7:10=3")

vignette.data.hu <- hudata  %>% 
  select(., c(sorsz,D1, D2, educ2, sns2, P1_1, P2, lr3, mig_v1, weight ))  %>% 
  na.omit() %>% 
  copy_labels(., hudata) %>% 
  left_join(vignette.data.hu, .)

rm(hudata)

#Remove vignettes without individual level data

vignette.data.hu <- vignette.data.hu %>% 
  .[!is.na(.$D1),] %>% 
  copy_labels(.,vignette.data.hu)
  
  
##Creating US Vignette level data file

frq(usdata$D3_US)
usdata$educ2 <- rec(usdata$D3_US, rec="1:6=1 [High School or lower]; 7:10=2 [Diploma]")
usdata$educ2 <- set_label(usdata$educ2,"Education")

#SNS scale
usdata %>% 
  select(., c(P9_1, P10_1, P11_1, P12_1, P13_1, P14_1, P16_1)) %>% 
  tab_itemscale(.)

usdata$sns <-  usdata %>% 
  select(., c(P9_1, P10_1, P11_1, P12_1, P13_1, P14_1, P16_1)) %>% 
  apply(., 1, mean)

usdata$sns2 <- rec(usdata$sns, rec="1:4.79=1 [Lower]; 4.8:6=2 [Higher]")


#Trust questions
usdata$P1_1 <- set_na(usdata$P1_1, na=9)
usdata$P1_2 <- set_na(usdata$P1_2, na=9)
usdata$P1_3 <- set_na(usdata$P1_3, na=9)
usdata$P1_4 <- set_na(usdata$P1_4, na=9)

usdata %>% 
  select(., c(P1_1, P1_2, P1_3, P1_4)) %>% 
  tab_itemscale(.)

#Imputation of missing scientif trust, with the mean of other trust variables
usdata$P1_mean <- usdata %>% 
  select(., c(P1_1, P1_2, P1_3, P1_4)) %>% 
  apply(., 1, function(x) mean(x, na.rm=T))

usdata$P1_1[which(is.na(usdata$P1_1))] <- usdata$P1_mean[which(is.na(usdata$P1_1))]
usdata$P1_1 <- set_label(usdata$P1_1,"Trust in science")

##Left-Right
frq(usdata$P5_1)

usdata$lr3 <- rec(usdata$P5_1, rec="1:3=1 [Left]; 5:7=3 [Right];4,9=2 [Middle, DK]")
usdata$lr3  <- as_factor(usdata$lr3)
usdata$lr3 <- set_label(usdata$lr3,"Left-Right")


#Evaluation of migration (3 categories)
frq(usdata$P6_1)
usdata$mig_v1 <- rec(usdata$P6_1, rec="0:3=1; 4:6=2; 7:10=3")

vignette.data.us <- usdata  %>% 
  select(., c(sorsz,D1, D2, educ2, sns2, P1_1, P2, lr3, mig_v1))  %>% 
  na.omit() %>% 
  copy_labels(., usdata) %>% 
  left_join(vignette.data.us, .)

rm(usdata)
#Remove vignettes without individual level data
vignette.data.us <- vignette.data.us %>% 
  .[!is.na(.$D1),] %>% 
  copy_labels(.,vignette.data.us)



########ANALYSIS####################

##Creating the sub-samples


vignette.data.hu$size <- as_factor(vignette.data.hu$size)
vignette.data.us$size <- as_factor(vignette.data.us$size)

vignette.data.nonpol.hu <- vignette.data.hu %>% 
  subset(., Type==1) %>% 
  copy_labels(., vignette.data.hu)

vignette.data.pol.hu <- vignette.data.hu %>% 
  subset(., Type==2) %>% 
  copy_labels(., vignette.data.hu)


vignette.data.nonpol.us <- vignette.data.us %>% 
  subset(., Type==1) %>% 
  copy_labels(., vignette.data.us)

vignette.data.pol.us <- vignette.data.us %>% 
  subset(., Type==2) %>% 
  copy_labels(., vignette.data.us)


#Calculating issue agreement
vignette.data.pol.hu$issue.agreement <- 0
vignette.data.pol.hu$issue.agreement[which((vignette.data.pol.hu$mig_v1==1) & (vignette.data.pol.hu$results_pol==2))] <- 1
vignette.data.pol.hu$issue.agreement[which((vignette.data.pol.hu$mig_v1==3) & (vignette.data.pol.hu$results_pol==1))] <- 1



vignette.data.pol.us$issue.agreement <- 0
vignette.data.pol.us$issue.agreement[which((vignette.data.pol.us$mig_v1==1) & (vignette.data.pol.us$results_pol==2))] <- 1
vignette.data.pol.us$issue.agreement[which((vignette.data.pol.us$mig_v1==3) & (vignette.data.pol.us$results_pol==1))] <- 1



##mean values od the dependent variable

descr(vignette.data.nonpol.hu$s.trust)
descr(vignette.data.nonpol.us$s.trust)
descr(vignette.data.pol.hu$s.trust)
descr(vignette.data.pol.us$s.trust)

#Table 2. Survey Trustworthiness – Study 1 (Commuting)


model_table2_1 <- lmer(formula = s.trust ~ 1+ (1|sorsz),
               weights = weight,
               data    = vignette.data.nonpol.hu)

model_table2_2 <- lmer(formula = s.trust ~ 1 +results_nonpol + sponsor_nonpol +
                 size + representative + random+ (1|sorsz),
               weights = weight,
               data    = vignette.data.nonpol.hu)


model_table2_3<- lmer(formula = s.trust ~ 1 +results_nonpol + sponsor_nonpol +
                  size + representative + random+ D2 + D1 +educ2+P1_1+ (1|sorsz),
                weights = weight,
                data    = vignette.data.nonpol.hu)

model_table2_4 <- lmer(formula = s.trust ~ 1+ (1|sorsz),
                       data    = vignette.data.nonpol.us)

model_table2_5 <- lmer(formula = s.trust ~ 1 +results_nonpol + sponsor_nonpol +
                         size + representative + random+ (1|sorsz),
                       data    = vignette.data.nonpol.us)

#Subset the first vignettes

vignette.data.nonpol.us_o1 <- subset(vignette.data.nonpol.us, vignette.data.nonpol.us$order==1)

model_table2_5_order1 <- glm(formula = s.trust ~ 1 +results_nonpol + sponsor_nonpol +
                         size + representative + random,
                       data    = vignette.data.nonpol.us_o1)


model_table2_6<- lmer(formula = s.trust ~ 1 +results_nonpol + sponsor_nonpol +
                        size + representative + random+ D2 + D1 +educ2+P1_1+ (1|sorsz),
                      data    = vignette.data.nonpol.us)

tab_model(model_table2_1,model_table2_2, model_table2_3,
          model_table2_4, model_table2_5, model_table2_6, show.dev=T, show.se=T, show.ci=F)

tab_model(model_table2_5, model_table2_5_order1, show.dev=T, show.se=T, show.ci=F)

##Bootstrap the explained variance

bootstrap_VarCorr <- function(x) {
bm <-   as_tibble(VarCorr(x, comp=c("Variance")))$vcov
bm.res <- bm[1]/sum(bm)
return(bm.res)
}
set.seed(123)
boot_results_hu_m1 <- bootMer(model_table2_1, FUN = function (x) bootstrap_VarCorr(x), nsim = 1000)



#Table 3. Survey Trustworthiness – Study 2 (Migration)


model_table3_1 <- lmer(formula = s.trust ~ 1+ (1|sorsz),
                       weights = weight,
                       data    = vignette.data.pol.hu)

model_table3_2 <- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                         size + representative + random+ (1|sorsz),
                       weights = weight,
                       data    = vignette.data.pol.hu)


model_table3_3<- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                        size + representative + random+ D2 + D1 +educ2+P1_1+
                        lr3 +  P2 + issue.agreement + (1|sorsz),
                      weights = weight,
                      data    = vignette.data.pol.hu)

model_table3_4 <- lmer(formula = s.trust ~ 1+ (1|sorsz),
                       data    = vignette.data.pol.us)

model_table3_5 <- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                         size + representative + random+ (1|sorsz),
                       data    = vignette.data.pol.us)

model_table3_5_o1 <- glm(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                         size + representative + random,
                       data    = vignette.data.pol.us, subset=order==1)


model_table3_6<- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                        size + representative + random+ D2 + D1 +educ2+P1_1+ 
                        lr3 +  P2 + issue.agreement + (1|sorsz),
                      data    = vignette.data.pol.us)

tab_model(model_table3_1,model_table3_2, model_table3_3,
          model_table3_4, model_table3_5, model_table3_6, show.dev=T, show.se=T, show.ci=F)

tab_model(model_table3_5, model_table3_5_o1)

set.seed(123)
boot_results_hu_m2 <- bootMer(model_table3_1, FUN = function (x) bootstrap_VarCorr(x), nsim = 1000)


#Table A2. Survey Trustworthiness by SNS – Study 1 (Commuting)

model_tableA2_1<- lmer(formula = s.trust ~ 1 +results_nonpol + sponsor_nonpol +
                        size + representative + random+ D2 + D1 +sns2+P1_1+ (1|sorsz),
                      weights = weight,
                      data    = vignette.data.nonpol.hu)

model_tableA2_2<- lmer(formula = s.trust ~ 1 +results_nonpol + sponsor_nonpol +
                         size + representative + random+ D2 + D1 +sns2+P1_1+ (1|sorsz),
                       data    = vignette.data.nonpol.us)

tab_model(model_tableA2_1, model_tableA2_2, show.dev=T, show.se=T, show.ci=F)


#Table A3. Survey Trustworthiness by SNS – Study 2 (Migration)

model_tableA3_1<- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                         size + representative + random+ D2 + D1 +sns2+P1_1+ (1|sorsz),
                       weights = weight,
                       data    = vignette.data.pol.hu)

model_tableA3_2<- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                         size + representative + random+ D2 + D1 +sns2+P1_1+ (1|sorsz),
                       data    = vignette.data.pol.us)

tab_model(model_tableA3_1, model_tableA3_2, show.dev=T, show.se=T, show.ci=F)


#Table A4. Survey Trustworthiness with 2-way interactions – Study 1 (Commuting)

model_tableA4_1 <- lmer(formula = s.trust ~ 1 +results_nonpol + sponsor_nonpol +
                        size + representative + random+ D2 + D1 +educ2+P1_1+
                         results_nonpol* sponsor_nonpol +
                         size*representative + size*random +  representative*random + (1|sorsz),
                      weights = weight,
                      data    = vignette.data.nonpol.hu)


model_tableA4_2 <- lmer(formula = s.trust ~ 1 +results_nonpol + sponsor_nonpol +
                         size + representative + random+ D2 + D1 +educ2+P1_1+
                         results_nonpol* sponsor_nonpol +
                         size*representative + size*random +  representative*random + (1|sorsz),
                       data    = vignette.data.nonpol.us)


tab_model(model_tableA4_1, model_tableA4_2, show.dev=T, show.se=T, show.ci=F)


#Table A5. Survey Trustworthiness with 2-way interactions – Study 2 (Migration)

model_tableA5_1<- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                        size + representative + random+ D2 + D1 +educ2+P1_1 +
                        lr3 +  P2 + issue.agreement + 
                          results_pol*sponsor_pol +
                          size*representative + size*random +  representative*random + (1|sorsz),
                      weights = weight,
                      data    = vignette.data.pol.hu)

model_tableA5_2<- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                         size + representative + random+ D2 + D1 +educ2+P1_1 +
                       lr3 +  P2 + issue.agreement + 
                         results_pol*sponsor_pol +
                         size*representative + size*random +  representative*random + (1|sorsz),
                       data    = vignette.data.pol.us)


tab_model(model_tableA5_1, model_tableA5_2, show.dev=T, show.se=T, show.ci=F)


#Table A6. Survey Trustworthiness split by Education categories– Study 1 (Commuting)


model_tableA6_1 <- lmer(formula = s.trust ~ 1 +results_nonpol + sponsor_nonpol +
                         size + representative + random+ (1|sorsz),
                       weights = weight,
                       data    = vignette.data.nonpol.hu, subset=(educ2==1))

model_tableA6_2 <- lmer(formula = s.trust ~ 1 +results_nonpol + sponsor_nonpol +
                          size + representative + random+ (1|sorsz),
                        weights = weight,
                        data    = vignette.data.nonpol.hu, subset=(educ2==2))


model_tableA6_3 <- lmer(formula = s.trust ~ 1 +results_nonpol + sponsor_nonpol +
                          size + representative + random+ (1|sorsz),
                        data    = vignette.data.nonpol.us, subset=(educ2==1))

model_tableA6_4 <- lmer(formula = s.trust ~ 1 +results_nonpol + sponsor_nonpol +
                          size + representative + random+ (1|sorsz),
                        data    = vignette.data.nonpol.us, subset=(educ2==2))



tab_model(model_tableA6_1, model_tableA6_2, model_tableA6_3, model_tableA6_4, show.dev=T, show.se=T, show.ci=F)


#Table A7. Survey Trustworthiness split by Education categories– Study 2 (Migration)


model_tableA7_1 <- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                          size + representative + random+ (1|sorsz),
                        weights = weight,
                        data    = vignette.data.pol.hu, subset=(educ2==1))

model_tableA7_2 <- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                          size + representative + random+ (1|sorsz),
                        weights = weight,
                        data    = vignette.data.pol.hu, subset=(educ2==2))


model_tableA7_3 <- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                          size + representative + random+ (1|sorsz),
                        data    = vignette.data.pol.us, subset=(educ2==1))

model_tableA7_4 <- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                          size + representative + random+ (1|sorsz),
                        data    = vignette.data.pol.us, subset=(educ2==2))


tab_model(model_tableA7_1, model_tableA7_2, model_tableA7_3, model_tableA7_4, show.dev=T, show.se=T, show.ci=F)

#Table A8. Survey Trustworthiness split by SNS categories– Study 1 (Commuting)



model_tableA8_1 <- lmer(formula = s.trust ~ 1 +results_nonpol + sponsor_nonpol +
                          size + representative + random+ (1|sorsz),
                        weights = weight,
                        data    = vignette.data.nonpol.hu, subset=(sns2==1))

model_tableA8_2 <- lmer(formula = s.trust ~ 1 +results_nonpol + sponsor_nonpol +
                          size + representative + random+ (1|sorsz),
                        weights = weight,
                        data    = vignette.data.nonpol.hu, subset=(sns2==2))


model_tableA8_3 <- lmer(formula = s.trust ~ 1 +results_nonpol + sponsor_nonpol +
                          size + representative + random+ (1|sorsz),
                        data    = vignette.data.nonpol.us, subset=(sns2==1))

model_tableA8_4 <- lmer(formula = s.trust ~ 1 +results_nonpol + sponsor_nonpol +
                          size + representative + random+ (1|sorsz),
                        data    = vignette.data.nonpol.us, subset=(sns2==2))


tab_model(model_tableA8_1, model_tableA8_2, model_tableA8_3, model_tableA8_4, show.dev=T, show.se=T, show.ci=F)


#Table A9. Survey Trustworthiness split by SNS categories– Study 2 (Migration)

model_tableA9_1 <- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                          size + representative + random+ (1|sorsz),
                        weights = weight,
                        data    = vignette.data.pol.hu, subset=(sns2==1))

model_tableA9_2 <- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                          size + representative + random+ (1|sorsz),
                        weights = weight,
                        data    = vignette.data.pol.hu, subset=(sns2==2))


model_tableA9_3 <- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                          size + representative + random+ (1|sorsz),
                        data    = vignette.data.pol.us, subset=(sns2==1))

model_tableA9_4 <- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                          size + representative + random+ (1|sorsz),
                        data    = vignette.data.pol.us, subset=(sns2==2))


tab_model(model_tableA9_1, model_tableA9_2, model_tableA9_3, model_tableA9_4, show.dev=T, show.se=T, show.ci=F)



#Table A10. Survey Trustworthiness with political control interactions – Study 2 (Migration)

model_tableA10_1<- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                        size + representative + random+ D2 + D1 +educ2+P1_1+
                        lr3 +  P2 + issue.agreement +lr3*issue.agreement + (1|sorsz),
                      weights = weight,
                      data    = vignette.data.pol.hu)

model_tableA10_2<- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                        size + representative + random+ D2 + D1 +educ2+P1_1+
                        lr3 +  P2 + issue.agreement +P2*issue.agreement + (1|sorsz),
                      weights = weight,
                      data    = vignette.data.pol.hu)


model_tableA10_3<- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                          size + representative + random+ D2 + D1 +educ2+P1_1+
                          lr3 +  P2 + issue.agreement +lr3*issue.agreement + (1|sorsz),
                        data    = vignette.data.pol.us)

model_tableA10_4<- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                          size + representative + random+ D2 + D1 +educ2+P1_1+
                          lr3 +  P2 + issue.agreement +P2*issue.agreement + (1|sorsz),
                        data    = vignette.data.pol.us)

tab_model(model_tableA10_1, model_tableA10_2, model_tableA10_3, model_tableA10_4, show.dev=T, show.se=T, show.ci=F)


#Table A11. Survey Trustworthiness  (Multilevel Mixed-Effects Ordered Logistic Regression Model) – Study 1 (Commuting)

vignette.data.nonpol.hu$s.trust.ord <- as.ordered(vignette.data.nonpol.hu$s.trust)
vignette.data.nonpol.us$s.trust.ord <- as.ordered(vignette.data.nonpol.us$s.trust)

model_tableA11_1 <- clmm(formula = s.trust.ord ~ 1 +results_nonpol + sponsor_nonpol +
                             size + representative + random+ D2 + D1 +educ2+P1_1+ (1|sorsz),
                           data    = vignette.data.nonpol.hu, weights = weight, threshold = "symmetric")


model_tableA11_2 <- clmm(formula = s.trust.ord ~ 1 +results_nonpol + sponsor_nonpol +
                           size + representative + random+ D2 + D1 +educ2+P1_1+ (1|sorsz),
                         data    = vignette.data.nonpol.us, threshold = "symmetric")


tab_model(model_tableA11_1, model_tableA11_2, show.dev=T, show.se=T, show.ci=F,
          transform=NULL)


#Table A12. Survey Trustworthiness  (Multilevel Mixed-Effects Ordered Logistic Regression Model) – Study 2 (Migration)

vignette.data.pol.hu$s.trust.ord <- as.ordered(vignette.data.pol.hu$s.trust)
vignette.data.pol.us$s.trust.ord <- as.ordered(vignette.data.pol.us$s.trust)



model_tableA12_1 <- clmm(formula = s.trust.ord ~ 1 +results_pol + sponsor_pol +
                         size + representative + random+ D2 + D1 +educ2+P1_1+ 
                         lr3 +  P2 + issue.agreement + (1|sorsz),
                       data    = vignette.data.pol.hu,  weights = weight, threshold = "symmetric")


model_tableA12_2 <- clmm(formula = s.trust.ord ~ 1 +results_pol + sponsor_pol +
                         size + representative + random+ D2 + D1 +educ2+P1_1+ 
                         lr3 +  P2 + issue.agreement + (1|sorsz),
                       data    = vignette.data.pol.us, threshold = "symmetric")


tab_model(model_tableA12_1, model_tableA12_2, show.dev=T, show.se=T, show.ci=F,
          transform=NULL)


##Further explanatory analyis (Figure 1.)

vignette.data.pol.us$sponsor_pol <- as_factor(vignette.data.pol.us$sponsor_pol)
vignette.data.pol.hu$sponsor_pol <- as_factor(vignette.data.pol.hu$sponsor_pol)

#We create a reverse coding for Hungarian Sponsor, for better plotting

vignette.data.pol.hu$sponsor_pol2 <- as_factor(rec(vignette.data.pol.hu$sponsor_pol,
                                         rec="2=1 [HVG]; 1=2 [Magyar Nemzet]"))

model_table_explan_0_hu<- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol2 +
                                 size + representative + random+ D2 + D1 +educ2+P1_1+
                                 lr3 +  P2 + issue.agreement + (1|sorsz),
                               weights = weight,
                               data    = vignette.data.pol.hu)

model_table_explan_1_hu<- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol2 +
                          size + representative + random+ D2 + D1 +educ2+P1_1+
                          lr3 +  P2 + issue.agreement +lr3*sponsor_pol2 + (1|sorsz),
                        weights = weight,
                        data    = vignette.data.pol.hu)

model_table_explan_0_us<- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                                 size + representative + random+ D2 + D1 +educ2+P1_1+
                                 lr3 +  P2 + issue.agreement + (1|sorsz),
                               data    = vignette.data.pol.us)


model_table_explan_1_us<- lmer(formula = s.trust ~ 1 +results_pol + sponsor_pol +
                                 size + representative + random+ D2 + D1 +educ2+P1_1+
                                 lr3 +  P2 + issue.agreement +lr3*sponsor_pol + (1|sorsz),
                               data    = vignette.data.pol.us)
tab_model(model_table_explan_0_hu, model_table_explan_1_hu, model_table_explan_0_us, model_table_explan_1_us)

p1 <- plot_model(model_table_explan_1_us, type="int", width = 0.1) +
  xlab("Sponsor") +
  ylab("Survey trustworthiness") +
  theme_minimal() +
  ggtitle("U.S.")

p2 <- plot_model(model_table_explan_1_hu, type="int", width = 0.1) +
  xlab("Sponsor") +
  ylab("Survey trustworthiness") +
  theme_minimal() +
  ggtitle("Hungary")

p0 <- ggpubr::ggarrange(p1, p2, nrow = 2)

ggsave(file="fig1.svg", plot=p0, width=6, height=10)

##End of code##
