clear all
*****************************************************
* SRM do-file
* this program written by Polina Polskaia
* Andy Crosby, Xiaoyan Hu,
* with contributions from other authors
* This version is as of June 26, 2024
*****************************************************
* Set delimit to semicolon
#delimit ;

* Show date and time;
display "$S_TIME  $S_DATE";

* Set more function off;
set more off;

* Set file path; note: user will need to customize for their working directory
cd "/Users/allyson/Dropbox/Survey Group MAPOR Materials/Buckeye State Polls Project/FINAL Files submitted to SRM for publication/";

* Log the output;
capture log using "SRM_062624.smcl", replace;
*****************************************************;
* Open April 2000 BSP data;
*****************************************************;
use "bsp400s.dta";
* Label dataset April 2000;
* I label this as 400 to represent April 2000 (4/2000);
gen svyid=400;
* Destring the caseid variable to allow later append;
destring caseid, replace;
* Destring other variables in Apr 2000 that are not string;
* In other datasets;
destring prand1, gen(prand1r);
destring prand2, gen(prand2r);
destring prand5, gen(prand5r);
destring prand6, gen(prand6r);
destring prand7, gen(prand7r);
* In April/May 2000 survey, mode/sampling was held constant as;
* RDD even though the data says otherwise. prand4 is the var that;
* was created for mode/sampling and was not used. We recode it as 2 = RDD;
destring prand4, gen(prand4r);
replace prand4r = 2;
* Then, save Apr 2000 dataset;
save "AAPOR22_400.dta", replace;
*****************************************************;
* Arrange other datasets for append;
*****************************************************;
* Now, rename other datasets;
* Using the same conventions;
* First August 1997 (labeled as 897);
use "bsp897.dta";
* Generate consistency variable for 897 dataset;
* rand2;
gen rand2r=.;
replace rand2r=rand2;
* recode rand2 - percent support for vouchers;
* Original coding is 1 = 40 fav/60 opp and 2 = 60 fav / 40 opp;
* Recode is 0 = 40f/60o and 1 = 60f/40o;
recode rand2r 1=0 2=1;
tab rand2r;
* recode q34 - peoples opinion about vouchers;
* Original coding is 1 = Favor and 2 = oppose;
* Recode is 0 = oppose and 1 = favor;
tab q34;
gen q34r = q34;
recode q34r 2 =0;
recode q34r 9=.u;
tab q34r;
*Generate consistency variable;
gen consist=.;
replace consist=. if q34r==.r;
replace consist=. if q34r==.u;
replace consist=. if q34r==.;
replace consist=1 if q34r==1 & rand2r==1;
replace consist=1 if q34r==0 & rand2r==0;
replace consist=0 if q34r==1 & rand2r==0;
replace consist=0 if q34r==0 & rand2r==1;
replace consist=. if rand2r==.;
* Rename variables with month/year to avoid conflicts;
rename * *_897;
* Generate survey ID variable;
gen svyid=.;
replace svyid=897;
* Rename variables that have identical values in other datasets;
rename caseid_897 caseid;
rename educ4_897 educ4;
rename pew2_897 pew2;
rename pew3_897 pew3;
rename rand2_897 prand2r;
rename rand5_897 prand5r;
rename rand6_897 prand6r;

*Save August 1997 dataset;
save "AAPOR22_897.dta", replace;
*Open March 2000 dataset;
use "bsp300w.dta";
*Generate consistency variable for 300 dataset;
*first, binary measure of pre-existing opinion;
*Original coding 1 = Favor ban on sale of handguns, 2 = Oppose ban;
gen favor_ban=.;
replace favor_ban=1 if p4a==1;
replace favor_ban=0 if p4a==2;
*then, poll result consistent with R attitude variable;
gen consist=.;
*Original rand2 coding 1 = 65/35 support handgun control, 2 = 35/65 support handgun control;
replace consist=1 if rand2==1 & favor_ban==1;
replace consist=1 if rand2==2 & favor_ban==0;
replace consist=0 if rand2==1 & favor_ban==0;
replace consist=0 if rand2==2 & favor_ban==1;
* Rename variables to avoid conflicts in merge;
rename * *_300;
* Generate survey ID variable;
gen svyid=.;
replace svyid=300;
* Rename variables that have identical values in other datasets;
rename caseid_300 caseid;
rename educ4_300 educ4;
rename pew2_300 pew2;
rename pew3_300 pew3;
rename rand1_300 prand1r;
rename rand2_300 prand2r;
rename rand5_300 prand5r;
rename rand6_300 prand6r;

*Save March 2000 dataset;
save "AAPOR22_300.dta", replace;

*Reopen April 2000 dataset;
use "AAPOR22_400.dta";

*Append in August 1997 and March 2000 datasets;
append using "AAPOR22_897.dta";
append using "AAPOR22_300.dta";


* Now begin recoding;
*****************************************************;
*****************************************************;
* Beginning with dependent variables;
* First the accuracy variable;
*****************************************************;
* Original variable name is pew2;
* Original coding is 1 = Extremely Accurate to;
* 5 = Not at all Accurate;
* With 9 = Uncertain;
* This creates a new variable called pew2r for analysis;
* Where 5 = 0, 4 = 0.25, 3 = 0.5, 2 = 0.75, and 1 = 1;
* And where 9 is recoded as missing;
gen pew2r=.;
replace pew2r=pew2;
* Now the recoding of the traditional values;
* Using the scheme outlined above;
recode pew2r 5=0 4=0.25 3=0.5 2=0.75 1=1;
* Now recode 9 values to 0.5;
recode pew2r 9=0.5;
* Now we recode the missing or omitted values;
* This do-file uses ".u" to differentiate "uncertain";
* for all surveys;
*****************************************************;
*****************************************************;
* Now the consideration variable;
*****************************************************;
* Original variable name is pew3;
* Original coding is 1 = Yes, should consider;
* 2 = No, should not consider;
* With 9 = Uncertain;
* This creates a new variable called pew3r for analysis;
* Where 1 = 1, 2 = 0;
* And where 9 is recoded as 0.5;
gen pew3r=.;
replace pew3r=pew3;
* Now the recoding of the traditional values;
* Using the scheme outlined above;
recode pew3r 2=0 1=1 9=0.5;
* Now create a binary variable for pew3r;
gen pew3rb=pew3r;
* Now recode middle values to missing;
recode pew3rb 2=0 1=1 0.5=.;
*****************************************************;
*****************************************************;
* Now the independent variables;
*****************************************************;
*****************************************************;
* Manipulated order variable;
*****************************************************;
* Original variable name is rand2;
* Original coding is 1 = start at beginning;
* 2 = start at Q16;
* This creates a new variable called rand2r for analysis;
* Where 1 = 0, 2 = 1;
* However, rand2 is coded as a string (text) variable in the original dataset;
* As such, we need to destring the variable first;
* Since all of the values are numeric and not text;
destring rand2, gen(rand2r);
* Now the recoding of the traditional values;
* Using the scheme outlined above;
recode rand2r 1=0 2=1;
* Create combined variable;
gen block=.;
replace block=rand2r;
*****************************************************;
*****************************************************;
* Order of information within vignette;
*****************************************************;
* Original variable name is prand1;
* Original coding is 1 = results then methods;
* 2 = methods then results;
* This creates a new variable called prand1r for analysis;
* Where 1 = 0, 2 = 1;
recode prand1r 1=0 2=1;
recode rand1_897 1=0 2=1;
* Create combined variable;
gen ordinfo=.;
replace ordinfo=prand1r;
replace ordinfo=rand1_897 if svyid == 897;
*****************************************************;
*****************************************************;
* Percent support variable;
*****************************************************;
* Original variable name is prand2;
* Original coding is 1 = poll result 60% (April 2000);
* 1 = poll result 65% (March 2000);
* 1 = poll result 40% (August 1997);
* 2 = poll result 40% (April 2000);
* 2 = poll result 35% (March 2000);
* 2 = poll result 60% (August 1997);
* This creates a new dummy variable called prand2r for analysis;
* Where 1 = 1, 2 = 0 for 2000 surveys;
* Flip for 1997 due to reverse coding;
recode prand2r 1=1 2=0 if svyid!=897;
recode prand2r 1=0 2=1 if svyid==897;

*****************************************************;
*****************************************************;
* Sample size;
*****************************************************;
* Original variable name is prand3;

* We will have three versions of this variable: ;
* 1 - actual numbers like 100 1000 10000...;
* 2 - ln of actual numbers;
* 3 - high, medium, low as 1, 0.5, 0;

* April/May 2000;

* However, prand3 is coded as a string (text) variable in the original dataset;
* As such, we need to "destring" the variable first;
* Since all of the values are numeric and not text;
destring prand3, gen(prand3r);

gen sample_actual = . ;
replace sample_actual = 100 if prand3r == 1 ;
replace sample_actual = 2000 if prand3r == 2 ;
replace sample_actual = 10000 if prand3r == 3 ;

gen sample_level = . ;
replace sample_level = 0 if prand3r == 1 ;
replace sample_level = 0.5 if prand3r == 2 ;
replace sample_level = 1 if prand3r == 3 ;

* March 2000;

replace sample_actual = 1000 if rand3_300 == 1 & svyid == 300;
replace sample_actual = 2000 if rand3_300 == 2 & svyid == 300;

replace sample_level = 0 if rand3_300 == 1 & svyid == 300;
replace sample_level = 1 if rand3_300 == 2 & svyid == 300;

* 1997;

replace sample_actual = 200 if rand3_897 == 1 & svyid == 897;
replace sample_actual = 1000 if rand3_897 == 2 & svyid == 897;


replace sample_level = 0 if rand3_897 == 1 & svyid == 897;
replace sample_level = 1 if rand3_897 == 2 & svyid == 897;

* Generate the 3rd variable - natural log ; 
gen sample_ln = log(sample_actual) ;

* Generate scaled log variable ;
gen samplnsc = . ;
replace samplnsc = 0 if sample_actual == 100;
replace samplnsc = 0.15 if sample_actual == 200;
replace samplnsc = 0.5 if sample_actual == 1000;
replace samplnsc = 0.65 if sample_actual == 2000;
replace samplnsc = 1 if sample_actual == 10000;

* Generate scaled sqrt variable ;
gen sampsqsc = . ;
replace sampsqsc = 0 if sample_actual == 100;
replace sampsqsc = 0.05 if sample_actual == 200;
replace sampsqsc = 0.24 if sample_actual == 1000;
replace sampsqsc = 0.39 if sample_actual == 2000;
replace sampsqsc = 1 if sample_actual == 10000;


*****************************************************;
*****************************************************;
* Mode/Sampling
*****************************************************;
* Original variable name is prand4;
* This creates a new variable called prand4r for analysis;
* Where 1 = 0, 2 = 1;

* Apri/May 2000;
gen mode= prand4r;
recode mode 2=1;
* March 2000;
recode rand4_300 1=0.5 2=1;
* 0.5 == Enhanced mall intercept;
replace mode = rand4_300 if svyid == 300;
* 1997 survey;
recode rand4_897 1=0 2=1;
replace mode = rand4_897 if svyid == 897;

*recoded mode;
gen moder=.;
replace moder=.;
replace moder=1 if svyid == 400;
replace moder=0 if svyid == 897 & mode==0;
replace moder=1 if svyid == 897 & mode==1;
replace moder=0.333 if svyid == 300 & mode==0.5;
replace moder=0.667 if svyid == 300 & mode==1;

*****************************************************;
* Survey response rate variable;
*****************************************************;
* Original variable name is prand5;
* Original coding is 1 = 45% response rate for April 2000;
* 1 = 70% response rate for March 2000;
* 1 = 80% response rate for August 1997;
* 2 = 55% response rate for April 2000;
* 2 = 30% response rate for March 2000;
* 2 = 20% response rate for August 1997
* This creates a new variable called prand5r for analysis;
* Where 1 = 0, 2 = 1;
recode prand5r 1=0 2=1 if svyid==400;
recode prand5r 1=1 2=0 if svyid!=400;
* Create combined variable;
gen rr=.;
replace rr=prand5r;
* Create continuous variable;
gen rrc=.;
replace rrc=0.55 if rr==1 & svyid==400;
replace rrc=0.45 if rr==0 & svyid==400;
replace rrc=0.70 if rr==1 & svyid==300;
replace rrc=0.30 if rr==0 & svyid==300;
replace rrc=0.80 if rr==1 & svyid==897;
replace rrc=0.20 if rr==0 & svyid==897;
*Generate rescaled continuous rr variable;
*Minimum was previously 0.2;
gen rrcx=.;
replace rrcx=(rrc-0.2)*1.6666667;
replace rrcx = 0 if rrcx<0.001 & rrcx >0;
*****************************************************;
*****************************************************;
* Survey sponsor variable;
*****************************************************;
* Original variable name is prand6;
* Original coding is 1 = major newspaper in Ohio;
* 2 = Religious Denomination (August 1997);
* 2 = National Rifle Association (March 2000);
* 2 = Ohioans against the lottery (April 2000);
* This creates a new variable called prand6r for analysis;
* Where 1 = 1, 2 = 0;
recode prand6r 1=1 2=0;
* Create combined variable;
gen sponsor=.;
replace spons=prand6r;
*****************************************************;
*****************************************************;
* Survey house variable;
*****************************************************;
* Original variable name is prand7;
* Original coding is 1 = a group of volunteers;
* 2 = the Gallup organization;
* This creates a new variable called prand7r for analysis;
* Where Gallup (1) or Market research firm in Ohio (1/2) and Group of volunteers (0) or Gallup (1);

* 1997 survey did not have this question;

* start with April/May 2000;

recode prand7r 1=0 2=1;

* Create combined variable;
gen house=.;
replace house=prand7r;

* March 2000; 

recode rand7_300 1=0.5 2=1;
replace house=rand7_300 if svyid == 300;

* Second option - recode as categorical;
gen house_cat = "";
replace house_cat="Gallup" if house == 1;
replace house_cat="Group of volunteers" if house == 0;
replace house_cat="Market research firm in Ohio" if house == 0.5;
*****************************************************;
*****************************************************;
* Question order variable;
*****************************************************;
* Create combined variable;
gen orderdv = .;

* generate temporary variable for the April 2000 survey;
destring prand8, gen(prand8_t_400);
* Original coding is 1 = accuracy(pew2)-use(pew3);
* 2 = use(pew3)-accuracy(pew2);
recode prand8_t_400 1=0 2=1;
replace orderdv=prand8_t_400;

* recode temporary variable for the March 2000 survey;
recode rand8_300 1=0 2=1;
replace orderdv = rand8_300 if svyid == 300;

* recode temporary variable for the August 1997 survey;

replace orderdv = 0 if rand7_897 == 1;
replace orderdv = 1 if rand7_897 == 2;

*****************************************************;
*****************************************************;
* Now the covariates;
*****************************************************;

* Survey quality index variable;
* This generates an overall quality index from 0 to 1;
* Some surveys will have more than 4 variables to construct this measure;
* gen surqual=(prand3r+prand5r+prand6r+prand7r)/4;
* Original surqual measure for 4-metric surveys;
gen surqual=(sample_level+mode+rr+spons)/4;
* Revised surqualr measure including continous response rate;
gen surqualr=(samplnsc+moder+rrcx+spons)/4;
* Original surqual measure for 5-metric surveys;
replace surqual=(sample_level+mode+rr+spons+house)/5 if svyid !=897;
* Revised measure including continous response rate;
replace surqualr=(samplnsc+moder+rrcx+spons+house)/5 if svyid !=897;

*****************************************************;
*****************************************************;
* Now survey-specific variables;
*****************************************************;
*****************************************************;

* Should Ohio eliminate lottery;
*Original q19 coding 1 = continue lottery, 2 = eliminate lottery, 3 = expand;
gen q19r=q19;
recode q19r 1=0;
recode q19r 2=1;
recode q19r 3=0;
recode q19r 8=.r;
recode q19r 9=.u;

* Generate "consistency" variable;
*Original prand2r coding 0 = 40/60 eliminate lottery, 1 = 60/40 eliminate lottery;
*Original q19r coding 0 = continue/expand lottery, 1 = eliminate lottery;
gen consist=.;
replace consist=1 if q19r==prand2r;
replace consist=0 if q19r!=prand2r;
replace consist=. if q19r==.r;
replace consist=. if q19r==.u;
replace consist=. if q19r==.;
replace consist=. if prand2r==.;
replace consist=consist_300 if svyid==300;
replace consist=consist_897 if svyid==897;

*****************************************************;

*Generate collapsed education variable;
gen educ4r=educ4;
recode educ4r 1=2;
*Value labels for education, ordinfo, consist, and orderdv;
label define educ4r 2 "HS or Less" 3 "SomeColl" 4 "CollGrad";
label values educ4r educ4r;
label define ordinfo 0 "RM" 1 "MR";
label values ordinfo ordinfo;
label define consist 0 "I" 1 "C";
label values consist consist;
label define orderdv 0 "AU" 1 "UA";
label values orderdv orderdv;

*****************************************************;
*****************************************************;

*Create accuracy and consideration variables;
rename pew2r accuracy;
rename pew3rb consider;

*Generate objective survey quality index;
gen objsurq1=samplnsc+moder+rrcx;
gen objsurql=objsurq1/3;

*Generate subjective survey quality index;
gen subsurq1=spons+house;
gen subsurql=spons;
replace subsurql=((spons+house)/2) if svyid!=897;

*************************************;
*Final Models 6/26/24;

*Tabulate categorical variables for descriptives;
tab spons;
tab house;
tab moder;
tab orderdv;
tab ordinfo;
tab consist;
tab consider;

*Summarize continuous variables for descriptives;
summarize surqualr objsurql subsurql accuracy samplnsc rrcx;

*Accuracy models;
*************************************;
*Objective survey quality;
*************************************;
*Main effects;
reg accuracy objsurql subsurql consist ordinfo orderdv i.educ4r;
*2-way interactions;
reg accuracy orderdv subsurql c.objsurql##consist c.objsurql##ordinfo consist##ordinfo c.objsurql##i.educ4r consist##educ4r ordinfo##i.educ4r;
*3-way interactions;
reg accuracy orderdv subsurql c.objsurql##consist##ordinfo c.objsurql##consist##i.educ4r c.objsurql##ordinfo##i.educ4r c.objsurql##ordinfo##i.educ4r ordinfo##consist##educ4r;
*4-way interactions;
reg accuracy orderdv subsurql c.objsurql##i.consist##i.ordinfo##i.educ4r;

*Consideration models;
*************************************;
*Objective survey quality;
*************************************;
*Main effects;
logit consider objsurql subsurql consist ordinfo orderdv i.educ4r;
*2-way interactions;
logit consider orderdv subsurql c.objsurql##consist c.objsurql##ordinfo consist##ordinfo c.objsurql##i.educ4r consist##educ4r ordinfo##i.educ4r;
*3-way interactions;
logit consider orderdv subsurql c.objsurql##consist##ordinfo c.objsurql##consist##i.educ4r c.objsurql##ordinfo##i.educ4r c.objsurql##ordinfo##i.educ4r ordinfo##consist##educ4r;
*4-way interactions;
logit consider orderdv subsurql c.objsurql##i.consist##i.ordinfo##i.educ4r;
*************************************;

*Accuracy models;
*************************************;
*Subjective survey quality;
*************************************;
*Main effects;
reg accuracy objsurql subsurql consist ordinfo orderdv i.educ4r;
*2-way interactions;
reg accuracy orderdv objsurql c.subsurql##consist c.subsurql##ordinfo consist##ordinfo c.subsurql##i.educ4r consist##educ4r ordinfo##i.educ4r;
*3-way interactions;
reg accuracy orderdv objsurql c.subsurql##consist##ordinfo c.subsurql##consist##i.educ4r c.subsurql##ordinfo##i.educ4r c.subsurql##ordinfo##i.educ4r ordinfo##consist##educ4r;
*4-way interactions;
reg accuracy orderdv objsurql c.subsurql##i.consist##i.ordinfo##i.educ4r;

*Consideration models;
*************************************;
*Subjective survey quality;
*************************************;
*Main effects;
logit consider objsurql subsurql consist ordinfo orderdv i.educ4r;
*2-way interactions;
logit consider orderdv objsurql c.subsurql##consist c.subsurql##ordinfo consist##ordinfo c.subsurql##i.educ4r consist##educ4r ordinfo##i.educ4r;
*3-way interactions;
logit consider orderdv objsurql c.subsurql##consist##ordinfo c.subsurql##consist##i.educ4r c.subsurql##ordinfo##i.educ4r c.subsurql##ordinfo##i.educ4r ordinfo##consist##educ4r;
*4-way interactions;
logit consider orderdv objsurql c.subsurql##i.consist##i.ordinfo##i.educ4r;


*Accuracy models;
*************************************;
*Total survey quality;
*************************************;
*Main effects;
reg accuracy surqualr consist ordinfo orderdv i.educ4r;
*2-way interactions;
reg accuracy orderdv c.surqualr##consist c.surqualr##ordinfo consist##ordinfo c.surqualr##i.educ4r consist##educ4r ordinfo##i.educ4r;
*3-way interactions;
reg accuracy orderdv c.surqualr##consist##ordinfo c.surqualr##consist##i.educ4r c.surqualr##ordinfo##i.educ4r ordinfo##consist##educ4r;
*4-way interactions;
reg accuracy orderdv c.surqualr##i.consist##i.ordinfo##i.educ4r;

*Consideration models;
*************************************;
*Total survey quality;
*************************************;
*Main effects;
logit consider surqualr consist ordinfo orderdv i.educ4r;
*2-way interactions;
logit consider orderdv c.surqualr##consist c.surqualr##ordinfo consist##ordinfo c.surqualr##i.educ4r consist##educ4r ordinfo##i.educ4r;
*3-way interactions;
logit consider orderdv c.surqualr##consist##ordinfo c.surqualr##consist##i.educ4r c.surqualr##ordinfo##i.educ4r ordinfo##consist##educ4r;
*4-way interactions;
logit consider orderdv c.surqualr##i.consist##i.ordinfo##i.educ4r;
*************************************;
*************************************;
*************************************;

*Models by education;

*Accuracy models;
*************************************;
*Objective survey quality;
*************************************;
*Main effects;
bysort educ4r: reg accuracy objsurql subsurql consist ordinfo orderdv;
*2-way interactions;
bysort educ4r: reg accuracy orderdv subsurql c.objsurql##consist c.objsurql##ordinfo consist##ordinfo;
*3-way interactions;
bysort educ4r: reg accuracy orderdv subsurql c.objsurql##consist##ordinfo;

*Consideration models;
*************************************;
*Objective survey quality;
*************************************;
*Main effects;
bysort educ4r: logit consider objsurql subsurql consist ordinfo orderdv;
*2-way interactions;
bysort educ4r: logit consider orderdv subsurql c.objsurql##consist c.objsurql##ordinfo consist##ordinfo;
*3-way interactions;
bysort educ4r: logit consider orderdv subsurql c.objsurql##consist##ordinfo;
*************************************;

*Accuracy models;
*************************************;
*Subjective survey quality;
*************************************;
*Main effects;
bysort educ4r: reg accuracy objsurql subsurql consist ordinfo orderdv;
*2-way interactions;
bysort educ4r: reg accuracy orderdv objsurql c.subsurql##consist c.subsurql##ordinfo consist##ordinfo;
*3-way interactions;
bysort educ4r: reg accuracy orderdv objsurql c.subsurql##consist##ordinfo;

*Consideration models;
*************************************;
*Subjective survey quality;
*************************************;
*Main effects;
bysort educ4r: logit consider objsurql subsurql consist ordinfo orderdv i.educ4r;
*2-way interactions;
bysort educ4r: logit consider orderdv objsurql c.subsurql##consist c.subsurql##ordinfo consist##ordinfo;
*3-way interactions;
bysort educ4r: logit consider orderdv objsurql c.subsurql##consist##ordinfo;

*Accuracy models;
*************************************;
*Total survey quality;
*************************************;
*Main effects;
bysort educ4r: reg accuracy surqualr consist ordinfo orderdv;
*2-way interactions;
bysort educ4r: reg accuracy orderdv c.surqualr##consist c.surqualr##ordinfo consist##ordinfo;
*3-way interactions;
bysort educ4r: reg accuracy orderdv c.surqualr##consist##ordinfo;

*Consideration models;
*************************************;
*Total survey quality;
*************************************;
*Main effects;
bysort educ4r: logit consider surqualr consist ordinfo orderdv;
*2-way interactions;
bysort educ4r: logit consider orderdv c.surqualr##consist c.surqualr##ordinfo consist##ordinfo;
*3-way interactions;
bysort educ4r: logit consider orderdv c.surqualr##consist##ordinfo;

*Models for Table 5;
*ordinfo = 0 "RM" 1 "MR";
*educ4r 2 "HS or Less" 3 "SomeColl" 4 "CollGrad";
*Models using revised total survey quality variable;
reg accuracy surqualr orderdv if consist==1 & ordinfo==1 & educ4r==4;
reg accuracy surqualr orderdv if consist==0 & ordinfo==1 & educ4r==4;
reg accuracy surqualr orderdv if consist==1 & ordinfo==0 & educ4r==4;
reg accuracy surqualr orderdv if consist==0 & ordinfo==0 & educ4r==4;
logit consider surqualr orderdv if consist==1 & ordinfo==1 & educ4r==4;
logit consider surqualr orderdv if consist==0 & ordinfo==1 & educ4r==4;
logit consider surqualr orderdv if consist==1 & ordinfo==0 & educ4r==4;
logit consider surqualr orderdv if consist==0 & ordinfo==0 & educ4r==4;

*Using objective and subjective variables;
reg accuracy objsurql subsurql orderdv if consist==1 & ordinfo==1 & educ4r==4;
reg accuracy objsurql subsurql orderdv if consist==0 & ordinfo==1 & educ4r==4;
reg accuracy objsurql subsurql orderdv if consist==1 & ordinfo==0 & educ4r==4;
reg accuracy objsurql subsurql orderdv if consist==0 & ordinfo==0 & educ4r==4;
logit consider objsurql subsurql orderdv if consist==1 & ordinfo==1 & educ4r==4;
logit consider objsurql subsurql orderdv if consist==0 & ordinfo==1 & educ4r==4;
logit consider objsurql subsurql orderdv if consist==1 & ordinfo==0 & educ4r==4;
logit consider objsurql subsurql orderdv if consist==0 & ordinfo==0 & educ4r==4;

*Table 6b;
reg accuracy house spons samplnsc moder rrcx orderdv if consist==1 & ordinfo==1 & educ4r==4;
reg accuracy house spons samplnsc moder rrcx orderdv if consist==0 & ordinfo==1 & educ4r==4;
reg accuracy house spons samplnsc moder rrcx orderdv if consist==1 & ordinfo==0 & educ4r==4;
reg accuracy house spons samplnsc moder rrcx orderdv if consist==0 & ordinfo==0 & educ4r==4;
logit consider house spons samplnsc moder rrcx orderdv if consist==1 & ordinfo==1 & educ4r==4;
logit consider house spons samplnsc moder rrcx orderdv if consist==0 & ordinfo==1 & educ4r==4;
logit consider house spons samplnsc moder rrcx orderdv if consist==1 & ordinfo==0 & educ4r==4;
logit consider house spons samplnsc moder rrcx orderdv if consist==0 & ordinfo==0 & educ4r==4;

*Table 6c;
reg accuracy spons samplnsc moder rrcx orderdv if consist==1 & ordinfo==1 & educ4r==4;
reg accuracy spons samplnsc moder rrcx orderdv if consist==0 & ordinfo==1 & educ4r==4;
reg accuracy spons samplnsc moder rrcx orderdv if consist==1 & ordinfo==0 & educ4r==4;
reg accuracy spons samplnsc moder rrcx orderdv if consist==0 & ordinfo==0 & educ4r==4;
logit consider spons samplnsc moder rrcx orderdv if consist==1 & ordinfo==1 & educ4r==4;
logit consider spons samplnsc moder rrcx orderdv if consist==0 & ordinfo==1 & educ4r==4;
logit consider spons samplnsc moder rrcx orderdv if consist==1 & ordinfo==0 & educ4r==4;
logit consider spons samplnsc moder rrcx orderdv if consist==0 & ordinfo==0 & educ4r==4;

*Mediation Models;
gsem (accuracy <- surqualr) (consider <- accuracy, logit) if educ4r==4 & consist==0 & ordinfo==0;
sem (accuracy <- surqualr) (consider <- accuracy) if educ4r==4 & consist==0 & ordinfo==0;
estat teffects;

*Table C1;
reg accuracy house;
reg accuracy spons;
reg accuracy samplnsc;
reg accuracy moder;
reg accuracy rrcx;
reg accuracy consist;
reg accuracy ordinfo;
reg accuracy orderdv;
reg accuracy i.educ4r;
bysort svyid: reg accuracy house;
bysort svyid: reg accuracy spons;
bysort svyid: reg accuracy samplnsc;
bysort svyid: reg accuracy moder;
bysort svyid: reg accuracy rrcx;
bysort svyid: reg accuracy consist;
bysort svyid: reg accuracy ordinfo;
bysort svyid: reg accuracy orderdv;
bysort svyid: reg accuracy i.educ4r;

logit consider house;
logit consider spons;
logit consider samplnsc;
logit consider moder;
logit consider rrcx;
logit consider consist;
logit consider ordinfo;
logit consider orderdv;
logit consider i.educ4r;
bysort svyid: logit consider house;
bysort svyid: logit consider spons;
bysort svyid: logit consider samplnsc;
bysort svyid: logit consider moder;
bysort svyid: logit consider rrcx;
bysort svyid: logit consider consist;
bysort svyid: logit consider ordinfo;
bysort svyid: logit consider orderdv;
bysort svyid: logit consider i.educ4r;

*Table C2;
bysort svyid: reg accuracy house spons rrcx moder samplnsc consist ordinfo orderdv i.educ4r;
bysort svyid: reg accuracy spons rrcx moder samplnsc consist ordinfo orderdv i.educ4r;
reg accuracy house spons rrcx moder samplnsc consist ordinfo orderdv i.educ4r;
reg accuracy spons rrcx moder samplnsc consist ordinfo orderdv i.educ4r;
bysort svyid: logit consider house spons rrcx moder samplnsc consist ordinfo orderdv i.educ4r;
bysort svyid: logit consider spons rrcx moder samplnsc consist ordinfo orderdv i.educ4r;
logit consider house spons rrcx moder samplnsc consist ordinfo orderdv i.educ4r;
logit consider spons rrcx moder samplnsc consist ordinfo orderdv i.educ4r;


*Table C3a;
bysort svyid: reg accuracy objsurql subsurql consist ordinfo orderdv i.educ4r;
reg accuracy objsurql subsurql consist ordinfo orderdv i.educ4r;
bysort svyid: logit consider objsurql subsurql consist ordinfo orderdv i.educ4r;
logit consider objsurql subsurql consist ordinfo orderdv i.educ4r;

*Table C3b;
bysort svyid: reg accuracy surqualr consist ordinfo orderdv i.educ4r;
reg accuracy surqualr consist ordinfo orderdv i.educ4r;
bysort svyid: logit consider surqualr consist ordinfo orderdv i.educ4r;
logit consider surqualr consist ordinfo orderdv i.educ4r;



log close;
save "SRM_062624.dta", replace;
