************** Descriptives *********************************

*** Stats for 99 percent cut off and 18 brackets.

**income 
/*

keep gw_18_o gw_18_r stat n



rename gw_18_o inc_18_o
rename gw_18_r inc_18_r

merge 1:1 n using "$data_temp/descr_fits_2017_99_wealth", nogen keepus(gw_18_o gw_18_r)

drop if n==12 | n==13  

drop n
format *_r *_o %14.0g  

dataout, save( "$data_out/comp_table_1.tex") tex replace


*/

***** Graph 
*** relative difference brackets/cut offs along percentile
*inc
global ca "4 6 8 10 12 14 16 18 20 22 24 26"
global cut "90 91 92 93 94 95 96 97 98 99"
foreach up_cut of global cut{ 

	foreach k of global ca {  

		use  "${data_temp}\brtest_wave_all_comparison_q_final_inc.dta", clear

		sum hh_inc_w, d
		scalar x_mean=r(mean)

		_pctile hh_inc_w, percentiles(5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 99)

		forvalues i=1/20 {

		scalar x_org_`i'=r(r`i')


		}


		_pctile p_hh_inc_`up_cut'_`k'_w, percentiles(5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 99)

		forvalues i=1/20 {

		scalar x_`up_cut'_`k'_`i'=(r(r`i')-x_org_`i') / x_mean*100 


		}
	}

}


clear

set obs 20


gen n=_n

foreach up_cut of global cut{ 

	foreach k of global ca {  
		gen perc_`up_cut'_`k'=.
		local t=1
		forvalues i=1/19 {
		 	replace perc_`up_cut'_`k'=x_`up_cut'_`k'_`i' if n==`t'
		 	 local t=`t'+1
		 }

	}
}

gen perc=.
local t=1
forvalues p=5(5)95 {
	replace perc=`p' if n==`t'
	local t=`t'+1

}

tw line perc_95_6 perc || line  perc_95_10  perc || line  perc_95_14 perc || line  perc_95_18 perc  || line  perc_95_22 perc || line  perc_95_26 perc, xlabel(5(5)95)   ylabel(-20(10)70, nogrid)  xtitle("percentiles", size(small)) ytitle("(MCIB-Orig)/mean in %") subtitle("cut-off: p95")  scheme(s2mono) ///
plotregion(lcolor(black)) plotregion(fcolor(white)) graphregion(fcolor(white)) graphregion(lcolor(white)) saving(c95, replace)  /// 
legend(label(1 "brackets: 6") label(2 "brackets: 10") label(3 "brackets: 14") label(4 "brackets: 18") label(5 "brackets: 22") label(6 "brackets: 26") size(small))  


tw line perc_98_6 perc || line  perc_98_10  perc || line  perc_98_14 perc || line  perc_98_18 perc  || line  perc_98_22 perc || line  perc_98_26 perc, xlabel(5(5)95)   ylabel(-20(10)70, nogrid)    xtitle("percentiles") ytitle("(MCIB-Orig)/mean in %") subtitle("cut-off: p98")  scheme(s2mono) ///
plotregion(fcolor(white)) plotregion(lcolor(black))  graphregion(fcolor(white)) graphregion(lcolor(white)) saving(c98, replace) ///
legend(label(1 "brackets: 6") label(2 "brackets: 10") label(3 "brackets: 14") label(4 "brackets: 18") label(5 "brackets: 22") label(6 "brackets: 26")) 
*graph export "$data_graph\inc_br_var_c_98.pdf", replace 

grc1leg c95.gph c98.gph, ycommon iscale(0.7)
graph export "$data_graph\inc_br_var_c_95_98.pdf", replace



tw line perc_90_10 perc  || line  perc_92_10  perc || line  perc_94_10 perc || line perc_96_10 perc || line perc_98_10 perc, xlabel(5(5)95)  ylabel(-20(10)70, nogrid)  xtitle("percentiles") ytitle("(MCIB-Orig)/mean in %") subtitle("brackets: 10")  scheme(s2mono) ///
plotregion(fcolor(white)) plotregion(lcolor(black))  graphregion(fcolor(white)) graphregion(lcolor(white)) saving(b10, replace) legend(label(1 "cut-off: 90") label(2 "cut-off: 92") label(3 "cut-off: 94") label(4 "cut-off: 96") label(5 "cut-off: 98") size(small))  

tw line perc_90_26 perc  || line  perc_92_26 perc || line perc_94_26  perc || line perc_96_26 perc || line perc_98_26 perc, xlabel(5(5)95)  ylabel(-20(10)70, nogrid)  xtitle("percentiles") ytitle("(MCIB-Orig)/mean in %") subtitle("brackets: 26") scheme(s2mono) ///
plotregion(fcolor(white)) plotregion(lcolor(black))  graphregion(fcolor(white)) graphregion(lcolor(white)) saving(b26, replace) /// 
legend(label(1 "cut-off: 90") label(2 "cut-off: 92") label(3 "cut-off: 94") label(4 "cut-off: 96") label(5 "cut-off: 98"))

grc1leg b10.gph b26.gph, ycommon iscale(0.7)
graph export "$data_graph\inc_br_10_26_c_var.pdf", replace

*Appendix
tw line perc_99_4 perc || line  perc_99_8  perc || line  perc_99_12 perc || line  perc_99_16 perc  || line  perc_99_20 perc || line  perc_99_24 perc, xlabel(5(5)95, labsize(small))  ylabel(,nogrid labsize(small))  xtitle("percentiles", size(small)) ytitle("(MCIB-Orig)/mean in %", size(small)) subtitle("cut-off: p99", size(small))  scheme(s2mono)  ///
plotregion(fcolor(white)) plotregion(lcolor(black))  graphregion(fcolor(white)) graphregion(lcolor(white)) /// 
legend(label(1 "brackets: 4") label(2 "brackets: 8") label(3 "brackets: 12") label(4 "brackets: 16") label(5 "brackets: 20") label(6 "brackets: 24") size(small))  

graph export "$data_graph\inc_br_var_c_99.pdf", replace

tw line perc_91_4 perc  || line  perc_93_4 perc || line perc_95_4  perc || line perc_97_4 perc || line perc_98_4 perc, xlabel(5(5)95, labsize(small)) ylabel(,nogrid labsize(small))   xtitle("percentiles", size(small)) ytitle("(MCIB-Orig)/mean in %", size(small)) subtitle("brackets: 4", size(small)) scheme(s2mono) ///
plotregion(fcolor(white)) plotregion(lcolor(black))  graphregion(fcolor(white)) graphregion(lcolor(white)) /// 
 legend(label(1 "cut-off: 90") label(2 "cut-off: 92") label(3 "cut-off: 94") label(4 "cut-off: 96") label(5 "cut-off: 98") size(small))  
graph export "$data_graph\inc_br_4_c_var.pdf", replace



***Wealth 
global ca "4 6 8 10 12 14 16 18 20 22 24 26"
global cut "90 91 92 93 94 95 96 97 98 99"
foreach up_cut of global cut{ 

	foreach k of global ca {  

		use  "${data_temp}\brtest_wave_all_comparison_q_final_wealth.dta", clear

		sum gro_wealth_w, d
		scalar x_mean=r(mean)

		_pctile gro_wealth_w, percentiles(5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 99)

		forvalues i=1/20 {

		scalar x_org_`i'=r(r`i')


		}


		_pctile p_gro_wealth_`up_cut'_`k'_w, percentiles(5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 99)

		forvalues i=1/20 {

		scalar x_`up_cut'_`k'_`i'=(r(r`i')-x_org_`i') /x_mean*100  ///x_org_`i' 


		}
	}

}


clear

set obs 20


gen n=_n

foreach up_cut of global cut{ 

	foreach k of global ca {  
		gen perc_`up_cut'_`k'=.
		local t=1
		forvalues i=1/19 {
		 	replace perc_`up_cut'_`k'=x_`up_cut'_`k'_`i' if n==`t'
		 	 local t=`t'+1
		 }

	}
}

gen perc=.
local t=1
forvalues p=5(5)95 {
	replace perc=`p' if n==`t'
	local t=`t'+1

}

tw line perc_95_6 perc || line  perc_95_10  perc || line  perc_95_14 perc || line  perc_95_18 perc  || line  perc_95_22 perc || line  perc_95_26 perc, xlabel(5(5)95)  ylabel(-20(10)70, nogrid) xtitle("percentiles") ytitle("(MCIB-Orig)/mean in %") subtitle("cut-off: p95")  scheme(s2mono) ///
plotregion(fcolor(white)) plotregion(lcolor(black))  graphregion(fcolor(white)) graphregion(lcolor(white)) saving(cw95, replace)  /// 
legend(label(1 "brackets: 6") label(2 "brackets: 10") label(3 "brackets: 14") label(4 "brackets: 18") label(5 "brackets: 22") label(6 "brackets: 26") size(small))  


tw line perc_98_6 perc || line  perc_98_10  perc || line  perc_98_14 perc || line  perc_98_18 perc  || line  perc_98_22 perc || line  perc_98_26 perc, xlabel(5(5)95)  ylabel(-20(10)70, nogrid)   xtitle("percentiles") ytitle("(MCIB-Orig)/mean in %") subtitle("cut-off: p98")  scheme(s2mono) ///
plotregion(fcolor(white)) plotregion(lcolor(black))  graphregion(fcolor(white)) graphregion(lcolor(white)) saving(cw98, replace)  /// 
legend(label(1 "brackets: 6") label(2 "brackets: 10") label(3 "brackets: 14") label(4 "brackets: 18") label(5 "brackets: 22") label(6 "brackets: 26") size(small))  

grc1leg cw95.gph cw98.gph, ycommon iscale(0.7)
graph export "$data_graph\wealth_br_var_c_95_98.pdf", replace

tw line perc_90_10 perc  || line  perc_92_10  perc || line  perc_94_10 perc || line perc_96_10 perc || line perc_98_10 perc, xlabel(5(5)95)   ylabel(-20(10)70, nogrid)  xtitle("percentiles") ytitle("(MCIB-Orig)/mean in %") subtitle("brackets: 10")  scheme(s2mono) ///
plotregion(fcolor(white)) plotregion(lcolor(black))  graphregion(fcolor(white)) graphregion(lcolor(white)) saving(bw10, replace)  /// 
legend(label(1 "cut-off: 90") label(2 "cut-off: 92") label(3 "cut-off: 94") label(4 "cut-off: 96") label(5 "cut-off: 98") size(small))  


tw line perc_90_26 perc  || line  perc_92_26 perc || line perc_94_26  perc || line perc_96_26 perc || line perc_98_26 perc, xlabel(5(5)95) ylabel(-20(10)70, nogrid)   xtitle("percentiles") ytitle("(MCIB-Orig)/mean in %") subtitle("brackets: 26") scheme(s2mono) ///
plotregion(fcolor(white)) plotregion(lcolor(black))  graphregion(fcolor(white)) graphregion(lcolor(white)) saving(bw26, replace) /// 
legend(label(1 "cut-off: 90") label(2 "cut-off: 92") label(3 "cut-off: 94") label(4 "cut-off: 96") label(5 "cut-off: 98") size(small))  

grc1leg bw10.gph bw26.gph, ycommon iscale(0.7)
graph export "$data_graph\wealth_br_10_26_c_var.pdf", replace


*Appendix
tw line perc_99_4 perc || line  perc_99_8  perc || line  perc_99_12 perc || line  perc_99_16 perc  || line  perc_99_20 perc || line  perc_99_24 perc, xlabel(5(5)95, labsize(small))  ylabel(, nogrid labsize(small)) xtitle("percentiles", size(small)) ytitle("(MCIB-Orig)/mean in %", size(small)) subtitle("cut-off: p99", size(small)) scheme(s2mono) ///
plotregion(fcolor(white)) plotregion(lcolor(black))  graphregion(fcolor(white)) graphregion(lcolor(white)) /// 
 legend(label(1 "brackets: 4") label(2 "brackets: 8") label(3 "brackets: 12") label(4 "brackets: 16") label(5 "brackets: 20") label(6 "brackets: 24") size(small))  
graph export "$data_graph\wealth_br_var_c_99.pdf", replace

tw line perc_91_4 perc  || line  perc_93_4 perc || line perc_95_4  perc || line perc_97_4 perc || line perc_98_4 perc, xlabel(5(5)95, labsize(small))   xtitle("percentiles", size(small)) ylabel(, nogrid labsize(small)) ytitle("(MCIB-Orig)/mean in %", size(small)) subtitle("brackets: 4", size(small)) scheme(s2mono) ///
plotregion(fcolor(white)) plotregion(lcolor(black))  graphregion(fcolor(white)) graphregion(lcolor(white)) /// 
legend(label(1 "cut-off: 90") label(2 "cut-off: 92") label(3 "cut-off: 94") label(4 "cut-off: 96") label(5 "cut-off: 98") size(small))  
graph export "$data_graph\wealth_br_4_c_var.pdf", replace

/*

tw line perc_95_6 perc || line  perc_95_10  perc || line  perc_95_18 perc || line  perc_95_26 perc, xlabel(5(5)95)  ylabel(-10(2)10) xtitle("percentiles") ytitle("Difference (MCIB-Orig) in %") subtitle("cut-off: p95") scheme(s2mono) plotregion(fcolor(white)) graphregion(fcolor(white)) legend(label(1 "brackets: 6") label(2 "brackets: 10") label(3 "brackets: 18") label(4 "brackets: 26"))
graph export "$data_graph\wealth_br_var_c_95.pdf", replace
tw line perc_99_6 perc || line  perc_99_10  perc || line  perc_99_18 perc || line  perc_99_26 perc, xlabel(5(5)95)  xtitle("percentiles") ytitle("Difference (MCIB-Orig) in %") subtitle("cut-off: p99") scheme(s2mono) plotregion(fcolor(white)) graphregion(fcolor(white)) legend(label(1 "brackets: 6") label(2 "brackets: 10") label(3 "brackets: 18") label(4 "brackets: 26"))
graph export "$data_graph\wealth_br_var_c_99.pdf", replace

tw line perc_90_12 perc  || line  perc_93_12  perc || line  perc_96_12 perc || line perc_99_12 perc, xlabel(5(5)95)  ylabel(-10(10)60) xtitle("percentiles") ytitle("Difference (MCIB-Orig) in %") subtitle("brackets: 12") scheme(s2mono) plotregion(fcolor(white)) graphregion(fcolor(white)) legend(label(1 "cut-off: 90") label(2 "cut-off: 93") label(3 "cut-off: 96") label(4 "cut-off: 99"))
graph export "$data_graph\wealth_br_12_c_var.pdf", replace
tw line perc_90_26 perc  || line  perc_93_26 perc || line perc_96_26  perc || line perc_99_26 perc, xlabel(5(5)95) ylabel(-10(10)60)  xtitle("percentiles") ytitle("Difference (MCIB-Orig) in %") subtitle("brackets: 26") scheme(s2mono) plotregion(fcolor(white)) graphregion(fcolor(white)) legend(label(1 "cut-off: 90") label(2 "cut-off: 93") label(3 "cut-off: 96") label(4 "cut-off: 99"))
graph export "$data_graph\wealth_br_26_c_var.pdf", replace


tw line perc_93_26 perc  || line  perc_91_26 perc || line perc_92_26  perc || line perc_93_26 perc, xlabel(5(5)95) ylabel(-10(10)60)  xtitle("percentiles") ytitle("Difference (MCIB-Orig) in %") subtitle("brackets: 26") scheme(s2mono) plotregion(fcolor(white)) graphregion(fcolor(white)) legend(label(1 "cut-off: 90") label(2 "cut-off: 93") label(3 "cut-off: 96") label(4 "cut-off: 99"))
graph export "$data_graph\wealth_br_26_c_var.pdf", replace
*/
