*** Extra analysis

global ca "4 10"
global cut "98"


local sampleslit=5

foreach t of global cut{ 
	foreach k of global ca {  

		use "C:\Users/$cdpath\Seafile\Meine Bibliothek\InterVerm\wealth_1988\cd_path\brtest_w2017_gro_wealth_`t'_`k'_q_reduced_`sampleslit'.dta", clear

		forvalues d=10000(1)14999 {
		drop p`d'

		}

		keep p* ID

		reshape long p, i(ID)


		save  "${data_temp}\brtest_mcib_`t'_`k'_reshape_1_q_reduced_`sampleslit'.dta", replace 


		// reshape command does not work for >12000 vars - split sample
		use "C:\Users/$cdpath\Seafile\Meine Bibliothek\InterVerm\wealth_1988\cd_path\brtest_w2017_gro_wealth_`t'_`k'_q_reduced_`sampleslit'.dta", clear

		forvalues d=1(1)9999 {
		drop p`d'

		}


		keep p* ID

		reshape long p, i(ID)

		save  "${data_temp}\brtest_mcib_`t'_`k'_reshape_2_q_reduced_`sampleslit'.dta", replace 



		clear
		append using "${data_temp}\brtest_mcib_`t'_`k'_reshape_1_q_reduced_`sampleslit'.dta"
		append using "${data_temp}\brtest_mcib_`t'_`k'_reshape_2_q_reduced_`sampleslit'.dta"


		save  "${data_temp}\brtest_mcib_`t'_`k'_reshape_q_reduced_`sampleslit'.dta", replace 

	}
}



**** adjust reshaped data
local setseed=220619
foreach t of global cut{ 
		
	foreach k of global ca {  
		
		use  "${data_temp}\brtest_mcib_`t'_`k'_reshape_q_reduced_`sampleslit'.dta", clear

		rename p p_gro_wealth_`t'_`k'



		forvalues b=3(2)25 {
				local p=`b'+1
				gen gro_wealth_cat_`t'_`p'=.
				replace gro_wealth_cat_`t'_`p' = `p' if p_gro_wealth_`t'_`k' >= z1_`b'_gw_`t'_`p' & p_gro_wealth_`t'_`k' != .
				forvalues i=1/`b' {
					local a=`i'-1
					if `i'==1 				replace gro_wealth_cat_`t'_`p' = `i' if inrange(p_gro_wealth_`t'_`k', 0, z2_`i'_gw_`t'_`p')
					if `i'>=2 			 	replace gro_wealth_cat_`t'_`p' = `i' if inrange(p_gro_wealth_`t'_`k', z1_`a'_gw_`t'_`p', z2_`i'_gw_`t'_`p' )				
				}
		}


		forvalues v=1/`k' {

			preserve
				keep if gro_wealth_cat_`t'_`k'==`v' 

				set seed `setseed'
				gen ra=runiform()

				sort ra
				gen m_x=_n
			

				drop ra _j
				save "$data_temp\brtest_rand_m_`t'_`k'_`v'_q_reduced", replace

			restore
		}


		clear 
		forvalues v=1/`k' {

			append using "$data_temp\brtest_rand_m_`t'_`k'_`v'_q_reduced"

			
		}

			
		save "$data_temp\brtest_rand_m_`t'_`k'_q_reduced", replace
		local setseed=`setseed+1'
	}
	 
}
*

	*********

use "${data_temp}\hh_wealth_reduced_`sampleslit'.dta", clear 
foreach t of global cut{ 

local setseed=220619
foreach k of global ca {  
		local setseed=`setseed'

			bysort gro_wealth_cat_`t'_`k': gen m_x=_n

			merge 1:1 gro_wealth_cat_`t'_`k' m_x using  "$data_temp\brtest_rand_m_`t'_`k'_q_reduced", keep(3) nogen

			drop m_x
			

		}
		local setseed=`setseed'+1
}

	*windzoriz
		
	winsor2 gro_wealth, cuts(0.5 99.5) by(syear)

foreach t of global cut{ 

	foreach k of global ca {  	
		winsor2 p_gro_wealth_`t'_`k', cuts(0.5 99.5)  by(syear)
		/* by hand
		sort `k' 
		sum `k' 
		gen F_`k'=_n/r(N)*100 if `k'!=.
		sort p_`k' 
		sum p_`k' 
		gen F_p_`k'=_n/r(N)*100 if p_`k'!=. */
		

	}

}
*keep cid syear hid prime_prop* fin_assets* tan_assets* all_debt* gro_wealth* busin_assets* p_*

save  "${data_temp}\brtest_wave_all_comparison_q_final_wealth_reduced_`sampleslit'.dta", replace 


************income



foreach t of global cut{ 
	foreach k of global ca {  

		use "C:\Users/$cdpath\Seafile\Meine Bibliothek\InterVerm\wealth_1988\cd_path\brtest_w2017_hh_inc_`t'_`k'_q_reduced_`sampleslit'.dta", clear

		forvalues d=7500(1)19999 {
		drop p`d'

		}

		keep p* ID

		reshape long p, i(ID)


		save  "${data_temp}\brtest_mcib_`t'_`k'_reshape_1_q_hh_inc_reduced_`sampleslit'.dta", replace 


		// reshape command does not work for >12000 vars - split sample
		use "C:\Users/$cdpath\Seafile\Meine Bibliothek\InterVerm\wealth_1988\cd_path\brtest_w2017_hh_inc_`t'_`k'_q_reduced_`sampleslit'.dta", clear

		forvalues d=1(1)7499 {
		drop p`d'

		}

		forvalues d=15000(1)19999 {
		drop p`d'

		}


		keep p* ID

		reshape long p, i(ID)

		save  "${data_temp}\brtest_mcib_`t'_`k'_reshape_2_q_hh_inc_reduced_`sampleslit'.dta", replace 


		use "C:\Users/$cdpath\Seafile\Meine Bibliothek\InterVerm\wealth_1988\cd_path\brtest_w2017_hh_inc_`t'_`k'_q_reduced_`sampleslit'.dta", clear

		forvalues d=1(1)14999 {
		drop p`d'

		}


		keep p* ID

		reshape long p, i(ID)

		save  "${data_temp}\brtest_mcib_`t'_`k'_reshape_3_q_hh_inc_reduced_`sampleslit'.dta", replace 


		clear
		append using "${data_temp}\brtest_mcib_`t'_`k'_reshape_1_q_hh_inc_reduced_`sampleslit'.dta"
		append using "${data_temp}\brtest_mcib_`t'_`k'_reshape_2_q_hh_inc_reduced_`sampleslit'.dta"
		append using "${data_temp}\brtest_mcib_`t'_`k'_reshape_3_q_hh_inc_reduced_`sampleslit'.dta"

		save  "${data_temp}\brtest_mcib_`t'_`k'_reshape_q_hh_inc_reduced_`sampleslit'.dta", replace 

	}
}



**** adjust reshaped data

local setseed=220619
foreach t of global cut{ 
		
	foreach k of global ca {  
		
		use  "${data_temp}\brtest_mcib_`t'_`k'_reshape_q_hh_inc_reduced_`sampleslit'.dta", clear

		rename p p_hh_inc_`t'_`k'



		forvalues b=3(2)25 {
				local p=`b'+1
				gen hh_inc_cat_`t'_`p'=.
				replace hh_inc_cat_`t'_`p' = `p' if p_hh_inc_`t'_`k' >= z1_`b'_inc_`t'_`p' & p_hh_inc_`t'_`k' != .
				forvalues i=1/`b' {
					local a=`i'-1
					if `i'==1 				replace hh_inc_cat_`t'_`p' = `i' if inrange(p_hh_inc_`t'_`k', 0, z2_`i'_inc_`t'_`p')
					if `i'>=2 			 	replace hh_inc_cat_`t'_`p' = `i' if inrange(p_hh_inc_`t'_`k', z1_`a'_inc_`t'_`p', z2_`i'_inc_`t'_`p' )				
				}
		}


		forvalues v=1/`k' {

			preserve
				keep if hh_inc_cat_`t'_`k'==`v' 

				set seed `setseed'
				gen ra=runiform()

				sort ra
				gen m_x=_n
			

				drop ra _j
				save "$data_temp\brtest_rand_m_`t'_`k'_`v'_q_hh_inc_reduced", replace

			restore
		}


		clear 
		forvalues v=1/`k' {

			append using "$data_temp\brtest_rand_m_`t'_`k'_`v'_q_hh_inc_reduced"

			
		}

			
		save "$data_temp\brtest_rand_m_`t'_`k'_q_hh_inc_reduced", replace
		local setseed=`setseed'+1
	}
	 
}
*



use  "${data_temp}\hh_data_inc_reduced_`sampleslit'.dta", clear
local setseed=220619
foreach t of global cut{ 


	foreach k of global ca {  

			set seed `setseed'
			gen ra=runiform()

			sort ra

			bysort hh_inc_cat_`t'_`k': gen m_x=_n

			merge 1:1 hh_inc_cat_`t'_`k' m_x using  "$data_temp\brtest_rand_m_`t'_`k'_q_hh_inc_reduced", keep(1 3) nogen

			drop m_x ra
			

	}
	local setseed=`setseed'+1
}

	*windzoriz
		
	winsor2 hh_inc, cuts(0.5 99.5) by(syear)

foreach t of global cut{ 

	foreach k of global ca {  	
		winsor2 p_hh_inc_`t'_`k', cuts(0.5 99.5)  by(syear)
		/* by hand
		sort `k' 
		sum `k' 
		gen F_`k'=_n/r(N)*100 if `k'!=.
		sort p_`k' 
		sum p_`k' 
		gen F_p_`k'=_n/r(N)*100 if p_`k'!=. */
		

	}

}
*keep cid syear hid prime_prop* fin_assets* tan_assets* all_debt* hh_inc* busin_assets* p_*


save  "${data_temp}\brtest_wave_all_comparison_q_final_hh_inc_reduced_`sampleslit'.dta", replace 

******first descriptives
global B=500
local bs_orig=1
foreach up_cut of global cut { 

	foreach k of global ca {

		use  "${data_temp}\brtest_wave_all_comparison_q_final_wealth_reduced_`sampleslit'.dta", clear
		gen n=_n
		// quick fix  add capture
		*replace p_build_loan_w=p_busin_assets_w if syear==2002
		*replace build_loan_w=busin_assets_w if syear==2002
		******
		local t=2017
		sum gro_wealth_w, d 

		scalar mean_`k'_`t'o=r(mean)
		scalar med_`k'_`t'o=r(p50)
		scalar sd_`k'_`t'o=r(sd)
		scalar p1_`k'_`t'o=r(p1)
		scalar p5_`k'_`t'o=r(p5)
		scalar p10_`k'_`t'o=r(p10)
		scalar p25_`k'_`t'o=r(p25)
		scalar p75_`k'_`t'o=r(p75)
		scalar p90_`k'_`t'o=r(p90)
		scalar p95_`k'_`t'o=r(p95)
		scalar p99_`k'_`t'o=r(p99)
		scalar N_`k'_`t'o=r(N)
		scalar min_`k'_`t'o =r(min)
		scalar max_`k'_`t'o =r(max)

		inequal7 gro_wealth_w, returnscalars
		scalar mld_`k'_`t'o=r(mld) 
		scalar Theil_`k'_`t'o=r(theil) 
		scalar Gini_`k'_`t'o=r(gini) 
		scalar COV_`k'_`t'o=r(cov) 
		scalar rmd_`k'_`t'o=r(rmd) 


		sum p_gro_wealth_`up_cut'_`k'_w, d 

		scalar mean_`k'_`t'r=r(mean)
		scalar med_`k'_`t'r=r(p50)
		scalar sd_`k'_`t'r=r(sd)
		scalar p1_`k'_`t'r=r(p1)
		scalar p5_`k'_`t'r=r(p5)
		scalar p10_`k'_`t'r=r(p10)
		scalar p25_`k'_`t'r=r(p25)
		scalar p75_`k'_`t'r=r(p75)
		scalar p90_`k'_`t'r=r(p90)
		scalar p95_`k'_`t'r=r(p95)
		scalar p99_`k'_`t'r=r(p99)
		scalar N_`k'_`t'r=r(N)
		scalar min_`k'_`t'r =r(min)
		scalar max_`k'_`t'r =r(max)

		inequal7 p_gro_wealth_`up_cut'_`k'_w, returnscalars
		scalar mld_`k'_`t'r=r(mld) 
		scalar Theil_`k'_`t'r=r(theil) 
		scalar Gini_`k'_`t'r=r(gini) 
		scalar COV_`k'_`t'r=r(cov) 
		scalar rmd_`k'_`t'r=r(rmd) 


		correlate p_gro_wealth_`up_cut'_`k'_w gro_wealth_w 
		scalar corr_`k'_`t'r=r(rho)

		**difference
		scalar d_mean_`k'_`t'=(mean_`k'_`t'r-mean_`k'_`t'o)/mean_`k'_`t'o
		scalar d_sd_`k'_`t'=(sd_`k'_`t'r-sd_`k'_`t'o)/sd_`k'_`t'o
		scalar d_med_`k'_`t'=(med_`k'_`t'r-med_`k'_`t'o)/med_`k'_`t'o
		scalar d_p1_`k'_`t'=(p1_`k'_`t'r-p1_`k'_`t'o)/mean_`k'_`t'o
		scalar d_p5_`k'_`t'=(p5_`k'_`t'r-p5_`k'_`t'o)/mean_`k'_`t'o
		scalar d_p10_`k'_`t'=(p10_`k'_`t'r-p10_`k'_`t'o)/mean_`k'_`t'o
		scalar d_p25_`k'_`t'=(p25_`k'_`t'r-p25_`k'_`t'o)/mean_`k'_`t'o
		scalar d_p75_`k'_`t'=(p75_`k'_`t'r-p75_`k'_`t'o)/mean_`k'_`t'o
		scalar d_p90_`k'_`t'=(p90_`k'_`t'r-p90_`k'_`t'o)/mean_`k'_`t'o
		scalar d_p95_`k'_`t'=(p95_`k'_`t'r-p95_`k'_`t'o)/mean_`k'_`t'o
		scalar d_p99_`k'_`t'=(p99_`k'_`t'r-p99_`k'_`t'o)/mean_`k'_`t'o
		scalar d_N_`k'_`t'=(N_`k'_`t'r-N_`k'_`t'o)/N_`k'_`t'o
		scalar d_min_`k'_`t'=(min_`k'_`t'r-min_`k'_`t'o)/min_`k'_`t'o
		scalar d_max_`k'_`t'=(max_`k'_`t'r-max_`k'_`t'o)/max_`k'_`t'o
		scalar d_mld_`k'_`t'=(mld_`k'_`t'r-mld_`k'_`t'o)/mld_`k'_`t'o
		scalar d_Theil_`k'_`t'=(Theil_`k'_`t'r-Theil_`k'_`t'o)/Theil_`k'_`t'o
		scalar d_Gini_`k'_`t'=(Gini_`k'_`t'r-Gini_`k'_`t'o)/Gini_`k'_`t'o
		scalar d_COV_`k'_`t'=(COV_`k'_`t'r-COV_`k'_`t'o)/COV_`k'_`t'o
		scalar d_rmd_`k'_`t'=(rmd_`k'_`t'r-rmd_`k'_`t'o)/rmd_`k'_`t'o
		*scalar d_corr_`k'_`t'=(corr_`k'_`t'r-corr_`k'_`t'o)/corr_`k'_`t'o	

		***bootstrap
		gen bs_th_`k'_`t'_r=.
		gen bs_m_`k'_`t'_r=.
		gen bs_sd_`k'_`t'_r=.
		gen bs_mld_`k'_`t'_r=.
		gen bs_Gini_`k'_`t'_r=.
		gen bs_COV_`k'_`t'_r=.
		gen bs_rmd_`k'_`t'_r=.
		gen bs_corr_`k'_`t'_r=.

		forvalues b=1(1)$B {
			qui gen w`b'=.
			qui replace w`b'=runiform()
			qui sum w`b' 
			sum p_gro_wealth_`up_cut'_`k'_w [w=w`b'], d 
			replace bs_m_`k'_`t'_r=r(mean) if n==`b'
			replace bs_sd_`k'_`t'_r=r(sd) if n==`b'
			inequal7  p_gro_wealth_`up_cut'_`k'_w [w=w`b'],  returnscalars 
			replace bs_th_`k'_`t'_r=r(theil) if n==`b'
			replace bs_mld_`k'_`t'_r=r(mld) if n==`b'
			replace bs_Gini_`k'_`t'_r=r(gini) if n==`b'
			replace bs_COV_`k'_`t'_r=r(cov) if n==`b'
			replace bs_rmd_`k'_`t'_r=r(rmd) if n==`b'
			correlate p_gro_wealth_`up_cut'_`k'_w gro_wealth_w [w=w`b']
			replace  bs_corr_`k'_`t'_r=r(rho) if n==`b'
			di "`b'"
			drop w`b'
		}

		sum bs_th_`k'_`t'_r
		scalar bs_th_`k'_`t'_r=r(sd)
		sum bs_m_`k'_`t'_r
		scalar bs_m_`k'_`t'_r=r(sd)
		sum bs_sd_`k'_`t'_r
		scalar bs_sd_`k'_`t'_r=r(sd)
		sum bs_mld_`k'_`t'_r
		scalar bs_mld_`k'_`t'_r=r(sd)
		sum bs_Gini_`k'_`t'_r
		scalar bs_Gini_`k'_`t'_r=r(sd)
		sum bs_COV_`k'_`t'_r
		scalar bs_COV_`k'_`t'_r=r(sd)
		sum bs_rmd_`k'_`t'_r
		scalar bs_rmd_`k'_`t'_r=r(sd)
		sum bs_corr_`k'_`t'_r
		scalar bs_corr_`k'_`t'_r=r(sd)


		gen bs_th_`k'_`t'_o=.
		gen bs_m_`k'_`t'_o=.
		gen bs_sd_`k'_`t'_o=.
		gen bs_mld_`k'_`t'_o=.
		gen bs_Gini_`k'_`t'_o=.
		gen bs_COV_`k'_`t'_o=.
		gen bs_rmd_`k'_`t'_o=.
		if "`bs_orig'"=="1" {
			forvalues b=1(1)$B {
				qui gen w`b'=.
				qui replace w`b'=runiform()
				qui sum w`b' 
				sum gro_wealth_w [w=w`b'], d 
				replace bs_m_`k'_`t'_o=r(mean) if n==`b'
				replace bs_sd_`k'_`t'_o=r(sd) if n==`b'
				inequal7 gro_wealth_w [w=w`b'],  returnscalars 
				replace bs_th_`k'_`t'_o=r(theil) if n==`b'
				replace bs_mld_`k'_`t'_o=r(mld) if n==`b'
				replace bs_Gini_`k'_`t'_o=r(gini) if n==`b'
				replace bs_COV_`k'_`t'_o=r(cov) if n==`b'
				replace bs_rmd_`k'_`t'_o=r(rmd) if n==`b'	
				di "`b'"
				drop w`b'
			
			}
			preserve
				keep n *_4_2017_o
				save "${data_temp}\bs_wealth_o_reduced.dta", replace
			restore
		}
		if "`bs_orig'">"1" {
			merge 1:1 n using "${data_temp}\bs_wealth_o_reduced.dta", nogen
			replace bs_m_`k'_`t'_o=bs_m_4_`t'_o
			replace bs_sd_`k'_`t'_o=bs_sd_4_`t'_o
			replace bs_th_`k'_`t'_o=bs_th_4_`t'_o
			replace bs_mld_`k'_`t'_o=bs_mld_4_`t'_o
			replace bs_Gini_`k'_`t'_o=bs_Gini_4_`t'_o
			replace bs_COV_`k'_`t'_o=bs_COV_4_`t'_o
			replace bs_rmd_`k'_`t'_o=bs_rmd_4_`t'_o	
			
 		} 


		sum bs_th_`k'_`t'_o
		scalar bs_th_`k'_`t'_o=r(sd)
		sum bs_m_`k'_`t'_o
		scalar bs_m_`k'_`t'_o=r(sd)
		sum bs_sd_`k'_`t'_o
		scalar bs_sd_`k'_`t'_o=r(sd)
		sum bs_mld_`k'_`t'_o
		scalar bs_mld_`k'_`t'_o=r(sd)
		sum bs_Gini_`k'_`t'_o
		scalar bs_Gini_`k'_`t'_o=r(sd)
		sum bs_COV_`k'_`t'_o
		scalar bs_COV_`k'_`t'_o=r(sd)
		sum bs_rmd_`k'_`t'_o
		scalar bs_rmd_`k'_`t'_o=r(sd) 

		*** difference
		gen bs_d_th_`k'_`t'=(bs_th_`k'_`t'_r-bs_th_`k'_`t'_o)/bs_th_`k'_`t'_o
		gen bs_d_m_`k'_`t'=(bs_m_`k'_`t'_r-bs_m_`k'_`t'_o)/bs_m_`k'_`t'_o
		gen bs_d_sd_`k'_`t'=(bs_sd_`k'_`t'_r-bs_sd_`k'_`t'_o)/bs_sd_`k'_`t'_o
		gen bs_d_mld_`k'_`t'=(bs_mld_`k'_`t'_r-bs_mld_`k'_`t'_o)/bs_mld_`k'_`t'_o
		gen bs_d_Gini_`k'_`t'=(bs_Gini_`k'_`t'_r-bs_Gini_`k'_`t'_o)/bs_Gini_`k'_`t'_o
		gen bs_d_COV_`k'_`t'=(bs_COV_`k'_`t'_r-bs_COV_`k'_`t'_o)/bs_COV_`k'_`t'_o
		gen bs_d_rmd_`k'_`t'=(bs_rmd_`k'_`t'_r-bs_rmd_`k'_`t'_o)/bs_rmd_`k'_`t'_o
		*gen bs_d_corr_`k'_`t'_r=(bs_corr_`k'_`t'_r-bs_corr_`k'_`t'_o)/bs_corr_`k'_`t'_o
		sum bs_d_th_`k'_`t'
		scalar bs_d_th_`k'_`t'=r(sd)
		sum bs_d_m_`k'_`t'
		scalar bs_d_m_`k'_`t'=r(sd)
		sum bs_d_sd_`k'_`t'
		scalar bs_d_sd_`k'_`t'=r(sd)
		sum bs_d_mld_`k'_`t'   
		scalar bs_d_mld_`k'_`t'=r(sd)
		sum bs_d_Gini_`k'_`t'
		scalar bs_d_Gini_`k'_`t'=r(sd)
		sum bs_d_COV_`k'_`t'
		scalar bs_d_COV_`k'_`t'=r(sd)
		sum bs_d_rmd_`k'_`t'
		scalar bs_d_rmd_`k'_`t'=r(sd)
		*sum bs_d_corr_`k'_`t'
		*scalar bs_d_corr_`k'_`t'=r(sd)

		local bs_orig=`bs_orig'+1 //do not bs orig var again
		di `bs_orig'


	}

	clear

	set obs 29
	local t=2017
	gen year=`t'
	gen n=_n-1

	gen stat=""
	replace stat= "mean" if n==0
	replace stat= "median" if n==4
	replace stat= "sd" if n==2
	replace stat= "p1" if n==5	
	replace stat= "p5" if n==6
	replace stat= "p10" if n==7
	replace stat= "p25" if n==8
	replace stat= "p75" if n==9
	replace stat= "p90" if n==10
	replace stat= "p95" if n==11
	replace stat= "p99" if n==12
	replace stat="N" if n==13
	replace stat="min" if n==14
	replace stat="max" if n==15
	replace stat="Inequality Measures" if n==16
	replace stat= "Mean Log Dev" if n==17
	replace stat="Theil" if n==19
	replace stat="Gini" if n==21
	replace stat="COV" if n==23
	replace stat="Rel. Mean Dev" if n==25
	replace stat="Correlaton" if n==27

	local f "o r"

	foreach k of global ca {  
		foreach l of local f  {
			gen gw_`k'_`l'=.
			replace gw_`k'_`l'= mean_`k'_`t'`l' if n==0
			replace gw_`k'_`l'= bs_m_`k'_`t'_`l' if n==1
			replace gw_`k'_`l'= med_`k'_`t'`l' if n==4
			replace gw_`k'_`l'= sd_`k'_`t'`l' if n==2
			replace gw_`k'_`l'= bs_sd_`k'_`t'_`l' if n==3
			replace gw_`k'_`l'= p1_`k'_`t'`l' if n==5
			replace gw_`k'_`l'= p5_`k'_`t'`l' if n==6
			replace gw_`k'_`l'= p10_`k'_`t'`l' if n==7
			replace gw_`k'_`l'= p25_`k'_`t'`l' if n==8
			replace gw_`k'_`l'= p75_`k'_`t'`l' if n==9
			replace gw_`k'_`l'= p90_`k'_`t'`l' if n==10
			replace gw_`k'_`l'= p95_`k'_`t'`l' if n==11
			replace gw_`k'_`l'= p99_`k'_`t'`l' if n==12
			replace gw_`k'_`l'= N_`k'_`t'`l' if n==13
			replace gw_`k'_`l'= min_`k'_`t'`l' if n==14
		    replace gw_`k'_`l'= max_`k'_`t'`l' if n==15
		    replace gw_`k'_`l'= mld_`k'_`t'`l' if n==17
		    replace gw_`k'_`l'= bs_mld_`k'_`t'_`l' if n==18
		    replace gw_`k'_`l'= Theil_`k'_`t'`l' if n==19
		    replace gw_`k'_`l'= bs_th_`k'_`t'_`l' if n==20
		    replace gw_`k'_`l'= Gini_`k'_`t'`l' if n==21
		    replace gw_`k'_`l'= bs_Gini_`k'_`t'_`l' if n==22
		    replace gw_`k'_`l'= COV_`k'_`t'`l' if n==23
		    replace gw_`k'_`l'= bs_COV_`k'_`t'_`l' if n==24
		    replace gw_`k'_`l'= rmd_`k'_`t'`l' if n==25
		    replace gw_`k'_`l'= bs_rmd_`k'_`t'_`l' if n==26
		    if "`l'"=="r" replace gw_`k'_`l'= corr_`k'_`t'`l' if n==27
			if "`l'"=="r"  replace gw_`k'_`l'= bs_corr_`k'_`t'_`l' if n==28
			if "`l'"=="r" {
				gen di_`k'=.
				replace di_`k'= d_mean_`k'_`t' if n==0
				replace di_`k'= bs_d_m_`k'_`t' if n==1
				replace di_`k'= d_med_`k'_`t' if n==4
				replace di_`k'= d_sd_`k'_`t' if n==2
				replace di_`k'= bs_d_sd_`k'_`t' if n==3
				replace di_`k'= d_p1_`k'_`t' if n==5
				replace di_`k'= d_p5_`k'_`t' if n==6
				replace di_`k'= d_p10_`k'_`t' if n==7
				replace di_`k'= d_p25_`k'_`t' if n==8
				replace di_`k'= d_p75_`k'_`t' if n==9
				replace di_`k'= d_p90_`k'_`t' if n==10
				replace di_`k'= d_p95_`k'_`t' if n==11
				replace di_`k'= d_p99_`k'_`t' if n==12
				replace di_`k'= d_N_`k'_`t' if n==13
				replace di_`k'= d_min_`k'_`t' if n==14
			    replace di_`k'= d_max_`k'_`t' if n==15
			    replace di_`k'= d_mld_`k'_`t' if n==17
			    replace di_`k'= bs_d_mld_`k'_`t' if n==18
			    replace di_`k'= d_Theil_`k'_`t' if n==19
			    replace di_`k'= bs_d_th_`k'_`t' if n==20
			    replace di_`k'= d_Gini_`k'_`t' if n==21
			    replace di_`k'= bs_d_Gini_`k'_`t' if n==22
			    replace di_`k'= d_COV_`k'_`t' if n==23
			    replace di_`k'= bs_d_COV_`k'_`t' if n==24
			    replace di_`k'= d_rmd_`k'_`t' if n==25
			    replace di_`k'= bs_d_rmd_`k'_`t' if n==26
				*  if ""=="r" replace di_`k'= d_corr_`k'_`t' if n==27
				*if ""=="r"  replace di_`k'= bs_d_corr_`k'_`t' if n==28
		
			}
		}


		foreach k of local i {
			foreach l of local f  {
				replace gw_`k'_`l'=round(gw_`k'_`l',1)
				replace di_`k'=di_`k'*100
				replace di_`k'=round(di_`k',1)

			}
		}

	}
	format *_r  %12.0g  
	save  "$data_temp/descr_fits_2017_`up_cut'_wealth_reduced_`sampleslit'", replace
	export excel using "${data_out}\bracket_test_stats_`up_cut'_wealth_reduced_`sampleslit'.xlsx", replace firstrow(variables)

}


global B=500
local bs_orig=1
foreach up_cut of global cut { 

	foreach k of global ca {

		use  "${data_temp}\brtest_wave_all_comparison_q_final_hh_inc_reduced_`sampleslit'.dta", clear
		gen n=_n
		// quick fix  add capture
		*replace p_build_loan_w=p_busin_assets_w if syear==2002
		*replace build_loan_w=busin_assets_w if syear==2002
		******
		local t=2017
		sum hh_inc_w, d 

		scalar mean_`k'_`t'o=r(mean)
		scalar med_`k'_`t'o=r(p50)
		scalar sd_`k'_`t'o=r(sd)
		scalar p1_`k'_`t'o=r(p1)
		scalar p5_`k'_`t'o=r(p5)
		scalar p10_`k'_`t'o=r(p10)
		scalar p25_`k'_`t'o=r(p25)
		scalar p75_`k'_`t'o=r(p75)
		scalar p90_`k'_`t'o=r(p90)
		scalar p95_`k'_`t'o=r(p95)
		scalar p99_`k'_`t'o=r(p99)
		scalar N_`k'_`t'o=r(N)
		scalar min_`k'_`t'o =r(min)
		scalar max_`k'_`t'o =r(max)

		inequal7 hh_inc_w, returnscalars
		scalar mld_`k'_`t'o=r(mld) 
		scalar Theil_`k'_`t'o=r(theil) 
		scalar Gini_`k'_`t'o=r(gini) 
		scalar COV_`k'_`t'o=r(cov) 
		scalar rmd_`k'_`t'o=r(rmd) 


		sum p_hh_inc_`up_cut'_`k'_w, d 

		scalar mean_`k'_`t'r=r(mean)
		scalar med_`k'_`t'r=r(p50)
		scalar sd_`k'_`t'r=r(sd)
		scalar p1_`k'_`t'r=r(p1)
		scalar p5_`k'_`t'r=r(p5)
		scalar p10_`k'_`t'r=r(p10)
		scalar p25_`k'_`t'r=r(p25)
		scalar p75_`k'_`t'r=r(p75)
		scalar p90_`k'_`t'r=r(p90)
		scalar p95_`k'_`t'r=r(p95)
		scalar p99_`k'_`t'r=r(p99)
		scalar N_`k'_`t'r=r(N)
		scalar min_`k'_`t'r =r(min)
		scalar max_`k'_`t'r =r(max)

		inequal7 p_hh_inc_`up_cut'_`k'_w, returnscalars
		scalar mld_`k'_`t'r=r(mld) 
		scalar Theil_`k'_`t'r=r(theil) 
		scalar Gini_`k'_`t'r=r(gini) 
		scalar COV_`k'_`t'r=r(cov) 
		scalar rmd_`k'_`t'r=r(rmd) 


		correlate p_hh_inc_`up_cut'_`k'_w hh_inc_w 
		scalar corr_`k'_`t'r=r(rho)

		**difference
		scalar d_mean_`k'_`t'=(mean_`k'_`t'r-mean_`k'_`t'o)/mean_`k'_`t'o
		scalar d_sd_`k'_`t'=(sd_`k'_`t'r-sd_`k'_`t'o)/sd_`k'_`t'o
		scalar d_med_`k'_`t'=(med_`k'_`t'r-med_`k'_`t'o)/med_`k'_`t'o
		scalar d_p1_`k'_`t'=(p1_`k'_`t'r-p1_`k'_`t'o)/mean_`k'_`t'o
		scalar d_p5_`k'_`t'=(p5_`k'_`t'r-p5_`k'_`t'o)/mean_`k'_`t'o
		scalar d_p10_`k'_`t'=(p10_`k'_`t'r-p10_`k'_`t'o)/mean_`k'_`t'o
		scalar d_p25_`k'_`t'=(p25_`k'_`t'r-p25_`k'_`t'o)/mean_`k'_`t'o
		scalar d_p75_`k'_`t'=(p75_`k'_`t'r-p75_`k'_`t'o)/mean_`k'_`t'o
		scalar d_p90_`k'_`t'=(p90_`k'_`t'r-p90_`k'_`t'o)/mean_`k'_`t'o
		scalar d_p95_`k'_`t'=(p95_`k'_`t'r-p95_`k'_`t'o)/mean_`k'_`t'o
		scalar d_p99_`k'_`t'=(p99_`k'_`t'r-p99_`k'_`t'o)/mean_`k'_`t'o
		scalar d_N_`k'_`t'=(N_`k'_`t'r-N_`k'_`t'o)/N_`k'_`t'o
		scalar d_min_`k'_`t'=(min_`k'_`t'r-min_`k'_`t'o)/min_`k'_`t'o
		scalar d_max_`k'_`t'=(max_`k'_`t'r-max_`k'_`t'o)/max_`k'_`t'o
		scalar d_mld_`k'_`t'=(mld_`k'_`t'r-mld_`k'_`t'o)/mld_`k'_`t'o
		scalar d_Theil_`k'_`t'=(Theil_`k'_`t'r-Theil_`k'_`t'o)/Theil_`k'_`t'o
		scalar d_Gini_`k'_`t'=(Gini_`k'_`t'r-Gini_`k'_`t'o)/Gini_`k'_`t'o
		scalar d_COV_`k'_`t'=(COV_`k'_`t'r-COV_`k'_`t'o)/COV_`k'_`t'o
		scalar d_rmd_`k'_`t'=(rmd_`k'_`t'r-rmd_`k'_`t'o)/rmd_`k'_`t'o
		*scalar d_corr_`k'_`t'=(corr_`k'_`t'r-corr_`k'_`t'o)/corr_`k'_`t'o	

		***bootstrap
		gen bs_th_`k'_`t'_r=.
		gen bs_m_`k'_`t'_r=.
		gen bs_sd_`k'_`t'_r=.
		gen bs_mld_`k'_`t'_r=.
		gen bs_Gini_`k'_`t'_r=.
		gen bs_COV_`k'_`t'_r=.
		gen bs_rmd_`k'_`t'_r=.
		gen bs_corr_`k'_`t'_r=.

		forvalues b=1(1)$B {
			qui gen w`b'=.
			qui replace w`b'=runiform()
			qui sum w`b' 
			sum p_hh_inc_`up_cut'_`k'_w [w=w`b'], d 
			replace bs_m_`k'_`t'_r=r(mean) if n==`b'
			replace bs_sd_`k'_`t'_r=r(sd) if n==`b'
			inequal7  p_hh_inc_`up_cut'_`k'_w [w=w`b'],  returnscalars 
			replace bs_th_`k'_`t'_r=r(theil) if n==`b'
			replace bs_mld_`k'_`t'_r=r(mld) if n==`b'
			replace bs_Gini_`k'_`t'_r=r(gini) if n==`b'
			replace bs_COV_`k'_`t'_r=r(cov) if n==`b'
			replace bs_rmd_`k'_`t'_r=r(rmd) if n==`b'
			correlate p_hh_inc_`up_cut'_`k'_w hh_inc_w [w=w`b']
			replace  bs_corr_`k'_`t'_r=r(rho) if n==`b'
			di "`b'"
			drop w`b'
		}

		sum bs_th_`k'_`t'_r
		scalar bs_th_`k'_`t'_r=r(sd)
		sum bs_m_`k'_`t'_r
		scalar bs_m_`k'_`t'_r=r(sd)
		sum bs_sd_`k'_`t'_r
		scalar bs_sd_`k'_`t'_r=r(sd)
		sum bs_mld_`k'_`t'_r
		scalar bs_mld_`k'_`t'_r=r(sd)
		sum bs_Gini_`k'_`t'_r
		scalar bs_Gini_`k'_`t'_r=r(sd)
		sum bs_COV_`k'_`t'_r
		scalar bs_COV_`k'_`t'_r=r(sd)
		sum bs_rmd_`k'_`t'_r
		scalar bs_rmd_`k'_`t'_r=r(sd)
		sum bs_corr_`k'_`t'_r
		scalar bs_corr_`k'_`t'_r=r(sd)


		gen bs_th_`k'_`t'_o=.
		gen bs_m_`k'_`t'_o=.
		gen bs_sd_`k'_`t'_o=.
		gen bs_mld_`k'_`t'_o=.
		gen bs_Gini_`k'_`t'_o=.
		gen bs_COV_`k'_`t'_o=.
		gen bs_rmd_`k'_`t'_o=.
		if "`bs_orig'"=="1" {
			forvalues b=1(1)$B {
				qui gen w`b'=.
				qui replace w`b'=runiform()
				qui sum w`b' 
				sum hh_inc_w [w=w`b'], d 
				replace bs_m_`k'_`t'_o=r(mean) if n==`b'
				replace bs_sd_`k'_`t'_o=r(sd) if n==`b'
				inequal7 hh_inc_w [w=w`b'],  returnscalars 
				replace bs_th_`k'_`t'_o=r(theil) if n==`b'
				replace bs_mld_`k'_`t'_o=r(mld) if n==`b'
				replace bs_Gini_`k'_`t'_o=r(gini) if n==`b'
				replace bs_COV_`k'_`t'_o=r(cov) if n==`b'
				replace bs_rmd_`k'_`t'_o=r(rmd) if n==`b'	
				di "`b'"
				drop w`b'
			
			}
			preserve
				keep n *_4_2017_o
				save "${data_temp}\bs_inc_o_reduced.dta", replace
			restore
		}
		if "`bs_orig'">"1" {
			merge 1:1 n using "${data_temp}\bs_inc_o_reduced.dta", nogen
			replace bs_m_`k'_`t'_o=bs_m_4_`t'_o
			replace bs_sd_`k'_`t'_o=bs_sd_4_`t'_o
			replace bs_th_`k'_`t'_o=bs_th_4_`t'_o
			replace bs_mld_`k'_`t'_o=bs_mld_4_`t'_o
			replace bs_Gini_`k'_`t'_o=bs_Gini_4_`t'_o
			replace bs_COV_`k'_`t'_o=bs_COV_4_`t'_o
			replace bs_rmd_`k'_`t'_o=bs_rmd_4_`t'_o	
			
 		} 


		sum bs_th_`k'_`t'_o
		scalar bs_th_`k'_`t'_o=r(sd)
		sum bs_m_`k'_`t'_o
		scalar bs_m_`k'_`t'_o=r(sd)
		sum bs_sd_`k'_`t'_o
		scalar bs_sd_`k'_`t'_o=r(sd)
		sum bs_mld_`k'_`t'_o
		scalar bs_mld_`k'_`t'_o=r(sd)
		sum bs_Gini_`k'_`t'_o
		scalar bs_Gini_`k'_`t'_o=r(sd)
		sum bs_COV_`k'_`t'_o
		scalar bs_COV_`k'_`t'_o=r(sd)
		sum bs_rmd_`k'_`t'_o
		scalar bs_rmd_`k'_`t'_o=r(sd) 

		*** difference
		gen bs_d_th_`k'_`t'=(bs_th_`k'_`t'_r-bs_th_`k'_`t'_o)/bs_th_`k'_`t'_o
		gen bs_d_m_`k'_`t'=(bs_m_`k'_`t'_r-bs_m_`k'_`t'_o)/bs_m_`k'_`t'_o
		gen bs_d_sd_`k'_`t'=(bs_sd_`k'_`t'_r-bs_sd_`k'_`t'_o)/bs_sd_`k'_`t'_o
		gen bs_d_mld_`k'_`t'=(bs_mld_`k'_`t'_r-bs_mld_`k'_`t'_o)/bs_mld_`k'_`t'_o
		gen bs_d_Gini_`k'_`t'=(bs_Gini_`k'_`t'_r-bs_Gini_`k'_`t'_o)/bs_Gini_`k'_`t'_o
		gen bs_d_COV_`k'_`t'=(bs_COV_`k'_`t'_r-bs_COV_`k'_`t'_o)/bs_COV_`k'_`t'_o
		gen bs_d_rmd_`k'_`t'=(bs_rmd_`k'_`t'_r-bs_rmd_`k'_`t'_o)/bs_rmd_`k'_`t'_o
		*gen bs_d_corr_`k'_`t'_r=(bs_corr_`k'_`t'_r-bs_corr_`k'_`t'_o)/bs_corr_`k'_`t'_o
		sum bs_d_th_`k'_`t'
		scalar bs_d_th_`k'_`t'=r(sd)
		sum bs_d_m_`k'_`t'
		scalar bs_d_m_`k'_`t'=r(sd)
		sum bs_d_sd_`k'_`t'
		scalar bs_d_sd_`k'_`t'=r(sd)
		sum bs_d_mld_`k'_`t'   
		scalar bs_d_mld_`k'_`t'=r(sd)
		sum bs_d_Gini_`k'_`t'
		scalar bs_d_Gini_`k'_`t'=r(sd)
		sum bs_d_COV_`k'_`t'
		scalar bs_d_COV_`k'_`t'=r(sd)
		sum bs_d_rmd_`k'_`t'
		scalar bs_d_rmd_`k'_`t'=r(sd)
		*sum bs_d_corr_`k'_`t'
		*scalar bs_d_corr_`k'_`t'=r(sd)

		local bs_orig=`bs_orig'+1 //do not bs orig var again
		di `bs_orig'


	}

	clear

	set obs 29
	local t=2017
	gen year=`t'
	gen n=_n-1

	gen stat=""
	replace stat= "mean" if n==0
	replace stat= "median" if n==4
	replace stat= "sd" if n==2
	replace stat= "p1" if n==5	
	replace stat= "p5" if n==6
	replace stat= "p10" if n==7
	replace stat= "p25" if n==8
	replace stat= "p75" if n==9
	replace stat= "p90" if n==10
	replace stat= "p95" if n==11
	replace stat= "p99" if n==12
	replace stat="N" if n==13
	replace stat="min" if n==14
	replace stat="max" if n==15
	replace stat="Inequality Measures" if n==16
	replace stat= "Mean Log Dev" if n==17
	replace stat="Theil" if n==19
	replace stat="Gini" if n==21
	replace stat="COV" if n==23
	replace stat="Rel. Mean Dev" if n==25
	replace stat="Correlaton" if n==27

	local f "o r"

	foreach k of global ca {  
		foreach l of local f  {
			gen gw_`k'_`l'=.
			replace gw_`k'_`l'= mean_`k'_`t'`l' if n==0
			replace gw_`k'_`l'= bs_m_`k'_`t'_`l' if n==1
			replace gw_`k'_`l'= med_`k'_`t'`l' if n==4
			replace gw_`k'_`l'= sd_`k'_`t'`l' if n==2
			replace gw_`k'_`l'= bs_sd_`k'_`t'_`l' if n==3
			replace gw_`k'_`l'= p1_`k'_`t'`l' if n==5
			replace gw_`k'_`l'= p5_`k'_`t'`l' if n==6
			replace gw_`k'_`l'= p10_`k'_`t'`l' if n==7
			replace gw_`k'_`l'= p25_`k'_`t'`l' if n==8
			replace gw_`k'_`l'= p75_`k'_`t'`l' if n==9
			replace gw_`k'_`l'= p90_`k'_`t'`l' if n==10
			replace gw_`k'_`l'= p95_`k'_`t'`l' if n==11
			replace gw_`k'_`l'= p99_`k'_`t'`l' if n==12
			replace gw_`k'_`l'= N_`k'_`t'`l' if n==13
			replace gw_`k'_`l'= min_`k'_`t'`l' if n==14
		    replace gw_`k'_`l'= max_`k'_`t'`l' if n==15
		    replace gw_`k'_`l'= mld_`k'_`t'`l' if n==17
		    replace gw_`k'_`l'= bs_mld_`k'_`t'_`l' if n==18
		    replace gw_`k'_`l'= Theil_`k'_`t'`l' if n==19
		    replace gw_`k'_`l'= bs_th_`k'_`t'_`l' if n==20
		    replace gw_`k'_`l'= Gini_`k'_`t'`l' if n==21
		    replace gw_`k'_`l'= bs_Gini_`k'_`t'_`l' if n==22
		    replace gw_`k'_`l'= COV_`k'_`t'`l' if n==23
		    replace gw_`k'_`l'= bs_COV_`k'_`t'_`l' if n==24
		    replace gw_`k'_`l'= rmd_`k'_`t'`l' if n==25
		    replace gw_`k'_`l'= bs_rmd_`k'_`t'_`l' if n==26
		    if "`l'"=="r" replace gw_`k'_`l'= corr_`k'_`t'`l' if n==27
			if "`l'"=="r"  replace gw_`k'_`l'= bs_corr_`k'_`t'_`l' if n==28
			if "`l'"=="r" {
				gen di_`k'=.
				replace di_`k'= d_mean_`k'_`t' if n==0
				replace di_`k'= bs_d_m_`k'_`t' if n==1
				replace di_`k'= d_med_`k'_`t' if n==4
				replace di_`k'= d_sd_`k'_`t' if n==2
				replace di_`k'= bs_d_sd_`k'_`t' if n==3
				replace di_`k'= d_p1_`k'_`t' if n==5
				replace di_`k'= d_p5_`k'_`t' if n==6
				replace di_`k'= d_p10_`k'_`t' if n==7
				replace di_`k'= d_p25_`k'_`t' if n==8
				replace di_`k'= d_p75_`k'_`t' if n==9
				replace di_`k'= d_p90_`k'_`t' if n==10
				replace di_`k'= d_p95_`k'_`t' if n==11
				replace di_`k'= d_p99_`k'_`t' if n==12
				replace di_`k'= d_N_`k'_`t' if n==13
				replace di_`k'= d_min_`k'_`t' if n==14
			    replace di_`k'= d_max_`k'_`t' if n==15
			    replace di_`k'= d_mld_`k'_`t' if n==17
			    replace di_`k'= bs_d_mld_`k'_`t' if n==18
			    replace di_`k'= d_Theil_`k'_`t' if n==19
			    replace di_`k'= bs_d_th_`k'_`t' if n==20
			    replace di_`k'= d_Gini_`k'_`t' if n==21
			    replace di_`k'= bs_d_Gini_`k'_`t' if n==22
			    replace di_`k'= d_COV_`k'_`t' if n==23
			    replace di_`k'= bs_d_COV_`k'_`t' if n==24
			    replace di_`k'= d_rmd_`k'_`t' if n==25
			    replace di_`k'= bs_d_rmd_`k'_`t' if n==26
				*  if ""=="r" replace di_`k'= d_corr_`k'_`t' if n==27
				*if ""=="r"  replace di_`k'= bs_d_corr_`k'_`t' if n==28
		
			}
		}


		foreach k of local i {
			foreach l of local f  {
				replace gw_`k'_`l'=round(gw_`k'_`l',1)
				replace di_`k'=di_`k'*100
				replace di_`k'=round(di_`k',1)

			}
		}

	}
	format *_r  %12.0g  
	save  "$data_temp/descr_fits_2017_`up_cut'_inc_reduced_`sampleslit'", replace
	export excel using "${data_out}\bracket_test_stats_`up_cut'_inc_reduced_`sampleslit'.xlsx", replace firstrow(variables)

}


