****** Heatplots


*** Graph monthly income

use "${data_temp}\brtest_wave_all_comparison_q_final_inc.dta", clear
global ca "4 6 8 10 12 14 16 18 20 22 24 26"
global cut "90 91 92 93 94 95 96 97 98 99"


foreach up_cut of global cut{ 

	foreach k of global ca {  

correlate p_hh_inc_`up_cut'_`k'_w hh_inc_w 
scalar corr_`up_cut'_`k'=r(rho)
	}
}

clear

set obs 200
gen cut_off=.
gen categories=.
gen correlation=.

gen n=_n
local i=1
foreach up_cut of global cut{ 
foreach k of global ca {  
	replace cut_off=`up_cut' if n==`i'
	replace categories=`k' if n==`i'
	replace correlation=corr_`up_cut'_`k' if n==`i'
	local i=`i'+1
	}
}

gen cor_b=.
forvalues w=70(5)95 {
local i=(`w'+5)/100
local c=`w'/100
replace cor_b=`c' if correlation>=`c' & correlation<`i'
} 

*replace cor_b=69 if correlation<0.7

drop if cut_off==90
drop if cut_off==.

/* 
heatplot correlation cut_off categories, backfill colors(plasma)   ylabel(90(1)99, nogrid) xlabel(4(2)26, nogrid) discrete(2)  cuts(.7(.02)1) xtitle("brackets") ytitle("upper cut-off (percentile)") plotregion(fcolor(white)) plotregion(lcolor(black))  graphregion(fcolor(white)) graphregion(lcolor(white)) saving(heat_inc, replace) ramp(bottom labels(.71 (.02) 99) space(12) length(100) )  

*/
gen cat="A) Net Household Income"
save "${data_temp}\inc_graph.dta", replace

*** hexplot Wealth
use  "${data_temp}\brtest_wave_all_comparison_q_final_wealth.dta", clear
global ca "4 6 8 10 12 14 16 18 20 22 24 26"
global cut "90 91 92 93 94 95 96 97 98 99"


foreach up_cut of global cut{ 

	foreach k of global ca {  

correlate p_gro_wealth_`up_cut'_`k'_w gro_wealth_w 
scalar corr_`up_cut'_`k'=r(rho)
	}
}

clear

set obs 200
gen cut_off=.
gen categories=.
gen correlation=.

gen n=_n
local i=1
foreach up_cut of global cut{ 
foreach k of global ca {  
	replace cut_off=`up_cut' if n==`i'
	replace categories=`k' if n==`i'
	replace correlation=corr_`up_cut'_`k' if n==`i'
	local i=`i'+1
	}
}

gen cor_b=.
forvalues w=70(5)95 {
local i=(`w'+5)/100
local c=`w'/100
replace cor_b=`c' if correlation>=`c' & correlation<`i'
} 

*replace cor_b=69 if correlation<0.7

drop if cut_off==90
drop if cut_off==.
gen cat="B) Gross Household Wealth"
save "${data_temp}\wea_graph.dta", replace

use "${data_temp}\inc_graph.dta", clear
append using "${data_temp}\wea_graph.dta"

sort cat

heatplot correlation cut_off categories, backfill colors(plasma) ylabel(90(1)99, nogrid) xlabel(4(2)26, nogrid) discrete(2)  cuts(.7(.02)1) statistic(asis) xtitle("brackets") ytitle("upper cut-off (percentile)")  plotregion(fcolor(white)) plotregion(ifcolor(white)) plotregion(lcolor(black))  graphregion(fcolor(white)) graphregion(lcolor(white)) by(cat, note("")) aspectratio(1)  

graph export "$data_graph\corr_heat_inc_month_wealth_combine.pdf", replace


***** Robustness Graphs


forvalues r=1(1)4{ 

	*** Graph 

	use "${data_temp}/brtest_wave_all_comparison_q_final_hh_inc_`r'.dta", clear
	global ca "4 6 8 10 12 14 16 18 20 22 24 26"
global cut "90 91 92 93 94 95 96 97 98 99"


foreach up_cut of global cut{ 

	foreach k of global ca {  

correlate p_hh_inc_`up_cut'_`k'_w hh_inc_w 
scalar corr_`up_cut'_`k'=r(rho)
	}
}

clear

set obs 200
gen cut_off=.
gen categories=.
gen correlation=.

gen n=_n
local i=1
foreach up_cut of global cut{ 
foreach k of global ca {  
	replace cut_off=`up_cut' if n==`i'
	replace categories=`k' if n==`i'
	replace correlation=corr_`up_cut'_`k' if n==`i'
	local i=`i'+1
	}
}

gen cor_b=.
forvalues w=70(5)95 {
local i=(`w'+5)/100
local c=`w'/100
replace cor_b=`c' if correlation>=`c' & correlation<`i'
} 

*replace cor_b=69 if correlation<0.7

drop if cut_off==90
drop if cut_off==.

if "`r'"=="1" gen cat="A) GB2 Net Household Income"
if "`r'"=="2" gen cat="B) Simulation 1 (Gini =0.20)"
if "`r'"=="3" gen cat="C) Simulation 2 (Gini =0.40)"
if "`r'"=="4" gen cat="C) Simulation 3 (Gini =0.60)"
save "${data_temp}\rob_graph_`r'", replace
}

use "${data_temp}\rob_graph_1.dta", clear
append using "${data_temp}\rob_graph_2.dta"
append using "${data_temp}\rob_graph_3.dta"
append using "${data_temp}\rob_graph_4.dta"

heatplot correlation cut_off categories, backfill colors(plasma) ylabel(90(1)99, nogrid) xlabel(4(2)26, nogrid) discrete(2)  cuts(.7(.02)1) statistic(asis) xtitle("brackets") ytitle("upper cut-off (percentile)")  plotregion(fcolor(white)) plotregion(ifcolor(white)) plotregion(lcolor(black))  graphregion(fcolor(white)) graphregion(lcolor(white)) by(cat, note("")) aspectratio(0.7)  


graph export "$data_graph/corr_rob_inc.pdf", replace



graph export "$data_graph\corr_heat_inc_month_wealth_combine.pdf", replace







*** Robust: Bracketsize

use  "${data_temp}/brtest_wave_all_comparison_q_final_hh_inc_b.dta", clear
global ca "4 6 8 10 12 14 16 18 20 22 24 26"
global cut "90 91 92 93 94 95 96 97 98 99"


foreach up_cut of global cut{ 

	foreach k of global ca {  

correlate p_hh_inc_`up_cut'_`k'_w hh_inc_w 
scalar corr_`up_cut'_`k'=r(rho)
	}
}

clear

set obs 200
gen cut_off=.
gen categories=.
gen correlation=.

gen n=_n
local i=1
foreach up_cut of global cut{ 
foreach k of global ca {  
	replace cut_off=`up_cut' if n==`i'
	replace categories=`k' if n==`i'
	replace correlation=corr_`up_cut'_`k' if n==`i'
	local i=`i'+1
	}
}

gen cor_b=.
forvalues w=70(5)95 {
local i=(`w'+5)/100
local c=`w'/100
replace cor_b=`c' if correlation>=`c' & correlation<`i'
} 

*replace cor_b=69 if correlation<0.7

drop if cut_off==90
drop if cut_off==.


heatplot correlation cut_off categories, backfill colors(plasma) ylabel(90(1)99, nogrid) xlabel(4(2)26, nogrid) discrete(2)  cuts(.7(.02)1) statistic(asis) xtitle("brackets") ytitle("upper cut-off (percentile)")  plotregion(fcolor(white)) plotregion(ifcolor(white)) plotregion(lcolor(black))  graphregion(fcolor(white)) graphregion(lcolor(white)) aspectratio(1)  

graph export "$data_graph\corr_heat_inc_new_brackets.pdf", replace
