******+ Category check for 2017 ***********************************************
***wealth*****
do "$do_path\Check_gbgfit_new_waves\02_b_mciblg.do"

global ca "4 6 8 10 12 14 16 18 20 22 24 26"
global cut "90 91 92 93 94 95 96 97 98 99"

 scalar drop _all

use hid cid syear w010ha using  "${data_in}\hwealth.dta", clear

keep if syear==2017
gen gro_wealth = w010ha if w010ha>0 & w010ha!=.

// brackets arranged by quantiles 
/* top brackets starts at 95 percentile (check sensibility here later) */
xtile x_gro_wealth= gro_wealth,  nquantiles(500) 

foreach t of global cut{ 
	//algorthim which creates  4 to 26 brackets based on 500 quantiles. 
	forvalues b=3/25 {

			local d=`b'
			local p=`b'+1
			gen gro_wealth_cat_`t'_`p' = .
			//(leaves room for 1 quantile)
			local s=`t'-1 
			scalar br_help_c=`t'/`b'*5
			scalar br_help=round(br_help_c,1)
			di br_help
		forvalues i=1/`b' {
			local a=`i'-1
			if `d'==`b' scalar br_`d'=`t'*5
			if `d'<`b' scalar br_`d'=`t'*5-`a'*br_help
			di br_`d'
			local d=`d'-1
		}
		
		forvalues i=1/`b' {
			//
			qui sum gro_wealth if x_gro_wealth==br_`i'
			scalar z1_`i'_gw_`t'_`p'=r(max)
				if r(max)==. {  	//check for missing categories: in some cases, the algorithm above picks empty quantiles. So I use one before or after
					forvalues c=1(1)5 {
						scalar br_miss=br_`i'+`c'
						qui sum gro_wealth  if x_gro_wealth==br_miss 
						scalar z1_`i'_gw_`t'_`p'=r(max)
						di "z1_`i'_gw_`t'_`p' " z1_`i'_gw_`t'_`p'
						if r(max)!=. {
							di "solved +`c', cut of at " br_miss " instead of " br_`i'
						}
						// if not solved, check c quantile(s) before 
						else { 
							scalar br_miss=br_`i'-`c'
							qui sum gro_wealth  if x_gro_wealth==br_miss 
							scalar z1_`i'_gw_`t'_`p'=r(max)
							if r(max)!=. {
								di "solved -`c', cut of at " br_miss " instead of " br_`i'
							} 
						}
						// Found a quantile? if so, stop! If not, continue.
						qui sum gro_wealth  if x_gro_wealth==br_miss 
						if r(max)!=. continue, break
					}
				}
			//defining second break	
			scalar z2_`i'_gw_`t'_`p'=z1_`i'_gw_`t'_`p'-0.01
			di "Ober z1_`i'_gw_`t'_`p' "  z1_`i'_gw_`t'_`p'  " Unter z2_`i'_gw_`t'_`p' " z2_`i'_gw_`t'_`p'
			scalar drop	br_`i'

		}


		/*forvalues i=1/`b' {	
			qui sum gro_wealth if x_gro_wealth==br_`i'
			scalar z1_`i'_gw_`t'_`p'=r(max)

		} */

	}

	di `unsolved'

		//including infos into wealth category variables

	forvalues b=3/25 {
			local p=`b'+1
			replace gro_wealth_cat_`t'_`p' = `p' if gro_wealth >= z1_`b'_gw_`t'_`p' & gro_wealth != . & gro_wealth_cat_`t'_`p' ==.	
			forvalues i=1/`b' {
			local a=`i'-1
			if `i'==1 				replace gro_wealth_cat_`t'_`p' = `i' if inrange(gro_wealth, 0, z2_`i'_gw_`t'_`p') & gro_wealth_cat_`t'_`p' ==.	
			if `i'>=2 			 	replace gro_wealth_cat_`t'_`p' = `i' if inrange(gro_wealth, z1_`a'_gw_`t'_`p', z2_`i'_gw_`t'_`p')	& gro_wealth_cat_`t'_`p' ==.		
		}
	}




	//create a dummy
	forvalues b=3/25 {

		local p=`b'+1


		gen d_cat_gro_wealth_`t'_`p'=0
		replace d_cat_gro_wealth_`t'_`p'=1 if gro_wealth_cat_`t'_`p'>=0 & gro_wealth_cat_`t'_`p'!=.
	}
		
}

save   "${data_temp}\hh_wealth.dta", replace

*
/* //check if all categories have been generated
foreach t of global cut{ 
	forvalues p=5/26 {

		sum gro_wealth_cat_`t'_`p'
		local i=r(mean)
		local b=`p'-1
		sum gro_wealth_cat_`t'_`b'
		local k=`i'-r(mean)
		if `k'<0 global check "$check, `t'_`p'"
	}
	local i=0
	local k=0
}
di "$check"

macro drop check
*/


// Get ready for MCIBGL
foreach t of global cut{ 

	foreach p of global ca {  
			local a=`p'-1
			preserve
			collapse (count) obs=d_cat_gro_wealth_`t'_`p', by(gro_wealth_cat_`t'_`p')

			g n=_n
			drop if gro_wealth_cat_`t'_`p'==.

			gen  z1=0

			replace z1=0  if n==1
			forvalues b=1/`a' {
			local n=`b'+1
				replace z1=z1_`b'_gw_`t'_`p' if n==`n'

			}

			gen z2=.
		forvalues b=1/`a' {
				replace z2=z1_`b'_gw_`t'_`p' if n==`b'
			
		}

		mciblg obs z1 z2,  twopoint saving(brtest_w2017_gro_wealth_`t'_`p'_q.dta) replace   
		di `p'
		restore
	}

}




