* -------------------------------------------------------------------------
* Stata do-file to article
* -------------------------------------------------------------------------
* Wenz, A., Jäckle, A., Burton, J., Couper, M. P., and Read, B. 
* Quality of expenditure data collected with a mobile receipt scanning app
* in a probability household panel
* -------------------------------------------------------------------------

* Set working directory ---------------------------------------------------
sysdir set PLUS "d:\home\user\ado\stbplus"
cd "I:\Research\Output quality\Data"

* Load Spending Study data ------------------------------------------------
use "Spending_Study", clear

* Append Living Costs and Food Survey data --------------------------------
append using "Living_Costs_and_Food_Survey"

* Recode data -------------------------------------------------------------
// Generate id variable
gen id = _n
la var id "Person identifier"
order id, first
drop pidp i_hidp

// Recode income into quartiles (based on Living Costs and Food Survey income distribution)
sum income if source == 1, d

gen income_cat = .
replace income_cat = 1 if income >= 0 & income < r(p25)
replace income_cat = 2 if income >= r(p25) & income < r(p50)
replace income_cat = 3 if income >= r(p50) & income < r(p75)
replace income_cat = 4 if income >= r(p75)
la var income_cat "Personal monthly gross income: quartiles"
order income_cat, after(income)

tab income_cat if source == 1
tab income_cat if source == 0

// Save data
save "Spending_Study_LCFS", replace
