* -------------------------------------------------------------------------
* Stata do-file to article
* -------------------------------------------------------------------------
* Wenz, A., Jäckle, A., Burton, J., Couper, M. P., and Read, B. 
* Quality of expenditure data collected with a mobile receipt scanning app
* in a probability household panel
* -------------------------------------------------------------------------

* Set working directory ---------------------------------------------------
sysdir set PLUS "d:\home\user\ado\stbplus"
cd "I:\Research\Output quality\Data"

* Load Spending Study App paradata ----------------------------------------
use "UKDA-8749-stata\stata\stata13\apd.dta", clear
keep pidp i_hidp entryid activitytype nr_amount-nr_other starttime_apd endtime_apd

* Recode Spending Study data ----------------------------------------------
// Generate day of study when submission took place
local daystrt=tc(21oct2016_00:00:00.000)
local dayend=`daystrt'+86399999	
gen day_dv=.

foreach day of numlist 1/76 {
	replace day_dv=`day' if endtime_apd>=`daystrt' & endtime_apd<=`dayend'
	local daystrt=`daystrt'+86400000	
	local dayend=`dayend'+86400000
}
la var day_dv "Day of study when submission took place"

// Generate week of study when submission took place
gen week_dv=1 if day_dv<11
local wkstrt=11
local wkend=17
foreach week of numlist 2/11{
	replace week_dv=`week' if day_dv>=`wkstrt' & day_dv<=`wkend'
	local wkstrt=`wkstrt'+7
	local wkend=`wkend'+7
}
la var week_dv "Week of study when submission took place"

order day_dv week_dv, after(activitytype)
drop starttime_apd endtime_apd

// Restrict submission type to scanned receipt and direct entry 
drop if activitytype == 3

bysort pidp: egen min_week_dv = min(week_dv)
gen week = week_dv - min_week_dv + 1

* Table 1. Expenditure reports in the Understanding Society Spending Study in week 1 and 2
tab activitytype if week == 1 | week == 2
tab activitytype

keep if activitytype == 2

* Table 1. Expenditure reports in the Understanding Society Spending Study in week 1 and 2
foreach var of varlist nr_food-nr_gift {
	tab `var' if week == 1 | week == 2
}

foreach var of varlist nr_food-nr_gift {
	tab `var'
}
