/*Table 1, 2, 3, 4, Figure 1*/
/*Create libname  for sas dataset tab1234_fig1.sasbdat */
data t1234_f1; set h.tab1234_fig1;
if randomcati ne .;
/*Table 1 Mode Assignment */
title ' '; run;
proc freq data=two; where randomcati ne .; tables randomcati; run;
/*Table 2: Table 2. Response Rates and Completion Mode / Device / 
Use of Alternative Mode by Treatment Condition*/
proc freq data=two; where randomcati ne .; tables randomcati*iw21; run;
/*Completion Mode, among completed interviews */
proc freq data=two; where randomcati ne .; tables webmode; run;
/*Test diff in mode by assignment for completes*/
proc freq data=two; where randomcati ne .; tables randomcati*webmode; run;
/*Test device completion for web completes, for WF */
proc freq data=two; where randomcati=0 and webmode=1 and iw21=1; tables smartphone; run;
/*Test device completion for web completes, for CF */
proc freq data=two; where randomcati=1 and webmode=1 and iw21=1; tables randomcati*smartphone; run;
/*Table 3. Fieldwork Outcomes During PSID-2021 by Treatment Condition*/
/*Fieldwork Effort: Number of Attempts and Days in Field by Condition */
proc means data=two n mean median; where randomcati ne .; class randomcati; 
var totatt callcommsiwer emailtext days_in_field; run;
proc ttest data=two plots=none; where randomcati ne .; class randomcati; 
var totatt callcommsiwer emailtext days_in_field; run;
proc quantreg data=two; where randomcati ne .;
  class randomcati;
   model totatt = randomcati / quantile=0.5;
   estimate 'Diff in Quantiles' randomcati 1 -1 / CL; run;
proc quantreg data=two; where randomcati ne .;
  class randomcati;
   model callcommsiwer = randomcati / quantile=0.5;
   estimate 'Diff in Quantiles' randomcati 1 -1 / CL; run;
proc quantreg data=two; where randomcati ne .;
  class randomcati;
   model emailtext = randomcati / quantile=0.5;
   estimate 'Diff in Quantiles' randomcati 1 -1 / CL; run;  /*Used Stata to approximate 50th percentile*/
proc quantreg data=two; where randomcati ne .;
  class randomcati;
   model days_in_field = randomcati / quantile=0.5;
   estimate 'Diff in Quantiles' randomcati 1 -1 / CL; run;
/* Table 4. Fieldwork Outcomes and Completion Mode / Device / Sessions			
by Treament Condition for Completed Interviews	*/
/*CF, CATI complete */
proc means data=two n mean median; where randomcati ne . and iw21=1 and randomcati=1
and webmode=0; var totsessions websessions catisessions; run;
/*CF, Web complete */
proc means data=two n mean median; where randomcati ne . and iw21=1 and randomcati=1
and webmode=1; var totsessions websessions catisessions; run;
/*CF, Web vs CATI complete */
proc ttest data=two plots=none; where randomcati ne . and iw21=1 and randomcati=1; class webmode; 
var totsessions websessions catisessions; run;
proc quantreg data=two; where randomcati ne . and iw21=1 and randomcati=1;
  class webmode;
   model totsessions = webmode / quantile=0.5;
   estimate 'Diff in Quantiles' webmode 1 -1 / CL; run;
proc quantreg data=two; where randomcati ne . and iw21=1 and randomcati=1;
  class webmode;
   model websessions = webmode / quantile=0.5;
   estimate 'Diff in Quantiles' webmode 1 -1 / CL; run;  /*Used Stata to approximate 50th percentile*/
proc quantreg data=two; where randomcati ne . and iw21=1 and randomcati=1;
  class webmode;
   model catisessions = webmode / quantile=0.5;
   estimate 'Diff in Quantiles' webmode 1 -1 / CL; run;
/*By device */
/*CF, Web complete */
proc ttest data=two plots=none; where randomcati ne . and iw21=1 and randomcati=1
and webmode=1; class smartphone; var totsessions websessions catisessions; run;
/*WF, CATI complete */
proc means data=two mean median; where randomcati ne . and iw21=1 and randomcati=0
and webmode=0; var totsessions websessions catisessions; run;
/*WF, Web complete */
proc means data=two n mean median; where randomcati ne . and iw21=1 and randomcati=0
and webmode=1; var totsessions websessions catisessions; run;
/*By device */
proc ttest data=two plots=none; where randomcati ne . and iw21=1 and randomcati=0
and webmode=1; class smartphone; var totsessions websessions catisessions; run;
/*WF, Web vs CATI complete */
proc means data=two n mean median; where randomcati ne . and iw21=1 and randomcati=0; class webmode; 
var totsessions websessions catisessions; run;
proc ttest data=two plots=none; where randomcati ne . and iw21=1 and randomcati=0; class webmode; 
var  totsessions websessions catisessions; run;
proc freq data=two; where randomcati ne . and iw21=1 and randomcati=0 and webmode=1;
tables catisessions; run;
proc quantreg data=two; where randomcati ne . and iw21=1 and randomcati=0;
  class webmode;
   model totsessions = webmode / quantile=0.5;
   estimate 'Diff in Quantiles' webmode 1 -1 / CL; run;
proc quantreg data=two; where randomcati ne . and iw21=1 and randomcati=0;
  class webmode;
   model websessions = webmode / quantile=0.5;
   estimate 'Diff in Quantiles' webmode 1 -1 / CL; run;  /*Used Stata to approximate 50th percentile*/
proc quantreg data=two; where randomcati ne . and iw21=1 and randomcati=0;
  class webmode;
   model catisessions = webmode / quantile=0.5;
   estimate 'Diff in Quantiles' webmode 1 -1 / CL; run; /*Used Stata to approximate 50th percentile*/
/*See median tests_Table3_4.log for Stata code for median comparisons not estimable in SAS */
/*Figure 1. Kaplan Meier Estimate of the Cumulative Distribution Function of Duration to PSID-2021 Completed Cases: 											
CATI First vs. Web First */
data tre; set two;
if CF_vs_WF=1 then Group="CATI-First"; 
else if CF_vs_WF=0 then Group="Web-First";
proc freq data=tre; tables group; run;
proc means data=tre; class group; var days_in_field; run;
ods html style=journal;
proc lifetest data=tre notable
plots=survival(failure cb=all test strata=overlaid);
where randomcati ne .;
strata group;
time days_in_field*iw21(0);
run;	

