ESS.survey.contact.analysed <- analysed %>% 
  group_by(cntry.round) %>% 
  filter(row_number()==1) %>% 
  select(analysed, cntry.round) %>% 
  left_join(ESS.survey.contact, by = "cntry.round") %>% 
  mutate(analysed.dummy = analysed %in%  c("Interviewer observations",
                                           "Interviewer observations and Demographics")) %>% 
  filter(interview == T) %>% 
  filter(analysed.dummy == T) %>% 
  mutate(happy.n = as.numeric(happy)-1,
         hinctnta.n = as.numeric(hinctnta),
         ppltrst.n = as.numeric(ppltrst),
         eduyrs.n = extract_numeric(eduyrs),
         hinctnta.missing = is.na(hinctnta)) 





# Income

inc.neighb <- ESS.survey.contact.analysed %>% 
  group_by(cntry.full) %>%   
  cohens_d(formula = hinctnta.n ~ neighb, 
           var.equal = FALSE, data = .) %>% 
  mutate(comp = paste("Neighb. char.: ", group1, "-", group2))


inc.multi <- ESS.survey.contact.analysed %>% 
  group_by(cntry.full) %>%   
  cohens_d(formula = hinctnta.n ~ multi.unit, 
           var.equal = FALSE, data = .) %>% 
  mutate(comp = paste("Building: ", group1, "-", group2))


### Education

edu.neighb <- ESS.survey.contact.analysed %>% 
  group_by(cntry.full) %>%   
  cohens_d(formula = eduyrs.n ~ neighb, 
           var.equal = FALSE, data = .) %>% 
  mutate(comp = paste("Neighb. char.: ", group1, "-", group2))


edu.multi <- ESS.survey.contact.analysed %>% 
  group_by(cntry.full) %>%   
  cohens_d(formula = eduyrs.n ~ multi.unit, 
           var.equal = FALSE, data = .) %>% 
  mutate(comp = paste("Building: ", group1, "-", group2))



### Trust

trust.neighb <- ESS.survey.contact.analysed %>% 
  group_by(cntry.full) %>%   
  cohens_d(formula = ppltrst.n ~ neighb, 
           var.equal = FALSE, data = .) %>% 
  mutate(comp = paste("Neighb. char.: ", group1, "-", group2))


trust.multi <- ESS.survey.contact.analysed %>% 
  group_by(cntry.full) %>%   
  cohens_d(formula = ppltrst.n ~ multi.unit, 
           var.equal = FALSE, data = .) %>% 
  mutate(comp = paste("Building: ", group1, "-", group2))


combined <- bind_rows(inc.multi, edu.multi, 
                      inc.neighb, edu.neighb,
                      trust.multi, trust.neighb)


combined  %>%  
  mutate(y.lab = case_when(.y. == "hinctnta.n" ~ "Household income",
                           .y. == "eduyrs.n" ~ "Education (yrs)",
                           .y. == "ppltrst.n" ~ "Trust",
                           TRUE ~ "Other"
                           
  )) %>% 
  ggplot(aes(x = fct_rev(cntry.full), y = effsize, fill = magnitude)) +
  geom_col() +
  coord_flip() +
  facet_grid(fct_rev(y.lab) ~ comp) +
  theme_bw() +
  labs(x = "",
       y = "Cohen's d effect size",
       fill = "Magnitude") +
  scale_fill_viridis_d(begin = 0.05, end = 0.95, option = "turbo", direction = 1) +
  scale_x_discrete(guide = guide_axis(n.dodge = 2)) +
  theme(legend.position = "bottom") 


ggsave(here("Figures", "cohens.svg"), height = 9.5, width = 7)







n.cntries <- ESS.survey.contact.analysed %>% 
  ungroup() %>% 
  summarise(unique(cntry)) %>% 
  nrow()

n.comparisons <- 6






########################################


neigh.income <- ESS.survey.contact.analysed %>% 
  filter(!is.na(neighb)) %>% filter(!is.na(hinctnta.n)) %>% 
  group_by(cntry.full) %>% 
  summarise(n = n(),
            int.obs = "Neighbourhood characteristics",
            test = "Household income",
            n.rounds = length(unique(essround)),
            t = t.test(hinctnta.n ~ neighb)$statistic,
            pval = t.test(hinctnta.n ~ neighb)$p.value,
            n.rounds = mean(n.rounds),
            sig05 = pval < 0.05 / (n.cntries * n.comparisons),
            sig01 = pval < 0.01 / (n.cntries * n.comparisons),
            sig001 = pval < 0.001 / (n.cntries * n.comparisons),
            sig = case_when(sig001 == T ~ "p < 0.001/(36*6) (***)",
                            sig01 == T & sig001 == F ~ "p < 0.01/(36*6) (**)",
                            sig05 == T & sig01 == F ~ "p < 0.05/(36*6) (*)",
                            sig05 == F & sig01 == F & sig001 == F ~ "p >= 0.05/(36*6)"))

multi.income <- ESS.survey.contact.analysed %>% 
  filter(!is.na(multi.unit)) %>% filter(!is.na(hinctnta.n)) %>% 
  group_by(cntry.full) %>% 
  summarise(n = n(),
            int.obs = "Type of building",
            test = "Household income",
            n.rounds = length(unique(essround)),
            t = t.test(hinctnta.n ~ multi.unit)$statistic,
            pval = t.test(hinctnta.n ~ multi.unit)$p.value,
            n.rounds = mean(n.rounds),
            sig05 = pval < 0.05 / (n.cntries * n.comparisons),
            sig01 = pval < 0.01 / (n.cntries * n.comparisons),
            sig001 = pval < 0.001 / (n.cntries * n.comparisons),
            sig = case_when(sig001 == T ~ "p < 0.001/(36*6) (***)",
                            sig01 == T & sig001 == F ~ "p < 0.01/(36*6) (**)",
                            sig05 == T & sig01 == F ~ "p < 0.05/(36*6) (*)",
                            sig05 == F & sig01 == F & sig001 == F ~ "p >= 0.05/(36*6)"))

neigh.eduyrs <- ESS.survey.contact.analysed %>% 
  filter(!is.na(neighb)) %>% filter(!is.na(eduyrs.n)) %>% 
  group_by(cntry.full) %>% 
  summarise(n = n(),
            int.obs = "Neighbourhood characteristics",
            test = "Education (yrs)",
            n.rounds = length(unique(essround)),
            t = t.test(eduyrs.n ~ multi.unit)$statistic,
            pval = t.test(eduyrs.n ~ multi.unit)$p.value,
            n.rounds = mean(n.rounds),
            sig05 = pval < 0.05 / (n.cntries * n.comparisons),
            sig01 = pval < 0.01 / (n.cntries * n.comparisons),
            sig001 = pval < 0.001 / (n.cntries * n.comparisons),
            sig = case_when(sig001 == T ~ "p < 0.001/(36*6) (***)",
                            sig01 == T & sig001 == F ~ "p < 0.01/(36*6) (**)",
                            sig05 == T & sig01 == F ~ "p < 0.05/(36*6) (*)",
                            sig05 == F & sig01 == F & sig001 == F ~ "p >= 0.05/(36*6)"))

multi.eduyrs <-  ESS.survey.contact.analysed %>% 
  filter(!is.na(multi.unit)) %>% filter(!is.na(eduyrs.n)) %>% 
  group_by(cntry.full) %>% 
  summarise(n = n(),
            int.obs = "Type of building",
            test = "Education (yrs)",
            n.rounds = length(unique(essround)),
            t = t.test(eduyrs.n ~ multi.unit)$statistic,
            pval = t.test(eduyrs.n ~ multi.unit)$p.value,
            n.rounds = mean(n.rounds),
            sig05 = pval < 0.05 / (n.cntries * n.comparisons),
            sig01 = pval < 0.01 / (n.cntries * n.comparisons),
            sig001 = pval < 0.001 / (n.cntries * n.comparisons),
            sig = case_when(sig001 == T ~ "p < 0.001/(36*6) (***)",
                            sig01 == T & sig001 == F ~ "p < 0.01/(36*6) (**)",
                            sig05 == T & sig01 == F ~ "p < 0.05/(36*6) (*)",
                            sig05 == F & sig01 == F & sig001 == F ~ "p >= 0.05/(36*6)"))


neigh.ppltrst <- ESS.survey.contact.analysed %>% 
  filter(!is.na(neighb)) %>% filter(!is.na(ppltrst.n)) %>% 
  group_by(cntry.full) %>% 
  summarise(n = n(),
            int.obs = "Neighbourhood characteristics",
            test = "Trust",
            n.rounds = length(unique(essround)),
            t = t.test(ppltrst.n ~ neighb)$statistic,
            pval = t.test(ppltrst.n ~ neighb)$p.value,
            n.rounds = mean(n.rounds),
            sig05 = pval < 0.05 / (n.cntries * n.comparisons),
            sig01 = pval < 0.01 / (n.cntries * n.comparisons),
            sig001 = pval < 0.001 / (n.cntries * n.comparisons),
            sig = case_when(sig001 == T ~ "p < 0.001/(36*6) (***)",
                            sig01 == T & sig001 == F ~ "p < 0.01/(36*6) (**)",
                            sig05 == T & sig01 == F ~ "p < 0.05/(36*6) (*)",
                            sig05 == F & sig01 == F & sig001 == F ~ "p >= 0.05/(36*6)"))

multi.ppltrst <- ESS.survey.contact.analysed %>% 
  filter(!is.na(multi.unit)) %>% filter(!is.na(ppltrst.n)) %>% 
  group_by(cntry.full) %>% 
  summarise(n = n(),
            int.obs = "Type of building",
            test = "Trust",
            n.rounds = length(unique(essround)),
            t = t.test(ppltrst.n ~ multi.unit)$statistic,
            pval = t.test(ppltrst.n ~ multi.unit)$p.value,
            n.rounds = mean(n.rounds),
            sig05 = pval < 0.05 / (n.cntries * n.comparisons),
            sig01 = pval < 0.01 / (n.cntries * n.comparisons),
            sig001 = pval < 0.001 / (n.cntries * n.comparisons),
            sig = case_when(sig001 == T ~ "p < 0.001/(36*6) (***)",
                            sig01 == T & sig001 == F ~ "p < 0.01/(36*6) (**)",
                            sig05 == T & sig01 == F ~ "p < 0.05/(36*6) (*)",
                            sig05 == F & sig01 == F & sig001 == F ~ "p >= 0.05/(36*6)"))



int.survey.vars <- bind_rows(neigh.ppltrst, multi.ppltrst, neigh.income, 
                             multi.income, neigh.eduyrs, multi.eduyrs)




int.survey.vars %>% 
  select(-sig05, -sig01, -sig001) %>% 
  arrange(cntry.full, test, int.obs) %>% 
  mutate(t = round(t, 3),
    pval = round(pval, 3)) |> 
  write_csv(here("Tables", "surveyvars_intobs_significancetests.csv"))



# How often do we find significant differences (Bonferroni)


int.survey.vars |> 
  tabyl(test, sig05)





