# 01_contact_data
# Cleaning of ESS contact data


selectvars <- c("name","typesamp", "essround","edition","proddate","cntry","idno","defectcf",
                "telnum",
                "interva","gndr_su","age_su","type","access","physa","vandaa", "littera",
                "outinval", "reconva", "foutcod")

ESS1 <- read_sav(here::here("Data/ESS1CFe01.sav")) %>% janitor::clean_names(.) %>%
  mutate(across(.cols = starts_with("resul"),
                .fns  = ~ str_detect(as.factor(.x), "1") == TRUE)) %>% 
  mutate(interva = as.integer(rowSums(select(., starts_with("resul")), 
                                      na.rm = T) > 0))    %>% 
  mutate(typesamp = as_factor(typesamp),
         typesamp = case_when(typesamp == 1 ~ "Individual person",
                              typesamp == 2 ~ "Household",
                              typesamp == 3 ~ "Address"),
         cntry = as.factor(cntry),
         vandaa = vanda,
         littera = litter,
         physa = phys,
         #    gndr_su = genderr,
         #age_su = ager,
         essround = 1,
         proddate = lubridate::dmy(NA)
  ) %>%    
  select_if(names(.) %in% selectvars) %>% 
  filter(cntry != "CZ") # CZ-1 inlcudes four duplicate rows


ESS2 <- read_spss(here::here("Data/ess2cf_ed3_2.por")) %>% janitor::clean_names(.) %>%
  select(-resulala, -resula2n) %>% 
  mutate(across(.cols = starts_with("resul"),
                .fns  = ~ str_detect(as.factor(.x), "1") == TRUE)) %>% 
  mutate(interva = as.integer(rowSums(select(., starts_with("resul")), 
                                      na.rm = T) > 0))    %>% 
  mutate(typesamp = as_factor(typesamp),
         typesamp = case_when(typesamp == 1 ~ "Individual person",
                              typesamp == 2 ~ "Household",
                              typesamp == 3 ~ "Address"),
         cntry = as.factor(cntry),
         vandaa = vanda,
         littera = litter,
         physa = phys,
         #  gndr_su = genderr,
         #   age_su = ager,    
         essround = 2,     
         proddate = lubridate::dmy(NA)) %>%    
  select_if(names(.) %in% selectvars) 

ESS3 <- read_spss(here::here("Data/ess3cf_ed1_1.por")) %>% janitor::clean_names(.) %>%
  mutate(typesamp = as_factor(typesamp),         
         cntry = as.factor(cntry),
         interva = interv,
         vandaa = vanda,
         littera = litter,
         physa = phys,
         #    gndr_su = genderr,
         #    age_su = ager,
         proddate = lubridate::dmy(NA)) %>% 
  select_if(names(.) %in% selectvars)

ESS4 <- to_labelled(read_sav(here::here("Data/ess4cf_e02_1.sav"))) %>%
  mutate(typesamp = as_factor(typesamp),
         typesamp = case_when(typesamp == 1 ~ "Individual person",
                              typesamp == 2 ~ "Household",
                              typesamp == 3 ~ "Address"),
         cntry = as.factor(cntry),
         vandaa = vanda,
         littera = litter,
         physa = phys,
         #     gndr_su = gendera1,
         #      age_su = agea_1,          
         proddate = lubridate::dmy(NA)) %>%   
  select_if(names(.) %in% selectvars) %>% 
  mutate(proddate = lubridate::dmy(proddate)) 


ESS5 <- read_sav(here::here("Data/ESS5CFe02_1.sav")) %>%
  mutate(
    #    gndr_su = gendera1,
    # age_su = agea_1,
    typesamp = as_factor(typesamp),
    cntry = as.factor(cntry)
  ) %>%  
  select_if(names(.) %in% selectvars) %>% 
  mutate(proddate = lubridate::dmy(proddate))%>% 
  mutate_if(is.labelled, as.numeric) 

ESS6 <- read_sav(here::here("Data/ESS6CFe02.sav")) %>%
  mutate(typesamp = as_factor(typesamp),
         cntry = as.factor(cntry)) %>% 
  select_if(names(.) %in% selectvars) %>% 
  mutate(proddate = lubridate::dmy(proddate))%>% 
  mutate_if(is.labelled, as.numeric) 

ESS7 <- read_sav(here::here("Data/ess7CFe02_1.sav")) %>%
  mutate(typesamp = as_factor(typesamp),
         cntry = as.factor(cntry)) %>% 
  select_if(names(.) %in% selectvars) %>% 
  mutate(proddate = lubridate::dmy(proddate))%>% 
  mutate_if(is.labelled, as.numeric) 

ESS8 <- read_sav(here::here("Data/ESS8CFe03.sav")) %>%
  mutate(typesamp = as_factor(typesamp),
         cntry = as.factor(cntry)) %>% 
  select_if(names(.) %in% selectvars) %>% 
  mutate(proddate = lubridate::dmy(proddate))%>% 
  mutate_if(is.labelled, as.numeric) 

ESS9 <- read_sav(here::here("Data/ESS9CFe02.sav")) %>%
  mutate(typesamp = as_factor(typesamp),
         cntry = as.factor(cntry)) %>% 
  select_if(names(.) %in% selectvars) %>% 
  mutate(proddate = lubridate::dmy(proddate)) %>% 
  mutate_if(is.labelled, as.numeric) 

ESS10 <- read_sav(here::here("Data/ESS10CF.sav")) %>%
  mutate(typesamp = as_factor(typesamp),
         cntry = as.factor(cntry)) %>% 
  select_if(names(.) %in% selectvars) %>% 
  mutate(proddate = lubridate::dmy(proddate)) %>% 
  mutate_if(is.labelled, as.numeric) 





# Combine contact data for all rounds



ESS <- bind_rows(ESS1, ESS2, ESS3, ESS4, ESS5, ESS6, ESS7, ESS8, ESS9, ESS10,
                 .id = "round") %>% 
  mutate(interview = interva == 1,
         typesamp2 = case_when(typesamp == "Individual person" ~ "Individual person",
                               typesamp == "Household" ~ "Household or Address",
                               typesamp == "Address" ~ "Household or Address"),
         telephone.present = telnum == 1,
         gndr_su = case_when(gndr_su == 1 ~ "Male",
                             gndr_su == 2 ~ "Female"),
         age_cat = case_when(age_su >= 14 & age_su <= 34~ "Under 35",
                             age_su >= 35 & age_su <= 50 ~ "35-49",
                             age_su >= 50 & age_su <= 64 ~ "50-64",
                             age_su >= 65  ~ "65+"),
         age50 = case_when(age_su < 34 ~ "Under 50",
                           age_su >= 35 & age_su < 50 ~ "Under 50",
                           age_su >= 50 & age_su < 64 ~ "50+",
                           age_su >= 65 ~ "50+"),
         age_cat = fct_relevel(age_cat, "Under 35", after = 0),
         housetype = case_when(type < 5 ~ "Single unit",
                               type >= 6 & type <= 8 ~ "Multi-unit",
                               type == 5  ~ "Other",
                               type >= 9 & type <= 10 ~ "Other"),
         housetype = fct_relevel(housetype, "Other", after = Inf),
         multi.unit = case_when(housetype ==  "Multi-unit"  ~ "Multi-unit",
                                housetype != "Multi-unit"  ~"Not multi-unit"),
         physa.2 = case_when(physa == 1 | physa == 2 ~ "Good",
                             physa == 3 ~ "Satisfactory",
                             physa == 4 | physa == 5 ~ "Bad",
                             TRUE ~ NA),
         physa.2 = physa.3 == "Bad",
         no.access = case_when(access == 4 ~ "No barriers",
                               access != 4 ~ "Barriers"), 
         vandalism = vandaa != 4,
         litter = littera != 4,
         neighb.assessment = physa.2 + vandalism + litter,
         neighb = case_when(neighb.assessment == 0 ~ "None",
                            neighb.assessment >= 1 ~ "One or more"),
         neighb3 = case_when(neighb.assessment == 0 ~ "None",
                             neighb.assessment == 1 ~ "One",
                             neighb.assessment >= 2 ~ "Two or more"),
         cntry.round = str_c(cntry, round, sep = "-"),
         interview_fct = as.factor(interview),
         interview_fct = if_else(interview_fct == "TRUE", 
                                 "Interview", "No interview"),
         interva789 = interva == 7 | interva == 8 | interva == 9,
         interview_na = ifelse(interva789 == T | is.na(interva), TRUE, FALSE),
  )  %>% 
  mutate(essround = as.numeric(round)) |> 
  mutate(cntry.full = str_replace_all(cntry, c("AL" = "Albania", 
                                               "AT" = "Austria", 
                                               "BG" = "Bulgaria", 
                                               "BE" = "Belgium", 
                                               "CH" = "Switzerland", 
                                               "CY" = "Cyprus", 
                                               "CZ" = "Czechia", 
                                               "DE" = "Germany", 
                                               "DK" = "Denmark", 
                                               "EE" = "Estonia", 
                                               "ES" = "Spain", 
                                               "FI" = "Finland", 
                                               "FR" = "France", 
                                               "GB" = "UK", 
                                               "GR" = "Greece", 
                                               "HU" = "Hungary", 
                                               "HR" = "Croatia", 
                                               "IE" = "Ireland", 
                                               "IL" = "Israel", 
                                               "IS" = "Iceland",
                                               "IT" = "Italy",
                                               "LT" = "Lithuania",
                                               "LU" = "Luxembourg",
                                               "LV" = "Latvia",
                                               "ME" = "Montenegro",
                                               "MK" = "N–Macedonia",
                                               "NL" = "Netherlands",
                                               "NO" = "Norway",
                                               "PL" = "Poland",
                                               "PT" = "Portugal",
                                               "RO" = "Romania",
                                               "RS" = "Serbia",
                                               "RU" = "Russia",
                                               "SE" = "Sweden",
                                               "SI" = "Slovenia",
                                               "SK" = "Slovakia",
                                               "TR" = "Turkey",
                                               "UA" = "Ukraine",
                                               "XK" = "Kosovo"
                                               )))





glimpse(ESS)

saveRDS(ESS, "Data/ESS_contacts_1_10.Rdata")









