
# Figure 1. Country-rounds included in the European Social Survey Contact Form Data by information available. Red country-rounds are included in all analyses, yellow country-rounds are included only in the interviewer observations only model. Green country-rounds are excluded due to missing data, and no data is available for blue country-rounds.


analysed %>%
  ggplot(aes(as.numeric(round),
             y = fct_rev(cntry.full),
             fill = analysed)) +
  geom_tile(aes(width = 0.9, height = 0.9)) +
  theme_minimal(base_size = 15) +
  theme(legend.position = "bottom") +
  scale_fill_viridis_d(begin = 0.05, end = 0.95, option = "turbo", direction = -1) +
  labs(x = "ESS round",
       y = "Country",
       fill = "") +
  guides(fill = guide_legend(nrow = 2)) +
  scale_x_continuous(n.breaks = 10)



ggsave(here("Figures", "Figure1_Partipated.pdf"), 
       height = 10, width = 9, device = "pdf")


# Figure 3 R-indicators over time, based on models using only interviewer observations. Countries that have participated in at least 8 of the 9 survey rounds are shown. 
# Dashed blue line indicates overall mean

R.int.obs |> 
  ggplot(aes(x = round_fct,
             y = R)) +
  geom_point(aes(color = typesamp2), 
             size = 2) +
  geom_errorbar(aes(ymin = RCI.lower, 
                    ymax = RCI.upper, 
                    color = typesamp2), 
                width = 0.2) +
  geom_line(aes(group = cntry.full), 
            linetype = "longdash", 
            size = .5) +
  geom_hline(yintercept = 1, 
             colour = "Red", 
             linetype = "dashed") +
  geom_hline(yintercept = mean(R), 
             colour = "Blue", 
             linetype = "dashed") +
  theme_minimal(base_size = 15) +
  facet_wrap(~cntry.full) +
  scale_y_continuous(breaks = seq(0.7, 1.05, 
                                  by = 0.05)) +
  scale_fill_viridis_d(begin = 0.05, 
                       end = 0.95, 
                       option = "turbo",
                       direction = -1) +
  theme(legend.position="bottom") +
  labs(
    color = "Type of sample",
    y = "R-indicator",
    x = "ESS round") 



ggsave(here("Figures", "Figure2_R_over_time.svg"), 
       height = 12, width = 9, device = "svg")



# Figure 3 Partial-R indicator by variables for countries sampling individual persons in ESS rounds 6-9, full model. 


full.partialRbyVariables %>%  
  mutate(significant = (Pu - PuSE*1.96) < 0,
         significant001 = case_when(significant == F ~ "Significant",
                                    Pu < 0.01 &  significant == T ~ "Pu 0.01",
                                    significant == T ~ "Not significant"),
  ) %>% 
  ggplot(aes(x = as.numeric(round),
             y = Pu,
             color = variable,
             shape = variable,
             group = variable)) +
  geom_point(size = 3, aes(alpha = significant), 
             position = position_dodge(width = .4)) +  
  geom_errorbar(aes(ymin = Pu - PuSE*1.96,
                    alpha = significant001,  
                    ymax = Pu + PuSE*1.96), 
                position = position_dodge(width = .4), 
                width = 0.5) +
  geom_hline(yintercept = 0, 
             colour = "Red", 
             linetype = "dashed", 
             linewidth = 1) +
  geom_hline(yintercept = 0.01, 
             colour = "Blue", 
             linetype = "dashed",
             linewidth = 1) +
  theme_minimal(base_size = 15) +
  scale_color_viridis_d(begin = 0.05, 
                        end = 0.95, 
                        option = "turbo", 
                        direction = -1) +
  scale_alpha_manual(values = c(1, 0.5, 0, 1, 0.5))  +
  scale_shape_manual(values=c(15, 16, 17, 18)) +
  facet_wrap(~cntry.full) +
  labs(
    color = "Variable",
    x = "ESS round") +
  ylim(-0.025, 0.125) +
  guides(alpha = F,
         color = guide_legend(nrow = 4)) +
  theme(legend.position = c(0.8, 0.1))  +
  labs(color = "Variable",
       shape = "Variable",
       x = "ESS round",
       y = "Partial R-indicator (Pu)")



ggsave(here("Figures", "Figure3_partialR.svg"), 
       height = 12, width = 9, device = "svg")




# Appendix Figure 2 Partial-R indicator by variables for countries sampling individual persons in ESS rounds 6-9, full model. 


intobs.partialRbyVariables %>%  
  mutate(significant = (Pu - PuSE*1.96) < 0,
         significant001 = case_when(significant == F ~ "Significant",
                                    Pu < 0.01 &  significant == T ~ "Pu 0.01",
                                    significant == T ~ "Not significant"),
  ) %>% 
  ggplot(aes(x = as.numeric(round),
             y = Pu,
             color = variable,
             shape = variable,
             group = variable)) +
  geom_point(size = 2, aes(alpha = significant), 
             position = position_dodge(width = .4)) +  
  geom_errorbar(aes(ymin = Pu - PuSE*1.96,
                    alpha = significant001,  
                    ymax = Pu + PuSE*1.96), 
                position = position_dodge(width = .4), 
                width = 0.5) +
  geom_hline(yintercept = 0, 
             colour = "Red", 
             linetype = "dashed", 
             linewidth = 1) +
  geom_hline(yintercept = 0.01, 
             colour = "Blue", 
             linetype = "dashed",
             linewidth = 1) +
  theme_minimal() + 
  scale_color_viridis_d(begin = 0.05, 
                        end = 0.35, 
                        option = "turbo", 
                        direction = -1) +
  scale_alpha_manual(values = c(1, 0.5, 0, 1, 0.5))  +
  scale_shape_manual(values=c(17, 18)) +
  scale_x_continuous(n.breaks = 10) +
  facet_wrap(~cntry.full) +
  labs(
    color = "Variable",
    x = "ESS round") +
  ylim(-0.025, 0.175) +
  guides(alpha = F,
         color = guide_legend(nrow = 1)) +
  theme(legend.position = "bottom")  +
  labs(color = "Variable",
       shape = "Variable",
       x = "ESS round",
       y = "Partial R-indicator (Pu)")


ggsave(here("Figures", "Appendix_Figure2_partialR.svg"), 
       height = 12, width = 9, device = "svg")
