# Specify model using only interviewer observations  

model.intobs <- formula(interview ~ multi.unit * neighb)

model.dem <- formula(interview ~ gndr_su * age_cat)

model.full <- formula(interview ~ multi.unit * neighb + gndr_su * age_cat)



# R indicator model

R.int.obs.output <- ESS.int.obs %>% 
  group_by(round_fct, cntry.full, typesamp2) %>% 
  do(R.indicator = getRIndicator(formula = model.intobs, 
                                       sampleData = ., 
                                       family = "binomial",
                                       withPartials = TRUE))


# Extract results 

R <- sapply(R.int.obs.output$R.indicator, `[[`, 'R' )
RUnadj <- sapply(R.int.obs.output$R.indicator, `[[`, 'RUnadj' )
propMean <- sapply(R.int.obs.output$R.indicator, `[[`, 'propMean' )
RSE <- sapply(R.int.obs.output$R.indicator, `[[`, 'RSE' )
n <- ESS.int.obs %>% group_by(cntry.round) %>%
  summarise(n = n()) %>% select(n)

# Combine R-indicator results in dataframe

R.int.obs <- data.frame(R.int.obs.output[2], R.int.obs.output[1], R.int.obs.output[3], 
                          R, RUnadj,  propMean, RSE, n) %>% 
  mutate(round = as.numeric(round_fct)) %>% 
  mutate(cntry.round = str_c(cntry.full, round_fct, sep = "-"),
         t1 = (R - 1) / RSE,
         p1 = pt(t1, df = n-1),
         RCI.upper = R + RSE * 1.96,
         RCI.lower = R - RSE * 1.96,
         p1sig.05 = p1 < 0.05,
         p1sig.bonf = p1 < 0.05 / length(unique(cntry.round))) 

tabyl(R.int.obs, p1sig.05, p1sig.bonf)


# Partial R indicators

partial.r.byVariables.intobs <- map(R.int.obs.output$R.indicator, 
                   ~.[["partialR"]][["byVariables"]])

list_names <- str_c(R.int.obs$cntry.full, R.int.obs$round_fct, sep = "-")

names(partial.r.byVariables.intobs) <- list_names

intobs.partialRbyVariables <- data.table::rbindlist(partial.r.byVariables.intobs, 
                                             idcol = TRUE) %>%   
  separate(.id, sep = "-", into = c("cntry.full", "round"), remove = FALSE) %>% 
  left_join(R.int.obs, 
            by = c("cntry.full",
                   "round" = "round_fct") )

intobs.partialRbyVariables$variable <-  recode(intobs.partialRbyVariables$variable, 
                                        "multi.unit" = "Multi-unit building",
                                        "neighb" = "Neighbourhood characteristics")




# Repeat analysis on reduced dataset, where demographics are available





# R indicator model using demographics only

R.dem.output <- ESS.full %>% 
  group_by(round_fct, cntry.full, typesamp2) %>% 
  do(R.indicator = getRIndicator(formula = model.dem, 
                                 sampleData = ., 
                                 family = "binomial",
                                 withPartials = TRUE))


# Extract results 

R <- sapply(R.dem.output$R.indicator, `[[`, 'R' )
RUnadj <- sapply(R.dem.output$R.indicator, `[[`, 'RUnadj' )
propMean <- sapply(R.dem.output$R.indicator, `[[`, 'propMean' )
RSE <- sapply(R.dem.output$R.indicator, `[[`, 'RSE' )
n <- ESS.full %>% group_by(cntry.round) %>%
  summarise(n = n()) %>% select(n)

# Combine R-indicator results in dataframe

R.dem <- data.frame(R.dem.output[2], R.dem.output[1], R.dem.output[3], 
                    R, RUnadj,  propMean, RSE, n) %>% 
  mutate(round = as.numeric(round_fct)) %>% 
  mutate(cntry.round = str_c(cntry.full, round_fct, sep = "-"),
         t1 = (R - 1) / RSE,
         p1 = pt(t1, df = n-1),
         RCI.upper = R + RSE * 1.96,
         RCI.lower = R - RSE * 1.96,
         p1sig.05 = p1 < 0.05,
         p1sig.bonf = p1 < 0.05 / length(unique(cntry.round))) 

tabyl(R.dem, p1sig.05, p1sig.bonf)


# Partial R indicators

partial.r.byVariables.dem <- map(R.dem.output$R.indicator, 
                                 ~.[["partialR"]][["byVariables"]])

list_names <- str_c(R.dem$cntry.full, R.dem$round_fct, sep = "-")

names(partial.r.byVariables.dem) <- list_names

dem.partialRbyVariables <- data.table::rbindlist(partial.r.byVariables.dem, 
                                                 idcol = TRUE) %>%   
  separate(.id, sep = "-", into = c("cntry.full", "round"), remove = FALSE) %>% 
  left_join(R.dem, 
            by = c("cntry.full",
                   "round" = "round_fct") )

dem.partialRbyVariables$variable <-  recode(dem.partialRbyVariables$variable, 
                                            "age_cat" = "Age",
                                            "gndr_su" = "Gender")



# R indicator model

R.full.output <- ESS.full %>% 
  group_by(round_fct, cntry.full, typesamp2) %>% 
  do(R.indicator = getRIndicator(formula = model.full, 
                                 sampleData = ., 
                                 family = "binomial",
                                 withPartials = TRUE))


# Extract results 

R <- sapply(R.full.output$R.indicator, `[[`, 'R' )
RUnadj <- sapply(R.full.output$R.indicator, `[[`, 'RUnadj' )
propMean <- sapply(R.full.output$R.indicator, `[[`, 'propMean' )
RSE <- sapply(R.full.output$R.indicator, `[[`, 'RSE' )
n <- ESS.full %>% group_by(cntry.round) %>%
  summarise(n = n()) %>% select(n)

# Combine R-indicator results in dataframe

R.full <- data.frame(R.full.output[2], R.full.output[1], R.full.output[3], 
                     R, RUnadj,  propMean, RSE, n) %>% 
  mutate(round = as.numeric(round_fct)) %>% 
  mutate(cntry.round = str_c(cntry.full, round_fct, sep = "-"),
         t1 = (R - 1) / RSE,
         p1 = pt(t1, df = n-1),
         RCI.upper = R + RSE * 1.96,
         RCI.lower = R - RSE * 1.96,
         p1sig.05 = p1 < 0.05,
         p1sig.bonf = p1 < 0.05 / length(unique(cntry.round))) 

tabyl(R.full, p1sig.05, p1sig.bonf)


# Partial R indicators

partial.r.byVariables.full <- map(R.full.output$R.indicator, 
                                  ~.[["partialR"]][["byVariables"]])

list_names <- str_c(R.full$cntry.full, R.full$round_fct, sep = "-")

names(partial.r.byVariables.full) <- list_names

full.partialRbyVariables <- data.table::rbindlist(partial.r.byVariables.full, 
                                                  idcol = TRUE) %>%   
  separate(.id, sep = "-", into = c("cntry.full", "round"), remove = FALSE) %>% 
  left_join(R.full, 
            by = c("cntry.full",
                   "round" = "round_fct") )

full.partialRbyVariables$variable <-  recode(full.partialRbyVariables$variable, 
                                             "multi.unit" = "Multi-unit building",
                                             "neighb" = "Neighbourhood characteristics",
                                             "age_cat" = "Age",
                                             "gndr_su" = "Gender")





# Run interviewer observations model on the reduced dataset



# R indicator model using interviewer observations only

R.int.obs6_10.output <- ESS.full %>% 
  group_by(round_fct, cntry.full, typesamp2) %>% 
  do(R.indicator = getRIndicator(formula = model.intobs, 
                                 sampleData = ., 
                                 family = "binomial",
                                 withPartials = TRUE))


# Extract results 

R <- sapply(R.int.obs6_10.output$R.indicator, `[[`, 'R' )
RUnadj <- sapply(R.int.obs6_10.output$R.indicator, `[[`, 'RUnadj' )
propMean <- sapply(R.int.obs6_10.output$R.indicator, `[[`, 'propMean' )
RSE <- sapply(R.int.obs6_10.output$R.indicator, `[[`, 'RSE' )
n <- ESS.full %>% group_by(cntry.round) %>%
  summarise(n = n()) %>% select(n)

# Combine R-indicator results in dataframe

R.int.obs6_10 <- data.frame(R.int.obs6_10.output[2], R.int.obs6_10.output[1], R.int.obs6_10.output[3], 
                            R, RUnadj,  propMean, RSE, n) %>% 
  mutate(round = as.numeric(round_fct)) %>% 
  mutate(cntry.round = str_c(cntry.full, round_fct, sep = "-"),
         t1 = (R - 1) / RSE,
         p1 = pt(t1, df = n-1),
         RCI.upper = R + RSE * 1.96,
         RCI.lower = R - RSE * 1.96,
         p1sig.05 = p1 < 0.05,
         p1sig.bonf = p1 < 0.05 / length(unique(cntry.round))) 

tabyl(R.int.obs6_10, p1sig.05, p1sig.bonf)


# Partial R indicators

partial.r.byVariables.int.obs6_10 <- map(R.int.obs6_10.output$R.indicator, 
                                         ~.[["partialR"]][["byVariables"]])

list_names <- str_c(R.int.obs6_10$cntry.full, R.int.obs6_10$round_fct, sep = "-")

names(partial.r.byVariables.int.obs6_10) <- list_names

int.obs6_10.partialRbyVariables <- data.table::rbindlist(partial.r.byVariables.int.obs6_10, 
                                                         idcol = TRUE) %>%   
  separate(.id, sep = "-", into = c("cntry.full", "round"), remove = FALSE) %>% 
  left_join(R.int.obs6_10, 
            by = c("cntry.full",
                   "round" = "round_fct") )

int.obs6_10.partialRbyVariables$variable <-  recode(int.obs6_10.partialRbyVariables$variable, 
                                                    "multi.unit" = "Multi-unit building",
                                                    "neighb" = "Neighbourhood characteristics")








# Is there actionable information?


R.int.obs |> 
  count(p1sig.bonf)

R.full |> 
  count(p1sig.bonf)


# Which country-rounds are inactionable?


R.dem %>% 
  mutate(inactionable = if_else(R + RSE*1.96 > 1, TRUE, FALSE)) %>% 
  filter(inactionable == T) %>% 
  tabyl(cntry.round)

R.int.obs6_10 %>% 
  mutate(inactionable = if_else(R + RSE*1.96 > 1, TRUE, FALSE)) %>% 
  filter(inactionable == T) %>% 
  tabyl(cntry.round)






# How often are partials significant?

full.partialRbyVariables %>% 
  add_count(cntry.full) %>% 
  mutate(significant = (Pu - PuSE*1.96) < 0) %>% 
  group_by(variable) %>% 
  count(significant) 


# summarize indicators 

R.int.obs %>% 
  summarise(mean.dem = mean(R),
            sd.dem = sd(R))

R.int.obs %>% 
  group_by(typesamp2) |> 
  summarise(mean.dem = mean(R),
            sd.dem = sd(R))



R.full %>% 
  summarise(mean.dem = mean(R),
            sd.dem = sd(R))

