# 


model.intobs.noint <- formula(interview ~ multi.unit + neighb)
model.dem <- formula(interview ~ age_cat * gndr_su)

model.dem.noint <- formula(interview ~ age_cat + gndr_su)


models <- c("model.dem.sim1", "model.full.sim1", "model.dem.sim2", "model.full.sim2")

## Model fits 
# https://cran.r-project.org/web/packages/broom/vignettes/broom_and_dplyr.html

summary.model.intobs.noint <- ESS.no.nas %>% 
  nest(data = -cntry.round) %>% 
  mutate(resp = map(data, ~ glm(formula = model.intobs.noint, 
                                data = .x, 
                                family = "binomial")),
         tidy.resp = map(resp, glance), 
         model = "Int obs only no interaction")   %>% 
  unnest(tidy.resp) %>% 
  mutate(pseudo.r2 = 1 - deviance/null.deviance) |> 
  select(model, cntry.round, nobs, logLik, AIC, pseudo.r2) 


summary.model.intobs <- ESS.no.nas %>% 
  nest(data = -cntry.round) %>% 
  mutate(resp = map(data, ~ glm(formula = model.intobs, 
                                data = .x, 
                                family = "binomial")),
         tidy.resp = map(resp, glance), 
         model = "Int obs only with interaction")   %>% 
  unnest(tidy.resp) %>% 
  mutate(pseudo.r2 = 1 - deviance/null.deviance) |> 
  select(model, cntry.round, nobs, logLik, AIC, pseudo.r2) 


summary.model.dem.noint <- ESS.no.nas %>% 
  nest(data = -cntry.round) %>% 
  mutate(resp = map(data, ~ glm(formula = model.dem.noint, 
                                data = .x, 
                                family = "binomial")),
         tidy.resp = map(resp, glance), 
         model = "Demographics only no interaction")   %>% 
  unnest(tidy.resp) %>% 
  mutate(pseudo.r2 = 1 - deviance/null.deviance) |> 
  select(model, cntry.round, nobs, logLik, AIC, pseudo.r2) 


summary.model.intobs <- ESS.no.nas %>% 
  nest(data = -cntry.round) %>% 
  mutate(resp = map(data, ~ glm(formula = model.intobs, 
                                data = .x, 
                                family = "binomial")),
         tidy.resp = map(resp, glance), 
         model = "Int obs only with interaction")   %>% 
  unnest(tidy.resp) %>% 
  mutate(pseudo.r2 = 1 - deviance/null.deviance) |> 
  select(model, cntry.round, nobs, logLik, AIC, pseudo.r2)  




bind_rows(summary.model.intobs.noint, summary.model.intobs,
          summary.model.intobs.noint.noaccess) %>% 
  # mutate(cntry.round = str_replace_all(cntry.round, c("BE" = "Belgium",
  #                                                     "CH" = "Switzerland",
  #                                                     "DK" = "Denmark",
  #                                                     "EE" = "Estonia",
  #                                                     "FI" = "Finland",
  #                                                     "SI" = "Slovenia"))) %>%
  gt::gt() %>% 
  cols_label(.list = c("model" = "Model", 
                       "cntry.round" = "Country-round",
                       "nobs" = "N")) %>% 
  gtsave(filename = "Tables/model_summaries.docx", inline_css = TRUE)







coefs.model.dem.sim1 <- contacts.early.attempts %>% 
  nest(data = -cntry.round) %>% 
  mutate(resp = map(data, ~ glm(formula = model.dem.sim1, 
                                data = .x, 
                                family = "binomial")),
         tidy.resp = map(resp, tidy),
         model = "Model 1")   %>% 
  unnest(tidy.resp) 


coefs.model.full.sim1 <- contacts.early.attempts %>% 
  nest(data = -cntry.round) %>% 
  mutate(resp = map(data, ~ glm(formula = model.full.sim1, 
                                data = .x, 
                                family = "binomial")),
         tidy.resp = map(resp, tidy),
         model = "Model 2")   %>% 
  unnest(tidy.resp) 


coefs.model.dem.sim2 <- contacts.early.attempts %>% 
  nest(data = -cntry.round) %>% 
  mutate(resp = map(data, ~ glm(formula = model.dem.sim2, 
                                data = .x, 
                                family = "binomial")),
         tidy.resp = map(resp, tidy),
         model = "Model 3")   %>% 
  unnest(tidy.resp) 


coefs.model.full.sim2 <- contacts.early.attempts %>% 
  nest(data = -cntry.round) %>% 
  mutate(resp = map(data, ~ glm(formula = model.full.sim2, 
                                data = .x, 
                                family = "binomial")),
         tidy.resp = map(resp, tidy),
         model = "Model 4")   %>% 
  unnest(tidy.resp) 



bind_rows(coefs.model.dem.sim1, coefs.model.full.sim1, coefs.model.dem.sim2, coefs.model.full.sim2) %>% 
  mutate(estimate  = round(estimate, 3),
         p.value   = round(p.value, 3),
         statistic = round(statistic, 3),
         std.error = round(std.error, 3)) %>% 
  mutate(term = case_when(term == "(Intercept)" ~ "Constant",
                          term == "multi.unitMulti-unit" ~ "Multi-unit",
                          term == "neighbOne or more" ~ "One or more undesirable neighb. char.",
                          term == "no.accessBarriers" ~ "One or more barriers to access",
                          term == "gndr_suMale" ~ "Male",
                          term == "age_cat35-49" ~ "Age 35-49",
                          term == "age_cat50-64" ~ "Age 50-64",
                          term == "age_cat65+" ~ "Age 65+",
                          term == "attempt" ~ "Number of contact attempts",
                          term == "multi.unitMulti-unit:neighbOne or more" ~ "Multi-unit*Neighbourhood characteristics",
                          term == "gndr_suMale:age_cat35-49" ~ "Male*Age 35-49",
                          term == "gndr_suMale:age_cat50-64" ~ "Male*Age 50-64",
                          term == "gndr_suMale:age_cat65+" ~ "Male*Age 65+")) %>% 
  mutate(signif = gtools::stars.pval(p.value)) %>% 
  mutate(cntry.round = str_replace_all(cntry.round, c("BE" = "Belgium",
                                                      "CH" = "Switzerland",
                                                      "DK" = "Denmark",
                                                      "EE" = "Estonia",
                                                      "FI" = "Finland",
                                                      "SI" = "Slovenia"))) %>% 
  filter(p.value < 0.05) %>%
  select(-data, -resp) %>%
  relocate(model) %>% 
  gt::gt() %>% 
  cols_label(.list = c(
    "model" = "Model",
    "cntry.round" = "Country-round",
    "term" = "Term",
    "estimate" = "Estimate",
    "std.error" = "SE",
    "statistic" = "Statistic",
    "p.value" = "p",
    "signif" = "")) %>% 
  gtsave(filename = "coefs_regression_models.docx", inline_css = TRUE)


