# Download data for ESS rounds 1-10, save these in folder /Data

# ESS contact form data https://www.europeansocialsurvey.org/data/download_contact_form.html
# ESS survey data https://ess-search.nsd.no

# Load packages
library("here")
library("tidyverse")
library("janitor")
library("haven")
library("lubridate")
library("labelled")
library("gt")
library("scales")
library("patchwork")
library("gridExtra")
library("broom")
library("lme4")
library("modelsummary")
library("lmerTest")
library("robustlmm")
library("sjPlot")
library("haven")
library("performance")
library("rstatix")
library("gtsummary")



# 1. Clean the data and create the dataset contacts.Rdata which will be used in the analysis

# source(here::here("01_contact_data.R")) OR
ESS <- readRDS(here("Data", "ESS_contacts_1_10.Rdata"))

# 2. Get R-indicator functions from the RISQ project

source(here::here("R-Indicator RISQ.R"))

# 3. Set seed

set.seed(12345)

# 4. Select country-round combinations which meet eligibility criteria

source(here::here("02_country_round_selection.R"))

# 5. Compute R-indicators using three different response propensity models

source(here::here("03_R_indicators.R"))

# 6. Fit MLM for change using interviewer observations only 

source(here::here("04_mlm_change.R"))

# 7. Merge survey data, from scratch or load data 

#source(here::here("05_survey_data.R")) # OR load data directly
ESS.survey.contact <- readRDS(here("Data", 
        "ESS_survey_and_contact_data.Rdata"))

# 8. Explore relationship between interviewer observations and target variables

source(here::here("06_intobs_targetvars.R"))

# 9. Figures

source(here::here("07_tables.R"))


# 10. Tables

source(here::here("08_figures.R"))









