# Table 1. Descriptive statistics for ESS rounds 1-10 (complete cases (individual or household sample frame types), unweighted sample).*


descriptives <- ESS.int.obs %>% 
  select(multi.unit, neighb, typesamp2, gndr_su, age_cat, interview_fct) %>% 
  mutate_if(is_logical, as.factor)

tbl_summary(descriptives, 
            by = interview_fct,
            percent = "row",
) %>% 
  add_p() %>% 
  add_overall() %>%
  bold_labels() %>% 
  as_gt() %>% 
  gtsave(here("Tables", "table_1_descriptives.rtf"))


# Appendix Table 3. Descriptive statistics, unweighted sample.

descriptives.appendix <- ESS.no.nas %>% select(multi.unit , vandalism , litter , physa.2  ,
                                      neighb ,  typesamp2 ,  gndr_su , age_cat , interview_fct) %>% 
  mutate_if(is_logical, as.factor)

tbl_summary(descriptives.appendix, 
            by = interview_fct,
            percent = "row",
) %>% 
  add_p() %>% 
  add_overall() %>%
  bold_labels() %>% 
  as_gt() %>% 
  gtsave(here("Tables", "appendix_table_3_descriptives.rtf"))




ESS.no.nas %>% 
  select(multi.unit, neighb ,  typesamp2 ,  gndr_su , age_cat , interview_fct) %>% 
  mutate_if(is_logical, as.factor)

tbl_summary(descriptives, 
            by = interview_fct,
            percent = "row",
) %>% 
  add_p() %>% 
  add_overall() %>%
  bold_labels() %>% 
  as_gt()


# Appendix table 6 - Design weights variation

ESS.survey.contact.analysed |> 
  group_by(cntry.full) |> 
  summarise(median.dw = round(median(dweight), 3),
            sd.dw = round(sd(dweight), 3),
            min.dw = round(min(dweight), 3),
            max.dw = round(max(dweight), 3)) |> 
  gt() |>  
  gtsave(here("Tables", "appendix_table_6_dweights.rtf"))


# Appendix table 5 - Missing data



missing.data.table <- ESS %>% 
  mutate_if(is.labelled, to_factor)  %>% 
  mutate(gndr_su = fct_drop(gndr_su),
         interview_fct = as.factor(interview),
         interview_fct = if_else(interview_fct == "TRUE", "Interview", "No interview")) %>% 
  group_by(cntry.round) %>% 
  summarize(n = n(),
            interva789 = interva == "Blocked cases or sample unit refusal before first contact" | 
              interva == "No contact made - error of field organization" | 
              interva == "Not available",
            interview_na = ifelse(interva789 == T | is.na(interva), TRUE, FALSE),
            interva.na.prop = interview_na / n,
            interview.sum = sum(interview, na.rm = T),
            response.rate = interview.sum / n,
            typesamp2 = typesamp2,
            gndr.na = sum(is.na(gndr_su)),
            gndr.na.prop = gndr.na / n,
            age.na = sum(is.na(age50)),
            age.na.prop = age.na / n,
            multi.unit.na = sum(is.na(multi.unit)),
            multi.unit.na.prop = multi.unit.na / n,
            neighb.na = sum(is.na(neighb)),
            neighb.na.prop = neighb.na / n,
            sum.na = gndr.na + age.na + neighb.na + multi.unit.na,
            prop.na = sum.na / n) %>%
  select(cntry.round, n, typesamp2, response.rate, ends_with(".na.prop")) %>% 
  mutate(across(ends_with(".na.prop"), ~pct(round(., 3) * 100)))  %>% 
  mutate(across(response.rate, ~pct(round(., 3) * 100))) %>%  
  group_by(cntry.round) %>% 
  filter(row_number() == 1) %>% 
  ungroup()


missing.data.table.no.nas <- ESS.int.obs %>% 
  group_by(cntry.round) %>% 
  summarize(n = n(),
            interview.sum = sum(interview),
            response.rate.no.nas = interview.sum / n) %>% 
  mutate(response.rate.no.nas = pct(round(response.rate.no.nas, 3) * 100))


missing.data.table %>% 
  left_join(missing.data.table.no.nas, 
            by = c("cntry.round")) %>% 
  select(-interview.sum) %>% 
  select(cntry.round, typesamp2, n.x, response.rate, n.y, response.rate.no.nas, interva.na.prop, multi.unit.na.prop,
         neighb.na.prop, gndr.na.prop, age.na.prop) %>% 
  gt()  %>% 
  cols_label(
    cntry.round = "Country-round",
    typesamp2 = "Type of sample",
    n.x = "N",
    response.rate = "Response rate",
    n.y = "N analysed (missing cases removed)",
    response.rate.no.nas = "RR analysed (missing cases removed)",
    interva.na.prop	 = "Missing %: Interview",
    gndr.na.prop = "Missing %: Gender",
    age.na.prop = "Missing %: Age",
    multi.unit.na.prop = "Missing %: Multi-unit",
    neighb.na.prop = "Missing %: Neighbourhood characteristics"
  ) %>%
  gtsave(filename = 
    here("Tables", "appendix_table_5_missing_data_table.rtf"))


# Appendix table 5 R-indicator comparisons

r.int.table <- R.int.obs6_10 %>%
  arrange(as.character(cntry.full), round) %>%
  select(cntry.round, R, RSE) |> 
  mutate(R = round(R, 3),
         RSE = round(RSE, 3),
  )

r.full.table <- R.full %>%
  arrange(as.character(cntry.full), round) %>%
  select(cntry.round, R, RSE) |> 
  mutate(R = round(R, 3),
         RSE = round(RSE, 3),
  )

r.int.table %>% 
  left_join(r.full.table, by = "cntry.round") %>% 
  gt() %>% 
  cols_label(
    R.x = "R-indicator (Int. obs.)",
    RSE.x = "RSE (Int. obs.)",
    R.y = "R-indicator (Full model)",
    RSE.y = "RSE (Full model)"
  ) %>%
  gtsave(filename = here("Tables", 
      "appendix_table_5_r_by_model.rtf"))








