selectvars.survey <- c("essround", "cntry","idno", "dweight", 
                       "pspweight", "pweight", "anweight",
                       "domain", "prob", "stratum", "psu", 
                       "ppltrst", "hinctnta",  "eduyrs")



ESS1S <- read_sav(here::here("Data/ESS1e06_6.sav"))  %>% 
  select_if(names(.) %in% selectvars.survey)  %>% 
  mutate(cntry = as.factor(cntry)) %>% 
  mutate_if(is.labelled, to_factor) %>% 
  filter()

ESS2S <- read_sav(here::here("Data/ESS2e03_6.sav"))  %>% 
  select_if(names(.) %in% selectvars.survey)  %>% 
  mutate(cntry = as.factor(cntry)) %>% 
  mutate_if(is.labelled, to_factor)

ESS3S <- read_sav(here::here("Data/ESS3e03_7.sav"))  %>% 
  select_if(names(.) %in% selectvars.survey)  %>% 
  mutate(cntry = as.factor(cntry)) %>% 
  mutate_if(is.labelled, to_factor)

ESS4S <- read_sav(here::here("Data/ESS4e04_5.sav"))  %>% 
  select_if(names(.) %in% selectvars.survey)  %>% 
  mutate(cntry = as.factor(cntry)) %>% 
  mutate_if(is.labelled, to_factor)

ESS5S <- read_sav(here::here("Data/ESS5e03_4.sav"))  %>% 
  select_if(names(.) %in% selectvars.survey)  %>% 
  mutate(cntry = as.factor(cntry)) %>% 
  mutate_if(is.labelled, to_factor)

ESS6S <- read_sav(here::here("Data/ESS6e02_4.sav"))  %>% 
  select_if(names(.) %in% selectvars.survey)  %>% 
  mutate(cntry = as.factor(cntry)) %>% 
  mutate_if(is.labelled, to_factor)

ESS7S <- read_sav(here::here("Data/ESS7e02_2.sav"))  %>% 
  select_if(names(.) %in% selectvars.survey)  %>% 
  mutate(cntry = as.factor(cntry)) %>% 
  mutate_if(is.labelled, to_factor)

ESS8S <- read_sav(here::here("Data/ESS8e02_2.sav"))  %>% 
  select_if(names(.) %in% selectvars.survey)  %>% 
  mutate(cntry = as.factor(cntry)) %>% 
  mutate_if(is.labelled, to_factor)

ESS9S <- read_sav(here::here("Data/ESS9e03_1.sav"))  %>% 
  select_if(names(.) %in% selectvars.survey)  %>% 
  mutate(cntry = as.factor(cntry)) %>% 
  mutate_if(is.labelled, to_factor)


ESS10S <- read_sav(here::here("Data/ESS10.sav"))  %>% 
  select_if(names(.) %in% selectvars.survey)  %>% 
  select(-domain) %>% 
  mutate(cntry = as.factor(cntry)) %>% 
  mutate_if(is.labelled, to_factor)




ESS.survey.data <- bind_rows(ESS1S, ESS2S, ESS3S, 
                             ESS4S, ESS5S, ESS6S,
                             ESS7S, ESS8S, ESS9S, ESS10S,
                             .id = "round") 



ESS.survey.contact <- ESS.survey.data %>% 
  left_join(ESS, by = c("essround", "cntry", "idno")) 




saveRDS(ESS.survey.contact, here("Data", "ESS_survey_and_contact_data.Rdata"))

        