/*******Rutgers NYAHS*************/

options nofmterr;

/******************DATA EXTRACTIO AND PREPARATION****************************
****************************************************************************/

*Keeping Wave 1 Completes for analyses;
proc import out=w1 dbms=csv replace
	datafile="Y:\RUTGERS\70 - Deliveries\RutgersMainWave1_Final\RutgersMainWave1_1-15-21.csv";
run;

*appending mode variable;
proc import out=w1mode (keep=RpsRespondent_ReplaceWithBASEID mode) dbms=csv replace
	datafile="Y:\RUTGERS\60 - Data Cleaning-Mgmt\Deliveries\W1 Delivery\Final redelivery August 2020\FINAL FILES JON\w1 main_redelivery_20200804.csv";
run;

proc sql;
	create table w1a as
	select w.*, m.mode
	from w1 as w right join w1mode as m
	on w.RpsRespondent=m.RpsRespondent_ReplaceWithBASEID;
quit;

data w1b;
set w1a;

w1_mode=mode;

****************outcomes for nonresponse bias analysis;
***ever use;
if a1a in (-7, -8) and a2a in (-7, -8) then cigarette_ever=.;
else if a1a=0 and a2a=2 then cigarette_ever=0;
else cigarette_ever=1;

if b1 in (-7, -8) then ecig_ever=.;
else if b1=1 then ecig_ever=1;
else if b1=2 then ecig_ever=0;

if c1 in (-7, -8) then cigar_ever=.;
else if c1=1 then cigar_ever=1;
else if c1=2 then cigar_ever=0;

if x2 in (-7, -8) then marijuana_ever=.;
else if x2=1 then marijuanna_ever=1;
else if x2=2 then marijuanna_ever=0;

***current use;
if a2a in (-7, -8) and a2b in (-7, -8) then cigarette_current=.;
else if a2a=1 and a2b in (1,2) then cigarette_current=1;
else cigarette_current=0;

if b1 in (-7, -8) then ecig_current=.;
else if b1=2 then ecig_current=0;
else do;
	if b3 in (-7, -8) and b4 in (-7, -8) then ecig_current=.;
	else if b3=1 and b4 in (1,2) then ecig_current=1;
	else ecig_current=0;
end;

if c1 in (-7, -8,-9,.) then cigar_current=.;
else if c1=2 then cigar_current=0;
else do;
	if c3 in (-7, -8) and c4 in (-7, -8) then cigar_current=.;
	else if c3=1 and c4 in (1,2) then cigar_current=1;
	else cigar_current=0;
end;

***past 30 days use;
if x1 in (-7, -8) then alcohol_past30days=.;
else if x1=1 then alcohol_past30days=1;
else if x1=2 then alcohol_past30days=0;

if x2 in (-7, -8) or x3 in (-7, -8) then marijuanna_past30days=.;
else if x2=2 or x3=2 then marijuanna_past30days=0;
else if x2=1 and x3=1 then marijuanna_past30days=1;

keep baseid RpsRespondent quextype w1_mode
cigarette_ever cigarette_current ecig_ever ecig_current cigar_ever cigar_current
marijuanna_ever marijuanna_past30days alcohol_past30days;
run;

*W1 follow-up compltes;
proc import out=w1fu dbms=csv replace
	datafile="Y:\RUTGERS\60 - Data Cleaning-Mgmt\Deliveries\W1 Follow Up Delivery\W1 Follow Up Re-Delivery Aug 2020\FINAL FILES FOR JON\NYAHS Wave 1 Follow-up data_redelivery_20200804.csv";
run;

data w1fu2;
set w1fu;
w1fu_comp=1;
w1fu_mode=mode;

keep w1fu_comp w1fu_mode RpsRespondent_CASIID_ReplaceWith;
run;
proc contents varnum; run;

*put in baseid for phone cases;
proc import out=w1fu_cati dbms=xlsx replace
	datafile="Y:\RUTGERS\60 - Data Cleaning-Mgmt\Deliveries\W1 Follow Up Delivery\W1 Follow Up Re-Delivery Aug 2020\Working files\Rutgers_fu_cati_int_all_20200722_withquextype.xlsx";
run;

data w1fu_cati2;
set w1fu_cati;
RpsRespondent2=RpsRespondent*1;
baseid2=baseid*1;
keep RpsRespondent RpsRespondent2 baseid baseid2; 
run;
proc sql;
	create table w1fu3 as
	select w.*, c.baseid2
	from w1fu2 as w left join w1fu_cati2 as c
	on w.RpsRespondent_CASIID_ReplaceWith=c.rpsrespondent2;
quit;

data w1fu3a;
set w1fu3;
if baseid2=. then baseid2=RpsRespondent_CASIID_ReplaceWith;
run;

*appending w1fu to w1;
proc sql;
	create table two as
	select w.*, f.w1fu_mode, f.w1fu_comp
	from w1b as w left join w1fu3a as f
	on w.baseid =f.baseid2;
quit;

*pulling w2 information;
proc import out=w2 dbms=csv replace
	datafile="Y:\RUTGERS\70 - Deliveries\Wave 2\nyahs wave 2 main data 1-15-21.csv";
run;
data w2a;
set w2;
w2_mode=mode;
w2_comp=1;

keep baseid w2_comp w2_mode ;
run;
proc sql;
	create table three as
	select a.*, w.w2_comp, w.w2_mode
	from two as a left join w2a as w
	on a.baseid=w.baseid;
quit;

*pulling w2 followup;
proc import out=fu2 dbms=csv replace
	datafile="Y:\RUTGERS\60 - Data Cleaning-Mgmt\Deliveries\W2 Follow Up Delivery\final files for Jon\nyahs wave 2 follow up data.csv";
quit;
data fu2a;
set fu2;

w2fu_comp=1;
w2fu_mode=mode;

keep baseid w2fu_comp w2fu_mode ;
run;

proc sql;
	create table four as
	select a.*, w.w2fu_comp, w.w2fu_mode
	from three as a left join fu2a as w
	on a.baseid=w.baseid;
quit;


***pulling information from W3;
PROC import out=w3 DBMS=xlsx REPLACE
	dataFILE="U:\Rutgers NYAHS\wave 3 results 2-2-2022.xlsx";
RUN;

proc sort data=four; by baseid; run;
proc sort data=w3; by baseid; run;

data five;
merge four (in=aa) w3 (in=bb);
by baseid; 
if aa and bb then merged=1;*n=804;
else if aa and ^bb then merged=2; *n=27;
else if ^aa and bb then merged=3;

if resCodeResult="C1" then w3_comp=1;
else w3_comp=0;

if w1fu_comp=. then w1fu_comp=0;
if w2_comp=. then w2_comp=0;
if w2fu_comp=. then w2fu_comp=0;


run;

**********completion rates comparisons;
proc freq data=five; table quextype*w1fu_comp/chisq; run;
proc freq data=five; table quextype*w1fu_comp/chisq; where quextype in (1,3); run;
proc freq data=five; table quextype*w1fu_comp/chisq; where quextype in (1,2); run;
proc freq data=five; table quextype*w1fu_comp/chisq; where quextype in (2,3); run;

proc freq data=five; table quextype*w2_comp/chisq; run;
proc freq data=five; table quextype*w2_comp/chisq; where quextype in (1,3); run;
proc freq data=five; table quextype*w2_comp/chisq; where quextype in (1,2); run;
proc freq data=five; table quextype*w2_comp/chisq; where quextype in (2,3); run;


proc freq data=five; table quextype*w2fu_comp/chisq; run;
proc freq data=five; table quextype*w2fu_comp/chisq; where quextype in (1,3); run;
proc freq data=five; table quextype*w2fu_comp/chisq; where quextype in (1,2); run;
proc freq data=five; table quextype*w2fu_comp/chisq; where quextype in (2,3); run;

proc freq data=five; table quextype*w3_comp/chisq; run;
proc freq data=five; table quextype*w3_comp/chisq; where quextype in (1,3); run;
proc freq data=five; table quextype*w3_comp/chisq; where quextype in (1,2); run;
proc freq data=five; table quextype*w3_comp/chisq; where quextype in (2,3); run;


*********nonrepsonse bias;

*W1 unweighted estimates;
proc means data=five mean ;
class quextype;
var cigarette_ever cigarette_current ecig_ever ecig_current cigar_ever cigar_current
marijuanna_ever marijuanna_past30days alcohol_past30days;
output out=out2 (where=(_stat_="MEAN" and _Type_=1) ) ;
run;
proc transpose data=out2 (drop=_type_ _freq_ _stat_) out=w1bias (rename=(col1=w1est));
by quextype;
run;

*unweighted estimates for w1fu completes;
proc means data=five mean ;
class quextype;
var cigarette_ever cigarette_current ecig_ever ecig_current cigar_ever cigar_current
marijuanna_ever marijuanna_past30days alcohol_past30days;
where w1fu_comp=1;
output out=out2 (where=(_stat_="MEAN" and _Type_=1) ) ;
run;
proc transpose data=out2 (drop=_type_ _freq_ _stat_) out=w1fubias (rename=(col1=w1fuest));
by quextype;
run;

*unweighted estimates for w2 completes;
proc means data=five mean ;
class quextype;
var cigarette_ever cigarette_current ecig_ever ecig_current cigar_ever cigar_current
marijuanna_ever marijuanna_past30days alcohol_past30days;
where w2_comp=1;
output out=out2 (where=(_stat_="MEAN" and _Type_=1) ) ;
run;
proc transpose data=out2 (drop=_type_ _freq_ _stat_) out=w2bias (rename=(col1=w2est));
by quextype;
run;

*unweighted estimates for w2fu completes;
proc means data=five mean ;
class quextype;
var cigarette_ever cigarette_current ecig_ever ecig_current cigar_ever cigar_current
marijuanna_ever marijuanna_past30days alcohol_past30days;
where w2fu_comp=1;
output out=out2 (where=(_stat_="MEAN" and _Type_=1) ) ;
run;
proc transpose data=out2 (drop=_type_ _freq_ _stat_) out=w2fubias (rename=(col1=w2fuest));
by quextype;
run;

*unweighted estiamtes for w3 completes;
proc means data=five mean ;
class quextype;
var cigarette_ever cigarette_current ecig_ever ecig_current cigar_ever cigar_current
marijuanna_ever marijuanna_past30days alcohol_past30days;
where w3_comp=1;
output out=out3 (where=(_stat_="MEAN" and _Type_=1) ) ;
run;
proc transpose data=out3 (drop=_type_ _freq_ _stat_) out=w3bias (rename=(col1=w3est));
by quextype;
run;

proc sort data=w1bias; by quextype _NAME_; run;
proc sort data=w1fubias; by quextype _NAME_; run;
proc sort data=w2bias; by quextype _NAME_; run;
proc sort data=w2fubias; by quextype _NAME_; run;
proc sort data=w3bias; by quextype _NAME_; run;

data bias;
merge w1bias w1fubias w2bias w2fubias w3bias;
by quextype _NAME_; 
*w1fu bias;
w1fu_bias=w1fuest-w1est;
w1fu_bias_rel=abs(w1fu_bias/w1est);
*w2 bias;
w2_bias=w2est-w1est;
w2_bias_rel=abs(w2_bias/w1est);
*w2fu bias;
w2fu_bias=w2fuest-w1est;
w2fu_bias_rel=abs(w2fu_bias/w1est);
*w3 bias;
w3_bias=w3est-w1est;
w3_bias_rel=abs(w3_bias/w1est);
run;	
proc print; run;

*output data for depository;
libname dd "U:\Rutgers NYAHS";

data dd.NYAHS_Mode_paper;
set five;
drop merged resCodeResult RpsRespondent; 
run;
proc contents varnum; run;
