/* Effect of public shutdown in waves 8 and 9 on response 
* Public shutdown in 2020: 16. März 2021 - 10. Mai 2020; 
Public shutdown in 2021: 18. Januar 2021 - 19. April 2021 bzw. 31. Mai 2021 */

version 17
set more off, perm
clear all
macro drop _all
set linesize 132
capture log close

/* Figure 1 */
* Wave 7 & 8
use "spW78.dta", clear
sort code newid  

stset partdur if welle==7 , failure(crcen==1) id(newid)
streg t1-t28, dist(exp) nohr 
predict CAWI , hazard
line CAWI _t , sort  
drop CAWI

stset partdur if welle==8 , failure(crcen==1) id(newid)
streg t1-t28, dist(exp) nohr 
predict CAWI , hazard
line CAWI _t , sort  
drop CAWI

* Wave 9
use "spW9.dta" , clear
sort code newid 

stset partdur , failure(partcen==1) id(newid)
stsplit time , at(0 (1) max)
tab time , ge(t)

streg t1-t28 , dist(exp) nohr 
predict CAWI, hazard
line CAWI _t , sort

gr combine "GraphHR_W7.gph"  "GraphHR_W8.gph"  "GraphHR_W9.gph" , row(1)


* Analysen für Wellen 8 und 9 - Table 1
use "w89-covid.dta" , clear
sort teilnehmercode newid ts psdate

stset tf  if gender != . , failure(cen) id(newid)

* Multivariate Analyses - Table 1
* Model 1
streg ib9.welle Lockdown casesprotag hospitalisationenprotag TodesfälleproTag  ib7.hh_egp_mv ib4.sektyp9_mv zdemark9 ib1.gender , distribution(exp) nohr 

* Model 2 & 3
use "w789-Lockdown.dta", clear
stset tf if gender != .   , failure(cen) id(newid)

streg ib9.welle Lockdown casesprotag hospitalisationenprotag TodesfälleproTag  ib7.hh_egp_mv ib4.sektyp9_mv zdemark9 ib1.gender , distribution(exp) nohr 

streg ib9.welle Lockdown ib7.hh_egp_mv ib4.sektyp9_mv zdemark9 ib1.gender , distribution(exp) nohr 

/* EOF */
