﻿* Encoding: UTF-8.
***SPSS syntax for replicating the results by Höhne, Krebs, and Kühnel "Investigating direction effects in rating scales with five and seven points in a probability-based online panel" published in Survey Research Methods. 

***ID variable.
compute id=id_g.
fre id id_g.
   
***Group variable.
recode expZF42145 (1=1) (2=2) (3=3) (4=4) (-90=9) into group.
value labels group 1'decremental 5p' 2'incremental 5p' 3'decremental 7p' 4'incremental 7p' 9'k.A.'.
missing values group (9).
fre group.

***Sample characteristics.
***Age.
MISSING VALUES year_of_birth_cat_18 (-80,-90).
fre year_of_birth_cat_18.
***Gender.
MISSING VALUES gender_18 (-80,-90).
fre gender_18.
***School education.
recode  educ_school_18 (3=1) (4=2) (5,6=3) (1,2,7=4) into educ.
variable labels educ 'Education'.
value labels educ 1'lower secondary' 2'intermediate secondary' 3'college prep or univ' 4'other'.
fre educ.

***Recode variables from decremental to incremental (5 points).
recode ZF42145 to ZF42156 (5=1) (4=2) (3=3) (2=4) (1=5) (-90=8) (sysmis=9) into rZF42145 to rZF42156.
fre rZF42145 to rZF42156. 
missing values rZF42145 to rZF42156 (8,9).
fre  rZF42145 to rZF42156. 

***Missing values for incremental variables (5 points).
missing values ZF42157 to ZF42168 (8,9).
fre ZF42157 to ZF42168.

***Recode variables from decremental to incremental (7 points).
recode ZF42169 to ZF42180 (7=1) (6=2) (5=3) (4=4) (3=5) (2=6) (1=7) (-90=8) (sysmis=9) into
         rZF42169 to rZF42180.
missing values rZF42169 to rZF42180 (8,9).
fre rZF42169 to rZF42180.

***Missing values for incremental variables (7 points).
missing values ZF42181 to ZF42192 (8,9).
fre ZF42181 to ZF42192.

***IMPORTANT: The order of the achievement/intrinsic/extrinsic variables is not consistently ongoing from 1.

***Fusing achievement variables with decremental and incremental scales (5 points).
compute v11_5=rZF42145.
if (rZF42145 ge 1) and (group eq 1) rZF42145=v11_5.
fre rZF42145 v11_5.
if (ZF42157 ge 1) and (group eq 2) v11_5=ZF42157.
fre ZF42157 v11_5.
recode v11_5 (sysmis=9).
value labels v11_5 1'1 Applies not at al' 2'2'  3'3' 4'4'  5'5 Applies completely' 9'Does not apply'.
missing values v11_5 (9).
fre v11_5.
compute v12_5=rZF42146.
if (rZF42146 ge 1 and group eq 1) rZF42146=v12_5.
fre rZF42146 v12_5.
if (ZF42158 ge 1 and group eq 2) v12_5=ZF42158.
fre ZF42158 v12_5.
recode v12_5 (sysmis=9).
value labels v12_5 1'1 Applies not at al' 2'2'  3'3' 4'4'  5'5 Applies completely' 9'Does not apply'.
missing values v12_5 (9).
fre v12_5.
compute v13_5=rZF42147.
if (rZF42147 ge 1 and group eq 1) rZF42147=v13_5.
fre rZF42147 v13_5.
if (ZF42159 ge 1 and group eq 2) v13_5=ZF42159.
fre ZF42159 v13_5.
recode v13_5 (sysmis=9).
value labels v13_5 1'1 Applies not at al' 2'2'  3'3' 4'4'  5'5 Applies completely' 9'Does not apply'.
missing values v13_5 (9).
fre v13_5.
compute v14_5=rZF42148.
if (rZF42148 ge 1 and group eq 1) rZF42148=v14_5.
fre rZF42148 v14_5.
if (ZF42160 ge 1 and group eq 2) v14_5=ZF42160.
fre ZF42160 v14_5.
recode v14_5 (sysmis=9).
value labels v14_5 1'1 Applies not at al' 2'2'  3'3' 4'4'  5'5 Applies completely' 9'Does not apply'.
missing values v14_5 (9).
fre v14_5.
compute v16_5=rZF42149.
if (rZF42149 ge 1 and group eq 1) rZF42149=v16_5.
fre rZF42149 v16_5.
if (ZF42161 ge 1 and group eq 2) v16_5=ZF42161.
fre ZF42161 v16_5.
recode v16_5 (sysmis=9).
value labels v16_5 1'1 Applies not at al' 2'2'  3'3' 4'4'  5'5 Applies completely' 9'Does not apply'.
missing values v16_5 (9).
fre v16_5.

***Fusing intrinsic variables with decremental and incremental scales (5 points).
compute v25_5=rZF42150.
if (rZF42150 ge 1 and group eq 1) rZF42150=v25_5.
fre rZF42150 v25_5.
if (ZF42162 ge 1 and group eq 2) v25_5=ZF42162.
fre ZF42162 v25_5.
recode v25_5 (sysmis=9).
value labels v25_5 1'1 Applies not at al' 2'2'  3'3' 4'4'  5'5 Applies completely' 9'Does not apply'.
missing values v25_5 (9).
fre v25_5.
compute v26_5=rZF42151.
if (rZF42151 ge 1 and group eq 1) rZF42151=v26_5.
fre rZF42151 v26_5.
if (ZF42163 ge 1 and group eq 2) v26_5=ZF42163.
fre ZF42163 v26_5.
recode v26_5 (sysmis=9).
value labels v26_5 1'1 Applies not at al' 2'2'  3'3' 4'4'  5'5 Applies completely' 9'Does not apply'.
missing values v26_5 (9).
fre v26_5.
compute v27_5=rZF42152.
if (rZF42152 ge 1 and group eq 1) rZF42152=v27_5.
fre rZF42152 v27_5.
if (ZF42164 ge 1 and group eq 2) v27_5=ZF42164.
fre ZF42164 v27_5.
recode v27_5 (sysmis=9).
value labels v27_5 1'1 Applies not at al' 2'2'  3'3' 4'4'  5'5 Applies completely' 9'Does not apply'.
missing values v27_5 (9).
fre v27_5.
compute v28_5=rZF42153.
if (rZF42153 ge 1 and group eq 1) rZF42153=v28_5.
fre rZF42153 v28_5.
if (ZF42165 ge 1 and group eq 2) v28_5=ZF42165.
fre ZF42165 v28_5.
recode v28_5 (sysmis=9).
value labels v28_5 1'1 Applies not at al' 2'2'  3'3' 4'4'  5'5 Applies completely' 9'Does not apply'.
missing values v28_5 (9).
fre v28_5.

***Fusing extrinsic variables with decremental and incremental scales (5 points).
compute v21_5=rZF42154.
if (rZF42154 ge 1 and group eq 1) rZF42154=v21_5.
fre rZF42154 v21_5.
if (ZF42166 ge 1 and group eq 2) v21_5=ZF42166.
fre ZF42166 v21_5.
recode v21_5 (sysmis=9).
value labels v21_5 1'1 Applies not at al' 2'2'  3'3' 4'4'  5'5 Applies completely' 9'Does not apply'.
missing values v21_5 (9).
fre v21_5.
compute v22_5=rZF42155.
if (rZF42155 ge 1 and group eq 1) rZF42155=v22_5.
fre rZF42155 v22_5.
if (ZF42167 ge 1 and group eq 2) v22_5=ZF42167.
fre ZF42167 v22_5.
recode v22_5 (sysmis=9).
value labels v22_5 1'1 Applies not at al' 2'2'  3'3' 4'4'  5'5 Applies completely' 9'Does not apply'.
missing values v22_5 (9).
fre v22_5.
compute v23_5=rZF42156.
if (rZF42156 ge 1 and group eq 1) rZF42156=v23_5.
fre rZF42156 v23_5.
if (ZF42168 ge 1 and group eq 2) v23_5=ZF42168.
fre ZF42168 v23_5.
recode v23_5 (sysmis=9).
value labels v23_5 1'1 Applies not at al' 2'2'  3'3' 4'4'  5'5 Applies completely' 9'Does not apply'.
missing values v23_5 (9).
fre v23_5.

***Fusing achievement variables with decremental and incremental scales (7 points).
compute v11_7=rZF42169.
if (rZF42169 ge 1 and group eq 3) v11_7=rZF42169.
fre ZF42169 v11_7.
if (ZF42181 ge 1 and group eq 4) v11_7=ZF42181.
fre ZF42181 v11_7.
recode v11_7 (sysmis=9).
value labels v11_7 1'1 Applies not at all' 2'2' 3'3' 4'4' 5'5' 6'6' 7'7 Applies completely' 9'Does not apply'.
missing values v11_7 (9).
fre v11_7.
compute v12_7=rZF42170.
if (rZF42170 ge 1 and group eq 3) v12_7=rZF42170.
fre ZF42170 v12_7.
if (ZF42182 ge 1 and group eq 4) v12_7=ZF42182.
fre ZF42182 v12_7.
recode v12_7 (sysmis=9).
value labels v12_7 1'1 Applies not at all' 2'2' 3'3' 4'4' 5'5' 6'6' 7'7 Applies completely' 9'Does not apply'.
missing values v12_7 (9).
fre v12_7.
compute v13_7=rZF42171.
if (rZF42171 ge 1 and group eq 3) v13_7=rZF42171.
fre ZF42171 v13_7.
if (ZF42183 ge 1 and group eq 4) v13_7=ZF42183.
fre ZF42183 v13_7.
recode v13_7 (sysmis=9).
value labels v13_7 1'1 Applies not at all' 2'2' 3'3' 4'4' 5'5' 6'6' 7'7 Applies completely' 9'Does not apply'.
missing values v13_7 (9).
fre v13_7.
compute v14_7=rZF42172.
if (rZF42172 ge 1 and group eq 3) v14_7=rZF42172.
fre ZF42172 v14_7.
if (ZF42184 ge 1 and group eq 4) v14_7=ZF42184.
fre ZF42184 v14_7.
recode v14_7 (sysmis=9).
value labels v14_7 1'1 Applies not at all' 2'2' 3'3' 4'4' 5'5' 6'6' 7'7 Applies completely' 9'Does not apply'.
missing values v14_7 (9).
fre v14_7.
compute v16_7=rZF42173.
if (rZF42173 ge 1 and group eq 3) v16_7=rZF42173.
fre ZF42173 v16_7.
if (ZF42185 ge 1 and group eq 4) v16_7=ZF42185.
fre ZF42185 v16_7.
recode v16_7 (sysmis=9).
value labels v16_7 1'1 Applies not at all' 2'2' 3'3' 4'4' 5'5' 6'6' 7'7 Applies completely' 9'Does not apply'.
missing values v16_7 (9).
fre v16_7.

***Fusing intrinsic variables with decremental and incremental scales (7 points).
compute v25_7=rZF42174.
if (rZF42174 ge 1 and group eq 3) v25_7=rZF42174.
fre ZF42174 v25_7.
if (ZF42186 ge 1 and group eq 4) v25_7=ZF42186.
fre ZF42186 v25_7.
recode v25_7 (sysmis=9).
value labels v25_7 1'1 Applies not at all' 2'2' 3'3' 4'4' 5'5' 6'6' 7'7 Applies completely' 9'Does not apply'.
missing values v25_7 (9).
fre v25_7.
compute v26_7=rZF42175.
if (rZF42175 ge 1 and group eq 3) v26_7=rZF42175.
fre ZF42175 v26_7.
if (ZF42187 ge 1 and group eq 4) v26_7=ZF42187.
fre ZF42187 v26_7.
recode v26_7 (sysmis=9).
value labels v26_7 1'1 Applies not at all' 2'2' 3'3' 4'4' 5'5' 6'6' 7'7 Applies completely' 9'Does not apply'.
missing values v26_7 (9).
fre v26_7.
compute v27_7=rZF42176.
if (rZF42176 ge 1 and group eq 3) v27_7=rZF42176.
fre ZF42176 v27_7.
if (ZF42188 ge 1 and group eq 4) v27_7=ZF42188.
fre ZF42188 v27_7.
recode v27_7 (sysmis=9).
value labels v27_7 1'1 Applies not at all' 2'2' 3'3' 4'4' 5'5' 6'6' 7'7 Applies completely' 9'Does not apply'.
missing values v27_7 (9).
fre v27_7.
compute v28_7=rZF42177.
if (rZF42177 ge 1 and group eq 3) v28_7=rZF42177.
fre ZF42177 v28_7.
if (ZF42189 ge 1 and group eq 4) v28_7=ZF42189.
fre ZF42189 v28_7.
recode v28_7 (sysmis=9).
value labels v28_7 1'1 Applies not at all' 2'2' 3'3' 4'4' 5'5' 6'6' 7'7 Applies completely' 9'Does not apply'.
missing values v28_7 (9).
fre v28_7.

***Fusing extrinsic variables with decremental and incremental scales (7 points).
compute v21_7=rZF42178.
if (rZF42178 ge 1 and group eq 3) v21_7=rZF42178.
fre ZF42178 v21_7.
if (ZF42190 ge 1 and group eq 4) v21_7=ZF42190.
fre ZF42190 v21_7.
recode v21_7 (sysmis=9).
value labels v21_7 1'1 Applies not at all' 2'2' 3'3' 4'4' 5'5' 6'6' 7'7 Applies completely' 9'Does not apply'.
missing values v21_7 (9).
fre v21_7.
compute v22_7=rZF42179.
if (rZF42179 ge 1 and group eq 3) v22_7=rZF42179.
fre ZF42179 v22_7.
if (ZF42191 ge 1 and group eq 4) v22_7=ZF42191.
fre ZF42191 v22_7.
recode v22_7 (sysmis=9).
value labels v22_7 1'1 Applies not at all' 2'2' 3'3' 4'4' 5'5' 6'6' 7'7 Applies completely' 9'Does not apply'.
missing values v22_7 (9).
fre v22_7.
compute v23_7=rZF42180.
if (rZF42180 ge 1 and group eq 3) v23_7=rZF42180.
fre ZF42180 v23_7.
if (ZF42192 ge 1 and group eq 4) v23_7=ZF42192.
fre ZF42192 v23_7.
recode v23_7 (sysmis=9).
value labels v23_7 1'1 Applies not at all' 2'2' 3'3' 4'4' 5'5' 6'6' 7'7 Applies completely' 9'Does not apply'.
missing values v23_7 (9).
fre v23_7.

***Applying answers for decremental and incremental scales (5 points).
recode v11_5 v12_5 v13_5 v14_5 v16_5 v25_5 v26_5 v27_5 v28_5 v21_5 v22_5 v23_5 (4,5=1) (1,2,3=0) (9=9) into v11_5a v12_5a v13_5a v14_5a v16_5a v25_5a v26_5a v27_5a v28_5a v21_5a v22_5a v23_5a.
missing values v11_5a v12_5a v13_5a v14_5a v16_5a v25_5a v26_5a v27_5a v28_5a v21_5a v22_5a v23_5a (9).
fre v11_5a v12_5a v13_5a v14_5a v16_5a v25_5a v26_5a v27_5a v28_5a v21_5a v22_5a v23_5a.
***Non-Applying answers for decremental and incremental scales (5 point).
recode v11_5 v12_5 v13_5 v14_5 v16_5 v25_5 v26_5 v27_5 v28_5 v21_5 v22_5 v23_5 (1,2=1) (3,4,5=0) (9=9) into v11_5na v12_5na v13_5na v14_5na v16_5na v25_5na v26_5na v27_5na v28_5na v21_5na v22_5na v23_5na.
missing values v11_5na v12_5na v13_5na v14_5na v16_5na v25_5na v26_5na v27_5na v28_5na v21_5na v22_5na v23_5na (9).
fre v11_5na v12_5na v13_5na v14_5na v16_5na v25_5na v26_5na v27_5na v28_5na v21_5na v22_5na v23_5na.

***Achievement motivation applying answers for decremental and incremental scales (5 points).
COMPUTE achievement_5a = sum(MEAN(v11_5a + v12_5a + v13_5a + v14_5a + v16_5a)).
fre achievement_5a.
missing values achievement_5a (9).
fre achievement_5a.
compute achievement_5a_prop=achievement_5a/5.
missing values achievement_5a_prop (9).
fre achievement_5a_prop.

***Comparing achievement motivation applying answers for decremental and incremental scales (5 points).
PROPORTIONS
  /INDEPENDENTSAMPLES achievement_5a_prop BY group SELECT=LEVEL(1 ,2) CITYPES=AGRESTI_CAFFO NEWCOMBE  
    TESTTYPES=WALDH0 
  /SUCCESS VALUE=MIDPOINT
  /CRITERIA CILEVEL=95
  /MISSING SCOPE=ANALYSIS USERMISSING=EXCLUDE.

***Intrinsic job motivation applying answers for decremental and incremental scales (5 points).
COMPUTE intrinsic_5a = sum(MEAN(v26_5a + v27_5a + v28_5a)).
fre intrinsic_5a.
missing values intrinsic_5a (9).
fre intrinsic_5a.
compute intrinsic_5a_prop=intrinsic_5a/3.
missing values intrinsic_5a_prop (9).
fre intrinsic_5a_prop.

***Comparing intrinsic job motivation applying answers for decremental and incremental scales (5 points).
PROPORTIONS
  /INDEPENDENTSAMPLES intrinsic_5a_prop BY group SELECT=LEVEL(1 ,2) CITYPES=AGRESTI_CAFFO NEWCOMBE  
    TESTTYPES=WALDH0 
  /SUCCESS VALUE=MIDPOINT
  /CRITERIA CILEVEL=95
  /MISSING SCOPE=ANALYSIS USERMISSING=EXCLUDE.

***Extrinsic job motivation applying answers for decremental and incremental scales (5 points).
COMPUTE extrinsic_5a = sum(MEAN(v21_5a + v22_5a + v23_5a + v25_5a)).
fre extrinsic_5a.
missing values extrinsic_5a (9).
fre extrinsic_5a.
compute extrinsic_5a_prop=extrinsic_5a/4.
missing values extrinsic_5a_prop (9).
fre extrinsic_5a_prop.

***Comparing extrinsic job motivation applying answers for decremental and incremental scales (5 points).
PROPORTIONS
  /INDEPENDENTSAMPLES extrinsic_5a_prop BY group SELECT=LEVEL(1 ,2) CITYPES=AGRESTI_CAFFO NEWCOMBE  
    TESTTYPES=WALDH0 
  /SUCCESS VALUE=MIDPOINT
  /CRITERIA CILEVEL=95
  /MISSING SCOPE=ANALYSIS USERMISSING=EXCLUDE.

***Achievement motivation non-applying answers for decremental and incremental scales (5 points).
COMPUTE achievement_5na = sum(MEAN(v11_5na + v12_5na + v13_5na + v14_5na + v16_5na)).
fre achievement_5na.
missing values achievement_5na (9).
fre achievement_5na.
compute achievement_5na_prop=achievement_5na/5.
missing values achievement_5na_prop (9).
fre achievement_5na_prop.

***Comparing achievement motivation applying answers for decremental and incremental scales (5 points).
PROPORTIONS
  /INDEPENDENTSAMPLES achievement_5na_prop BY group SELECT=LEVEL(1 ,2) CITYPES=AGRESTI_CAFFO NEWCOMBE  
    TESTTYPES=WALDH0 
  /SUCCESS VALUE=MIDPOINT
  /CRITERIA CILEVEL=95
  /MISSING SCOPE=ANALYSIS USERMISSING=EXCLUDE.

***Intrinsic job motivation non-applying answers for decremental and incremental scales (5 points).
COMPUTE intrinsic_5na = sum(MEAN(v26_5na + v27_5na + v28_5na)).
fre intrinsic_5na.
missing values intrinsic_5na (9).
fre intrinsic_5na.
compute intrinsic_5na_prop=intrinsic_5na/3.
missing values intrinsic_5na_prop (9).
fre intrinsic_5na_prop.

***Comparing intrinsic job motivation non-applying answers for decremental and incremental scales (5 points).
PROPORTIONS
  /INDEPENDENTSAMPLES intrinsic_5na_prop BY group SELECT=LEVEL(1 ,2) CITYPES=AGRESTI_CAFFO NEWCOMBE  
    TESTTYPES=WALDH0 
  /SUCCESS VALUE=MIDPOINT
  /CRITERIA CILEVEL=95
  /MISSING SCOPE=ANALYSIS USERMISSING=EXCLUDE.

***Extrinsic job motivation non-applying answers for decremental and incremental scales (5 points).
COMPUTE extrinsic_5na = sum(MEAN(v21_5na + v22_5na + v23_5na + v25_5na)).
fre extrinsic_5na.
missing values extrinsic_5na (9).
fre extrinsic_5na.
compute extrinsic_5na_prop=extrinsic_5na/4.
missing values extrinsic_5na_prop (9).
fre extrinsic_5na_prop.

***Comparing extrinsic job motivation applying answers for decremental and incremental scales (5 points).
PROPORTIONS
  /INDEPENDENTSAMPLES extrinsic_5na_prop BY group SELECT=LEVEL(1 ,2) CITYPES=AGRESTI_CAFFO NEWCOMBE  
    TESTTYPES=WALDH0 
  /SUCCESS VALUE=MIDPOINT
  /CRITERIA CILEVEL=95
  /MISSING SCOPE=ANALYSIS USERMISSING=EXCLUDE.

***Applying answers for decremental and incremental scales (7 points).
recode v11_7 v12_7 v13_7 v14_7 v16_7 v25_7 v26_7 v27_7 v28_7 v21_7 v22_7 v23_7 (5,6,7=1) (1,2,3,4=0) (9=9) into v11_7a v12_7a v13_7a v14_7a v16_7a v25_7a v26_7a v27_7a v28_7a v21_7a v22_7a v23_7a.
missing values v11_7a v12_7a v13_7a v14_7a v16_7a v25_7a v26_7a v27_7a v28_7a v21_7a v22_7a v23_7a (9).
fre v11_7a v12_7a v13_7a v14_7a v16_7a v25_7a v26_7a v27_7a v28_7a v21_7a v22_7a v23_7a.
***Non-Applying answers for decremental and incremental scales (7 point).
recode v11_7 v12_7 v13_7 v14_7 v16_7 v25_7 v26_7 v27_7 v28_7 v21_7 v22_7 v23_7 (1,2,3=1) (4,5,6,7=0) (9=9) into v11_7na v12_7na v13_7na v14_7na v16_7na v25_7na v26_7na v27_7na v28_7na v21_7na v22_7na v23_7na.
missing values v11_7na v12_7na v13_7na v14_7na v16_7na v25_7na v26_7na v27_7na v28_7na v21_7na v22_7na v23_7na (9).
fre v11_7na v12_7na v13_7na v14_7na v16_7na v25_7na v26_7na v27_7na v28_7na v21_7na v22_7na v23_7na.

***Achievement motivation applying answers for decremental and incremental scales (7 points).
COMPUTE achievement_7a = sum(MEAN(v11_7a + v12_7a + v13_7a + v14_7a + v16_7a)).
fre achievement_7a.
missing values achievement_7a (9).
fre achievement_7a.
compute achievement_7a_prop=achievement_7a/5.
missing values achievement_7a_prop (9).
fre achievement_7a_prop.

***Comparing achievement motivation applying answers for decremental and incremental scales (7 points).
PROPORTIONS
  /INDEPENDENTSAMPLES achievement_7a_prop BY group SELECT=LEVEL(3, 4) CITYPES=AGRESTI_CAFFO NEWCOMBE  
    TESTTYPES=WALDH0 
  /SUCCESS VALUE=MIDPOINT
  /CRITERIA CILEVEL=95
  /MISSING SCOPE=ANALYSIS USERMISSING=EXCLUDE.

***Intrinsic job motivation applying answers for decremental and incremental scales (7 points).
COMPUTE intrinsic_7a = sum(MEAN(v26_7a + v27_7a + v28_7a)).
fre intrinsic_7a.
missing values intrinsic_7a (9).
fre intrinsic_7a.
compute intrinsic_7a_prop=intrinsic_7a/3.
missing values intrinsic_7a_prop (9).
fre intrinsic_7a_prop.

***Comparing intrinsic job motivation applying answers for decremental and incremental scales (7 points).
PROPORTIONS
  /INDEPENDENTSAMPLES intrinsic_7a_prop BY group SELECT=LEVEL(3 ,4) CITYPES=AGRESTI_CAFFO NEWCOMBE  
    TESTTYPES=WALDH0 
  /SUCCESS VALUE=MIDPOINT
  /CRITERIA CILEVEL=95
  /MISSING SCOPE=ANALYSIS USERMISSING=EXCLUDE.

***Extrinsic job motivation applying answers for decremental and incremental scales (7 points).
COMPUTE extrinsic_7a = sum(MEAN(v21_7a + v22_7a + v23_7a + v25_7a)).
fre extrinsic_7a.
missing values extrinsic_7a (9).
fre extrinsic_7a.
compute extrinsic_7a_prop=extrinsic_7a/4.
missing values extrinsic_7a_prop (9).
fre extrinsic_7a_prop.

***Comparing extrinsic job motivation applying answers for decremental and incremental scales (7 points).
PROPORTIONS
  /INDEPENDENTSAMPLES extrinsic_7a_prop BY group SELECT=LEVEL(3 ,4) CITYPES=AGRESTI_CAFFO NEWCOMBE  
    TESTTYPES=WALDH0 
  /SUCCESS VALUE=MIDPOINT
  /CRITERIA CILEVEL=95
  /MISSING SCOPE=ANALYSIS USERMISSING=EXCLUDE.

***Achievement motivation non-applying answers for decremental and incremental scales (7 points).
COMPUTE achievement_7na = sum(MEAN(v11_7na + v12_7na + v13_7na + v14_7na + v16_7na)).
fre achievement_7na.
missing values achievement_7na (9).
fre achievement_7na.
compute achievement_7na_prop=achievement_7na/5.
missing values achievement_7na_prop (9).
fre achievement_7na_prop.

***Comparing achievement motivation non-applying answers for decremental and incremental scales (7 points).
PROPORTIONS
  /INDEPENDENTSAMPLES achievement_7na_prop BY group SELECT=LEVEL(3, 4) CITYPES=AGRESTI_CAFFO NEWCOMBE  
    TESTTYPES=WALDH0 
  /SUCCESS VALUE=MIDPOINT
  /CRITERIA CILEVEL=95
  /MISSING SCOPE=ANALYSIS USERMISSING=EXCLUDE.

***Intrinsic job motivation non-applying answers for decremental and incremental scales (7 points).
COMPUTE intrinsic_7na = sum(MEAN(v26_7na + v27_7na + v28_7na)).
fre intrinsic_7na.
missing values intrinsic_7na (9).
fre intrinsic_7na.
compute intrinsic_7na_prop=intrinsic_7na/3.
missing values intrinsic_7na_prop (9).
fre intrinsic_7na_prop.

***Comparing intrinsic job motivation non-applying answers for decremental and incremental scales (7 points).
PROPORTIONS
  /INDEPENDENTSAMPLES intrinsic_7na_prop BY group SELECT=LEVEL(3 ,4) CITYPES=AGRESTI_CAFFO NEWCOMBE  
    TESTTYPES=WALDH0 
  /SUCCESS VALUE=MIDPOINT
  /CRITERIA CILEVEL=95
  /MISSING SCOPE=ANALYSIS USERMISSING=EXCLUDE.

***Extrinsic job motivation non-applying answers for decremental and incremental scales (7 points).
COMPUTE extrinsic_7na = sum(MEAN(v21_7na + v22_7na + v23_7na + v25_7na)).
fre extrinsic_7na.
missing values extrinsic_7na (9).
fre extrinsic_7na.
compute extrinsic_7na_prop=extrinsic_7na/4.
missing values extrinsic_7na_prop (9).
fre extrinsic_7na_prop.

***Comparing extrinsic job motivation non-applying answers for decremental and incremental scales (7 points).
PROPORTIONS
  /INDEPENDENTSAMPLES extrinsic_7na_prop BY group SELECT=LEVEL(3 ,4) CITYPES=AGRESTI_CAFFO NEWCOMBE  
    TESTTYPES=WALDH0 
  /SUCCESS VALUE=MIDPOINT
  /CRITERIA CILEVEL=95
  /MISSING SCOPE=ANALYSIS USERMISSING=EXCLUDE.

***Preparing Mplus-File.
SAVE TRANSLATE outfile ="D:\replication_file.dat" 
 /Type=TAB 
 /MAP 
 /Replace 
/CELLS=VALUES 
/KEEP=id group v11_5 v12_5 v13_5 v14_5 v16_5 v25_5 v26_5 v27_5 v28_5 v21_5 v22_5 v23_5 v11_5 v12_5 v13_5 v14_5 v16_5 v25_5 v26_5 v27_5 v28_5 v21_5 v22_5 v23_5 v11_7 v12_7 v13_7 v14_7 
    v16_7 v25_7 v26_7 v27_7 v28_7 v21_7 v22_7 v23_7. 

