/*STATA 15*/

ssc install tsspell
ssc install coefplot
net install grc1leg2.pkg, from (http://digital.cgdev.org/doc/stata/MO/Misc/)

**************preparing nlsy data
**set path to directory with input NLSY files
global path "[path_to_data]"

**set path to directory where replication outputs are to be stored
global path_replUSA "[path to outputs]"

use $path/long.dta
xtset pid syear
foreach l in benefits_9M benefits_1M {
gen f`l'=f.`l'
}

drop if syear<2003 | syear>2017
gen age=syear- dateborn_y

drop if perc_linc==. | employed_nmths==. | njobterm==.
drop if fullcases1==0

sort pid
merge m:1 pid using $path\demographics.dta
keep if _m==3

gen one=1

******************generating index values

///generating dummy variable for years affected by low earnings from work///
gen liperc_low=0
replace liperc_low=1 if perc_linc<1

///generating total n of years with low earnings and total n of month at work in a sequence///
macro drop _all
/*accounting for gaps*/
tsset pid syear
tsspell one
sum _spell
local spell=r(max)
*set sequence length: insert desired sequence length(s) in the following line, after local seqlength ... (default is 5)
local seqlength 5
foreach sl in `seqlength' {
local range=`sl'
gen totalemplR`range'=.
gen totallipercR`range'=.
*providing maximum observation scope (max individual trajectory length)
sum _seq
local longest=r(max)
local bound=`longest'-`range'+1
forvalues aa=1/`bound'{
local last=`aa'+`sl'-1
bysort pid _spell: egen totalemplR=total(employed_nmths) if _seq>=`aa' & _seq<=`last'
replace totalemplR`range'=totalemplR if _seq==`last'
bysort pid _spell: egen totallipercR=total(liperc_low) if _seq>=`aa' & _seq<=`last'
replace totallipercR`range'= totallipercR if _seq==`last'
drop totalemplR totallipercR
}
}
drop _spell _end _seq

///generating non-employment component naci_nw///

macro drop _all
/*account for gaps*/
tsset pid syear
tsspell one
sum _spell
local spell=r(max)
*set sequence length: insert desired sequence length(s) in the following line, after local seqlength ... (default is 5)
local seqlength 5
bysort pid _spell: egen EN=max(_seq)
foreach sl in `seqlength' {
local range=`sl'
gen nwincidenceR`range'=.
gen nw_recencyR`range'=.
gen nw_incidence_licznikR`range'=.
forvalues z=1(1)9{
gen naci_nw`z'R`range'=.
}
forvalues spl=1/`spell'{
*providing maximum observation scope (max individual trajectory length)
sum _seq if _spell==`spl'
local longest=r(max)
local bound=`longest'-`range'+1
forvalues aa=1/`bound'{
local last=`aa'+`sl'-1
quietly levelsof pid if employed_nmths<12 & _seq>=`aa' & _seq<=`last' & EN>=`last' & _spell==`spl', local(pidneet)
foreach l of local pidneet {
display `l'
levelsof syear if pid==`l' & employed_nmths<12 & _seq>=`aa' & _seq<=`last' & _spell==`spl', local(year)
local max=r(r)
local maxlessone=`max'-1
tokenize "`year'"
local sumpid=""
forvalues z=1/`maxlessone'{
local start `z'
local next=`z'+1
local sum ""
forvalues b=`next'/`max'{
local d``b''_``start''=((``b''-``start'')^-1)
local sum "`sum' + `d``b''_``start'''"
}
local sumpid="`sumpid' `sum'"
display `l'
}
replace nw_incidence_licznikR`range'=0`sumpid' if pid==`l' & _seq==`last' & _spell==`spl'
}
/*recencynw*/
gen lp`last'=.
gen lpnw`last'=.
local one=0
forvalues k=1/`sl'{
replace lp`last'=(1+ `one') if _seq==(`aa'+ `one') & _spell==`spl'
local one=`one'+1
}
replace lpnw`last'=lp`last'*(12-employed_nmths)/12
bysort pid: egen advnw_n=total(lpnw`last')
gen advnw=advnw_n/(`range'*(`range'+1)/2)
replace nw_recencyR`range'=advnw if _seq==`last' & _spell==`spl'
drop advnw_n advnw
drop lp`last' lpnw`last'
}
}
gen denominator=sum(_n/(`range'-_n))
local den=denominator in `range'
replace nwincidenceR`range'=nw_incidence_licznikR`range'/`den'
replace nwincidenceR`range'=0 if totalemplR`range'==60
drop denominator
/*generating component vals for different alpha*/
local i 1
foreach fa in .1 .2 .3 .4 .5 .6 .7 .8 .9 {
replace naci_nw`i'R`range'=`fa'*nwincidenceR`range'+(1-`fa')*nw_recencyR`range'
local i=`i'+1
}
}
drop _spell _end _seq EN																																																										

///generating low earnings component naci_liperc///

macro drop _all
/*account for gaps*/
tsset pid syear
tsspell one
sum _spell
local spell=r(max)
*set sequence length: insert desired sequence length(s) in the following line, after local seqlength ... (default is 5)
local seqlength 5
bysort pid _spell: egen EN=max(_seq)
foreach sl in `seqlength' {
local range=`sl'
gen lipercincidenceR`range'=.
gen liperc_recencyR`range'=.
gen nlipercincidenceR`range'=.
gen liperc_incidence_licznikR`range'=.
forvalues z=1(1)9{
gen naci_liperc`z'R`range'=.
}
forvalues spl=1/`spell'{
*providing maximum observation scope (max individual trajectory length)
sum _seq if _spell==`spl'
local longest=r(max)
local bound=`longest'-`range'+1
forvalues aa=1/`bound'{
local last=`aa'+`sl'-1
quietly levelsof pid if perc_linc<1 & _seq>=`aa' & _seq<=`last' & EN>=`last' & _spell==`spl', local(pidlinc)
foreach l of local pidlinc {
display `l'
levelsof syear if pid==`l' & perc_linc<1 & _seq>=`aa' & _seq<=`last' & _spell==`spl', local(year)
local max=r(r)
local maxlessone=`max'-1
tokenize "`year'"
local sumpid=""
forvalues z=1/`maxlessone'{
local start `z'
local next=`z'+1
local sum ""
forvalues b=`next'/`max'{
local d``b''_``start''=(``b''-``start'')^-1
local sum "`sum' + `d``b''_``start'''"
}
local sumpid="`sumpid' `sum'"
display `l'
}
replace liperc_incidence_licznikR`range'=0`sumpid' if pid==`l' & _seq==`last' & _spell==`spl'
}

/*recency_earnings*/
gen lp`last'=.
gen lplincratio`last'=.
local one=0
forvalues k=1/`sl'{
replace lp`last'=(1+ `one') if _seq==(`aa'+ `one') & _spell==`spl'
local one=`one'+1
}
replace lplincratio`last'=lp`last'*(1-perc_linc)
replace lplincratio`last'=0 if lplincratio`last'<0
bysort pid: egen advlinc_n=total(lplincratio`last')
gen advlinc=advlinc_n/(`range'*(`range'+1)/2)
replace liperc_recencyR`range'=advlinc if _seq==`last' & _spell==`spl'
drop advlinc_n advlinc
drop lp`last' lplincratio`last'
}
}
gen denominator=sum(_n/(`range'-_n))
local den=denominator in `range'
replace nlipercincidenceR`range'=liperc_incidence_licznikR`range'/`den'
replace nlipercincidenceR`range'=0 if totallipercR`range'==0
drop denominator
/*generating component vals for different alpha*/
local i 1
foreach fa in .1 .2 .3 .4 .5 .6 .7 .8 .9 {
replace naci_liperc`i'R`range'=`fa'*nlipercincidenceR`range'+(1-`fa')*liperc_recencyR`range'
local i= `i'+1
}
}
drop _spell _end _seq EN

///generating job terminations component aejt///
/*
The code generates aejt for any desired max_jt. It can be set at the code line indicated by "set maximum job terminations threshold (max_jt)". The default is 3 years
*/
macro drop _all
/*account for gaps*/
tsset pid syear
tsspell one
sum _spell
local spell=r(max)
*set sequence length: insert desired sequence length(s) in the following line, after local seqlength ... (default is 5)
local seqlength 5
bysort pid _spell: egen EN=max(_seq)
foreach sl in `seqlength' {
local range=`sl'
gen jtpersistR`range'=.
*set maximum job terminations threshold (max_jt): insert desired threshold in the following line, after local jtnorm ... (default is 3)
local jtnorm 3
foreach jtn in `jtnorm' {
gen jt_recencyR`range'_`jtn'=.
gen jt_recencyR`range'_`jtn'_licznik=.
}
gen jtpersist_licznikR`range'=.
gen totaljtR`range'=.
*gen jtincR`range'=.
/*generating totaljt*/
sum _seq
local longest=r(max)
local bound=`longest'-`range'+1
forvalues aa=1/`bound'{
local last=`aa'+`sl'-1
bysort pid _spell: egen totaljtR=total(njobterm) if _seq>=`aa' & _seq<=`last'
replace totaljtR`range'=totaljtR if _seq==`last'
/*recencynew*/
gen lp`last'=.
local one=0
forvalues k=1/`sl'{
replace lp`last'=(1+ `one') if _seq==(`aa'+ `one')
local one=`one'+1
}
foreach jtn in `jtnorm' {
gen lpjt`last'=.
gen inc=njobterm/`jtn'
replace inc=1 if inc>1 & inc!=.
replace lpjt`last'=lp`last'*inc
bysort pid _spell: egen licznik=total(lpjt`last')
replace jt_recencyR`range'_`jtn'_licznik=licznik if _seq==`last'
drop lpjt`last' inc licznik
}
drop lp`last' totaljtR
}
forvalues z=1(1)9{
*gen aejt`z'R`range'=.
foreach jtn in `jtnorm' {
gen aejt`jtn'`z'R`range'=.
}
}

forvalues spl=1/`spell'{
*provide maximum observation scope (max individual trajectory length)
sum _seq if _spell==`spl'
local longest=r(max)
local bound=`longest'-`range'+1
forvalues aa=1/`bound'{
local last=`aa'+`sl'-1
quietly levelsof pid if njobterm>0 & _seq>=`aa' & _seq<=`last' & EN>=`last' & _spell==`spl', local(pidneet)
foreach l of local pidneet {
display `l'
levelsof syear if pid==`l' & njobterm>0 & _seq>=`aa' & _seq<=`last' & _spell==`spl', local(year)
local max=r(r)
local maxlessone=`max'-1
tokenize "`year'"
local sumpid=""
forvalues z=1/`maxlessone'{
local start `z'
local next=`z'+1
local sum ""
forvalues b=`next'/`max'{
local d``b''_``start''=((``b''-``start'')^-1)
local sum "`sum' + `d``b''_``start'''"
}
local sumpid="`sumpid' `sum'"
display `l'
}
replace jtpersist_licznikR`range'=0`sumpid' if pid==`l' & _seq==`last' & _spell==`spl'
}

}
}
gen denominator=sum(_n/(`range'-_n))
local den=denominator in `range'
replace jtpersistR`range'=jtpersist_licznikR`range'/`den'
replace jtpersistR`range'=0 if totaljtR`range'==0
drop denominator
/*denominator recencynew*/
gen denominator_recency=sum(_n)
local den=denominator_recency in `range'
foreach jtn in `jtnorm' {
replace jt_recencyR`range'_`jtn'=jt_recencyR`range'_`jtn'_licznik/`den'
replace jt_recencyR`range'_`jtn'=0 if totaljtR`range'==0
}
drop denominator_recency

/*generating component vals for different alpha*/
local i 1
foreach fa in .1 .2 .3 .4 .5 .6 .7 .8 .9 {
*replace aejt`i'R`range'=`fa'*jtpersistR`range'+(1-`fa')*jt_recencyR`range'old
foreach jtn in `jtnorm' {
replace aejt`jtn'`i'R`range'=`fa'*jtpersistR`range'+(1-`fa')*jt_recencyR`range'_`jtn'
}
local i=`i'+1
}
}
drop _spell _end _seq EN

///generating CNPI///
/*The researcher specifies components' weights and the alpha parameter
li_weight - low earnings weight
nw_weight - non-employment weight
jt_weight - job terminations weight
alpha - weight attributed to the persistence dimension (in range 1-9, corresponding to 0.1-0.9)
jtn - maximum job terminations threshold*/

*define sequence length
local seqlength 5

*define specification-specific weights
capture program drop _all

program define default
gen li_weight=0.33
gen nw_weight=0.33
gen jt_weight=0.33
gen alpha=5
gen jtn=3
end

program define adjusted
gen li_weight=0.25
gen nw_weight=0.25
gen jt_weight=0.5
gen alpha=5
gen jtn=3
end

local specification default adjusted
macro list

foreach sl in `seqlength' {
foreach spec in `specification' {
`spec'
gen cnpi_`spec'R`sl'=.
local alpha=alpha in 1
local jtn=jtn in 1
replace cnpi_`spec'R`sl'=li_weight*naci_liperc`alpha'R`sl'+nw_weight*naci_nw`alpha'R`sl'+jt_weight*aejt`jtn'`alpha'R`sl'
drop li_weight nw_weight jt_weight alpha jtn
}
}

*******************analyses
**create directory where replication outputs are to be stored
mkdir $path_replUSA\output

lab var aejt35R5 "Job terminations" 
lab var naci_nw5R5 "Non-employment" 
lab var naci_liperc5R5 "Low earnings"


log using $path_replUSA\output\log

****corrs components (Table 1)

corr aejt35R5 naci_nw5R5 naci_liperc5R5 cnpi_defaultR5 if totalemplR5>0 & totalemplR5!=. & syear==2017 [aw=weights]

log off
*******5-year Index distributions (Figure 2)
gen zero=1 if cnpi_defaultR5==0
replace zero=0 if zero==.
sum zero if totalemplR5>0 & totalemplR5!=. & syear==2017 [aw=weights]
local mean=round(r(mean),.01)*100
drop zero
kdensity cnpi_defaultR5 if totalemplR5>0 & totalemplR5!=. & cnpi_defaultR5>0 & syear==2017 [aw=weights], /*
*/saving($path_replUSA\output\fig2) note("CNPI=0 for `mean'% of the population") title("USA") xtitle(CNPI) /*
*/graphr(c(white))

********distributions components (Figure 3)
graph box naci_nw5R5 naci_liperc5R5 aejt35R5 if totalemplR5>0 & totalemplR5!=. & cnpi_adjustedR5>0 & syear==2017 /*
*/[pw=weights], noout box(1, col(white) lc(black)) box(2, col(gs10) lc(black)) box(3, col(gs5) lc(black)) graphr(c(white)) /*
*/leg(c(3) region(lc(white))) saving($path_replUSA\output\fig3)

****clusters (Figure 4)
foreach com in naci_nw5R5 naci_liperc5R5 aejt35R5 {
egen std`com'=std(`com') if totalemplR5>0 & totalemplR5!=. & syear==2017 & oversampl_filter==1
}
cluster wardslinkage stdnaci_nw5R5 stdnaci_liperc5R5 stdaejt35R5 if totalemplR5>0 & totalemplR5!=. & syear==2017 & oversampl_filter==1, measure (L2squared) name(wards_linkagestd)
cluster dendrogram wards_linkagestd, cutnumber(10) showcount name(usadendrogram)
cluster generate Acluster2017wzero= groups(5), name(wards_linkagestd)
tab Acluster2017wzero [aw=weights], matcell(five)
svmat five, name(five)
gen five=round(five1/`r(N)'*100)
forvalues z=1/5{
local cl`z'=five in `z'
}
graph box naci_nw5R5 naci_liperc5R5 aejt35R5 cnpi_defaultR5 cnpi_adjustedR5, over(Acluster2017wzero, /*
*/relabel(1 "`cl1'%" 2 "`cl2'%" 3 "`cl3'%" 4 "`cl4'%" 5 "`cl5'%")) noout graphr(c(white)) /*
*/leg(c(5) region(lc(white)) order(1 2 3 4 "CNPI equal" 5 "CNPI adjusted") symx(7)) /*
*/xsize(5.5) ysize(2) scale(1.5) box(5, col(white) lc(black)) box(2, col(gs4) fi(inten50)) /*
*/box(3, col(gs8) fi(inten50)) box(4, col(gs12) fi(inten50)) box(1, col(black) fi(inten100) lc(white)) saving($path_replUSA\output\fig4)

drop stdnaci_nw5R5 stdnaci_liperc5R5 stdaejt35R5

******weights persistence vs recency
*Figure 5
twoway kdensity naci_liperc1R5 if totalemplR5>0 & totalemplR5!=. & cnpi_adjustedR5>0 & syear==2017 [aw=weights], lp(shortdash) lc(black) leg(lab(1 "alpha=0.1")) || kdensity naci_liperc9R5 if totalemplR5>0 & totalemplR5!=. & syear==2017 [aw=weights], lp(solid) lc(black) leg(lab(2 "alpha=0.9")) xtitle(Low earnings component) ytitle(Density) graphr(c(white)) title(USA) leg(region(lc(white)) symx(7)) scale(1.5) saving($path_replUSA\output\fig5)
*Figure B5
graph drop _all
twoway kdensity aejt31R5 if totalemplR5>0 & totalemplR5!=. & cnpi_adjustedR5>0 & syear==2017 [aw=weights], /*
*/lp(shortdash) || kdensity aejt39R5 if totalemplR5>0 & totalemplR5!=. & cnpi_adjustedR5>0 & syear==2017 /*
*/[aw=weights], lp(solid) xtitle(Job terminations) name(jt) graphr(c(white)) /*
*/legend(order(1 "alpha=0.1" 2 "alpha=0.9") region(lc(white)))
twoway kdensity naci_nw1R5 if totalemplR5>0 & totalemplR5!=. & cnpi_adjustedR5>0 & syear==2017 [aw=weights], /*
*/lp(shortdash) || kdensity naci_nw9R5 if totalemplR5>0 & totalemplR5!=. & cnpi_adjustedR5>0 & syear==2017 /*
*/[aw=weights], lp(solid) xtitle(Non-employment) name(nw) graphr(c(white))
twoway kdensity naci_liperc1R5 if totalemplR5>0 & totalemplR5!=. & cnpi_adjustedR5>0 & syear==2017 [aw=weights], /*
*/lp(shortdash) || kdensity naci_liperc9R5 if totalemplR5>0 & totalemplR5!=. & cnpi_adjustedR5>0 & syear==2017 /*
*/[aw=weights], lp(solid) xtitle(Low earnings) name(li) graphr(c(white))
grc1leg2 jt li nw, graphr(c(white)) c(3) leg(jt) xsize(6) ysize(2) scale(1.5) saving($path_replUSA\output\figB5)

log on
******corrs weights (Table 2)
corr aejt31R5 aejt39R5 if totalemplR5>0 & totalemplR5!=. & cnpi_adjustedR5>0 & syear==2017 [aw=weights]
corr naci_nw1R5 naci_nw9R5 if totalemplR5>0 & totalemplR5!=. & cnpi_adjustedR5>0 & syear==2017 [aw=weights]
corr naci_liperc1R5 naci_liperc9R5 if totalemplR5>0 & totalemplR5!=. & cnpi_adjustedR5>0 & syear==2017 [aw=weights]

log off

*********benefits in year 6 (Figure 6 & 7, B6, Table A6 & A10)

twoway kdensity cnpi_adjustedR5 if totalemplR5>0 & totalemplR5!=. & syear==2017 & fbenefits_9M==0 [aw=weight19], lc(black) lp(solid) leg(lab(1 "no benefits")) || kdensity cnpi_adjustedR5 if totalemplR5>0 & totalemplR5!=. & syear==2017 & fbenefits_9M==1 [aw=weight19], lc(black) lp(shortdash) leg(lab(2 "one or two benefits")) || kdensity cnpi_adjustedR5 if totalemplR5>0 & totalemplR5!=. & syear==2017 & fbenefits_9M==2 [aw=weight19], lc(black) lp(dash) leg(lab(3 "all benefits") c(3) region(lc(white))) xtitle(CNPI) ytitle(Density) graphr(c(white)) saving($path_replUSA\output\fig6)

mlogit fbenefits_9M cnpi_adjustedR5 age i.maritstat i.edu i.sex i.race if totalemplR5>0 & totalemplR5!=. & syear==2017 & fbenefits_9M>=0 [pw=weight19]
est sto mlogit
margins, dydx(cnpi_adjustedR5) post
coefplot, xsize(4) ysize(2) scale(2.5) xline(0) graphr(c(white)) coeflabels(1._predict="no benefits" 2._predict="1-2 benefits" 3._predict="all benefits") saving($path_replUSA\output\fig7)
estout mlogit using $path_replUSA\output\tableA10.txt, cells(b(star fmt(%9.3f)) se(par)) stats(N, fmt(%9.3f %9.0g))

log on
**descriptives on variables (Table A6)
sum i.fbenefits_9M cnpi_adjustedR5 age i.maritstat i.edu i.sex i.race if e(sample) [aw=weight19]
log off

*FigB6
mlogit fbenefits_9M cnpi_defaultR5 age i.maritstat i.edu i.sex i.race if totalemplR5>0 & totalemplR5!=. & syear==2017 & fbenefits_9M>=0 [pw=weight19]
margins, dydx(cnpi_defaultR5) post
coefplot, xsize(4) ysize(2) scale(2) xline(0) graphr(c(white)) coeflabels(1._predict="no benefits" 2._predict="1-2 benefits" 3._predict="all benefits") title(USA) saving($path_replUSA\output\figB6)

*********employment form in year 1 (Figure 8 & 9, B7, Table A8 & A12)

xtset pid syear
foreach l in benefits_9M benefits_1M {
gen l4`l'=l4.`l'
}

twoway kdensity cnpi_adjustedR5 if totalemplR5>0 & totalemplR5!=. & syear==2017 & l4benefits_9M==0 [aw=weights], lc(black) lp(solid) leg(lab(1 "no benefits")) || kdensity cnpi_adjustedR5 if totalemplR5>0 & totalemplR5!=. & syear==2017 & l4benefits_9M==1 [aw=weights], lc(black) lp(shortdash) leg(lab(2 "1-2 benefits")) || kdensity cnpi_adjustedR5 if totalemplR5>0 & totalemplR5!=. & syear==2017 & l4benefits_9M==2 [aw=weights], lc(black) lp(dash) leg(lab(3 "all benefits") c(3) region(lc(white))) xtitle(CNPI) ytitle(Density) graphr(c(white)) saving($path_replUSA\output\fig8)

reg cnpi_adjustedR5 age i.maritstat i.edu i.sex i.race i.l4benefits_9M if totalemplR5>0 & totalemplR5!=. & syear==2017 [pw=weights]
est sto reg
margins i.l4benefits_9M, vce(unconditional) post
coefplot, keep(0.l4benefits_9M 1.l4benefits_9M 2.l4benefits_9M) recast(bar) ylabel(1 "no benefits" 2 "1-2 benefits" 3 "all benefits") col(black%20) xsize(5.5) ysize(2) scale(3) graphr(c(white)) cire(rcap) saving($path_replUSA\output\fig9)
estout reg using $path_replUSA\output\tableA12.txt, cells(b(star fmt(%9.3f)) se(par)) stats(r2_a N, fmt(%9.3f %9.0g) labels(R-squared))

log on
*descriptives on variables (Table A8)
sum i.l4benefits_9M cnpi_adjustedR5 age i.maritstat i.edu i.sex i.race if e(sample) [aw=weights]
log off

*FigA7
reg cnpi_defaultR5 age i.maritstat i.edu i.sex i.race i.l4benefits_9M if totalemplR5>0 & totalemplR5!=. & syear==2017 [pw=weights]
margins i.l4benefits_9M, vce(unconditional) post
coefplot, keep(0.l4benefits_9M 1.l4benefits_9M 2.l4benefits_9M) recast(bar) ylabel(1 "no benefits" 2 "1-2 benefits" 3 "all benefits") col(black%20) xsize(5.5) ysize(2) scale(2) title(USA) graphr(c(white)) cire(rcap) saving($path_replUSA\output\figB7)

*******CNPI across life course (Figure 10)
reg cnpi_adjustedR5 i.age if totalemplR5>0 & totalemplR5!=. & age>=25 & syear<=2017 [pw=weights], cluster(pid)
margins i.age, vce(unconditional) atmeans
marginsplot, title(USA) xtitle(Age) ytitle(CNPI) graphr(c(white)) recast(bar) plotop(col(gs10) lc(black)) xlabel(25(5)67) ciopts(lc(black)) saving($path_replUSA\output\fig10)

log on
*****Appendix
*N months in employment (Table A1)
tabstat totalemplR5 if totalemplR5>0 & totalemplR5!=. & syear==2017 [aw=weights], st(N mean sd p25 median p75)

log off
*N years with low earnings (Figure B2)
tab totallipercR5 if totalemplR5>0 & totalemplR5!=. & syear==2017, gen(sth)
graph bar sth* if totalemplR5>0 & totalemplR5!=. & syear==2017 [aw=weights], /*
*/ascat yvaroptions(relabel(1 "0" 2 "1" 3 "2" 4 "3" 5 "4" 6 "5")) title(USA) saving($path_replUSA\output\figB2)
drop sth*

*N job terminations (Figure B1, Table A2)
xtset pid syear
gen totalnjobterm=l4.njobterm+l3.njobterm+l2.njobterm+l1.njobterm+njobterm
log on
*N job terminations (Table A2)
tabstat totalnjobterm if totalemplR5>0 & totalemplR5!=. & syear==2017 [aw=weights], st(N mean sd p25 median p75)
log off
tab totalnjobterm if totalemplR5>0 & totalemplR5!=. & syear==2017 [aw=weights], gen(sth)
graph bar sth* if syear==2017 [aw=weights], ascat yvaroptions(relabel(1 "0" 2 "1" 3 "2" 4 "3" 5 "4" 6 "5" 7 "6" 8 "7" 9 "10" 10 "14" 11 "18")) saving($path_replUSA\output\figB1)
drop sth*

*yearly njobterm (Table A3)
gen validseq=1 if totalemplR5>0 & totalemplR5!=. & cnpi_adjustedR5!=. & syear==2017
xtset pid syear
replace validseq=1 if f1.validseq==1 | f2.validseq==1 | f3.validseq==1 | f4.validseq==1

log on
*yearly njobterm (Table A3)
tab njobterm if validseq==1 [aw=weights]
sum njobterm if validseq==1 [aw=weights]
log off

drop validseq

*distribution of intensity of low earnings in years with low earnings in the sample of sequences under analysis (Figure B3, Table A4)
gen validseq=1 if totalemplR5>0 & totalemplR5!=. & cnpi_adjustedR5!=. & syear==2017
xtset pid syear
replace validseq=1 if f1.validseq==1 | f2.validseq==1 | f3.validseq==1 | f4.validseq==1
gen distance=1-perc_linc

log on
*Table A4
tabstat distance if validseq==1 & liperc_low==1 [aw=weights], st(N mean sd p25 median p75)
log off
*Figure B3
kdensity distance if validseq==1 & liperc_low==1 [aw=weights], title(USA) xtitle("Distance to low earnings threshold") note("") saving($path_replUSA\output\figB3)


