cap log close
log using "$log\Auswertungen_RR_CAPI_CATI_Dezile.log", replace


*--------------------------------*
* Analysis CATI/CAPI-Experiment --> DECILES
*--------------------------------*

* load data
use "$temp\cati_aufbereitung_mit_high.dta", clear	
append using "$temp\capi_aufbereitung_mit_high.dta"


// X1 = response propensities
	bysort interview: sum X1 		
	tab quant expw14

// how is response rate distributed across deciles
	tab quant interview, ro				

// group Low Propensities in respondent incentives yes/no
	bysort bef_inc: tabstat interview, by(quant) statistics(N mean sd)   			

	
// grapghs by deciles
graph bar (mean) interview, ///
					over(bef_inc, relabel(1"ohne B." 2"mit B.") label(angle(forty_five))) ///
					over(quant)
	// higher response rate if incentivizedim
	

log close