* Preparation of contact data

forvalues x = 5/13 { 

* Final contact data wave x 
use "$data_con\PASSW`x'-Kontaktdaten_final.dta", clear
rename _all, lower
	sort hhelfd
	* Keeping household level information
	keep if konhp == 0
	* Keeping panel cases
	keep if stich == 1

* Outcome, RCL 
	recode rcl  	(4 5 35 36 = 0)	///
					(18 = 1) ///
					(47 = 2) ///
					(1 2 3 20 28 34 61 = 3) ///
					(8 9 10 11 12 22 39 40 48 50 52 53 54 59 62 71 77 78 88 199 = 4) ///
					(13 14 15 16 17 26 33  = 5) ///
					(42 43 80 = 6) ///
					(81 82 = 71) ///
					(6 7 31 32 70 = 8) ///
					(. 0 91 = 9), into(rcl_neu) 
	#delimit ;	
	la def rcl_neu	   0 "ADR, adress problems"    
					   1 "I, complete interview"                       
					   2 "P, partial interview"
					   3 "NC, eligible non-contact"     
					   4 "R, refusal and break-off"                      
					   5 "NE, not eligible"
					   6 "NI, eligible non-interview"
					  71 "W/C, mode"
					  72 "W/NC, mode"
					   8 "T, Appointment"
					   9 "MV, missing value";
	#delimit cr

	la val rcl_neu rcl_neu
	tab rcl_neu

	* Dummy if interview y/n
	gen interview = 0
	replace interview = 1 if rcl_neu == 1
	
			
	* Sample categories
	gen sample_neu = 2 
	replace sample_neu = 1 if sample == 1 | sample == 6 | sample == 15
	replace sample_neu = 3 if sample == 14 | sample == 17 | sample == 19 | sample == 21
	la def sample_neu 1 "EWO" 2 "BA (without syria/iraq)" 3 "BA (syria/iraq)"
	lab val sample_neu sample_neu	
		
	keep hnr kon_nrh konart sample interview rcl_neu sample_neu
	
	
	* Number of contact with interview
	sort hnr kon_nrh
	gen kon_int = kon_nrh if interview == 1
	bysort hnr: egen kon_int_m = max(kon_int)
	
	* last contact?
	bysort hnr (kon_nrh):  gen last_kon = kon_nrh if _n == _N
	bysort hnr: egen last_kon_m = max(last_kon)

	count if last_kon_m ~= kon_int_m & interview == 1 
	
	bysort hnr: egen int_max = max(interview)
	replace last_kon_m = kon_int_m if last_kon_m ~= kon_int_m & int_max == 1
	drop kon_int_m kon_int last_kon int_max 
	keep if kon_nrh == last_kon_m
	drop last_kon_m
	
	gen welle = `x'
	
save $tmp\kontaktdaten_`x'.dta, replace
		
}	
	
use $tmp\kontaktdaten_5.dta, clear

forvalues x = 6/12 {
	append using $tmp\kontaktdaten_`x'.dta
}
sort hnr welle
order hnr welle sample_neu interview
save $tmp\kontaktdatenW5-W12.dta, replace
	

// Merging wave 4 
use "$data_con\PASSW4-Kontaktdaten_final.dta", clear
rename _all, lower
	sort hhelfd
	keep if konhp == 0
	keep if stich == 1
	recode rcl  	(4 5 35 36 = 0)	///
					(18 = 1) ///
					(47 = 2) ///
					(1 2 3 20 28 34 61 = 3) ///
					(8 9 10 11 12 22 39 40 48 50 52 53 54 59 62 71 77 78 88 199 = 4) ///
					(13 14 15 16 17 26 33  = 5) ///
					(42 43 80 = 6) ///
					(81 82 = 71) ///
					(6 7 31 32 70 = 8) ///
					(. 0 91 = 9), into(rcl_neu) 
	#delimit ;	
	la def rcl_neu	   0 "ADR, adress problems"    
					   1 "I, complete interview"                       
					   2 "P, partial interview"
					   3 "NC, eligible non-contact"     
					   4 "R, refusal and break-off"                      
					   5 "NE, not eligible"
					   6 "NI, eligible non-interview"
					  71 "W/C, mode"
					  72 "W/NC, mode"
					   8 "T, Appointment"
					   9 "MV, missing value";
	#delimit cr
	la val rcl_neu rcl_neu
	gen interview = 0
	replace interview = 1 if rcl_neu == 1
	keep hnr kon_nrh rcl_neu konart interview
	
	* Number of contact with interview
	sort hnr kon_nrh
	gen kon_int = kon_nrh if interview == 1
	bysort hnr: egen kon_int_m = max(kon_int)
	
	* last contact?
	bysort hnr (kon_nrh):  gen last_kon = kon_nrh if _n == _N
	bysort hnr: egen last_kon_m = max(last_kon)

	count if last_kon_m ~= kon_int_m & interview == 1 
	
	bysort hnr: egen int_max = max(interview)
	replace last_kon_m = kon_int_m if last_kon_m ~= kon_int_m & int_max == 1
	drop kon_int_m kon_int last_kon int_max 
	keep if kon_nrh == last_kon_m
	drop last_kon_m

	gen welle = 4
	
save $tmp\kontaktdaten_4.dta, replace
append using $tmp\kontaktdatenW5-W12.dta

** Sample variable
bysort hnr: egen sample_kat = max(sample_neu)
lab val sample_kat sample_neu	

sort hnr welle
order hnr welle sample_kat interview
drop sample sample_neu

save $tmp\kontaktdaten_final.dta, replace

* delete data no longer needed
forvalues x = 4/12 {
	erase $tmp\kontaktdaten_`x'.dta
}
erase $tmp\kontaktdatenW5-W12.dta
