####################################################################################################
# Graphics
####################################################################################################

# Load data
load("DATA/AllModelsPaper.RData")

# Select Model
model1 <- models$rf

# Fixes Setting
ctrl_fix <- trainControl(method = "none", classProbs=TRUE, sampling = "down")

# Control
rfGrid <- model1$bestTune

# RF
set.seed(1234)
system.time(models$rf_varImp <- train(ausfall~., 
                                            data = train,
                                            method = "ranger",
                                            importance = "impurity",
                                            metric = performance_metric,
                                            preProcess = c("center", "scale"),
                                            trControl = ctrl_fix,
                                            tuneGrid = rfGrid))

# Variable Importance
varImp <- varImp(models$rf_varImp, scale=TRUE)

# Plot
labels <- c(kon_nrh="Number of contacts ",palter="Age", dauerHH="Duration HH interview", dauerP="Duration P interview", HEK0600="HH income", real_wave="Number of participated waves", int_alter="Age of interviewer", prop_wave="Proportion of participated waves", HEK1200="Savings of HH", int_erfahrung="Work experience of interviewer", PSK0200="Number of friends", PA0200="Satisfaction with housing", depind="Deprivation index", PA0100="Satisfaction with health", PA0800="Social integration", PA0300="Satisfaction with standard of living", PA0900="Social position", PA1000="Contentment with life in general", interesse2="Interest of interviewee", PMI01002="Born in Germany", HEK1420="Total amount of debts ", HA0100="Size of household", HW03003="Type of renting", beruf22="Highest vocational qualification")
varImpPlot <- ggplot(varImp(models$rf_down_roc_varImp, scale=TRUE), top=15) + scale_x_discrete(labels = labels) + labs(x="")
ggsave("GRAPH/figure_1.svg", 
       plot = varImpPlot,
       width = 200,
       height = 110,
       units = "mm")


#PDP
lb <- 0.01
ub <- 0.95

# Number of contacts
par.kon_W <- partial(model1, pred.var = c("kon_nrh"), chull = TRUE)
kon_W_quan <- quantile(validation$kon_nrh, probs = c(lb,ub))
par.kon_W_test <- subset(par.kon_W, kon_nrh >= kon_W_quan[1] & kon_nrh <= kon_W_quan[2])
par.kon_W_test[,2] <- par.kon_W_test[,2]
plot.kon_W <- autoplot(par.kon_W_test, contour = TRUE, ylab = "centered PAA", xlab = "number of contact")

# Age
par.palter_W <- partial(model1, pred.var = c("palter"), chull = TRUE)
palter_W_quan <- quantile(validation$palter, probs = c(lb,ub))
par.palter_W_test <- subset(par.palter_W, palter >= palter_W_quan[1] & palter <= palter_W_quan[2])
par.palter_W_test[,2] <- par.palter_W_test[,2]
plot.palter_W <- autoplot(par.palter_W_test, contour = TRUE, ylab = "centered PAA", xlab = "age")

# Duration HH-Interview
par.dauerHH_W <- partial(model1, pred.var = c("dauerHH"), chull = TRUE)
dauerHH_W_quan <- quantile(validation$dauerHH, probs = c(lb,ub))
par.dauerHH_W_test <- subset(par.dauerHH_W, dauerHH >= dauerHH_W_quan[1] & dauerHH <= dauerHH_W_quan[2])
par.dauerHH_W_test[,2] <- par.dauerHH_W_test[,2]
plot.dauerHH_W <- autoplot(par.dauerHH_W_test, contour = TRUE, ylab = "centered PAA", xlab = "duration hh interview (seconds)")

# Duration P-Interview
par.dauerP_W <- partial(model1, pred.var = c("dauerP"), chull = TRUE)
dauerP_W_quan <- quantile(validation$dauerP, probs = c(lb,ub))
par.dauerP_W_test <- subset(par.dauerP_W, dauerP >= dauerP_W_quan[1] & dauerP <= dauerP_W_quan[2])
par.dauerP_W_test[,2] <- par.dauerP_W_test[,2]
plot.dauerP_W <- autoplot(par.dauerP_W_test, contour = TRUE, ylab = "centered PAA", xlab = "duration P interview (seconds)")

# HH size
par.HEK0600_W <- partial(model1, pred.var = c("HEK0600"), chull = TRUE)
HEK0600_W_quan <- quantile(validation$HEK0600, probs = c(lb,ub))
par.HEK0600_W_test <- subset(par.HEK0600_W, HEK0600 >= HEK0600_W_quan[1] & HEK0600 <= HEK0600_W_quan[2])
par.HEK0600_W_test[,2] <- par.HEK0600_W_test[,2]
plot.HEK0600_W <- autoplot(par.HEK0600_W_test, contour = TRUE, ylab = "centered PAA", xlab = "HH income (euro)")

# Number of participated waves 
par.real_W <- partial(model1, pred.var = c("real_wave"), chull = TRUE)
real_W_quan <- quantile(validation$real_wave, probs = c(lb,ub))
par.real_W_test <- subset(par.real_W, real_wave >= real_W_quan[1] & real_wave <= real_W_quan[2])
par.real_W_test[,2] <- par.real_W_test[,2]
plot.real_W <- autoplot(par.real_W_test, contour = TRUE, ylab = "centered PAA", xlab = "number of participated waves")

# Age interviewer
par.int_alter_W <- partial(model1, pred.var = c("int_alter"), chull = TRUE)
int_alter_W_quan <- quantile(validation$int_alter, probs = c(lb,ub))
par.int_alter_W_test <- subset(par.int_alter_W, int_alter >= int_alter_W_quan[1] & int_alter <= int_alter_W_quan[2])
par.int_alter_W_test[,2] <- par.int_alter_W_test[,2]
plot.int_alter_W <- autoplot(par.int_alter_W_test, contour = TRUE, ylab = "centered PAA", xlab = "age of interviewer")

# Proportion of participated waves
par.prop_W <- partial(model1, pred.var = c("prop_wave"), chull = TRUE)
prop_W_quan <- quantile(validation$prop_wave, probs = c(lb,ub))
par.prop_W_test <- subset(par.prop_W, prop_wave >= prop_W_quan[1] & prop_wave <= prop_W_quan[2])
par.prop_W_test[,2] <- par.prop_W_test[,2]
plot.prop_W <- autoplot(par.prop_W_test, contour = TRUE, ylab = "centered PAA", xlab = "share of participated waves")

# Savings of HH
par.HEK1200_W <- partial(model1, pred.var = c("HEK1200"), chull = TRUE)
HEK1200_W_quan <- quantile(validation$HEK1200, probs = c(lb,ub))
par.HEK1200_W_test <- subset(par.HEK1200_W, HEK1200 >= HEK1200_W_quan[1] & HEK1200 <= HEK1200_W_quan[2])
par.HEK1200_W_test[,2] <- par.HEK1200_W_test[,2]
plot.HEK1200_W <- autoplot(par.HEK1200_W_test, contour = TRUE, ylab = "centered PAA", xlab = "savings of hh")

# Work experience of interviewer
par.int_erf_W <- partial(model1, pred.var = c("int_erfahrung"), chull = TRUE)
int_erf_W_quan <- quantile(validation$int_erfahrung, probs = c(lb,ub))
par.int_erf_W_test <- subset(par.int_erf_W, int_erfahrung >= int_erf_W_quan[1] & int_erfahrung <= int_erf_W_quan[2])
par.int_erf_W_test[,2] <- par.int_erf_W_test[,2]
plot.int_erf_W <- autoplot(par.int_erf_W_test, contour = TRUE, ylab = "centered PAA", xlab = "interviewer: experience (years)")

# Number of friends
par.PSK0200_W <- partial(model1, pred.var = c("PSK0200"), chull = TRUE)
PSK0200_W_quan <- quantile(validation$PSK0200, probs = c(lb,ub))
par.PSK0200_W_test <- subset(par.PSK0200_W, PSK0200 >= PSK0200_W_quan[1] & PSK0200 <= PSK0200_W_quan[2])
par.PSK0200_W_test[,2] <- par.PSK0200_W_test[,2]
plot.PSK0200_W <- autoplot(par.PSK0200_W_test, contour = TRUE, ylab = "centered PAA", xlab = "number of friends")

# Satisfaction with housing
par.PA0200_W <- partial(model1, pred.var = c("PA0200"), chull = TRUE)
PA0200_W_quan <- quantile(validation$PA0200, probs = c(lb,ub))
par.PA0200_W_test <- subset(par.PA0200_W, PA0200 >= PA0200_W_quan[1] & PA0200 <= PA0200_W_quan[2])
par.PA0200_W_test[,2] <- par.PA0200_W_test[,2]
plot.PA0200_W <- autoplot(par.PA0200_W_test, contour = TRUE, ylab = "centered PAA", xlab = "satisfaction with housing")

# Deprivation index
par.depind_W <- partial(model1, pred.var = c("depind"), chull = TRUE)
depind_W_quan <- quantile(validation$depind, probs = c(lb,ub))
par.depind_W_test <- subset(par.depind_W, depind >= depind_W_quan[1] & depind <= depind_W_quan[2])
par.depind_W_test[,2] <- par.depind_W_test[,2]
plot.depind_W <- autoplot(par.depind_W_test, contour = TRUE, ylab = "centered PAA", xlab = "deprivation index")

# Satisfaction with health
par.PA0300_W <- partial(model1, pred.var = c("PA0300"), chull = TRUE)
PA0300_W_quan <- quantile(validation$PA0300, probs = c(lb,ub))
par.PA0300_W_test <- subset(par.PA0300_W, PA0300 >= PA0300_W_quan[1] & PA0300 <= PA0300_W_quan[2])
par.PA0300_W_test[,2] <- par.PA0300_W_test[,2]
plot.PA0300_W <- autoplot(par.PA0300_W_test, contour = TRUE, ylab = "centered PAA", xlab = "satisfaction with health")

par.PG0100_W <- partial(model1, pred.var = c("PG0100"), chull = TRUE)
PG0100_W_quan <- quantile(validation$PG0100, probs = c(lb,ub))
par.PG0100_W_test <- subset(par.PG0100_W, PG0100 >= PG0100_W_quan[1] & PG0100 <= PG0100_W_quan[2])
par.PG0100_W_test[,2] <- par.PG0100_W_test[,2]
plot.PG0100_W <- autoplot(par.PG0100_W_test, contour = TRUE, ylab = "centered PAA", xlab = "number doctor visit")

# Social integration
par.PA0800_W <- partial(model1, pred.var = c("PA0800"), chull = TRUE)
PA0800_W_quan <- quantile(validation$PA0800, probs = c(lb,ub))
par.PA0800_W_test <- subset(par.PA0800_W, PA0800 >= PA0800_W_quan[1] & PA0800 <= PA0800_W_quan[2])
par.PA0800_W_test[,2] <- par.PA0800_W_test[,2]
plot.PA0800_W <- autoplot(par.PA0800_W_test, contour = TRUE, ylab = "centered PAA", xlab = "social integration")

# Interest of interviewee
par.interesse_W <- partial(model1, pred.var = c("interesse2"), chull = TRUE)
interesse_W_quan <- quantile(validation$interesse2, probs = c(lb,ub))
par.interesse_W_test <- subset(par.interesse_W, interesse2 >= interesse_W_quan[1] & interesse2 <= interesse_W_quan[2])
par.interesse_W_test[,2] <- par.interesse_W_test[,2]
plot.interesse_W <- autoplot(par.interesse_W_test, contour = TRUE, ylab = "centered PAA", xlab = "interest of interviewee")


arrange <- ggarrange(plot.kon_W, plot.palter_W, plot.dauerHH_W, plot.dauerP_W,  
                     plot.HEK0600_W, plot.real_W, plot.int_alter_W, plot.prop_W, 
                     plot.HEK1200_W, plot.int_erf_W, plot.PSK0200_W, plot.PA0200_W, 
                     plot.depind_W, plot.PA0300_W, plot.PA0800_W, ncol=3, nrow=5) 

ggsave("GRAPH/figure_2.svg", 
       plot = arrange,
      width = 200,
      height = 280,
      units = "mm")
