*** Duration of interview

*********************************************************************************************************************************************
* Merging household data
*********************************************************************************************************************************************

* Starting with wave 4
use "$data_dur\PASS-W4_HH_Quer_gültig_roh_Dauern_1", clear
merge 1:1 befr_hh using "$data_dur\PASS-W4_HH_Quer_gültig_roh_2.dta", nogen keep(3) keepus(hnr)
gen welle = 4
order hnr lfd befr_hh welle

* Appending waves 5 to 12
forvalues w = 5/12 {
  append using "$data_dur\PASS-W`w'_HH_Quer_anonym.dta", keep(hnr lfd befr_hh zst*)
  replace welle = `w' if welle == .
}

* Generating durations
gen dauerHH = .

egen dauerTmp = rowtotal(zsthh1 zsthh2 zsthh3 zsthh4 zsthh5 zsthh6 zsthh7) if welle == 4 
replace dauerHH = dauerTmp if dauerTmp > 0 & dauerTmp != .
drop dauerTmp

egen dauerTmp = rowtotal(zsthh1 zsthh2 zsthh3 zsthh4 zsthh5 zsthh6 zsthh7 zstpostintro zstgrid01 zstgrid02) if welle == 5
replace dauerHH = dauerTmp - zstintro1 if dauerTmp > 0 & dauerTmp != .
drop dauerTmp

gen dauerTmp = cond(welle == 6, zsthh9, cond(inlist(welle, 7, 9), zsthh11, cond(welle == 8, zsthh12, cond(inlist(welle, 10, 11, 12), zsthhend, .))))
replace dauerHH = dauerTmp - zstintro1 if dauerTmp > 0 & dauerTmp != .
drop dauerTmp
replace dauerHH = . if dauerHH <= 0
sum dauerHH, d

keep hnr welle dauerHH
isid hnr welle 

* saving
save $tmp\intDauernHHgen.dta, replace

*********************************************************************************************************************************************
* Merging indvidual data
*********************************************************************************************************************************************

use "$data_dur\PASS-W4_P-Sen_Quer_gültig_roh_Dauern_1.dta", clear
merge 1:1 lfd using "$data_dur\PASS-W4_P-Sen_Quer_gültig_roh_2.DTA", nogen keep(3) keepus(pnr hnr)
gen welle = 4
order pnr welle lfd befr_hh welle

* Appending waves 5 to 12
forvalues w = 5/12 {
  append using "$data_dur\PASS-W`w'_P-Sen_Quer_anonym.dta", keep(pnr hnr lfd befr_hh zst*)
  replace welle = `w' if welle == .
}

* Clean up data errors
replace zstp1 = . if zsts2 != .
replace zsts1 = . if zstp2 != .

* Generating durations
gen dauerP = .

egen dauerTmp = rowtotal(zstp1 zstp2 zstp3 zstp4 zstp5 zstp6 zstp7 zstp8 zstp9 zstp10 zstp11 zstp12 zstp13 zstp14 zstp15) if welle == 4 & zstp2 != .
replace dauerP = dauerTmp if dauerTmp > 0 & dauerTmp != . 
drop dauerTmp

egen dauerTmp = rowtotal(zsts1 zsts2 zsts3 zsts4 zsts5 zsts6 zsts7 zsts8 zsts9 zsts10) if welle == 4 & zsts2 != .
replace dauerP = dauerTmp if dauerTmp > 0 & dauerTmp != . 
drop dauerTmp

egen dauerTmp = rowtotal(zstp1 zstp2 zstp3 zstp4 zstp5 zstp6 zstp7 zstp8 zstp9 zstp10 zstp11 zstp12 zstp13 zstp14 zstp15 zstp16 zstp17 zstp18 zstp19 zstp20 zstp21 zstp22) if welle == 5 & zstp2 != .
replace dauerP = dauerTmp - zstbeg_person_int if dauerTmp > 0 & dauerTmp != . 
drop dauerTmp

egen dauerTmp = rowtotal(zsts1 zsts2 zsts3 zsts4 zsts5 zsts6 zsts7 zsts8 zsts9 zsts10 zsts11 zsts12 zsts13 zsts14) if welle == 5 & zsts2 != .
replace dauerP = dauerTmp - zstbeg_person_int if dauerTmp > 0 & dauerTmp != . 
drop dauerTmp

replace dauerP = zstnachadress - zstbeg_person_int if inrange(welle, 6, 12)
replace dauerP = . if dauerP <= 0
sum dauerP, d

* Drop duplicates
duplicates tag pnr welle, gen(dup) 
bysort pnr welle (dauerP): drop if _n == 1 & dup == 1 

keep pnr hnr welle dauerP

* saving
save $tmp\intDauernPgen.dta, replace
