cap log close
log using "$log\Auswertungen_RR_CAPI.log", replace


*--------------------------------*
* Analysis CAPI experiment 
*--------------------------------*

* load processed final contact dataset
use "$temp\03_aufber_EXP_kw$aktkw.dta", clear 

* keep CAPI 
	tab expw14 mode_exp	
	keep if mode_exp == 1

	
** Compare Response Rate between low und high propensities

	// Interviews
	tab low_prop_capi interview, ro 					.
	tab expw14 interview if expw14 ~= 16, ro 			
	tabstat interview if expw14 ~= 16, by(expw14) statistics(N mean)  

	// Regression CAPI
	logit interview i.expw14, cluster(INTNR)	
	margins expw14, pwcompare(pveffects)		


	
* F2F exclude no intnr 
	tab expw14 SMETH
	drop if expw14 == 16

	
* All low prop with respondent incentive
gen low_bef_inc = .
	replace low_bef_inc = 1 if expw14 == 11 | expw14 == 12 					// respondent incentive
	replace low_bef_inc = 0 if expw14 == 13 | expw14 == 14 | expw14 == 15 	// no respondent incentive
	tab low_bef_inc
	
	tab low_bef_inc interview, ro 	
	tabstat interview, by(low_bef_inc) statistics(N mean)  
	
	// Regression 
	logit interview i.low_bef_inc, cluster(INTNR)	
	margins low_bef_inc, pwcompare(pveffects)		

	
	
* Create two dummy vars for repression: : Interviewer incentive (yes/no) and respodent incentive (yes/no)
	gen int_inc = 0
	replace int_inc = 1 if expw14 == 11 | expw14 == 13 // interviewer incentive
	tab int_inc
	
	gen bef_inc = 0
	replace bef_inc = 1 if expw14 == 11 | expw14 == 12 // respodent incentive
	tab bef_inc
	
	save "$temp\capi_aufbereitung_mit_high.dta", replace	

	drop if expw14 == 0 // drop high propensitiy cases
	tab expw14


	// Interviews
	tab int_inc interview, ro 	
	tab bef_inc interview, ro 	
	
	
	// Regression CAPI
	logit interview i.int_inc i.bef_inc, cluster(INTNR)		// Befragtenincentive schwach signifikant
	
	logit interview i.int_inc##i.bef_inc, cluster(INTNR) 	// Interaktion nicht signifikant
	eststo ame1: margins i.int_inc##i.bef_inc, post			// vorgesagte Werte
	
	/* coefplot (ame1, color(black) ciopts(color(black%20))), ///
					title("Response Rate", size(medium) span )				///
					xtitle("Vorhergesagter Wert") 	
		*/			

					
	save "$temp\capi_aufbereitung_ohne_high.dta", replace	
	
	
log close