####################################################################################################
# Data preparation steps in R
####################################################################################################

# Clear
rm(list = ls())

####################################################################################################
# Load the data
####################################################################################################

load("data.rdata")

####################################################################################################
# Imputation
####################################################################################################

# Change hsprache
data$hsprache[data$hsprache==3] <- 2 

# Transforming variables to a factor
data$ausfall <- data$autkam
data$autkam <- NULL
cols <- c("ausfall", "zpsex", "PB0100", "PD0200", "PD0500", "PET0510", "PEK1400", "PEK1450", "PSK0100", "PSK0400a", "PSK0400b", "PSK0400c", "PSK0400d", "PSK0400e", "PG0500", "PG0800", "PP0110", "PMI0100", "ekinu18", "etakt", "alakt", "partner", "zuspiel", "schul2", "beruf2", "hintmod", "hsprache", "HW0300", "HEK0100", "HEK0120", "HEK0200", "HEK0400", "HEK2000", "HEK2200", "kindu4", "kindu15", "alg2abez", "umzug", "bundesld", "sample_kat", "interesse", "verstaendnis", "zuverlaessig", "schwierigkeit", "HLS2300a_mis", "HLS2400a_mis", "HEK0600_mis", "HEK1200_mis", "HEK1420_mis", "PA0900_mis", "int_sex", "int_schul")
data[cols] <- lapply(data[cols], factor)
sapply(data, class)

# Imputing with MICE
drops <- c("mis_pnr", "HLS2300a_mis", "HLS2400a_mis", "HEK0600_mis", "HEK1200_mis", "HEK1420_mis", "PA0900_mis")
tempData1 <- data[ , !(names(data) %in% drops)]
tempData <- mice(tempData1, m=1, maxit=5, seed=1234) 

dataImp1 <- mice::complete(tempData, 1)
dataImp <- cbind(dataImp1, data[ , (names(data) %in% drops)])

####################################################################################################
# Prepare data for ML
####################################################################################################

##############################################
# Normalization and one-hot-encoding

# identify numerical variables
numeric_vars <- vapply(dataImp, is.numeric, logical(1))
numeric_vars["welle"] <- FALSE

# identify factor variables
factor_vars <- vapply(dataImp, is.factor, logical(1))
factor_vars["ausfall"] <- FALSE

# one-hot-encode factors
factors_as_dummies <- model.matrix( ~ . -1, dataImp[, factor_vars])

# combine non-factor variables with dummy-coded factors
data_ml <- cbind(dataImp[, !factor_vars], factors_as_dummies[,2:ncol(factors_as_dummies)])

##############################################
# Train-test-split

#Partitioning the data into training and validation data
set.seed(102)
index = data_ml$welle != 12
train = data_ml[index==T,]
validation = data_ml[index==F,]

train$ausfall <- as.numeric(train$ausfall)
train$ausfall <- ifelse(train$ausfall == 2, 0, 1)
train$ausfall <- as.factor(train$ausfall)

validation$ausfall <- as.numeric(validation$ausfall)
validation$ausfall <- ifelse(validation$ausfall == 2, 0, 1)
validation$ausfall <- as.factor(validation$ausfall)

# Remove wave
train$welle <- NULL
validation$welle <- NULL

# Setting levels for both training and validation data
levels(train$ausfall) <- make.names(levels(factor(train$ausfall)))
levels(validation$ausfall) <- make.names(levels(factor(validation$ausfall)))
