*** Adaptives Design: Preparation delivery to infas, assignment to incentives

* Globals & settings
global data_14			"N:\Ablagen\D01700-Projekte\D01700-Adaptives_design\Archivierung\Data_stata\orig\Sample_w14"
global tmp 				"N:\Ablagen\D01700-Projekte\D01700-Adaptives_design\Archivierung\Data_stata\data"
set sortseed 1234

* Load data with predicted propensities, only hnr, mode and propensity 
*use hnr X0 hintmod using "N:\Ablagen\D01700-IAB-Projekte\D01700-Adaptives_design\R\predictionsFinal_20200203.dta", clear
use hnr X0 hintmod using "$tmp\predictions_w13.dta", clear
format hnr %12.0g
rename X0 propensity

* merge to the PASS gross sample wave 14
merge 1:1 hnr using "$data_14/PASS_W14_Panelstichprobe_HH_infas_7123_20200108.dta", keep(3)

* keep 50% of low propensities cases
sum propensity, d
keep if propensity >= r(p50)

** CATI-field --> only Befragtenincentives (50%)
set seed 20200120
gen random_cati = uniform() if smeth == 2
egen inc_b_cati = cut(random_cati), group(2)
drop random_cati


** CAPI-field --> 50% Respondent- and 50% Interviewerincentives --> infas will later set 20% to never/never
* Respondent incentive (50% = 1, 50% = 0)
set seed 20200120
gen random_capi = uniform() if smeth == 1
egen inc_b_capi = cut(random_capi), group(2)
egen inc_b = rowtotal(inc_b_cati inc_b_capi), missing
drop random_capi inc_b_cati inc_b_capi

* Interviewer incentive (50% = 1, 50% = 0)
set seed 20200127
gen random_capi = uniform() if smeth == 1
egen inc_i = cut(random_capi), group(2)
drop random_capi

* Label Treatmentvariable
label var inc_b "Respondent incentive"
label var inc_i "Interviewer incentive"
label def inc_lb 0 "No incentive" 1 "Incentive"
label val inc_b inc_i inc_lb

* Counting
bysort smeth: tab inc_b inc_i, m
pwcorr inc_b inc_i if smeth == 1,  sig

bysort inc_i: sum propensity
bysort inc_b smeth: sum propensity

* Sort und keep variables
drop propensity
order hnr smeth hintmod inc_b inc_i

* Save
save "$tmp/PASS_W14_Treatment_adaptives_Design_20200203.dta", replace


