cap log close
log using "$log\Auswertungen_BIAS_CAPI.log", replace


*--------------------------------*
* analysis CAPI and CATI Experiment 
*--------------------------------*

* load data
use "$temp\aufbereitung_bias2.dta", clear 

* keep CAPI 
	tab expw14 mode_exp	
	keep if mode_exp == 1

* all intnr preserved
drop if expw14 == 16
	
* incentivized = respodent Incentive (ONLY Interviewer-Incentive = not incentivized)
	tab expw14 low_prop_capi

* Differentiate Non incentivized uad incentivized Low-Prop cases
gen low_inc  = .
	replace low_inc = 1 if low_prop_capi == 1 & (expw14 >= 11 & expw14 < 14)	// CAPI incentivized Low prop.
	replace low_inc = 0 if low_prop_capi == 1 & (expw14 >= 13)					// CAPI non-incentivized low prop.
		
tab expw14 low_inc, m
	
** zunächst Fallzahlen generieren für (13) und (14)
	
	* N_brutto die Fallzahl in der Brutto Stichprobe
	gen N_brutto = 1 if brutto == 1
	qui: sum N_brutto
	global N_brutto = r(N)

	* N_netto die Fallzahl der realisierten Stichprobe
	gen N_netto = 1 if netto == 1
	qui: sum N_netto
	global N_netto = r(N)
	
	* RR
	global N_rr = $N_netto/$N_brutto

	* N_h_brutto die Fallzahl der high propensity Fälle in der Brutto Stichprobe
	gen N_h_brutto = 1 if expw14 == 0 & brutto == 1
	qui: sum N_h_brutto
	global N_h_brutto = r(N)

	* N_h_netto die Fallzahl der high propensity Fälle in der realisierten Stichprobe
	gen N_h_netto = 1 if expw14 == 0 & netto == 1
	qui: sum N_h_netto
	global N_h_netto = r(N)
	
	* RR
	global N_h_rr = $N_h_netto/$N_h_brutto

	* N_l_brutto die Fallzahl der nicht incentivierten low propensity Fälle in der Brutto-Stichprobe
	gen N_l_brutto = 1 if low_inc == 0 & brutto == 1
	qui: sum N_l_brutto
	global N_l_brutto = r(N)

	* N_l_netto die Fallzahl der nicht incentivierten low propensity Fälle in der realisierten Stichprobe
	gen N_l_netto = 1 if low_inc == 0 & netto == 1
	qui: sum N_l_netto
	global N_l_netto = r(N)
	
	* RR
	global N_l_n_rr = $N_l_netto/$N_l_brutto

	* N_l_i_brutto die Fallzahl der incentivierten low propensity Fälle in der Brutto-Stichprobe
	gen N_l_i_brutto = 1 if low_inc == 1 & brutto == 1
	qui: sum N_l_i_brutto
	global N_l_i_brutto = r(N)

	* N_l_i_netto die Fallzahl der incentivierten low propensity Fälle in der realisierten Stichprobe
	gen N_l_i_netto = 1 if low_inc == 1 & netto == 1
	qui: sum N_l_i_netto
	global N_l_i_netto = r(N)
	
	* RR
	global N_l_i_n_rr = $N_l_i_netto/$N_l_i_brutto
	
	* leeres global für Tabelle
	global leer = .


* Merkmale (z.T. metrisch, z.T. Dummies), Mittelwertvergleiche: palter HEK0600 PSK0200 HA0100 PA0300 PA0800	PA0100	PMI0100 interesse

sum palter HEK0600 PSK0200 HA0100 PA0300 PA0800	PA0100	PMI0100 interesse
recode PMI0100 (2 = 0)
recode interesse (2 = 0)

global varlist "palter HEK0600 PSK0200 HA0100 PA0300 PA0800	PA0100 PMI0100 interesse"

foreach var of varlist $varlist {

* (1)	Wie ist der Anteil mit diesem Merkmal X in der Bruttostichprobe?
	qui: sum `var' if brutto == 1		
	global `var'_1 = r(mean)
* (2)	Wie ist der Anteil mit diesem Merkmal X in der realisierten Stichprobe?
	qui: sum `var' if netto == 1		
	global `var'_2 = r(mean)
* (3)	Die Differenz von (2) – (1) ist der Nonresponse Bias des Merkmals X
	global `var'_3 = $`var'_2-$`var'_1
	
// Dieselben drei Schritte für alle nicht-incentivierten Fälle aus der Low-Propensity Hälfte:
* (4)	Wie ist der Anteil mit diesem Merkmal X in diesem Teil der Bruttostichprobe?
	qui: sum `var' if brutto == 1 & low_inc == 0
	global `var'_4 = r(mean)
* (5)	Wie ist der Anteil mit diesem Merkmal X in diesem Teil der realisierten Stichprobe?
	qui: sum `var' if netto == 1 & low_inc == 0
	global `var'_5 = r(mean)
* (6)	Die Differenz von (5) – (4) ist der Nonresponse Bias des Merkmals X in diesem Teil der Stichprobe
	global `var'_6 = $`var'_5-$`var'_4
	
// Dieselben drei Schritte für alle incentivierten Fälle aus der Low-Propensity Hälfte

* (7)	Wie ist der Anteil mit diesem Merkmal X in diesem Teil der Bruttostichprobe?
	qui: sum `var' if brutto == 1 & low_inc == 1
	global `var'_7 = r(mean)
* (8)	Wie ist der Anteil mit diesem Merkmal X in diesem Teil der realisierten Stichprobe?
	qui: sum `var' if netto == 1 & low_inc == 1
	global `var'_8 = r(mean)
* (9)	Die Differenz von (8) – (7) ist der Nonresponse Bias des Merkmals X in diesem Teil der Stichprobe
	global `var'_9 = $`var'_8-$`var'_7
	
// Dieselben drei Schritte der Vollständigkeit halber in der High Propensity-Hälfte:

* (10)	Wie ist der Anteil mit diesem Merkmal X in diesem Teil der Bruttostichprobe?
	qui: sum `var' if brutto == 1 & expw14 == 0
	global `var'_10 = r(mean)
* (11)	Wie ist der Anteil mit diesem Merkmal X in diesem Teil der realisierten Stichprobe?
	qui: sum `var' if netto == 1 & expw14 == 0
	global `var'_11 = r(mean)
* (12)	Die Differenz von (11) – (10) ist der Nonresponse Bias des Merkmals X in diesem Teil der Stichprobe
	global `var'_12 = $`var'_11-$`var'_10

// Gedankenexperiment

* (13)	Was wäre passiert, wenn wir niemanden incentiviert hätten: hypothetischer Wert 
	qui: global `var'_13 = ($`var'_11 * $N_h_netto + $`var'_5 * $N_l_netto + ($`var'_7 + $`var'_6)* $N_l_i_brutto * $N_l_netto / $N_l_brutto) / ($N_h_netto + $N_l_netto + (($N_l_i_brutto * $N_l_netto) / $N_l_brutto))
* (14)	Was wäre passiert, wenn wir alle Low Propensity Cases incentiviert hätten: hypothetischer Wert 
	qui: global `var'_14 = (($`var'_11 * $N_h_netto) + ($`var'_8 * $N_l_i_netto) + (($`var'_4 + $`var'_9) * ($N_l_brutto * $N_l_i_netto) / $N_l_i_brutto)) / ($N_h_netto + $N_l_i_netto + (($N_l_brutto * $N_l_i_netto) / $N_l_i_brutto))
* (15)	Den jeweiligen Bias in beiden Szenarien berechnen wir als (13)-(1) 
	qui: global `var'_15 = $`var'_13-$`var'_1
* (16)	bzw. (14)-(1)
	qui: global `var'_16 = $`var'_14-$`var'_1


mat `var' = [$`var'_1,$`var'_2,$`var'_3,$N_brutto,$N_netto,$N_rr \    ///
			 $`var'_10,$`var'_11,$`var'_12,$N_h_brutto,$N_h_netto,$N_h_rr \ ///
			 $`var'_4,$`var'_5,$`var'_6,$N_l_brutto,$N_l_netto,$N_l_n_rr \    ///
			 $`var'_7,$`var'_8,$`var'_9,$N_l_i_brutto,$N_l_i_netto,$N_l_i_n_rr \    ///
			 $`var'_1,$`var'_13,$`var'_15,$leer,$leer,$leer \ ///
			 $`var'_1,$`var'_14,$`var'_16,$leer,$leer,$leer]

mat l `var'			 	  


putexcel set "$xcl/analyse_N_CAPI_neu.xlsx", sheet("`var'") modify
putexcel B2 = matrix(`var')


}


log close