
*---------------------------------------*
* Analysis Initial Bias 
*--------------------------------------*

/*
For each attribute (palter HEK0600 PSK0200 HA0100 PA0300 PA0800 PA0100 PMI0100 interesse) compute whether there is initial bias
	-> Is there a Nonresponse Bias before incentives? --> do (wihtout incentivized cases) respondents and nonrespondents differ from each other 
	-> seperate by CATI / CAPI

1 From gross sample use only high Propensity cases and non-incentivized low propensity cases

2 Generate proportion of wav 14 participants / non-participants
	--> group by variable (group), within the groups created by step 1
		- 1 for participants 
		- 2 (or 0) for non-participants

3 test for difference in proportions  (proportion-command, groups in over()-option)
	- Then generate  prop x, over(group)
	- or for metric vars mean(x), over(group)
	- for all x from the Tables
	
*/


* load data
use "$temp\aufbereitung_bias2.dta", clear 

tab expw14 mode_exp	
drop if expw14 == 16 // no interviewer dropped

* distinguish non-incentivized und incentivized Low-Propensity cases	
gen low_inc  = .
	replace low_inc = 1 if low_prop_capi == 1 & (expw14 >= 11 & expw14 < 14)	// CAPI incentivized Low prop.
	replace low_inc = 1 if low_prop_cati == 1 & (expw14 == 21)					// CATI incentivized Low prop.
	replace low_inc = 0 if low_prop_capi == 1 & (expw14 >= 14 & expw14 < 21)	// CAPI non-incentivized low prop.
	replace low_inc = 0 if low_prop_cati == 1 & (expw14 == 22)					// CATI non-incentivized low prop.

	tab low_inc, m
	


******************************
*** Compute Initial Bias  ***	
******************************


// Step 1: Keep only  High Propensity cases and non incentivized low propensity cases
	
** High Propensity cases from gross sample
gen high_brutto_capi = 1 if expw14 == 0 & brutto == 1 & mode_exp == 1 // CAPI
gen high_brutto_cati = 1 if expw14 == 0 & brutto == 1 & mode_exp == 2 // CATI

** non incentivized low propensity cases from gross sample
gen low_noinc_brutto_capi = 1 if low_inc == 0 & low_prop_capi == 1 & brutto == 1 // CAPI
gen low_noinc_brutto_cati = 1 if low_inc == 0 & low_prop_cati == 1 & brutto == 1 // CATI


** merge
gen group_capi = 1 if high_brutto_capi == 1 | low_noinc_brutto_capi == 1
gen group_cati = 1 if high_brutto_cati == 1 | low_noinc_brutto_cati == 1



	
// Step 2: generate proportion of  (non-)participants Wave 14
	* by (group):  1 for participants und 0 for non participants

** proportion of  (non-)participants Wave 14 (by groups)
gen at_group_capi = 1 if interview == 1 & group_capi == 1			 			// CAPI --> participants
	replace at_group_capi = 0 if interview == 0 & group_capi == 1 				// CAPI --> non Participants 
	tab at_group_capi
gen at_group_cati = 1 if interview == 1 & group_cati == 1			 			// CATI --> participants
	replace at_group_cati = 0 if interview == 0 & group_cati == 1 				// CATI --> non participants 
	tab at_group_cati

lab def tn 1"Respondent" 0"Non-Respondent"
lab val at_group_capi at_group_cati  tn




cap log close
log using "$log\Initial_Bias_Auswertungen_Vergleiche.log", replace



// Schritt 3: Anteilswertdifferenz auf Signifikanz testen (proportion-Befehl, Gruppen als over()-Option)
		* Bilden von prop x, over(group), bzw. mean(x) für metrische Variablen
	
	* mean comparison: palter HEK0600 PSK0200 HA0100 PA0300 PA0800	PA0100	PMI0100 interesse
	sum palter HEK0600 PSK0200 HA0100 PA0300 PA0800	PA0100	PMI0100 interesse
	recode PMI0100 (2 = 0)
	recode interesse (2 = 0)

	
	proportion PMI0100, over(at_group_capi)
	test 1.PMI0100@0.at_group_capi=1.PMI0100@1.at_group_capi 
	ttest PMI0100, by(at_group_capi)

	
	proportion interesse, over(at_group_capi)
	test 1.interesse@0.at_group_capi=1.interesse@1.at_group_capi 
	ttest interesse, by(at_group_capi)



// mean comparison

lab var palter "Alter"

global varlist "palter HEK0600 PSK0200 HA0100 PA0300 PA0800	PA0100 PMI0100 interesse"

 
foreach var of varlist $varlist {
		di "CAPI `var'"
		di "`: variable label `var''"
		ttest `var', by(at_group_capi)
		di "CATI `var'"
		di "`: variable label `var''"
		ttest `var', by(at_group_cati)
	}
	
	
log close