####################################################################################################
# ML estimation
####################################################################################################


####################################################################################################
# Metric
####################################################################################################

set.seed(12345)
performance_metric <- "ROC"
repeats <- 3
numbers <- 10


# List of models
models <- list()

# Control
set.seed(1234)
ctrl <- trainControl(method = "repeatedcv",
                     repeats = repeats,
                     number = numbers,
                     selectionFunction = "best",
                     summaryFunction = twoClassSummary,
                     classProbs = TRUE,
                     sampling = "down")


####################################################################################################
# Logistic Regression
####################################################################################################

glm(ausfall~., 
    data = train, 
    family="binomial")


system.time(models$log <- train(ausfall~., 
                                data = train, 
                                method = "glm",
                                family="binomial",
                                preProcess = c("scale", "center"),
                                metric = performance_metric,
                                trControl = ctrl)) 


####################################################################################################
# Elastic net
####################################################################################################

system.time(models$glmnet <- train(ausfall~., 
                                   data = train, 
                                   method = "glmnet",
                                   family="binomial",
                                   preProcess = c("scale", "center"),
                                   metric = performance_metric,
                                   tuneGrid=expand.grid(alpha=seq(0,1,length=10),
                                                        lambda= seq(0.0001,0.2,length=10)),
                                   trControl = ctrl)) 


####################################################################################################
# classification tree
####################################################################################################

system.time(models$tree <- train(ausfall ~ .,
                                 data = train,
                                 method = "rpart",
                                 metric = performance_metric,
                                 preProcess = c("scale", "center"),
                                 tuneGrid = data.frame(cp = seq(0.0008, 0.02, by = 0.0001)),
                                 trControl = ctrl))


####################################################################################################
# KNN
####################################################################################################

system.time(models$knn <- train(ausfall ~ ., 
                                data = train, 
                                method = "knn",
                                metric = performance_metric,
                                preProcess = c("scale", "center"),
                                trControl = ctrl,        
                                tuneGrid = data.frame(k = seq(20, 400, by = 20))))


                            
####################################################################################################
# Random Forest
####################################################################################################

rfGrid <- expand.grid(mtry = c(6, 8, 10, 12, 14, 16, 20, 30),
                      splitrule = "gini",
                      min.node.size = c(30, 50, 100, 150, 200, 300, 500))

set.seed(1234)
system.time(models$rf <- train(ausfall~., 
                                         data = train,
                                         method = "ranger",
                                         metric = performance_metric,
                                         preProcess = c("center", "scale"),
                                         trControl = ctrl,
                                         tuneGrid = rfGrid))



####################################################################################################
# GBM Gradient Boosting Machine
####################################################################################################

gbmGrid <- expand.grid(interaction.depth = c(1, 2, 3, 4),
                       n.trees = c(200, 300, 400, 500, 600),
                       shrinkage = c(0.02, 0.04, 0.06, 0.08),
                       n.minobsinnode = c(100, 150, 200, 300, 400))

system.time(models$gbm <- train(ausfall~., 
                                         data = train,
                                         method = "gbm",
                                         metric = performance_metric,
                                         preProcess = c("center", "scale"),
                                         trControl = ctrl,
                                         tuneGrid = gbmGrid))


####################################################################################################
# XgBoost
####################################################################################################

gridXGB <- expand.grid(nrounds = c(100, 200, 300),
                       max_depth = c(1, 2, 3),
                       eta = c(0.02, 0.05, 0.1),
                       gamma = c(0, 0.5, 1),
                       colsample_bytree = c(0.4, 0.6, 0.8),
                       min_child_weight = c(1, 2),
                       subsample = c(.8, 1))

set.seed(1234)
system.time(models$xgb <- train(ausfall~., 
                                         data = train,
                                         method = "xgbTree",
                                         metric = performance_metric,
                                         preProcess = c("center", "scale"),
                                         trControl = ctrl,
                                         tuneGrid = gridXTB))


save.image("DATA/AllModelsPaper.RData")
