*--------------------------------*
* data processing
*--------------------------------*

* load dataset with estimated response propensities
use "$temp\predictions_w13.dta", clear
count

* Create deciles of resp. prop. across both modesModusübergreifend
	// X1 = Teilnahmewahrscheinlichkeit
	bysort hintmod: sum X1	

	xtile quant = X1, nq(10)
	tab quant
	
save "$temp\predictionsFinal_dezile.dta", replace


* load contact dataset of current wave 
*use "$orig\02_hist_code_kw$aktkw.dta", clear 	 	// (Standard Definitions) AAPOR-coded contact history
use "$orig\Contact_data\PASSW14-Kontaktdaten_KW39_final.dta", clear 	 	// load final contact data

	rename HNR hnr
	sort hnr

* only keep cases used to estimate propensities
merge m:1 hnr using "$temp\predictionsFinal_dezile.dta"
keep if _merge == 3 
drop _merge


* Merge treatment variable
	merge m:1 hnr using "$treatment\PASS_W14_Panelstichprobe_HH_Experimentzuweisung_infas_7123_20200205.dta" 
	tab SMETH
	tab STICH _merge, m 
	tab expw14 if _merge == 2 // no tretament assignment
	keep if STICH == 1 // keep panel cases only 
	drop _merge 
	tab expw14 SMETH, m 

	lab def expw14 0"0 high propensity", modify // cases without treatnment are high prop
	lab val expw14 expw14


* distinguish CAPI and CATI Experiment 
	tab expw14 SMETH, m nolab
	tab expw14 SMETH, m 

	gen mode_exp = 1 																		// CAPI Experiment
	replace mode_exp = 2 if (expw14 >= 21 & SMETH <= 11) | (expw14 == 0 & SMETH <= 11)  	// CATI Experiment
	lab def mode_exp 1 "1 CAPI-Experiment"  2 "2 CATI-Experiment", modify
	lab val mode_exp mode_exp
	tab expw14 mode_exp
	bysort mode_exp: tab expw14 


	sort hnr
	count if hnr~=hnr[_n-1] 
	
save "$temp\02_hist_code_EXP_kw$aktkw.dta", replace 



// Analyses --> dep var = Interview yes/no

* Dummy variable for low and high propensity groups, separate by CATI / CAPI
	* CAPI
	gen low_prop_capi = 1 if mode_exp == 1						// low	
	replace low_prop_capi = 0 if mode_exp == 1 & expw14 == 0	// high
	
	* CATI
	gen low_prop_cati = 1 if mode_exp == 2						// low	
	replace low_prop_cati = 0 if mode_exp == 2 & expw14 == 0	// high

	lab def low_prop 0"0 high propensity" 1"1 low propensity", modify
	lab val low_prop_cati low_prop_capi low_prop
	tab low_prop_cati low_prop_capi, m

	sort HHELFD hnr KONDAT_j KONDAT_m KONDAT_t KONUHR_h KONUHR_m KON_NR LASTKON  				


*********************************
*** Interview successful
*********************************

* Interview on household level successful (HHELFD == PELFD --> hbv)
	keep if HHELFD == PELFD

	gen intv = 0
	replace intv = 1 if RCL == 18 
	bysort HHELFD: egen interview = max(intv)
 
	by HHELFD: gen n = _n		// generate count variable  (contact attempts 1 to x)
	by HHELFD: gen N = _N		// generate sum	(x contact attenmpts)

	keep if n==N // letzten Kontakt behalten
	keep HHELFD hnr KON_NRH expw14 interview N low_prop_cati low_prop_capi mode_exp INTNR SMETH X0 X1 Ausfall quant



*************************
** create deciles      *
*************************

// Q1-Q5 incentivized, Q6-Q10 not incentivized  	

tab quant expw14		
bysort mode_exp: tab quant expw14
save "$temp\03_aufber_EXP_kw$aktkw.dta", replace 
