*****ANALYSIS CODE*****
****Satisficing Response Behavior Across Time: Assessing Negative Panel Conditioning Using an Experimental Design with Six Repetitions ****
***Author: Fabienne Kraemer***

clear all
set more off
set maxvar 32000

*Set file path
cd ""

*Load data set
use ""


capture log close
log using analysis-satisficing.log, replace

************************************PART 1**************************************

***Define analytic sample***
*Respondents participating in all 6 panel waves
keep if fdispcode==31 | fdispcode==32

*Variable for experimental groups with different levels of conditioning frequency and different conditioning intervals

fre group
label var group "Experimental group"
label value group grp
label define grp 1 "Conditioned-short" 2 "Unconditioned-short" 3 "Conditioned-long" 8 "Unconditioned-long" 

********************************************************************************
********** EXISTENCE AND EXTENT OF SATISFICING IN EACH WAVE **********

**Main analytic sample: Fully conditioned respondents of short interval (group 1)**

********************************************************************************

***Response order experiments***

*Experiment 1: Adequate housing*


*Wave 1/wave a
fre atro1a atro1b

gen atro1_total=.
replace atro1_total=1 if atro1a==1 | atro1b==2
replace atro1_total=0 if atro1a==2 | atro1b==1

fre atro1_total

label value atro1_total atro1
label define atro1 0 "Individual" 1 "State"

*Group trigger
fre atriggerro1
mvdecode atriggerro1, mv(-11=.)

*Primacy effect in wave 1/wave a
tab atriggerro1 atro1_total if group==1, row chi2

*Wave 2/wave b
fre btro1a btro1b

gen btro1_total=.
replace btro1_total=1 if btro1a==1 | btro1b==2
replace btro1_total=0 if btro1a==2 | btro1b==1

fre btro1_total

label value btro1_total btro1
label define btro1 0 "Individual" 1 "State"

*Group trigger
fre btriggerro1
mvdecode btriggerro1, mv(-11=.)

*Primacy effect in wave 2/wave b
tab btriggerro1 btro1_total if group==1, row chi2

*Wabe 3/wave c
fre ctro1a ctro1b 

gen ctro1_total=.
replace ctro1_total=1 if ctro1a==1 | ctro1b==2
replace ctro1_total=0 if ctro1a==2 | ctro1b==1

fre ctro1_total

label value ctro1_total ctro1
label define ctro1 0 "Individual" 1 "State"

*Group trigger
fre ctriggerro1
mvdecode ctriggerro1, mv(-11=.)

*Primacy effect in wave 3/wave c
tab ctriggerro1 ctro1_total if group==1, row chi2

*Wave 4/wave d
fre dtro1a dtro1b

gen dtro1_total=.
replace dtro1_total=1 if dtro1a==1 | dtro1b==2
replace dtro1_total=0 if dtro1a==2 | dtro1b==1

fre dtro1_total

label value dtro1_total dtro1
label define dtro1 0 "Individual" 1 "State"

*Group trigger
fre dtriggerro1
mvdecode dtriggerro1, mv(-11=.)

*Primacy effect in wave 4/wave d
tab dtriggerro1 dtro1_total if group==1, row chi2

*Wave 5/wave e
fre etro1a etro1b

gen etro1_total=.
replace etro1_total=1 if etro1a==1 | etro1b==2
replace etro1_total=0 if etro1a==2 | etro1b==1

fre etro1_total

label value etro1_total etro1
label define etro1 0 "Individual" 1 "State"

*Group trigger
fre etriggerro1
mvdecode etriggerro1, mv(-11=.)

*Primacy effect in wave 5/wave e
tab etriggerro1 etro1_total if group==1, row chi2

*Wave 6/wave f
fre ftro1a ftro1b

gen ftro1_total=.
replace ftro1_total=1 if ftro1a==1 | ftro1b==2
replace ftro1_total=0 if ftro1a==2 | ftro1b==1

fre ftro1_total

label value ftro1_total ftro1
label define ftro1 0 "Individual" 1 "State"

*Group trigger
fre ftriggerro1
mvdecode ftriggerro1, mv(-11=.)

*Primacy effect in wave 6/wave f
tab ftriggerro1 ftro1_total if group==1, row chi2

********************************************************************************
*Experiment 2: Trust*

*Wave 1/wave a
fre atro2a atro2b

gen atro2_total=.
replace atro2_total=1 if atro2a==1 | atro2b==2
replace atro2_total=0 if atro2a==2 | atro2b==1

fre atro2_total

label value atro2_total atro2 
label define atro2 0 "Cannot be careful enough" 1 "Most people can be trusted"

*Group trigger
fre atriggerro2
mvdecode atriggerro2, mv(-11=.)

*Primacy effect in wave 1/wave a
tab atriggerro2 atro2_total if group==1, row chi2

*Wave 2/wave b
fre btro2a btro2b

gen btro2_total=.
replace btro2_total=1 if btro2a==1 | btro2b==2
replace btro2_total=0 if btro2a==2 | btro2b==1

fre btro2_total

label value btro2_total btro2 
label define btro2 0 "Cannot be careful enough" 1 "Most people can be trusted"

*Group trigger
fre btriggerro2
mvdecode btriggerro2, mv(-11=.)

*Primacy effect in wave 2/wave b
tab btriggerro2 btro2_total if group==1, row chi2

*Wave 3/wave c
fre ctro2a ctro2b

gen ctro2_total=.
replace ctro2_total=1 if ctro2a==1 | ctro2b==2
replace ctro2_total=0 if ctro2a==2 | ctro2b==1

fre ctro2_total

label value ctro2_total ctro2 
label define ctro2 0 "Cannot be careful enough" 1 "Most people can be trusted"


*Group trigger
fre ctriggerro2
mvdecode ctriggerro2, mv(-11=.)

*Primacy effect in wave 3/wave c
tab ctriggerro2 ctro2_total if group==1, row chi2

*Wave 4/wave d
fre dtro2a dtro2b

gen dtro2_total=.
replace dtro2_total=1 if dtro2a==1 | dtro2b==2
replace dtro2_total=0 if dtro2a==2 | dtro2b==1

fre dtro2_total

label value dtro2_total dtro2 
label define dtro2 0 "Cannot be careful enough" 1 "Most people can be trusted"

*Group trigger
fre dtriggerro2
mvdecode dtriggerro2, mv(-11=.)

*Primacy effect in wave 4/wave d
tab dtriggerro2 dtro2_total if group==1, row chi2

*Wave 5/wave e
fre etro2a etro2b

gen etro2_total=.
replace etro2_total=1 if etro2a==1 | etro2b==2
replace etro2_total=0 if etro2a==2 | etro2b==1

fre etro2_total

label value etro2_total etro2 
label define etro2 0 "Cannot be careful enough" 1 "Most people can be trusted"

*Group trigger
fre etriggerro2
mvdecode etriggerro2, mv(-11=.)

*Primacy effect in wave 5/wave e
tab etriggerro2 etro2_total if group==1, row chi2


*Wave 6/wave f
fre ftro2a ftro2b

gen ftro2_total=.
replace ftro2_total=1 if ftro2a==1 | ftro2b==2
replace ftro2_total=0 if ftro2a==2 | ftro2b==1

fre ftro2_total

label value ftro2_total ftro2 
label define ftro2 0 "Cannot be careful enough" 1 "Most people can be trusted"

*Group trigger
fre ftriggerro2
mvdecode ftriggerro2, mv(-11=.)

*Primacy effect in wave 6/wave f
tab ftriggerro2 ftro2_total if group==1, row chi2

********************************************************************************

*** Acquiescence experiments ***
*Experiment 1: Women in politics*


*Wave 1/wave a
fre atacq1a atacq1b

gen atacq1_total=.
replace atacq1_total=1 if atacq1a==1 | atacq1b==1
replace atacq1_total=0 if atacq1a==2 | atacq1b==2 |atacq1b==3

fre atacq1_total

label value atacq1_total atacq1 
label define atacq1 0 "Men not better suited" 1 "Most men better suited"

*Group trigger
fre atriggeracq1
mvdecode atriggeracq1, mv(-11=.)

*Acquiescence in wave 1/wave a
tab atriggeracq1 atacq1_total if group==1, row chi2

*Wave 2/wave b
fre btacq1a btacq1b

gen btacq1_total=.
replace btacq1_total=1 if btacq1a==1 | btacq1b==1
replace btacq1_total=0 if btacq1a==2 | btacq1b==2 |btacq1b==3

fre btacq1_total

label value btacq1_total btacq1 
label define btacq1 0 "Men not better suited" 1 "Most men better suited"

*Group trigger
fre btriggeracq1
mvdecode btriggeracq1, mv(-11=.)

*Acquiescence in wave 2/wave b
tab btriggeracq1 btacq1_total if group==1, row chi2

*Wave 3/wave c
fre ctacq1a ctacq1b

gen ctacq1_total=.
replace ctacq1_total=1 if ctacq1a==1 | ctacq1b==1
replace ctacq1_total=0 if ctacq1a==2 | ctacq1b==2 |ctacq1b==3

fre ctacq1_total

label value ctacq1_total ctacq1 
label define ctacq1 0 "Men not better suited" 1 "Most men better suited"

*Group trigger
fre ctriggeracq1
mvdecode ctriggeracq1, mv(-11=.)

*Acquiescence in wave 3/wave c
tab ctriggeracq1 ctacq1_total if group==1, row chi2

*Wave 4/wave d
fre dtacq1a dtacq1b

gen dtacq1_total=.
replace dtacq1_total=1 if dtacq1a==1 | dtacq1b==1
replace dtacq1_total=0 if dtacq1a==2 | dtacq1b==2 |dtacq1b==3

fre dtacq1_total

label value dtacq1_total dtacq1 
label define dtacq1 0 "Men not better suited" 1 "Most men better suited"

*Group trigger
fre dtriggeracq1
mvdecode dtriggeracq1, mv(-11=.)

*Acquiescence in wave 4/wave d
tab dtriggeracq1 dtacq1_total if group==1, row chi2

*Wave 5/wave e
fre etacq1a etacq1b

gen etacq1_total=.
replace etacq1_total=1 if etacq1a==1 | etacq1b==1
replace etacq1_total=0 if etacq1a==2 | etacq1b==2 |etacq1b==3

fre etacq1_total

label value etacq1_total etacq1 
label define etacq1 0 "Men not better suited" 1 "Most men better suited"

*Group trigger
fre etriggeracq1
mvdecode etriggeracq1, mv(-11=.)

*Acquiescence in wave 5/wave e
tab etriggeracq1 etacq1_total if group==1, row chi2

*Wave 6/wave f
fre ftacq1a ftacq1b

gen ftacq1_total=.
replace ftacq1_total=1 if ftacq1a==1 | ftacq1b==1
replace ftacq1_total=0 if ftacq1a==2 | ftacq1b==2 |ftacq1b==3

fre ftacq1_total

label value ftacq1_total ftacq1 
label define ftacq1 0 "Men not better suited" 1 "Most men better suited"

*Group trigger
fre ftriggeracq1
mvdecode ftriggeracq1, mv(-11=.)

*Acquiescence in wave 6/wave f
tab ftriggeracq1 ftacq1_total if group==1, row chi2

********************************************************************************
*Experiment 2: Crime*
*Wave 1/wave a
fre atacq2a atacq2b

gen atacq2_total=.
replace atacq2_total=1 if atacq2a==1 | atacq2b==1
replace atacq2_total=0 if atacq2a==2 | atacq2b==2

fre atacq2_total

label value atacq2_total atacq2
label define atacq2 0 "Social circumstances" 1 "Individuals"

*Group trigger
fre atriggeracq2
mvdecode atriggeracq2, mv(-11=.)

*Acquiescence in wave 1/wave a
tab atriggeracq2 atacq2_total if group==1, row chi2

*Wave 2/wave b
fre btacq2a btacq2b

gen btacq2_total=.
replace btacq2_total=1 if btacq2a==1 | btacq2b==1
replace btacq2_total=0 if btacq2a==2 | btacq2b==2

fre btacq2_total

label value btacq2_total btacq2
label define btacq2 0 "Social circumstances" 1 "Individuals"

*Group trigger
fre btriggeracq2
mvdecode btriggeracq2, mv(-11=.)

*Acquiescence in wave 2/wave b
tab btriggeracq2 btacq2_total if group==1, row chi2

*Wave 3/wave c
fre ctacq2a ctacq2b

gen ctacq2_total=.
replace ctacq2_total=1 if ctacq2a==1 | ctacq2b==1
replace ctacq2_total=0 if ctacq2a==2 | ctacq2b==2

fre ctacq2_total

label value ctacq2_total ctacq2
label define ctacq2 0 "Social circumstances" 1 "Individuals"

*Group trigger
fre ctriggeracq2
mvdecode ctriggeracq2, mv(-11=.)

*Acquiescence in wave 3/wave c
tab ctriggeracq2 ctacq2_total if group==1, row chi2

*Wave 4/wave d
fre dtacq2a dtacq2b

gen dtacq2_total=.
replace dtacq2_total=1 if dtacq2a==1 | dtacq2b==1
replace dtacq2_total=0 if dtacq2a==2 | dtacq2b==2

fre dtacq2_total

label value dtacq2_total dtacq2
label define dtacq2 0 "Social circumstances" 1 "Individuals"

*Group trigger
fre dtriggeracq2
mvdecode dtriggeracq2, mv(-11=.)

*Acquiescence in wave 4/wave d
tab dtriggeracq2 dtacq2_total if group==1, row chi2

*Wave 5/wave e
fre etacq2a etacq2b

gen etacq2_total=.
replace etacq2_total=1 if etacq2a==1 | etacq2b==1
replace etacq2_total=0 if etacq2a==2 | etacq2b==2

fre etacq2_total

label value etacq2_total etacq2
label define etacq2 0 "Social circumstances" 1 "Individuals"

*Group trigger
fre etriggeracq2
mvdecode etriggeracq2, mv(-11=.)

*Acquiescence in wave 5/wave e
tab etriggeracq2 etacq2_total if group==1, row chi2

*Wave 6/wave f
fre ftacq2a ftacq2b

gen ftacq2_total=.
replace ftacq2_total=1 if ftacq2a==1 | ftacq2b==1
replace ftacq2_total=0 if ftacq2a==2 | ftacq2b==2

fre ftacq2_total

label value ftacq2_total ftacq2
label define ftacq2 0 "Social circumstances" 1 "Individuals"

*Group trigger
fre ftriggeracq2
mvdecode ftriggeracq2, mv(-11=.)

*Acquiescence in wave 6/wave f
tab ftriggeracq2 ftacq2_total if group==1, row chi2

********************************************************************************
***Don't know experiments***
*Experiment 1: Courts*

*Wave 1/wave a
fre atdk1a atdk1b

*Converting a case of question version B to item nonresponse
bysort id: fre atdk1b if group==1
bysort id: fre atdk1b if group==3

*short interval
*ID 5182
replace atdk1b=-99 if id==5182
fre atdk1b if id==5182

*long interval
*ID 4317
replace atdk1b=-99 if id==4317
fre atdk1b if id==4317

gen atdk1_total=.
replace atdk1_total=1 if atdk1a==-99 | atdk1a==99 | atdk1b==-99
replace atdk1_total=0 if atdk1a==1 | atdk1a==2 | atdk1b==1 | atdk1b==2

fre atdk1_total

label value atdk1_total atdk1
label define atdk1 0 "Substantial Answer" 1 "Nonresponse" 

*Group trigger
fre atriggerdk1
mvdecode atriggerdk1, mv(-11=.)

*Saying don't know in wave 1/wave a
tab atriggerdk1 atdk1_total if group==1, row exact

*Wave 2/wave b
fre btdk1a btdk1b

*Converting a case of question version B to item nonresponse
bysort id: fre btdk1b if group==3

*long interval
*ID 5122
replace btdk1b=-99 if id==5122
fre btdk1b if id==5122

gen btdk1_total=.
replace btdk1_total=1 if btdk1a==-99 | btdk1a==99 | btdk1b==-99
replace btdk1_total=0 if btdk1a==1 | btdk1a==2 | btdk1b==1 | btdk1b==2

fre btdk1_total

label value btdk1_total btdk1
label define btdk1 0 "Substantial Answer" 1 "Nonresponse" 

*Group trigger
fre btriggerdk1
mvdecode btriggerdk1, mv(-11=.)

*Saying don't know in wave 2/wave b
tab btriggerdk1 btdk1_total if group==1, row exact

*Wave 3/wave c
fre ctdk1a ctdk1b

*Converting a case of question version B to item nonresponse
bysort id: fre ctdk1b if group==1

*short interval
*ID 5106
replace ctdk1b=-99 if id==5106
fre ctdk1b if id==5106

gen ctdk1_total=.
replace ctdk1_total=1 if ctdk1a==-99 | ctdk1a==99 | ctdk1b==-99
replace ctdk1_total=0 if ctdk1a==1 | ctdk1a==2 | ctdk1b==1 | ctdk1b==2

fre ctdk1_total

label value ctdk1_total ctdk1
label define ctdk1 0 "Substantial Answer" 1 "Nonresponse" 

*Group trigger
fre ctriggerdk1
mvdecode ctriggerdk1, mv(-11=.)

*Saying don't know in wave 3/wave c
tab ctriggerdk1 ctdk1_total if group==1, row exact

*Wave 4/wave d
fre dtdk1a dtdk1b

*Converting a case of question version B to item nonresponse
bysort id: fre dtdk1b if group==1
bysort id: fre dtdk1b if group==3

*short interval
*ID 5110
replace dtdk1b=-99 if id==5110
fre dtdk1b if id==5110

*long interval
*ID 4989
replace dtdk1b=-99 if id==4989
fre dtdk1b if id==4989


gen dtdk1_total=.
replace dtdk1_total=1 if dtdk1a==-99 | dtdk1a==99 | dtdk1b==-99
replace dtdk1_total=0 if dtdk1a==1 | dtdk1a==2 | dtdk1b==1 | dtdk1b==2

fre dtdk1_total

label value dtdk1_total dtdk1
label define dtdk1 0 "Substantial Answer" 1 "Nonresponse" 

*Group trigger
fre dtriggerdk1
mvdecode dtriggerdk1, mv(-11=.)

*Saying don't know in wave 4/wave d
tab dtriggerdk1 dtdk1_total if group==1, row exact

*Wave 5/wave e
fre etdk1a etdk1b

*Converting a case of question version B to item nonresponse
bysort id: fre etdk1b if group==3

*long interval
*ID 4317
replace etdk1b=-99 if id==4317
fre etdk1b if id==4317

gen etdk1_total=.
replace etdk1_total=1 if etdk1a==-99 | etdk1a==99 | etdk1b==-99
replace etdk1_total=0 if etdk1a==1 | etdk1a==2 | etdk1b==1 | etdk1b==2

fre etdk1_total

label value etdk1_total etdk1
label define etdk1 0 "Substantial Answer" 1 "Nonresponse" 

*Group trigger
fre etriggerdk1
mvdecode etriggerdk1, mv(-11=.)

*Saying don't know in wave 5/wave e
tab etriggerdk1 etdk1_total if group==1, row exact

*Wave 6/wave f
bysort group: fre ftdk1a ftdk1b

*Converting a case of question version B to item nonresponse
*Conditioned Group
bysort id: fre ftdk1b if group==1
bysort id: fre ftdk1b if group==3

*short interval
*ID 5110
replace ftdk1b=-99 if id==5110
fre ftdk1b if id==5110


*long interval
*ID 5167
replace ftdk1b=-99 if id==5167
fre ftdk1b if id==5167

*Unconditioned Group
bysort id: fre ftdk1b if group==2
bysort id: fre ftdk1b if group==8

*short interval
*ID 4981
replace ftdk1b=-99 if id==4981
fre ftdk1b if id==4981

*long interval
*ID 4450
replace ftdk1b=-99 if id==4450
fre ftdk1b if id==4450

gen ftdk1_total=.
replace ftdk1_total=1 if ftdk1a==-99 | ftdk1a==99 | ftdk1b==-99
replace ftdk1_total=0 if ftdk1a==1 | ftdk1a==2 | ftdk1b==1 | ftdk1b==2

fre ftdk1_total

label value ftdk1_total ftdk1
label define ftdk1 0 "Substantial Answer" 1 "Nonresponse" 

*Group trigger
fre ftriggerdk1
mvdecode ftriggerdk1, mv(-11=.)

*Saying don't know in wave 6/wave f
tab ftriggerdk1 ftdk1_total if group==1, row exact

********************************************************************************
*Experiment 2: Smart leaders
*Wave 1/wave a
fre atdk2a atdk2b


*Converting a case of question version B to item nonresponse
bysort id: fre atdk2b if group==1

*short interval
*ID 4400
replace atdk2b=-99 if id==4400
fre atdk2b if id==4400

fre atdk2b

gen atdk2_total=.
replace atdk2_total=1 if atdk2a==-99 | atdk2a==99 | atdk2b==-99
replace atdk2_total=0 if atdk2a==1 | atdk2a==2 | atdk2b==1 | atdk2b==2

fre atdk2_total

label value atdk2_total atdk2
label define atdk2 0 "Substantial Answer" 1 "Nonresponse" 

*Group trigger
fre atriggerdk2
mvdecode atriggerdk2, mv(-11=.)

*Saying don't know in wave 1/wave a
tab atriggerdk2 atdk2_total if group==1, row exact

*Wave 2/wave b
fre btdk2a btdk2b

*Converting a case of question version B to item nonresponse
bysort id: fre btdk2b if group==1
bysort id: fre btdk2b if group==3

*short interval 
*ID 5106
replace btdk2b=-99 if id==5106
fre btdk2b if id==5106

*long interval 
*ID 5122
replace btdk2b=-99 if id==5122
fre btdk2b if id==5122


gen btdk2_total=.
replace btdk2_total=1 if btdk2a==-99 | btdk2a==99 | btdk2b==-99
replace btdk2_total=0 if btdk2a==1 | btdk2a==2 | btdk2b==1 | btdk2b==2

fre btdk2_total

label value btdk2_total btdk2
label define btdk2 0 "Substantial Answer" 1 "Nonresponse" 

*Group trigger
fre btriggerdk2
mvdecode btriggerdk2, mv(-11=.)

*Saying don't know in wave 2/wave b
tab btriggerdk2 btdk2_total if group==1, row exact


*Wave 3/wave c
fre ctdk2a ctdk2b

*Converting a case of question version B to item nonresponse
bysort id: fre ctdk2b if group==1

*short interval
*ID 5106
replace ctdk2b=-99 if id==5106
fre ctdk2b if id==5106

gen ctdk2_total=.
replace ctdk2_total=1 if ctdk2a==-99 | ctdk2a==99 | ctdk2b==-99
replace ctdk2_total=0 if ctdk2a==1 | ctdk2a==2 | ctdk2b==1 | ctdk2b==2

fre ctdk2_total

label value ctdk2_total ctdk2
label define ctdk2 0 "Substantial Answer" 1 "Nonresponse" 

*Group trigger
fre ctriggerdk2
mvdecode ctriggerdk2, mv(-11=.)

*Saying don't know in wave 3/wave c
tab ctriggerdk2 ctdk2_total if group==1, row exact

*Wave 4/wave d
fre dtdk2a dtdk2b

gen dtdk2_total=.
replace dtdk2_total=1 if dtdk2a==-99 | dtdk2a==99 | dtdk2b==-99
replace dtdk2_total=0 if dtdk2a==1 | dtdk2a==2 | dtdk2b==1 | dtdk2b==2

fre dtdk2_total

label value dtdk2_total dtdk2
label define dtdk2 0 "Substantial Answer" 1 "Nonresponse" 

*Group trigger
fre dtriggerdk2
mvdecode dtriggerdk2, mv(-11=.)

*Saying don't know in wave 4/wave d
tab dtriggerdk2 dtdk2_total if group==1, row exact

*Wave 5/wave e
fre etdk2a etdk2b

*Converting a case of question version B to item nonresponse
bysort id: fre etdk2b if group==3

*long interval 
*ID 5122
replace etdk2b=-99 if id==5122
fre etdk2b if id==5122


gen etdk2_total=.
replace etdk2_total=1 if etdk2a==-99 | etdk2a==99 | etdk2b==-99
replace etdk2_total=0 if etdk2a==1 | etdk2a==2 | etdk2b==1 | etdk2b==2

fre etdk2_total

label value etdk2_total etdk2
label define etdk2 0 "Substantial Answer" 1 "Nonresponse" 

*Group trigger
fre etriggerdk2
mvdecode etriggerdk2, mv(-11=.)

*Saying don't know in wave 5/wave e
tab etriggerdk2 etdk2_total if group==1, row exact

*Wave 6/wave f
bysort group: fre ftdk2a ftdk2b

*Converting a case of question version B to item nonresponse
*Conditioned Group
bysort id: fre ftdk2b if group==1
bysort id: fre ftdk2b if group==3

*short interval
*ID 5110
replace ftdk2b=-99 if id==5110
fre ftdk2b if id==5110

*long interval 
*ID 4156
replace ftdk2b=-99 if id==4156
fre ftdk2b if id==4156

gen ftdk2_total=.
replace ftdk2_total=1 if ftdk2a==-99 | ftdk2a==99 | ftdk2b==-99
replace ftdk2_total=0 if ftdk2a==1 | ftdk2a==2 | ftdk2b==1 | ftdk2b==2

fre ftdk2_total

label value ftdk2_total ftdk2
label define ftdk2 0 "Substantial Answer" 1 "Nonresponse" 

*Group trigger
fre ftriggerdk2
mvdecode ftriggerdk2, mv(-11=.)

*Saying don't know in wave 6/wave f
tab ftriggerdk2 ftdk2_total if group==1, row exact


************************************PART 2**************************************
***************************************************************************************************************************
********** CHANGE OF SATISFICING ACROSS WAVES **********

****************************************************************************************************************************
*relabeling trigger variables to comply with overall variable naming scheme of question design experiments

rename atriggerro1 attriggerro1
rename atriggerro2 attriggerro2
rename atriggeracq1 attriggeracq1
rename atriggeracq2 attriggeracq2
rename atriggerdk1 attriggerdk1
rename atriggerdk2 attriggerdk2

rename btriggerro1 bttriggerro1
rename btriggerro2 bttriggerro2
rename btriggeracq1 bttriggeracq1
rename btriggeracq2 bttriggeracq2
rename btriggerdk1 bttriggerdk1
rename btriggerdk2 bttriggerdk2

rename ctriggerro1 cttriggerro1
rename ctriggerro2 cttriggerro2
rename ctriggeracq1 cttriggeracq1
rename ctriggeracq2 cttriggeracq2
rename ctriggerdk1 cttriggerdk1
rename ctriggerdk2 cttriggerdk2

rename dtriggerro1 dttriggerro1
rename dtriggerro2 dttriggerro2
rename dtriggeracq1 dttriggeracq1
rename dtriggeracq2 dttriggeracq2
rename dtriggerdk1 dttriggerdk1
rename dtriggerdk2 dttriggerdk2

rename etriggerro1 ettriggerro1
rename etriggerro2 ettriggerro2
rename etriggeracq1 ettriggeracq1
rename etriggeracq2 ettriggeracq2
rename etriggerdk1 ettriggerdk1
rename etriggerdk2 ettriggerdk2

rename ftriggerro1 fttriggerro1
rename ftriggerro2 fttriggerro2
rename ftriggeracq1 fttriggeracq1
rename ftriggeracq2 fttriggeracq2
rename ftriggerdk1 fttriggerdk1
rename ftriggerdk2 fttriggerdk2


*convert data into long format to create wave dummies
reshape long @ro1_total @ro2_total @acq1_total @acq2_total @dk1_total @dk2_total @triggerro1 @triggerro2 @triggeracq1 @triggeracq2 @triggerdk1 @triggerdk2, i(id) j(wave) string

fre wave

*Converting string to numeric variable
encode wave, gen(waves)
fre waves

*recoding trigger variables into dummies // value 1 is question design that triggers satisficing response behavior
foreach var of varlist *triggerro1 *triggerro2 *triggeracq1 *triggeracq2 *triggerdk1 *triggerdk2 {
	recode `var' (1=1) (2=0)
}

*Logistic random-effects panel regression models
xtset id waves

xtlogit ro1_total triggerro1##i.waves if group==1, re
estimates store changero1

xtlogit ro2_total triggerro2##i.waves if group==1, re
estimates store changero2

xtlogit acq1_total triggeracq1##i.waves if group==1, re
estimates store changeacq1

xtlogit acq2_total triggeracq2##i.waves if group==1, re
estimates store changeacq2

xtlogit dk1_total triggerdk1##i.waves if group==1, re
estimates store changedk1

xtlogit dk2_total triggerdk2##i.waves if group==1, re
estimates store changedk2

*create table output
outreg2 [changero1 changero2 changeacq1 changeacq2 changedk1 changedk2] using satchange_output, word auto(3) alpha(0.001, 0.01, 0.05) replace


************************************PART 3**************************************
************************************************************************************************************************************************************
********** CROSS-SECTIONAL MULTILEVEL MODELS **********
***** DATA BASE WAVE 6 *****
*question design experiments nested in respondents

*drop newly generated variables of Part 2
drop _est* waves

*convert data back to wide format 
reshape wide @ro1_total @ro2_total @acq1_total @acq2_total @dk1_total @dk2_total @triggerro1 @triggerro2 @triggeracq1 @triggeracq2 @triggerdk1 @triggerdk2, i(id) j(wave) string


*relabeling question design experiments to generate overall satisficing variable
rename ftro1_total ro1satisficing
rename ftro2_total ro2satisficing
rename ftacq1_total acq1satisficing
rename ftacq2_total acq2satisficing
rename ftdk1_total dk1satisficing
rename ftdk2_total dk2satisficing

*relabeling trigger variables to generate overall treatment variable
rename fttriggerro1 ro1trigger
rename fttriggerro2 ro2trigger
rename fttriggeracq1 acq1trigger
rename fttriggeracq2 acq2trigger
rename fttriggerdk1 dk1trigger
rename fttriggerdk2 dk2trigger

*convert data into long format to get satisficing measurements nested per respondent
reshape long @satisficing @trigger, i(id) j(experiment) string

fre experiment

*converting string to numeric variable
encode experiment, gen(experiments)
fre experiments

***Cross-sectional multilevel models***
*Dependent variable is satisficing; main explanatory variable is trigger as question design or experimental version
*intercept-only model or null model

melogit satisficing if group==1 | group==2 || id:
estimates store nullmodel

estat icc

*model with response effect

melogit satisficing trigger if group==1 | group==2 || id:
estimates store responseeffect

estat icc

*Recoding experimental group variable to generate dummy on conditioning/no conditioning 
*both
recode group (1 3=1) (2 8=0), gen(expgroup)

label val expgroup expgr
label define expgr 0 "Unconditioned" 1 "Conditioned"

*model with learning mechanism
melogit satisficing trigger##expgroup if group==1 | group==2 || id:
estimates store contentlearnml

estat icc

***** MODERATORS FOR MODERATOR ANALYSES *****
*respondent-level variables (constant for each experiment of the satisficing measure) are panel interval, cognitive ability, and motivation
*** (1) PANEL INTERVAL ***
**Generating variable for conditioning interval**
fre aqintervalshort aqintervallong

gen interval=.
replace interval=0 if aqintervalshort==1
replace interval=1 if aqintervallong==1

label var interval "Conditioning interval"
label value interval intval
label define intval 0 "Short" 1 "Long"

*** (2) COGNITIVE ABILITY ****
*Cognitive Reflection Test*
fre aocogref1 aocogref2 aocogref3

mvdecode aocogref1 aocogref2 aocogref3, mv(-99=.\-77=.\-33=.)

*Correct answers for each item
gen cogref1_corr=.
replace cogref1_corr=1 if aocogref1==5 & aocogref1!=.
replace cogref1_corr=0 if aocogref1!=5 & aocogref1!=.

gen cogref2_corr=.
replace cogref2_corr=1 if aocogref2==5 & aocogref2!=.
replace cogref2_corr=0 if aocogref2!=5 & aocogref2!=.

gen cogref3_corr=.
replace cogref3_corr=1 if aocogref3==47 & aocogref3!=.
replace cogref3_corr=0 if aocogref3!=47 & aocogref3!=.

fre cogref*

*Sum score cognitive ability

egen cogref_score=rowtotal(cogref1_corr cogref2_corr cogref3_corr), m

label value cogref_score cogrefsc
label define cogrefsc 0 "0 items" 1 "1 item" 2 "2 items" 3 "3 items"

*Education*
fre aqedu

mvdecode aqedu, mv(-99=.)

recode aqedu (1 2 3=1) (4=2) (5 6=3), gen(education)

fre education

label value education educ
label define educ 1 "Low" 2 "Middle" 3 "High"

*Correlation cognitive reflection test and education
pwcorr education cogref_score, sig // r=3.0

*** (3) RESPONDENT MOTIVATION ***
fre aonfc1 aonfc2 aonfc3 aonfc4

mvdecode aonfc1 aonfc2 aonfc3 aonfc4, mv(-99=.)

*Reversion of negatively coded items
fre aonfc1 aonfc4

recode aonfc1 (1=7) (2=6) (3=5) (4=4) (5=3) (6=2) (7=1), gen(aonfc1r)
recode aonfc4 (1=7) (2=6) (3=5) (4=4) (5=3) (6=2) (7=1), gen(aonfc4r)

fre aonfc1r aonfc4r

*Mean score of "Need for cognition" 

egen mean_nfc=rowmean(aonfc1r aonfc2 aonfc3 aonfc4r)

fre mean_nfc


*MODERATOR ANALYSES*
*with panel interval
melogit satisficing trigger##expgroup##interval || id:
estimates store modintervalml

*with cognitive performance
melogit satisficing trigger##expgroup##c.cogref_score if group==1 | group==2 || id:
estimates store modcogabml

*with education
melogit satisficing trigger##expgroup##i.education if group==1 | group==2 || id:
estimates store modeduml

*with motivation
melogit satisficing trigger##expgroup##c.mean_nfc if group==1 | group==2 || id:
estimates store modmotml

*create table output
outreg2 [nullmodel responseeffect contentlearnml modintervalml modcogabml modmotml] using multilevel_output, word auto(3) alpha(0.001, 0.01, 0.05) replace
outreg2 [modeduml] using multilevel_education, word auto(3) alpha(0.001, 0.01, 0.05) replace


**************************************PART 4************************************
*********************************VALIDITY ANALYSIS******************************
**Main analytic sample: Fully conditioned respondents of short interval (group 1)**


*drop newly generated variables of Part 3
drop _est* experiments

*convert data back to wide format 
reshape wide @satisficing @trigger, i(id) j(experiment) string


*relabeling question design experiments back to general naming scheme
rename ro1satisficing ftro1_total 
rename ro2satisficing ftro2_total
rename acq1satisficing ftacq1_total
rename acq2satisficing ftacq2_total
rename dk1satisficing ftdk1_total
rename dk2satisficing ftdk2_total

*relabeling trigger variables back to general naming scheme
rename ro1trigger fttriggerro1 
rename ro2trigger fttriggerro2
rename acq1trigger fttriggeracq1
rename acq2trigger fttriggeracq2
rename dk1trigger fttriggerdk1
rename dk2trigger fttriggerdk2

*Response order experiments*
*Experiment 1: Adequate housing

*highest correlating content-related variable: attitudes toward job provision
fre ftjobprov

*recode missing values
mvdecode ftjobprov, mv(-99=.\99=.)

corr ftro1_total ftjobprov if group==1 | group==2 //r=0.2998

*Effect of satisficing on association between content-related variable and variable of interest
logit ftro1_total c.ftjobprov##fttriggerro1 if group==1 | group==2
estimates store validro1_simple

*Difference of effect of satisficing between conditioned and unconditioned group
logit ftro1_total c.ftjobprov##fttriggerro1##expgroup if group==1 | group==2
estimates store validro1

*Experiment 2: Trust

*highest correlating content-related variable: Big5-Item on trust
fre aobigfive2

*recode missing values
mvdecode aobigfive2, mv(-99=.)

corr ftro2_total aobigfive2 if group==1 | group==2 //r=0.4470

*Effect of satisficing on association between content-related variable and variable of interest
logit ftro2_total c.aobigfive2##fttriggerro2 if group==1 | group==2
estimates store validro2_simple

*Difference of effect of satisficing between conditioned and unconditioned group
logit ftro2_total c.aobigfive2##fttriggerro2##expgroup if group==1 | group==2
estimates store validro2

*Acquiescence Experiments*
*Experiment 1: Women in politics

*highest correlating content-related variable: attitudes toward womens' employment and family life

*content-related variables
fre ftfamwork

*recoding missing values
mvdecode ftfamwork, mv(-99=.\99=.)

corr ftacq1_total ftfamwork if group==1 | group== 2 //r=0.2544

*Effect of satisficing on association between content-related variable and variable of interest
logit ftacq1_total c.ftfamwork##fttriggeracq1 if group==1 | group==2
estimates store validacq1_simple

*Difference of effect of satisficing between conditioned and unconditioned group
logit ftacq1_total c.ftfamwork##fttriggeracq1##expgroup if group==1 | group==2
estimates store validacq1

*create table output for results of correlating content-related variables with r >= .2
outreg2 [validro1_simple validro1 validro2_simple validro2 validacq1_simple validacq1] using validity_output, word auto(3) alpha(0.001, 0.01, 0.05) replace

***ROBUSTNESS CHECK***
*Are those who drop out of the panel the ones who satisfice?

*reload dataset
clear all
set maxvar 10000
set more off

cd ""

use ""

**Run PART 1 WITHOUT excluding respondents who fdispcode!=31 & fdispcode!=32**

*recode missing values for unit nonresponse and break-offs in trigger variables
mvdecode *triggerro1 *triggerro2 *triggeracq1 *triggeracq2 *triggerdk1 *triggerdk2, mv(-33=.\-77=.)

*recoding trigger variables into dummies // value 1 is question design triggering satisficing response behavior
foreach var of varlist *triggerro1 *triggerro2 *triggeracq1 *triggeracq2 *triggerdk1 *triggerdk2 {
	recode `var' (1=1) (2=0)
}

*generating a variable for attrition (no/yes) (0/1)
fre fdispcode
gen attrition=.
replace attrition=0 if fdispcode==31 | fdispcode==32
replace attrition=1 if fdispcode!=31 & fdispcode!=32

*Difference in satisficing between full sample and respondents who participated in all waves
*Response Order Experiment: Adequate housing
logit atro1_total atriggerro1##attrition if group==1
logit btro1_total btriggerro1##attrition if group==1
logit ctro1_total ctriggerro1##attrition if group==1
logit dtro1_total dtriggerro1##attrition if group==1
logit etro1_total etriggerro1##attrition if group==1

*Response Order Experiment: Trust
logit atro2_total atriggerro2##attrition if group==1
logit btro2_total btriggerro2##attrition if group==1
logit ctro2_total ctriggerro2##attrition if group==1
logit dtro2_total dtriggerro2##attrition if group==1
logit etro2_total etriggerro2##attrition if group==1

*Acquiescence Experiment: Women in politics
logit atacq1_total atriggeracq1##attrition if group==1
logit btacq1_total btriggeracq1##attrition if group==1
logit ctacq1_total ctriggeracq1##attrition if group==1
logit dtacq1_total dtriggeracq1##attrition if group==1
logit etacq1_total etriggeracq1##attrition if group==1

*Acquiescence Experiment: Crime
logit atacq2_total atriggeracq2##attrition if group==1
logit btacq2_total btriggeracq2##attrition if group==1
logit ctacq2_total ctriggeracq2##attrition if group==1
logit dtacq2_total dtriggeracq2##attrition if group==1
logit etacq2_total etriggeracq2##attrition if group==1

*Don't Know Experiment: Courts
logit atdk1_total atriggerdk1##attrition if group==1
logit btdk1_total btriggerdk1##attrition if group==1
logit ctdk1_total ctriggerdk1##attrition if group==1
logit dtdk1_total dtriggerdk1##attrition if group==1
logit etdk1_total etriggerdk1##attrition if group==1

*Don't Know Experiment: Smart leaders
logit atdk2_total atriggerdk2##attrition if group==1
logit btdk2_total btriggerdk2##attrition if group==1
logit ctdk2_total ctriggerdk2##attrition if group==1
logit dtdk2_total dtriggerdk2##attrition if group==1
logit etdk2_total etriggerdk2##attrition if group==1


****** BENCHMARK ANALYSIS ******
***** GESIS PANEL: QUESTION DESIGN EXPERIMENTS*****
***DATA PREPARATION***
clear all
set maxvar 50000
set more off

* Define a macro with entering the file path where the GESIS Panel data are located

global filepath `""'


***************************************************************************
***																		***
***		Merging and appending the data (no changes required)			***
***																		***
***************************************************************************

global path = subinstr("${filepath}",char(92),char(47),.) //slash replace
global dataDta: dir `"${path}"' files "*.dta" //get all Stata data files from filepath
global dataDta = lower(`"${dataDta}"') //set string to lower case

//get recruitment and wave datasets
foreach x of global dataDta {
	if regexm(`"`x'"', "^za566[45]_[a-z][1-9]_[a-z][1-9][0-9]-[a-z][1-9][0-9]_v[1-9][0-9]-[0-9]-[0-9]") {
		local recruitment = strtrim("`recruitment'"+" `x'")
	}
	if regexm(`"`x'"', "^za566[45]_[a-z][1-9]_[a-z][a-z]-[a-z][a-z]_v[1-9][0-9]-[0-9]-[0-9]") {
		local waves = strtrim("`waves'"+" `x'")
	}
	if regexm(`"`x'"', "^za566[45]_[a-z][1-9]_[a-z][a-z]_v[1-9][0-9]-[0-9]-[0-9]") {
		local waves = strtrim("`waves'"+" `x'")
	}
}

//get cohorts
local r = wordcount(`"`recruitment'"')
tokenize `"`recruitment'"'
forval i=1(1)`r' {
	if regexm("``i''", "_[a-z][1-9]_") {
		local c = subinstr(regexs(0), "_","",.)
	}
	local cohort_`c' = `"${path}/``i''"'
	local cohorts = strtrim("`cohorts'"+" `c'")
}

//get cohort specific datasets
foreach c of local cohorts {
	tempfile dta_`c'
	use `"`cohort_`c''"', clear
	tokenize `"`waves'"'
	local j = wordcount(`"`waves'"') 
	forval i=1(1)`j' {
		if regexm("``i''", "_[a-z][1-9]_") { 
			if regexs(0)==`"_`c'_"' {
				merge 1:1 z000001a using `"${path}/``i''"', nogen
			}
		}
	}
	save `dta_`c''
}

//mvencode cohort specific datasets . --> -22 "Not in panel"
foreach c of local cohorts {
	use `dta_`c'', clear
	qui ds, has(type numeric)
	qui mvencode `r(varlist)', mv(.=-22) override
	qui ds, has(type string)
	foreach v in `r(varlist)' {
		qui replace `v' ="-22" if `v'==""
	}
	save `dta_`c'', replace
}

//append cohorts
local l = wordcount(`"`cohorts'"')
tokenize `"`cohorts'"'
forval i=1(1)`l' {
	di "`dta_``i'''"
	if `i' == 1 use `dta_``i''', clear
	else append using `dta_``i'''
}

//mvencode cohort specific datasets . --> -11 "Not invited"
qui ds, has(type numeric)
qui mvencode `r(varlist)', mv(.=-11) override
qui ds, has(type string)
foreach v in `r(varlist)' {
	qui replace `v' ="-11" if `v'==""
}

***External Study ba***
*Response Order Experiment: Adequate housing
fre baah070a baah071a

gen ro_housing=.
replace ro_housing=1 if baah070a==1 | baah071a==2
replace ro_housing=2 if baah070a==2 | baah071a==1

fre ro_housing

*Experimental Trigger
fre baah132a

mvdecode baah132a, mv(-11=.\-22=.\-33=.\3=.\4=.)

*Primacy effect: Adequate housing
tab baah132a ro_housing, row chi2

*Response Order Experiment: Trust
fre baah120a baah121a

gen ro_trust=.
replace ro_trust=1 if baah120a==1 | baah121a==2
replace ro_trust=2 if baah120a==2 | baah121a==1

fre ro_trust

*Experimental Trigger
fre baah144a

mvdecode baah144a, mv(-11=.\-22=.\-33=.)

*Primacy effect: Trust
tab baah144a ro_trust, row chi2

*Acquiescence Experiment: Women in politics
fre baah110a baah112a

gen acq_politics=.
replace acq_politics=1 if baah110a==1 | baah112a==1
replace acq_politics=2 if baah110a==2 | baah112a==2 | baah112a==3

fre acq_politics

*Experimental Trigger
fre baah140a

mvdecode baah140a, mv(-11=.\-22=.\-33=.\2=.\4=.)

*Acquiescence: Women in politics
tab baah140a acq_politics, row chi2

*Acquiescence Experiment: Crime
fre baah074a baah076a

gen acq_crime=.
replace acq_crime=1 if baah074a==1 | baah076a==1
replace acq_crime=2 if baah074a==2 | baah076a==2

fre acq_crime

*Experimental Trigger
fre baah133a

mvdecode baah133a, mv(-11=.\-22=.\-33=.\2=.\4=.)

*Acquiescence: Crime
tab baah133a acq_crime, row chi2

*Don't Know Experiment: Courts
fre baah088a baah091a

mvdecode baah088a baah091a, mv(-11=.\-22=.\-33=.\-66=.\-77=.\-111=.)

gen dk_courts=.
replace dk_courts=1 if baah088a==-99 | baah088a==3 | baah091a==-99
replace dk_courts=0 if baah088a==1 | baah088a==2 | baah091a==1 | baah091==2

fre dk_courts

*Experimental Trigger
fre baah135a

mvdecode baah135a, mv(-11=.\-22=.\-33=.\1=.\2=.)

*Saying don't know: Courts
tab baah135a dk_courts, row exact

*Don't Know Experiment: Smart leaders
fre baah089a baah092a

mvdecode baah089a baah092a, mv(-11=.\-22=.\-33=.\-66=.\-77=.\-111=.)

gen dk_leaders=.
replace dk_leaders=1 if baah089a==-99 | baah089a==3 | baah092a==-99
replace dk_leaders=0 if baah089a==1 | baah089a==2 | baah092a==1 | baah092a==2

fre dk_leaders

*Experimental Trigger
fre baah135a

*Saying don't know: Smart leaders
tab baah135a dk_leaders, row exact

log close
exit
