/* Effect of incentives on response: reciprocity as a mechanism */
version 17
set more off, perm
clear all
macro drop _all
set linesize 132
capture log close

* Data set
use "w89-reciprocity.dta" , replace

* Definition of Reciprocity
recode t8reciprocity4  (1/3=0)(4/5=1), gen(RecPref)
recode t8reciprocity1  (1/3=0)(4/5=1), gen(Favour)
recode t8reciprocity2  (1/3=0)(4/5=1), gen(Effort)
recode t8reciprocity3  (1/3=0)(4/5=1), gen(Cost)

recode RecPref (. .m = 0), gen(RecPref_mv)
recode Cost (. .m = 0), gen(Cost_mv)
recode Effort (. .m = 0), gen(Effort_mv)
recode Favour (. .m = 0), gen(Favour_mv)

* Reciprocity overall and imputation
egen mReciprocity = rowmean(t8reciprocity1-t8reciprocity3)
clonevar mReciprocity_mv = mReciprocity
replace mReciprocity_mv = 1 if mReciprocity == .

gen mRecPref = t8reciprocity4
replace mRecPref = 1 if t8reciprocity4 == .

* random impuation
clonevar rRecPref = RecPref
replace rRecPref = runiform(0,1) if RecPref == .
replace rRecPref = runiform(0,1) if RecPref == .m
clonevar rFavour = Favour
replace rFavour = runiform(0,1) if Favour == .
replace rFavour = runiform(0,1) if Favour == .m

* Previous participation
gen pPanel=0
replace pPanel=1 if RecPref == .

save "w89-reciprocity.dta" , replace


* Analysis
use "w89-reciprocity.dta" , clear
sort teilnehmercode 

stset partdur, failure(dispositionscode==1) id(teilnehmercode)


* Figure 1
* Reciprocal preference
sts graph, by(RecPref)
sts graph, failure by(RecPref)
bysort RecPref: stdescribe
* Altruistic reciprocity
sts graph, by(Favour)
sts graph, failure by(Favour)
bysort Favour: stdescribe

gr combine "GraphKM_Failure_RP.gph" "GraphKM_Failure_AR.gph"

sts test RecPref, l 
sts test RecPref, w
sts test RecPref, c
sts test RecPref, p
sts test RecPref, tw

sts list if RecPref==1
sts list if RecPref==0
bysort t8reciprocity4: stdescribe

streg RecPref ,  vce(robust) dist(gom) nohr
stcurve, surv at1(RecPref=0) at2(RecPref=1) 

sts test Favour, l 
sts test Favour, w
sts test Favour, c
sts test Favour, p
sts test Favour, tw


* Table 1
use "w89-reciprocity.dta" , clear
sort teilnehmercode 

stset partdur, failure(dispositionscode==1) id(teilnehmercode)

stcox Favour RecPref ib1.gender ib1.hh_egp_mv ib1.sektyp9_mv zdemark9  , vce(robust) nohr
outreg using "table1",   replace marginal se starlevel(5 1 .1) varlabels ///
title(Reciprocity)
streg Favour RecPref ib1.gender ib1.hh_egp_mv ib1.sektyp9_mv zdemark9   , dist(gom) nohr
outreg using "table1",   merge replace marginal se starlevel(5 1 .1) varlabels ///
title(Reciprocity)

stcox Favour_mv RecPref_mv ib1.gender ib1.hh_egp_mv ib1.sektyp9_mv zdemark9 , vce(robust) nohr
outreg using "table1",   merge replace marginal se starlevel(5 1 .1) varlabels ///
title(Reciprocity)
streg Favour_mv RecPref_mv pPanel ib1.gender ib1.hh_egp_mv ib1.sektyp9_mv zdemark9  , dist(gom) nohr
outreg using "table1",   merge replace marginal se starlevel(5 1 .1) varlabels ///
title(Reciprocity)


* Figure 2
* piecewise-constant rate model#
use "w89-reciprocity.dta" , clear
sort teilnehmercode 

gen crcen = dispositionscode
recode crcen (1=2) if RecPref==0

stset partdur , failure(crcen==1) id(newid)

stsplit time, at(0 (1) max)
tab time , ge(t)

streg t1-t48 , dist(exp) nohr 

predict DR1 , hazard

stset partdur , failure(crcen==2) id(newid)
streg t1-t48 , dist(exp) nohr 

predict DR0 , hazard

line DR1 _t , sort  || line DR0 _t , sort


/* Figure 3 (left-hand panel) and Table A.1 */  			
* piecewise constant rate model

use "w89-reciprocity.dta" , clear
ren dispositionscode partcen
save "w89-reciprpiece.dta" , replace

recode hh_egp_mv (1=1)(2/7=0), gen(egp1)
recode hh_egp_mv (2=1)(1 3/7=0), gen(egp2)
recode hh_egp_mv (3=1)(1/2 4/7=0), gen(egp3)
recode hh_egp_mv (4=1)(1/3 5/7=0), gen(egp4)
recode hh_egp_mv (5=1)(1/4 6/7=0), gen(egp5)
recode hh_egp_mv (6=1)(1/5 7=0), gen(egp6)
recode hh_egp_mv (7=1)(1/6=0), gen(egp7)

recode sektyp9_mv (1=1)(2/4=0), gen(sektyp1)
recode sektyp9_mv (2=1)(1 3/4=0), gen(sektyp2)
recode sektyp9_mv (3=1)(1/2 4=0), gen(sektyp3)
recode sektyp9_mv (4=1)(1/3=0), gen(sektyp4)

recode gender (1=0)(2=1), gen(female)
ren zdemark9 zdemark9_mv

stset partdur , failure(partcen==1) id(newid)
stsplit time, at(3 7 14 28)
tab time , ge(t)

for any RecPref RecPref RecPref RecPref  \ any t1 t2 t3 t4 : gen RecPrefY = X*Y
for any RecPref_mv RecPref_mv RecPref_mv RecPref_mv  \ any t1 t2 t3 t4 : gen RecPref_mvY = X*Y

for any egp1 egp1 egp1 egp1 \ any t1 t2 t3 t4: gen egp1Y = X*Y
for any egp2 egp2 egp2 egp2 \ any t1 t2 t3 t4: gen egp2Y = X*Y
for any egp3 egp3 egp3 egp3 \ any t1 t2 t3 t4: gen egp3Y = X*Y
for any egp4 egp4 egp4 egp4 \ any t1 t2 t3 t4: gen egp4Y = X*Y
for any egp5 egp5 egp5 egp5 \ any t1 t2 t3 t4: gen egp5Y = X*Y
for any egp6 egp6 egp6 egp6 \ any t1 t2 t3 t4: gen egp6Y = X*Y
for any egp7 egp7 egp7 egp7 \ any t1 t2 t3 t4: gen egp7Y = X*Y

for any sektyp1 sektyp1 sektyp1 sektyp1 \ any t1 t2 t3 t4: gen sektyp1Y = X*Y
for any sektyp2 sektyp2 sektyp2 sektyp2 \ any t1 t2 t3 t4: gen sektyp2Y = X*Y
for any sektyp3 sektyp3 sektyp3 sektyp3 \ any t1 t2 t3 t4: gen sektyp3Y = X*Y
for any sektyp4 sektyp4 sektyp4 sektyp4 \ any t1 t2 t3 t4: gen sektyp4Y = X*Y

for any zdemark9_mv zdemark9_mv zdemark9_mv zdemark9_mv \ any t1 t2 t3 t4: gen zdemark9_mvY = X*Y

for any female female female female \ any t1 t2 t3 t4: gen femaleY = X*Y

streg t1 t2 t3 t4 RecPreft* egp2t* egp3t* egp4t* egp5t* egp6t* egp7t* sektyp2t* sektyp3t* sektyp4t* zdemark9_mvt* femalet* , dist(exp) nohr noconstant
outreg using "tableA1",   replace marginal se starlevel(5 1 .1) varlabels ///
title(Reciprocity)
estimate store gift

* Right-hand panel
coefplot gift , bylabel(Reciprocity) keep(RecPreft1 RecPreft2 RecPreft3 RecPreft4) byopts(compact cols(1)) 

use "w89-reciprocity.dta" , clear
ren dispositionscode partcen
save "w89-reciprpiece.dta" , replace

recode hh_egp_mv (1=1)(2/7=0), gen(egp1)
recode hh_egp_mv (2=1)(1 3/7=0), gen(egp2)
recode hh_egp_mv (3=1)(1/2 4/7=0), gen(egp3)
recode hh_egp_mv (4=1)(1/3 5/7=0), gen(egp4)
recode hh_egp_mv (5=1)(1/4 6/7=0), gen(egp5)
recode hh_egp_mv (6=1)(1/5 7=0), gen(egp6)
recode hh_egp_mv (7=1)(1/6=0), gen(egp7)

recode sektyp9_mv (1=1)(2/4=0), gen(sektyp1)
recode sektyp9_mv (2=1)(1 3/4=0), gen(sektyp2)
recode sektyp9_mv (3=1)(1/2 4=0), gen(sektyp3)
recode sektyp9_mv (4=1)(1/3=0), gen(sektyp4)

recode gender (1=0)(2=1), gen(female)
ren zdemark9 zdemark9_mv

stset partdur , failure(partcen==1) id(newid)
stsplit time, at(1 2 3 4)
tab time , ge(t)

for any RecPref RecPref RecPref RecPref  \ any t1 t2 t3 t4 : gen RecPrefY = X*Y
for any RecPref_mv RecPref_mv RecPref_mv RecPref_mv  \ any t1 t2 t3 t4 : gen RecPref_mvY = X*Y

for any egp1 egp1 egp1 egp1 \ any t1 t2 t3 t4: gen egp1Y = X*Y
for any egp2 egp2 egp2 egp2 \ any t1 t2 t3 t4: gen egp2Y = X*Y
for any egp3 egp3 egp3 egp3 \ any t1 t2 t3 t4: gen egp3Y = X*Y
for any egp4 egp4 egp4 egp4 \ any t1 t2 t3 t4: gen egp4Y = X*Y
for any egp5 egp5 egp5 egp5 \ any t1 t2 t3 t4: gen egp5Y = X*Y
for any egp6 egp6 egp6 egp6 \ any t1 t2 t3 t4: gen egp6Y = X*Y
for any egp7 egp7 egp7 egp7 \ any t1 t2 t3 t4: gen egp7Y = X*Y

for any sektyp1 sektyp1 sektyp1 sektyp1 \ any t1 t2 t3 t4: gen sektyp1Y = X*Y
for any sektyp2 sektyp2 sektyp2 sektyp2 \ any t1 t2 t3 t4: gen sektyp2Y = X*Y
for any sektyp3 sektyp3 sektyp3 sektyp3 \ any t1 t2 t3 t4: gen sektyp3Y = X*Y
for any sektyp4 sektyp4 sektyp4 sektyp4 \ any t1 t2 t3 t4: gen sektyp4Y = X*Y

for any zdemark9_mv zdemark9_mv zdemark9_mv zdemark9_mv \ any t1 t2 t3 t4: gen zdemark9_mvY = X*Y

for any female female female female \ any t1 t2 t3 t4: gen femaleY = X*Y

streg t1 t2 t3 t4 RecPreft* egp2t* egp3t* egp4t* egp5t* egp6t* egp7t* sektyp2t* sektyp3t* sektyp4t* zdemark9_mvt* femalet* , dist(exp) nohr noconstant
estimate store gift

gr combine "GraphRecPieceLeft.gph" "GraphRecPieceRight.gph"


* Role of Reminder: Figure 4 & Table A.4 in Appendix
use "w89-reciprsplit.dta" , clear
sort teilnehmercode time

stset partdur , failure(partcen==1) id(newid)
stsplit time , at(0 (1) max)
tab time , ge(t)

stset partdur , failure(partcen==1) id(newid)

streg Schenken Gefallen reminder female egp2-egp7 sektyp2-sektyp4 zdemark9_mv   , dist(exp) vce(robust) nohr
outreg using "tabelle1",  replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Reminder)
est store M1
streg Schenken Gefallen reminder Sreminder female egp2-egp7 sektyp2-sektyp4 zdemark9_mv , dist(exp) vce(robust) nohr
outreg using "tabelle1",  merge replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Reminder)
est store M2

coefplot M1 , bylabel(Main) keep(Schenken Gefallen reminder) || M2, bylabel(Inter1) keep(Schenken Gefallen reminder Sreminder) xline(0)


/* Appendix */

* Figure A.1
use "w89-survival.dta" , clear
sort newid welle

stset partdur if welle >= 8, failure(partall==1) id(newid)
sts graph, by(welle)
bysort welle: stdescribe

sts test welle, l 
sts test welle, w
sts test welle, c
sts test welle, p
sts test welle, tw


stset partdur if welle >= 8 , failure(partcen ==1) id(newid)
sts graph, by(welle)
bysort welle: stdescribe

sts test welle, l 
sts test welle, w
sts test welle, c
sts test welle, p
sts test welle, tw

grc1leg "GraphKM_W89.gph" "GraphKMonline.gph", legendfrom("C:\Users\Rolf Becker\Eigene Daten\DAB\Reciprocity\GraphKM_W89.gph")


* Table A.2
use "w89-reciprocity.dta" , clear
sort teilnehmercode 

logit Favour ib1.gender ib1.hh_egp_mv ib1.sektyp9_mv zdemark9 , vce(robust) 
margins, dydx(*) predict()
outreg using "tableA2",   replace marginal se starlevel(5 1 .1) varlabels ///
title(Reciprocity)
logit rFavour ib1.gender ib1.hh_egp_mv ib1.sektyp9_mv zdemark9 , vce(robust) 
margins, dydx(*) predict()
outreg using "tableA2",   merge replace marginal se starlevel(5 1 .1) varlabels ///
title(Reciprocity)

logit RecPref ib1.gender ib1.hh_egp_mv ib1.sektyp9_mv zdemark9 , vce(robust) 
margins, dydx(*) predict()
outreg using "tableA2",   merge replace marginal se starlevel(5 1 .1) varlabels ///
title(Reciprocity)
logit rRecPref ib1.gender ib1.hh_egp_mv ib1.sektyp9_mv zdemark9 , vce(robust) 
margins, dydx(*) predict()
outreg using "tableA2",   merge replace marginal se starlevel(5 1 .1) varlabels ///
title(Reciprocity)

* Table A.3
use "w89-reciprocity.dta" , clear
sort teilnehmercode 

stset partdur, failure(dispositionscode==1) id(teilnehmercode)

streg rFavour rRecPref ib1.gender ib1.hh_egp_mv ib1.sektyp9_mv zdemark9 , dist(gom) nohr
outreg using "tableA3",   replace marginal se starlevel(5 1 .1) varlabels ///
title(Reciprocity)
streg rFavour rRecPref pPanel  ib1.gender ib1.hh_egp_mv ib1.sektyp9_mv zdemark9 , dist(gom) nohr
outreg using "tableA3",   merge replace marginal se starlevel(5 1 .1) varlabels ///
title(Reciprocity)

streg mReciprocity RecPref  ib1.gender ib1.hh_egp_mv ib1.sektyp9_mv zdemark9   , dist(gom) nohr
outreg using "tableA3",   merge replace marginal se starlevel(5 1 .1) varlabels ///
title(Reciprocity)
streg mReciprocity_mv RecPref_mv pPanel ib1.gender ib1.hh_egp_mv ib1.sektyp9_mv zdemark9  , dist(gom) nohr
outreg using "tableA3",   merge replace marginal se starlevel(5 1 .1) varlabels ///
title(Reciprocity)


/* EOF */