* Intro
set scheme s1mono

grstyle init
grstyle set imesh, horizontal 
grstyle set size 10pt: tick_label axis_title
grstyle set size 8pt: small_body

* Figure 1
clear
input str30 stat str20 typ diff x order2
	"Mean" "Iterative regression" 0.25  1 1
	"Mean" "LS"                	0.14  2 1
	"Mean" "Mean and within"   	-0.26 3 1
	"Mean" "Listwise deletion"    2.27  4 1
	"Coeff. of Variation" "Iterative regression" 1.18  1 2 
	"Coeff. of Variation" "LS"                  -0.12	2 2 
	"Coeff. of Variation" "Mean and within"      0.36	3 2
	"Coeff. of Variation" "Listwise deletion"   -0.53	4 2 
	"Gini coeff." "Iterative regression" 0.61  1 3
	"Gini coeff." "LS"                  -0.02	2  3
	"Gini coeff." "Mean and within"      0.66	3  3
	"Gini coeff." "Listwise deletion"   -0.99	4 3
	"Mean log deviation" "Iterative regression" 1.89  1  4
	"Mean log deviation" "LS"						  	0.24  2 4 
	"Mean log deviation" "Mean and within"	  	0.07  3  4
	"Mean log deviation" "Listwise deletion"	  	-1.32	4 4 
	"99/50 ratio of percentiles" "Iterative regression"  0.36 1 	 5
	"99/50 ratio of percentiles"	 "LS"							 0.50 2  5
	"99/50 ratio of percentiles"	 "Mean and within"		 0.17 3  5
	"99/50 ratio of percentiles"	 "Listwise deletion"		-1.34 4 5
end

drop x
compress
labmask order, values(stat)

graph twoway ///
  || scatter order2 diff, ms(O) mcolor(black)  ///
  || , by(typ, cols(1) note("")) subtitle(, bcolor(white) size(*.83))  ///
  ylabel(1/5, valuelabel angle(0) grid gstyle(dot) labsize(*.83)) ///
  ytitle("") xtitle(Difference to target (in %), size(*.83)) yscale(reverse) xline(0, lcolor(red))  ///
  xlabel(-1.5(0.5)2, grid format(%2.1f) labsize(*.83)) ysize(*1.2)

graph export 7949_fig1.pdf, replace

* Figure 2
clear
input str20 typ str20 stat r order
"Iterative regression" "Full sample"      	0.962  1
"LS"                   "Full sample"      	0.974  1
"Mean and within"      "Full sample"      	0.988  1
"Iterative regression" "1-99 percentile"  	0.956  2
"LS"                   "1-99 percentile"  	0.967  2
"Mean and within"      "1-99 percentile"  	0.985  2
"Iterative regression" "1-95 percentile"  	0.950  3
"LS"                   "1-95 percentile"  	0.958  3
"Mean and within"      "1-95 percentile"  	0.981  3
"Iterative regression" "2-100 percentile"  	0.961  4
"LS"                   "2-100 percentile"  	0.974  4
"Mean and within"      "2-100 percentile"  	0.988  4
"Iterative regression" "5-100 percentile" 	0.960  5
"LS"                   "5-100 percentile" 	0.974  5
"Mean and within"      "5-100 percentile" 	0.987  5
end

compress
labmask order, values(stat)

graph twoway ///
  || scatter order r, ms(O) mcolor(black)  ///
  || , by(typ, cols(1) note("")) subtitle(, bcolor(white))  ylabel(1/5, valuelabel angle(0) grid gstyle(dot)) ///
  ytitle("") xtitle(Correlation between observed and imputed data) yscale(reverse)  ///
  xlabel(, grid format(%3.2f))

graph export 7949_fig2.pdf, replace

* Figure 3
clear
input str20 typ sum order
	"Iterative regression" 20827  1
	"LS" 29188 2
	"Mean and within" 12301 3
end


compress
labmask order, values(typ)

graph twoway ///
  || scatter order sum, ms(O) mcolor(black) msize(*2)  ///
  || , ylabel(1/3, valuelabel angle(0) grid gstyle(dot) labsize(*2)) ///
  ytitle("") xtitle(Sum of relative difference, size(*2)) yscale(reverse range(0.5 3.5))  ///
  xlabel(, grid format(%5.0f) labsize(*2)) ysize(*.5) 

graph export 7949_fig3.pdf, replace


* Figure 4
clear
input str20 typ sum order
	"Iterative regression" 0.007  1
	"LS" 0.003 2
	"Mean and within" 0.007 3
end

compress
labmask order, values(typ)

graph twoway ///
  || scatter order sum, ms(O) mcolor(black) msize(*2)  ///
  || , ylabel(1/3, valuelabel angle(0) grid gstyle(dot) labsize(*2)) ///
  ytitle("") xtitle(Kolmogorov-Smirnov distance, size(*2)) yscale(reverse range(0.5 3.5))  ///
  xlabel(, grid format(%4.3f) labsize(*2)) ysize(*.5)

graph export 7949_fig4.pdf, replace


* Figure 5
clear
input str20 typ str20 stat r order order2
"Target"               "Full sample"               0.908       1 1
"Iterative regression" "Full sample"        			0.868       1 2
"LS"                   "Full sample"        			0.889       1 3
"Mean and within"      "Full sample"        			0.907       1 4
"Listwise deleted"     "Full sample"         		0.905       1 5
"Target"               "1-99 percentile"	   		0.909       2 1 
"Iterative regression" "1-99 percentile"    			0.862       2 2 
"LS"                   "1-99 percentile"    			0.886       2 3 
"Mean and within"      "1-99 percentile"				0.907       2 4 
"Listwise deleted"     "1-99 percentile"        	0.909       2 5 
"Target"               "1-95 percentile"				0.891       3 1 
"Iterative regression" "1-95 percentile"				0.837			3 2 
"LS"						  "1-95 percentile"				0.863			3 3 
"Mean and within"		  "1-95 percentile"				0.888			3 4 
"Listwise deleted"	  "1-95 percentile"				0.890			3 5 
"Target"               "2-100 percentile"				0.908			4 1  
"Iterative regression" "2-100 percentile"				0.868			4 2 
"LS"						  "2-100 percentile"				0.889			4 3 
"Mean and within"		  "2-100 percentile"				0.906			4 4 
"Listwise deleted"     "2-100 percentile"			   0.905			4 5 
"Target"               "5-100 percentile"				0.906			5 1 
"Iterative regression" "5-100 percentile"				0.865			5 2 
"LS"						  "5-100 percentile"				0.887			5 3 
"Mean and within"		  "5-100 percentile"				0.905			5 4 
"Listwise deleted"     "5-100 percentile"		   	0.903			5 5 
end

bys order (order2): gen p = (r - r[1])/r[1] * 100
drop if typ=="Target"
compress
labmask order, values(stat)
labmask order2, values(typ)

graph twoway ///
  || scatter order p, ms(O) mcolor(black)  ///
  || , by(order2, cols(1) note(""))  ///
  subtitle(, bcolor(white) size(*.83))   ///
  ylabel(1/5, valuelabel angle(0) grid gstyle(dot) labsize(*.83)) ///
  ytitle("") xtitle(Relative difference to target values (in %), size(*.83)) yscale(reverse)  ///
  xlabel(, grid format(%1.0f) labsize(*.83)) xline(0, lcolor(red)) ysize(*1.2)

graph export 7949_fig5.pdf, replace


* Figure 6
clear
input str20 typ str20 stat r order order2
"Target"               "One year"    0.908 1 1 
"Iterative regression" "One year"    0.880 1 2 
"LS"                   "One year"    0.883 1 3 
"Mean and within"      "One year"    0.905 1 4 
"Listwise deleted"     "One year"    0.909 1 5 
"Target"               "Five years"  0.759 2 1 
"Iterative regression" "Five years"  0.725 2 2 
"LS"                   "Five years"  0.776 2 3 
"Mean and within"      "Five years"  0.762 2 4 
"Listwise deleted"     "Five years"  0.770 2 5 
end

bys order (order2): gen p = (r - r[1])/r[1] * 100
drop if typ=="Target"
compress
labmask order, values(stat)
labmask order2, values(typ)
	
graph twoway ///
  || scatter order p, ms(O) mcolor(black)  ///
  || , by(order2, cols(1) note(""))  ///
  subtitle(, bcolor(white))   ///
  ylabel(1/2, valuelabel angle(0) grid gstyle(dot)) ///
  ytitle("") xtitle(Relative difference to target values (in %)) yscale(range(0.5 2.5) reverse)  ///
  xlabel(, grid format(%1.0f)) xline(0, lcolor(red)) 

graph export 7949_fig6.pdf, replace
	
* Figure 7
clear
input str20 typ str20 stat r order order2
"Target"               "Within"   	19675  1 1 
"Iterative regression" "Within"		21996	 1 2 
"LS"						  "Within"		19041	 1 3 
"Mean and within"		  "Within"		19429	 1 4 
"Listwise deleted"	  "Within"		19517	 1 5 
"Target"					  "Between"		48353	 2 1 
"Iterative regression" "Between"		48182	 2 2 
"LS"						  "Between"		48551	 2 3 
"Mean and within"		  "Between"		48500	 2 4 
"Listwise deleted"	  "Between"		48543	 2 5 
end
	
bys order (order2): gen p = (r - r[1])/r[1] * 100
drop if typ=="Target"
compress
labmask order, values(stat)
labmask order2, values(typ)
	
graph twoway ///
  || scatter order p, ms(O) mcolor(black)  ///
  || , by(order2, cols(1) note(""))  ///
  subtitle(, bcolor(white))   ///
  ylabel(1/2, valuelabel angle(0) grid gstyle(dot)) ///
  ytitle("") xtitle(Relative difference to target values (in %)) yscale(range(0.5 2.5) reverse)  ///
  xlabel(-4(2)12, grid format(%2.0f)) xline(0, lcolor(red)) 

graph export 7949_fig7.pdf, replace
	
* Figure 8
clear
input str20 typ str20 stat r order order2
	"Target"               "OLS"     	         0.199  1 1  
	"LS"						  "OLS"     	         0.195	 1 3  
	"Mean and within"		  "OLS"     	         0.203	 1 4  
	"Listwise deleted"	  "OLS"     	         0.197	 1 5  
	"Target"					  "Fixed effects"    	0.066	 2 1  
	"LS"						  "Fixed effects"    	0.052	 2 3  
	"Mean and within"		  "Fixed effects"    	0.079	 2 4  
	"Listwise deleted"	  "Fixed effects"    	0.061	 2 5  
end

bys order (order2): gen p = (r - r[1])/r[1] * 100
drop if typ=="Target"
compress
labmask order, values(stat)
labmask order2, values(typ)
	
graph twoway ///
  || scatter order p, ms(O) mcolor(black)  ///
  || , by(order2, cols(1) note(""))  ///
  subtitle(, bcolor(white))   ///
  ylabel(1/2, valuelabel angle(0) grid gstyle(dot)) ///
  ytitle("") xtitle(Relative difference to target values (in %)) yscale(range(0.5 2.5) reverse)  ///
  xlabel(, grid format(%2.0f)) xline(0, lcolor(red)) 

graph export 7949_fig8.pdf, replace

* Figure 9
clear
input str20 typ str20 stat r order order2
	"Target"               "OLS"          	0.21    1 1 
	"Iterative regression" "OLS"				0.186	  1 3 
	"LS"                 "OLS"					0.175	  1 4 
	"Mean and within"    "OLS"					0.238	  1 5 
	"Target"			   	"Fixed effects" 	0.14	  2 1 
	"Iterative regression" "Fixed effects"	0.045	  2 3 
	"LS"                "Fixed effects"   -0.047	  2 4 
	"Mean and within"   "Fixed effects"		0.205	  2 5 
end

bys order (order2): gen p = (r - r[1])/r[1] * 100
drop if typ=="Target"
compress
labmask order, values(stat)
labmask order2, values(typ)
	
graph twoway ///
  || scatter order p, ms(O) mcolor(black)  ///
  || , by(order2, cols(1) note(""))  ///
  subtitle(, bcolor(white))   ///
  ylabel(1/2, valuelabel angle(0) grid gstyle(dot)) ///
  ytitle("") xtitle(Relative difference to target values (in %)) yscale(range(0.5 2.5) reverse)  ///
  xlabel(, grid format(%2.0f)) xline(0, lcolor(red)) 

graph export 7949_fig9.pdf, replace

exit
