clear
set more off
capture log close
version 15

* Filepaths for data sets:
global d "IP11datafiles"
global j "temporaryfiles"

* read in the IP11 keystrokes data

use $d/k_keystroke_paradata, clear


* generate indicators: 

* consent question asked
gen CQ1 = strpos(k_keystrokes1, "CONSENTQ1") > 0
gen CQ2 = strpos(k_keystrokes1, "CONSENTQ2") > 0
gen CQ3 = strpos(k_keystrokes1, "CONSENTQ3") > 0
gen CQ4 = strpos(k_keystrokes1, "CONSENTQ4") > 0

gen CQ=.
replace CQ=1 if CQ1==1 
replace CQ=2 if CQ2==1
replace CQ=3 if CQ3==1
replace CQ=4 if CQ4==1
lab var CQ "Consent Q, paradata"
tab CQ, miss


* interviewer observation: leaflet
gen intleaf = strpos(k_keystrokes1, "INTCREAD") > 0
lab var intleaf "Int obs: leaflet, paradata"
// in analyses for modes consent paper - have used the variable from the IP11 survey data 
// rather than this from the keystrokes
// keep because identifies CAPI respondents, used to drop duplicates below

* interviewer observation: diagram
gen intdiag = strpos(k_keystrokes1, "INTFLREAD") > 0
lab var intdiag "Int obs: diagram, paradata"
// as previous


* web: clicked leaflet
gen wleaflet = strpos(k_keystrokes1, "TIMESTAMP_LEAFLET") > 0
lab var wleaflet "Clicked link to leaflet"

gen wleaflet2 = strpos(k_keystrokes2, "TIMESTAMP_LEAFLET") > 0
lab var wleaflet2 "Clicked link to leaflet"


* web: clicked diagram
gen wdiagram = strpos(k_keystrokes1, "TIMESTAMP_DIAGRAM") >0
lab var wdiagram "Clicked link to diagram"

gen wdiagram2 = strpos(k_keystrokes2, "TIMESTAMP_DIAGRAM") >0
lab var wdiagram2 "Clicked link to diagram"


tab1 wleaflet* wdiagram*
* ==> page2 doesn't contain info about clicks on diagram or leaflet

* 5 respondents with duplicate observations
* checked in K_INDRESP data which mode they completed in and which consent Q version
duplicates tag pidp, gen(tag)
sort pidp
list pidp CQ wleaflet wdiagram if tag

drop if pidp == 1714008092 & intleaf==0
drop if pidp == 1716292852 & CQ==2
drop if pidp == 1716292892 & CQ==1
drop if pidp == 1727982092 & CQ==3
drop if pidp == 1729525652 & CQ==3

drop tag
duplicates report pidp

keep pidp CQ wleaflet wdiagram
compress
d
sort pidp
save $j/keystrokes, replace

exit
