# R syntax to produce Figure 2.
#
# "Accounting for cross-country-cross-time variations in measurement invariance testing. A case of political participation"






rm(list=ls())
library(haven)
library(dplyr)
library(rio)
library(tidyr)



### PREPARING PREDICTORS

path<-""
setwd(path)
output_directory_R <-paste0( path, "/","Data","/", "dataset",".RData")
load(output_directory_R)
# Recoding and merging democracy types
library(rio)
raw <- import("Results//V-dem indices.csv")
raw <- raw %>%
  mutate(
    cntry = case_when(
      country_name	== "Belgium"	~	"BE"	,
      country_name	== "Switzerland"	~	"CH"	,
      country_name == "Germany"	~	"DE"	,
      country_name == "Estonia"~	"EE"	,
      country_name == "Spain"	~	"ES"	,
      country_name == "Finland"	~	"FI"	,
      country_name == "France"~	"FR",
      country_name == "United Kingdom"	~	"GB"	,
      country_name == "Hungary"	~	"HU"	,
      country_name == "Ireland"	~	"IE"	,
      country_name == "Netherlands"	~	"NL"	,
      country_name == "Norway"	~	"NO"	,
      country_name == "Poland"  ~	"PL"	,
      country_name == "Portugal"  ~	"PT"	,
      country_name == "Sweden"  ~	"SE"	,
      TRUE              ~ "ERROR"
    ))

raw <- raw %>%
  mutate(
    round = case_when(
      year	== 2004	~	2	,
      year	== 2006	~	3	,
      year == 2008	~	4	,
      year == 2010~	5	,
      year == 2012	~	6	,
      year == 2014	~	7	,
      year == 2016~	8,
      year == 2018	~	9	,
      
      TRUE              ~ 999
    ))


raw$V1 <- NULL
raw$country_name <- NULL
raw$year <- NULL
final <- inner_join(final, raw, by = c("cntry", "round"))

#Recoding and merging income inequality and household disposable income
library(rio)
hhdi <- import("Data//hhdi.csv") #OECD

unique(hhdi$LOCATION)

hhdi <- hhdi %>%
  filter(LOCATION %in% c("NLD", "CHE", "DEU", "PRT", "IRL", "POL", "BEL", "SWE", "ESP", "EST", "NOR", "GBR", "HUN", "FIN", "FRA"))%>%
  filter(TIME %in% seq(2004, 2018, 2))

hhdi <- hhdi%>%
  mutate(
    cntry = case_when(
      LOCATION	== "BEL"	~	"BE"	,
      LOCATION	== "CHE"	~	"CH"	,
      LOCATION == "DEU"	~	"DE"	,
      LOCATION == "EST"~	"EE"	,
      LOCATION == "ESP"	~	"ES"	,
      LOCATION == "FIN"	~	"FI"	,
      LOCATION == "FRA"~	"FR",
      LOCATION == "GBR"	~	"GB"	,
      LOCATION == "HUN"	~	"HU"	,
      LOCATION == "IRL"	~	"IE"	,
      LOCATION == "NLD"	~	"NL"	,
      LOCATION == "NOR"	~	"NO"	,
      LOCATION == "POL"  ~	"PL"	,
      LOCATION == "PRT"  ~	"PT"	,
      LOCATION == "SWE"  ~	"SE"	,
      TRUE              ~ "ERROR"
    ))
hhdi <- hhdi %>%
  mutate(
    round = case_when(
      TIME	== 2004	~	2	,
      TIME	== 2006	~	3	,
      TIME == 2008	~	4	,
      TIME == 2010~	5	,
      TIME == 2012	~	6	,
      TIME == 2014	~	7	,
      TIME == 2016~	8,
      TIME == 2018	~	9	,
      
      TRUE              ~ 999
    ))

hhdi[,c(1:6, 8)] <- NULL
hhdi$hhdi <- hhdi$Value
hhdi$Value <- NULL

final <- left_join(final, hhdi, by = c("round", "cntry"), )

#recoding gini #WORLD BANK INDICATORS
library(rio)
gini <- import("Data//gini.xlsx")
gini$GINI <- as.numeric(gini$GINI)

gini <- gini %>%
  mutate(
    cntry = case_when(
      Country	== "Belgium"	~	"BE"	,
      Country	== "Switzerland"	~	"CH"	,
      Country== "Germany"	~	"DE"	,
      Country== "Estonia"~	"EE"	,
      Country== "Spain"	~	"ES"	,
      Country== "Finland"	~	"FI"	,
      Country== "France"~	"FR",
      Country== "United Kingdom"	~	"GB"	,
      Country== "Hungary"	~	"HU"	,
      Country== "Ireland"	~	"IE"	,
      Country== "Netherlands"	~	"NL"	,
      Country== "Norway"	~	"NO"	,
      Country== "Poland"  ~	"PL"	,
      Country== "Portugal"  ~	"PT"	,
      Country== "Sweden"  ~	"SE"	,
      TRUE              ~ "ERROR"
    ))
gini <- rename(gini, "round" = "Round")
gini$Country <- NULL


final <- left_join(final, gini, by = c("round", "cntry"), )

#recoding GDP #WORLD BANK INDICATORS
gdp <- import("Data//GDP.xlsx")
gdp$gdp <- as.numeric(gdp$gdp)

gdp <- gdp %>%
  mutate(
    cntry = case_when(
      Country	== "Belgium"	~	"BE"	,
      Country	== "Switzerland"	~	"CH"	,
      Country== "Germany"	~	"DE"	,
      Country== "Estonia"~	"EE"	,
      Country== "Spain"	~	"ES"	,
      Country== "Finland"	~	"FI"	,
      Country== "France"~	"FR",
      Country== "United Kingdom"	~	"GB"	,
      Country== "Hungary"	~	"HU"	,
      Country== "Ireland"	~	"IE"	,
      Country== "Netherlands"	~	"NL"	,
      Country== "Norway"	~	"NO"	,
      Country== "Poland"  ~	"PL"	,
      Country== "Portugal"  ~	"PT"	,
      Country== "Sweden"  ~	"SE"	,
      TRUE              ~ "ERROR"
    ))
gdp$Country <- NULL

final <- left_join(final, gdp, by = c("round", "cntry"), )

#saving the dataset 
output_directory_R <-paste0( path, "/","Data","/", "dataset_without_imput",".RData")
save(final, file = output_directory_R)






### IMPUTATION
path<-""
setwd(path)
output_directory_R <-paste0( path, "/","Data","/", "dataset_without_imput",".RData")
load(output_directory_R)
final <- final[, !names(final) %in% c("z_sclr_se", "z_ali_se", "sclr_se", "ali_se")]

library(mice)
pred <- quickpred(final, exc= names(select(final, -starts_with("gdp"), -starts_with("v2x_egaldem"), -starts_with("hhdi"))) 
                  ) #selecting predictors for the imputation matrix
imp <- mice(final, m = 5, print =F, 
            method = c(rep("", 14), "pmm",""), #impute only GINI
            pred = pred, 
            seed = 6241)
imp$method
check  <- complete(imp,1) #checking an imputed dataset
plot(imp)

### MODELLING
library(brms)
##polyarchy with gdp
f1 <-  brm(
  bf(mvbind(z_ali, z_sclr) ~ scale(v2x_polyarchy) + scale(gdp), nu=2) + set_rescor(FALSE),
  data = final, 
  family = student,
  prior = c(set_prior("normal(0, 1)", class = "b", resp = c("zali", "zsclr")),
            set_prior("normal(0, 0.5)", class = "Intercept", resp = c("zali", "zsclr"))),
  iter = 2000, warmup = 500, chains = 4, cores = 3, 
  seed = 210191)
out1 <- paste0( path, "/","Results","/", "fit1",".rda")
save(f1, file = out1)

plot(f1)

##polyarchy without gdp
f1.1 <-  brm(
  bf(mvbind(z_ali, z_sclr) ~ scale(v2x_polyarchy), nu=2) + set_rescor(FALSE),
  data = final, 
  family = student,
  prior = c(set_prior("normal(0, 1)", class = "b", resp = c("zali", "zsclr")),
            set_prior("normal(0, 0.5)", class = "Intercept", resp = c("zali", "zsclr"))),
  iter = 2000, warmup = 500, chains = 4, cores = 3, 
  seed = 210191)
out1.1 <- paste0( path, "/","Results","/", "fit1.1",".rda")
save(f1.1, file = out1.1)

plot(f1.1)


##gini
f2 <- brm_multiple(
  bf(mvbind(z_ali, z_sclr) ~ scale(GINI), nu=2) + set_rescor(FALSE),
  data = imp, 
  family = student,
  prior = c(set_prior("normal(0, 1)", class = "b", resp = c("zali", "zsclr")),
            set_prior("normal(0, 0.5)", class = "Intercept", resp = c("zali", "zsclr"))),
  iter = 2000, warmup = 500, chains = 4, cores = 3, 
  seed = 210191)
out2 <- paste0( path, "/","Results","/", "fit2",".rda")
save(f2, file = out2)

round(fit_imp1$rhats, 2)#additional check
plot(f2)


##gdp
f3 <- brm(
  bf(mvbind(z_ali, z_sclr) ~ scale(gdp), nu=2) + set_rescor(FALSE),
  data = final, 
  family = student,
  prior = c(set_prior("normal(0, 1)", class = "b", resp = c("zali", "zsclr")),
            set_prior("normal(0, 0.5)", class = "Intercept", resp = c("zali", "zsclr"))),
  iter = 2000, warmup = 500, chains = 4, cores = 3, 
  seed = 210191)
out3 <- paste0( path, "/","Results","/", "fit3",".rda")
save(f3, file = out3)

plot(f3)


### PREPARING DATA FOR PLOTTING
path<-""
setwd(path)
load(out1)
load(out1.1)
load(out2)
load(out3)

library(brms)

s1 <- summary(f1)
b1 <- bayes_R2(f1)

s1.1 <- summary(f1.1)
b1.1 <- bayes_R2(f1.1)

s2 <- summary(f2)
b2 <- bayes_R2(f2) #just on 1

s3 <- summary(f3)
b3 <- bayes_R2(f3) 


fe_1<- s1[["fixed"]][c(3,5), c(1,3,4)]
fe_1.1<- s1.1[["fixed"]][c(3,4), c(1,3,4)]
fe_2<- s2[["fixed"]][c(3,4), c(1,3,4)]
fe_3<- s3[["fixed"]][c(3,4), c(1,3,4)]
fe <- cbind(rep(c("Alignment", "Scalar"), 4), 
            as.data.frame(rbind(fe_1.1, fe_1, fe_2, fe_3)), 
            c(rep("Polyarchy", 2), rep("Polyarchy|GDP", 2), rep("GINI", 2), rep("GDP per capita", 2))) 
colnames(fe) <- c("Model", "Est", "Lower", "Upper", "Key")

r2_1<- b1[, c(1,3,4)]
r2_1.1<- b1.1[, c(1,3,4)]
r2_2<- b2[, c(1,3,4)]
r2_3<- b3[, c(1,3,4)]
r2 <- cbind(rep(c("Alignment", "Scalar"), 4), 
            as.data.frame(rbind(r2_1.1, r2_1,  r2_2, r2_3)), 
            c( rep("Polyarchy", 2), rep("Polyarchy|GDP", 2),rep("GINI", 2), rep("GDP per capita", 2))) 
colnames(r2) <- c("Model", "Est", "Lower", "Upper", "Key")

out4 <- paste0( path, "/","Results","/", "fe",".rda")
save(fe, file = out4)
out5 <- paste0( path, "/","Results","/", "r2",".rda")
save(r2, file = out5)

### PLOTTING
load(out4)
load(out5)



library(ggplot2)
library(egg)
#Betas
windowsFonts(A = windowsFont("Times New Roman"))
p1 <- ggplot(fe, aes(x = Est, y = Model, xmin = Lower, xmax = Upper)) +
  geom_point(aes(x = Est,
                 y = Model), size = 2) +
  geom_errorbarh(height=.1)+
  geom_vline(xintercept = 0,  color = "grey")+
  coord_cartesian(xlim = c(-1, 1)) +
  xlab("Standardized regression coefficients") +
  theme_bw(base_family="A") +
  theme(
    panel.grid.major.y = element_blank(),
    panel.grid.minor.y = element_blank(),
    axis.ticks=element_blank(),
    axis.text.x=element_text(colour = "black", size = 9.5),
    axis.text.y=element_text(colour = "black", size = 9.5),
    axis.title.x=element_text(size = rel(0.9))
  )+
  facet_wrap(~Key, ncol=1)
p1 <- grid.arrange(grobs = lapply(
  list(p1),
  set_panel_size,
  width = unit(6, "cm"),
  height = unit(2, "cm")
))

out <-paste0( path, "/","Results","/", "Betas_vg",".tiff")
ggsave(p1, filename=out, units = "mm", width = 92, height = 125, device='tiff', dpi=300)


#r2
p2<- ggplot(r2, aes(x = Est, y = Model, xmin = Lower, xmax = Upper)) +
  geom_point(aes(x = Est,
                 y = Model), size = 2) +
  geom_errorbarh(height=.1)+
  coord_cartesian(xlim = c(0, 1)) +
  xlab(expression(paste("Bayesian ", R^{2}))) +
  theme_bw(base_family="A") +
  theme(
    panel.grid.major.y = element_blank(),
    panel.grid.minor.y = element_blank(),
    axis.ticks=element_blank(),
    axis.text.x=element_text(colour = "black", size = 9.5, ),
    axis.text.y=element_blank(),
    axis.title.y =element_blank(),
    axis.title.x=element_text(size = rel(0.9))
  )+
  facet_wrap(~Key, ncol=1)
p2 <- grid.arrange(grobs = lapply(
  list(p2),
  set_panel_size,
  width = unit(6, "cm"),
  height = unit(2, "cm")
))

out <-paste0( path, "/","Results","/", "r2_vg",".tiff")
ggsave(p2, filename=out, units = "mm", width = 70, height = 125, device='tiff', dpi=300)
