# R syntax to produce Figure 1. 
#
# "Accounting for cross-country-cross-time variations in measurement invariance testing. A case of political participation"





rm(list=ls())
library(haven)
library(dplyr)
library(rio)
library(tidyr)



path<-""
setwd(path)

# loading the Mplus object;
library(MplusAutomation) 
scalar <- readModels(target = "", recursive = FALSE, filefilter,
           what = "all", quiet = FALSE)

sc_df <- data.frame(
model = rep("scalar", length(scalar[["parameters"]][["unstandardized"]][["LatentClass"]])) , 
gr = scalar[["parameters"]][["unstandardized"]][["LatentClass"]],
param = scalar[["parameters"]][["unstandardized"]][["paramHeader"]],
est = scalar[["parameters"]][["unstandardized"]][["est"]],
se = scalar[["parameters"]][["unstandardized"]][["se"]])

ss <- as.character(1:120)
sc_df_r <- sc_df %>%
  filter(param == "Means") %>%
  filter(gr %in% ss)

ali <- readModels(target = "", recursive = FALSE, filefilter,
                     what = "all", quiet = FALSE)

al_df <- data.frame(
  model = rep("ali", length(ali[["parameters"]][["unstandardized"]][["LatentClass"]])) , 
  gr = ali[["parameters"]][["unstandardized"]][["LatentClass"]],
  param = ali[["parameters"]][["unstandardized"]][["paramHeader"]],
  est = ali[["parameters"]][["unstandardized"]][["est"]],
  se = ali[["parameters"]][["unstandardized"]][["se"]])



ss <- as.character(1:120)
al_df_r <- al_df %>%
  filter(param == "Means") %>%
  filter(gr %in% ss)
 
avr_df <- rbind(sc_df_r, al_df_r)
avr_df$gr <- as.numeric(avr_df$gr)
 
avr_df <- avr_df %>%
mutate(
  cntry = case_when(
    gr	%in%	1	:	8	~	"BE"	,
    gr	%in%	9	:	16	~	"CH"	,
    gr	%in%	17	:	24	~	"DE"	,
    gr	%in%	25	:	32	~	"EE"	,
    gr	%in%	33	:	40	~	"ES"	,
    gr	%in%	41	:	48	~	"FI"	,
    gr	%in%	49	:	56	~	"FR"	,
    gr	%in%	57	:	64	~	"GB"	,
    gr	%in%	65	:	72	~	"HU"	,
    gr	%in%	73	:	80	~	"IE"	,
    gr	%in%	81	:	88	~	"NL"	,
    gr	%in%	89	:	96	~	"NO"	,
    gr	%in%	97	:	104	~	"PL"	,
    gr	%in%	105	:	112	~	"PT"	,
    gr	%in%	113	:	120	~	"SE"	,
    TRUE              ~ "ERROR"
  ))
  
avr_df <- avr_df %>%
  mutate(
    round = case_when(
      gr	%in%	seq	(	1	,	113	,	8)	~	2	,
      gr	%in%	seq	(	2	,	114	,	8)	~	3	,
      gr	%in%	seq	(	3	,	115	,	8)	~	4	,
      gr	%in%	seq	(	4	,	116	,	8)	~	5	,
      gr	%in%	seq	(	5	,	117	,	8)	~	6	,
      gr	%in%	seq	(	6	,	118	,	8)	~	7	,
      gr	%in%	seq	(	7	,	119	,	8)	~	8	,
      gr	%in%	seq	(	8	,	120	,	8)	~	9	,
      TRUE              ~ 999
    ))
avr_df <- avr_df %>%
  mutate(cr = paste0(cntry, round,""))



final <- data.frame(
  gr = avr_df$gr[1:120],
  round = avr_df$round[1:120],
  cntry = avr_df$cntry[1:120],
  sclr_avrg = avr_df$est[1:120],
  sclr_se = avr_df$se[1:120],
  ali_avrg = avr_df$est[121:240],
  ali_se = avr_df$se[121:240],
  cr = avr_df$cr[1:120]
)

#standardizing
final$z_sclr <- (final$sclr_avrg - mean(final$sclr_avrg, na.rm = T))/sd(final$sclr_avrg, na.rm = T)
final$z_sclr_se <- final$sclr_se /sd(final$sclr_avrg, na.rm = T)


final$z_ali <- (final$ali_avrg - mean(final$ali_avrg, na.rm = T))/sd(final$ali_avrg, na.rm = T)
final$z_ali_se <-  final$ali_se /sd(final$ali_avrg, na.rm = T)

final$z_sclr[final$cr == "SE9"] <- NA
final$z_sclr_se[final$cr == "SE9"] <- NA

final$z_ali[final$cr == "NO9"] <- NA
final$z_ali_se[final$cr == "NO9"] <- NA

output_directory_R <-paste0( path, "/","Data","/", "dataset",".RData")
save(final, file = output_directory_R)



### PLOTTING 

path<-""
setwd(path)
output_directory_R <-paste0( path, "/","Data","/", "dataset",".RData")
load(output_directory_R)

# Creating a year variable
library(tidyverse)
final <- final %>%
  mutate(
    year = case_when(
      round == 2	~	2004,
      round == 3	~ 2006,
      round == 4	~ 2008,
      round == 5	~ 2010,
      round == 6	~ 2012,
      round == 7	~ 2014,
      round == 8	~ 2016,
      round == 9	~ 2018,
      TRUE              ~ 999
    ))

#Font
windowsFonts(A = windowsFont("Times New Roman"))


## Panel for trends per country
# Wide format data frame:
wideDF <- data.frame(cntry=final$cntry , year = final$year, 
                     ali_lo= final$z_ali - 1.96*final$z_ali_se , ali_avrg=final$z_ali , ali_hi=final$z_ali + 1.96*final$z_ali_se,
                     sclr_lo= final$z_sclr - 1.96*final$z_sclr_se , sclr_avrg=final$z_sclr , sclr_hi=final$z_sclr + 1.96*final$z_sclr_se)

# Long format data frame:
longDF = pivot_longer( wideDF , cols=!c(cntry,year) , names_to="line" , values_to="y" )
longDF$fill = NA
longDF$fill[grep( "ali" , longDF$line  )] = "ali"
longDF$fill[grep( "sclr" , longDF$line  )] = "sclr"


longDF1 <- longDF %>% 
  mutate(line = gsub("ali_","",gsub("sclr_","",line))) %>%
  pivot_wider(id_cols = c(cntry,year, fill), names_from = line, values_from = y)

long_11 <- longDF1 %>%
  filter(!cntry %in% c("PL", "PT", "HU", "EE"))


library(ggplot2)
library(tidyverse)
library(egg)
# For the 11
p2 <- ggplot(long_11) +
  geom_ribbon(aes(x=year, ymin=lo, ymax=hi, fill = fill), alpha=0.7, show.legend = F) +
  geom_line(aes(x=year, y=avrg, linetype = fill), show.legend = F) +
  labs( title="Countries with highest means" , x="Year", y="Country Means" ) +
  scale_linetype_manual("Model",values = c(ali = "solid", sclr = "dashed"),labels= c("Alignment", "Scalar")) + 
  scale_fill_manual("Model",values = c(ali = "grey65", sclr = "grey30"), labels= c("Alignment", "Scalar"))+
  facet_wrap(~ cntry, ncol = 2) +
  coord_cartesian(ylim = c(-1, 2)) +
  scale_y_continuous(breaks = c(-3 ,-2,  -1,  0,  1,  2))+
  facet_wrap(~ cntry, ncol = 3) +
  theme_bw(base_family="A")+ 
  theme(
    axis.title.x=element_blank(),
    legend.direction = "horizontal", 
    legend.position = "bottom",
    plot.title = element_text(hjust=0.5)
  )


p2  <- grid.arrange(grobs = lapply(
  list(p2),
  set_panel_size,
  width = unit(4, "cm"),
  height = unit(2, "cm")
))
out1 <-paste0( path, "/","Results","/", "Panel11",".tiff")
ggsave(p2, filename=out1, units = "mm", width = 160, height = 130, device='tiff', dpi=300)



# For the 4
long_4 <- longDF1 %>%
  filter(cntry %in% c("PL", "PT", "HU", "EE"))
p3 <- ggplot(long_4) +
  geom_ribbon(aes(x=year, ymin=lo, ymax=hi, fill = fill), alpha=0.5) +
  geom_line(aes(x=year, y=avrg, linetype = fill)) +
  labs( title="Countries with lowest means" , x="", y="Country Means" ) +
  scale_linetype_manual("Model",values = c(ali = "solid", sclr = "dashed"),labels= c("Alignment", "Scalar")) + 
  scale_fill_manual("Model",values = c(ali = "grey65", sclr = "grey30"), labels= c("Alignment", "Scalar"))+
  facet_wrap(~ cntry, ncol = 3) +
  coord_cartesian(ylim = c(-4.7, 1)) +
  scale_y_continuous(breaks = c(-5, -4 , -3, -2,  -1,  0,  1))+
  facet_wrap(~ cntry, ncol = 3) +
  theme_bw(base_family="A")+ 
  theme(
    legend.direction = "horizontal", 
    legend.position = "bottom",
    plot.title = element_text(hjust=0.5),
    legend.box.margin=margin(-25,-25,-25,-25),
    legend.margin=margin(0,0,0,0)
  )

p3 <- grid.arrange(grobs = lapply(
  list(p3),
  set_panel_size,
  width = unit(4, "cm"),
  height = unit(2, "cm")
))

out2 <-paste0( path, "/","Results","/", "Panel4",".tiff")
ggsave(p3, filename=out2, units = "mm", width = 160, height = 90, device='tiff', dpi=300)


