# R syntax to produce table 2. The syntax produces additional tests and indices that are unreported in the main text. 
#
# "Accounting for cross-country-cross-time variations in measurement invariance testing. A case of political participation"




rm(list=ls())
library(haven)
library(dplyr)
library(rio)
library(tidyr)



path<-""
setwd(path)

# loading the data; double slash (//)since the directory
# of the dataset is different than the working directory 
load("C://Users/....//ESS_RED.rda")

#excluding Slovenia 
ESS_RED <- ESS_RED[ESS_RED$cntry != "SI",]


#####################################################

ESS_RED$essround <- as.factor(as.character(ESS_RED$essround))

levels(ESS_RED$essround)

cntry <- unique(ESS_RED$cntry)

MI_T_8 <- list()
for (i in 1:length(cntry)){
  
  ESS <- ESS_RED[ESS_RED$cntry == cntry[i],]
  
  #Fit statistics cannot be computed when there are missing data.
  ESS <- ESS %>%
    filter_at(vars(contplt:bctprd), all_vars(!is.na(.)))
  
  library(mirt)
  models <- 'F1 = 1-7'
  
  mod_configural <- multipleGroup(ESS[,5:11], models, group = ESS$essround,
                                  technical = list(NCYCLES = 10000, removeEmptyRows=TRUE)) #completely separate analyses
  
  mod_metric <- multipleGroup(ESS[,5:11], models, group = ESS$essround, invariance=c('slopes'),
                              technical = list(NCYCLES = 10000, removeEmptyRows=TRUE)) #equal slopes
  #equal intercepts, free variance and means
  mod_scalar1 <- multipleGroup(ESS[,5:11], models, group = ESS$essround, 
                               invariance=c('slopes', 'intercepts', 'free_var','free_means'),
                               technical = list(NCYCLES = 10000, removeEmptyRows=TRUE))
  # 2x Likelihood Ratio Tests
  lrt_x2_mc <- anova(mod_metric, mod_configural)[2, c("X2", "p")] #equal slopes only
  lrt_x2_s1m <- anova(mod_scalar1, mod_metric)[2, c("X2", "p")] #equal intercepts, free variance and mean
  
  e1 <- rep(NA, ncol(lrt_x2_s1m))
  
  lrt_x2_all <- rbind.data.frame(e1, lrt_x2_mc, lrt_x2_s1m)
  
  #limited information fit statistics
  fit_c <- M2(mod_configural)
  fit_m <- M2(mod_metric)
  fit_s1 <- M2(mod_scalar1)
  
  fit_all <- rbind.data.frame(fit_c, fit_m, fit_s1)
  
  e2 <- rep(NA, ncol(fit_c ))
  d_mc <- fit_all[2,] - fit_all[1,] 
  d_s1m <- fit_all[3,] - fit_all[2,]
  
  d_all <- rbind.data.frame(e2, d_mc, d_s1m)
  d_all <- d_all[, c("RMSEA", "TLI", "CFI")]
  
  # convergence info
  cc <- mod_configural@OptimInfo[["converged"]]
  cm <- mod_metric@OptimInfo[["converged"]]
  cs1 <- mod_scalar1@OptimInfo[["converged"]]
  
  c_all <- rbind(cc, cm, cs1)
  
  #data frame containing all information; output contains more information than included in the table
  mi_lev <- c("configural", "metric", "scalar")
  cy <- rep(cntry[i], nrow(d_all))
  
  MI <- cbind.data.frame(mi_lev ,cy, lrt_x2_all, d_all, c_all)

  MI_T_8[[i]] <- MI  

  }
MI_T_8_ALL <- as.data.frame(do.call(rbind, MI_T_8))
View(MI_T_8_ALL)

rownames(MI_T_8_ALL) <- 1:nrow(MI_T_8_ALL) 
colnames(MI_T_8_ALL) <- c("Invariance_Level", "Country", "2xLRT", "Sig", "RMSEA_delta",
                          "TLI_delta", "CFI_delta", "Converged?")

output_directory <-paste0( path, "/", "Results", "/" , "MI_T_8_mirt",".csv")
write.csv2(MI_T_8_ALL, output_directory)

