****Self-Esteem****

recode per1i2 (1=5) (2=4) (3=3) (4=2) (5=1), gen(per1i2_r)
lab var per1i2_r "rekodiert (invertiert): Manchmal denke ich, dass ich wertlos bin (Frage 192)"
lab def per1i2_r 1 "1 trifft voll und ganz zu" 5 "5 trifft überhaupt nicht zu"  
lab val per1i2_r per1i2_r

egen help=rownonmiss(per1i2_r per1i7 per1i13)
* egen selfesteem=rowmean(per1i2_r per1i7 per1i13) if inlist(help,2,3)
alpha per1i2_r per1i7 per1i13, gen(selfesteem)
drop help 
lab var selfesteem "Ankerperson: Selbstwert (Selbsteinschätzung)"
lab def selfesteem 1 "1 niedrig" 5 "5 hoch"
lab val selfesteem selfesteem

****Depressiveness****

foreach var of varlist per2i2 per2i7 per2i8 per2i9 per2i10 {
    recode `var'(1=4) (2=3) (3=2) (4=1), gen(`var'_r) 
	lab def `var'_r 1 "1 fast immer" 4 "4 fast nie" 
	lab val `var'_r `var'_r
} 

lab var per2i2_r "rekodiert (invertiert): Bin glücklich (Frage 195)"
lab var per2i7_r "rekodiert (invertiert): Fühle mich gut (Frage 195)"
lab var per2i8_r "rekodiert (invertiert): Fühle mich sicher (Frage 195)"
lab var per2i9_r "rekodiert (invertiert): Bin ruhig und gelassen (Frage 195)"
lab var per2i10_r  "rekodiert (invertiert): Leben macht mir Spass (Frage 195)"
                
egen help=rownonmiss(per2i1 per2i2_r per2i3 per2i4 per2i5 per2i6 per2i7_r per2i8_r per2i9_r per2i10_r)
* egen depressive=rowmean(per2i1 per2i2_r per2i3 per2i4 per2i5 per2i6 per2i7_r per2i8_r per2i9_r per2i10_r) if inrange(help,6,10)
alpha per2i1 per2i2_r per2i3 per2i4 per2i5 per2i6 per2i7_r per2i8_r per2i9_r per2i10_r, gen(depressive)
drop help 
lab var depressive "Ankerperson: Depressivität(Selbsteinschätzung)"
lab def depressive 1 "1 niedrig" 4 "4 hoch"
lab val depressive depressive

*****Economic Deprivation*****

****Economic Deprivation Household****

egen help=rownonmiss(inc27i2 inc27i3)
* egen ecodep2_hh=rowmean(inc27i2 inc27i3) if help==2
alpha inc27i2 inc27i3, gen(ecodep2_hh)
drop help 
lab var ecodep2_hh "Ankerperson: Ökonomische Deprivation Haushalt"
lab def ecodep2_hh 1 "1 niedrig" 5 "5 hoch"
lab val ecodep2_hh ecodep2_hh


*****Dark Triad*****

****Machiavellianism****

egen help=rownonmiss(per8i1 per8i2 per8i3)
tab help 
* egen machiav=rowmean(per8i1 per8i2 per8i3) if help==3
alpha per8i1 per8i2 per8i3, gen(machiav)
drop help 
lab var machiav "Machiavellismus"
lab def machiav  1 "1 trifft voll und ganz zu" 5 "5 trifft überhaupt nicht zu"
lab val machiav machiav


****Psychopathy****

egen help=rownonmiss(per8i2 per8i4 per8i6)
* egen psychop=rowmean(per8i2 per8i4 per8i6) if help==3
alpha per8i2 per8i4 per8i6, gen(psychop)
drop help 
lab var psychop "Psychotizismus"
lab def psychop  1 "1 trifft voll und ganz zu" 5 "5 trifft überhaupt nicht zu"
lab val psychop psychop

****Narcissism****

***Rivalry***

egen help=rownonmiss(per8i7 per8i9 per8i12)
* egen riv=rowmean(per8i7 per8i9 per8i12) if help==3
alpha per8i7 per8i9 per8i12, gen(riv)
drop help 
lab var riv "Rivalität"
lab def riv  1 "1 trifft voll und ganz zu" 5 "5 trifft überhaupt nicht zu"
lab val riv riv

***Admiration***

egen help=rownonmiss(per8i8 per8i10 per8i11)
* egen adm=rowmean(per8i8 per8i10 per8i11) if help==3
alpha per8i8 per8i10 per8i11, gen(adm)
drop help 
lab var adm "Wertschätzung"
lab def adm  1 "1 trifft voll und ganz zu" 5 "5 trifft überhaupt nicht zu"
lab val adm adm


****Trust****

recode val7i2 (1=5) (2=4) (3=3) (4=2) (5=1), gen(val7i2_r)
lab var val7i2_r "rekodiert (invertiert): Bei Fremden besser vorsichtig sein, bevor man ihnen vertraut (Frage 10)"
lab def val7i2_r 1 "1 stimme überhaupt nicht zu" 5 "5 stimme voll und ganz zu" 
lab val val7i2_r val7i2_r

egen help=rownonmiss(val7i1 val7i2_r)
* egen trust=rowmean(val7i1 val7i2_r) if help==2
alpha val7i1 val7i2_r, gen(trust)
drop help 
lab var trust "Vertrauen"
lab def trust 1 "1 stimme überhaupt nicht zu" 5 "5 stimme voll und ganz zu"
lab val trust trust


****Refreshment sample*****

****Big Five****

***Neuroticism***

recode per3i9 (1=5) (2=4) (3=3) (4=2) (5=1), gen(per3i9_r)
lab var per3i9_r "rekodiert (invertiert): Entspannt, lasse mich durch Stress nicht aus Ruhe bringen (Frage 196)"
lab def per3i9_r 1 "1 sehr zutreffend" 5 "5 sehr unzutreffend" 
lab val per3i9_r per3i9_r

mvdecode per3i9_r per3i4 per3i14 per3i19, mv(-7/-1)

egen help=rownonmiss(per3i9_r per3i4 per3i14 per3i19)
* egen neurot=rowmean(per3i9_r per3i4 per3i14 per3i19) if inlist(help,3,4)
alpha per3i9_r per3i4 per3i14 per3i19, gen(neurot)
drop help 
lab var neurot "Ankerperson: Neurotizismus, Big Five"
lab def neurot 1 "1 niedrig" 5 "5 hoch"
lab val neurot neurot

****Extraversion****

foreach var of varlist per3i1 per3i11 {
    recode `var' (1=5) (2=4) (3=3) (4=2) (5=1) , gen(`var'_r) 
	lab def `var'_r 1 "1 sehr zutreffend" 5 "5 sehr unzutreffend" 
	lab val `var'_r `var'_r
} 

lab var per3i1_r "rekodiert (invertiert): Bin zurückhaltend, reserviert (Frage 196)"
lab var per3i11_r "rekodiert (invertiert): Stille Typ, wortkarg (Frage 196)"

mvdecode per3i1_r per3i11_r per3i6 per3i16, mv(-7/-1)

egen help=rownonmiss(per3i1_r per3i11_r per3i6 per3i16)
* egen extrav=rowmean(per3i1_r per3i11_r per3i6 per3i16) if inlist(help,3,4)
alpha per3i1_r per3i11_r per3i6 per3i16, gen(extrav)
drop help 
lab var extrav "Ankerperson: Extraversion, Big Five"
lab def extrav 1 "1 niedrig" 5 "5 hoch"
lab val extrav extrav

****Agreeableness****

foreach var of varlist per3i2 per3i12 per3i17 {
    recode `var' (1=5) (2=4) (3=3) (4=2) (5=1) , gen(`var'_r) 
	lab def `var'_r 1 "1 sehr zutreffend" 5 "5 sehr unzutreffend" 
	lab val `var'_r `var'_r
} 

lab var per3i2_r "rekodiert (invertiert): Neigung andere zu kritisieren (Frage 196)"
lab var per3i12_r "rekodiert (invertiert): Kalt und distanziert (Frage 196)"
lab var per3i17_r "rekodiert (invertiert): Kann mich schroff und abweisend verhalten (Frage 196)"

mvdecode per3i2_r per3i12_r per3i17_r per3i7, mv(-7/-1)

egen help=rownonmiss(per3i2_r per3i12_r per3i17_r per3i7)
* egen agreeable=rowmean(per3i2_r per3i12_r per3i17_r per3i7) if inlist(help,3,4)
alpha per3i2_r per3i12_r per3i17_r per3i7, gen(agreeable)
drop help 
lab var agreeable "Ankerperson: Verträglichkeit, Big Five"
lab def agreeable 1 "1 niedrig" 5 "5 hoch"
lab val agreeable agreeable

****Conscientiousness****

recode per3i8  (1=5) (2=4) (3=3) (4=2) (5=1), gen(per3i8_r)
lab var per3i8_r "rekodiert (invertiert): Bequem und neige zur Faulheit (Frage 196)"
lab def per3i8_r 1 "1 sehr zutreffend" 5 "5 sehr unzutreffend" 
lab val per3i8_r per3i8_r

mvdecode per3i8_r per3i3 per3i13 per3i18, mv(-7/-1)

egen help=rownonmiss(per3i8_r per3i3 per3i13 per3i18)
* egen conscient=rowmean(per3i8_r per3i3 per3i13 per3i18) if inlist(help,3,4)
alpha per3i8_r per3i3 per3i13 per3i18, gen(conscient)
drop help 
lab var conscient "Ankerperson: Gewissenhaftigkeit, Big Five"
lab def conscient 1 "1 niedrig" 5 "5 hoch"
lab val conscient conscient

****Openness****

recode per3i21 (1=5) (2=4) (3=3) (4=2) (5=1), gen(per3i21_r)
lab var per3i21_r "rekodiert (invertiert): Nur wenig künstlerisches Interesse (Frage 196)"
lab def per3i21_r 1 "1 sehr zutreffend" 5 "5 sehr unzutreffend" 
lab val per3i21_r per3i21_r

mvdecode per3i21_r per3i5 per3i10 per3i15 per3i20, mv(-7/-1)

egen help=rownonmiss(per3i21_r per3i5 per3i10 per3i15 per3i20)
* egen openness=rowmean(per3i21_r per3i5 per3i10 per3i15 per3i20) if inrange(help,3,5)
alpha per3i21_r per3i5 per3i10 per3i15 per3i20, gen(openness)
drop help 
lab var openness "Ankerperson: Offenheit für Erfahrungen, Big Five"
lab def openness 1 "1 niedrig" 5 "5 hoch"
lab val openness openness

*****SDQ-Behavior of the Anchor (Refreshment sample and stepups below 18)*****

****Conduct problems****

recode sdq1i7 (0=2) (1=1) (2=0), gen(sdq1i7_r)
label var sdq1i7_r "rekodiert (invertiert): Tue normalerweise, was man mir sagt (Frage 197)"
label def sdq1i7_r 0 "0 trifft eindeutig zu" 1 "1 trifft teilweise zu" 2 "2 trifft nicht zu"  
label val sdq1i7_r sdq1i7_r

egen help=rownonmiss(sdq1i5 sdq1i7_r sdq1i12 sdq1i18 sdq1i22)
* egen conduct=rowmean(sdq1i5 sdq1i7_r sdq1i12 sdq1i18 sdq1i22) if inrange(help,3,5)
alpha sdq1i5 sdq1i7_r sdq1i12 sdq1i18 sdq1i22, gen(conduct)
drop help
label var conduct "Anker: SDQ-Verhalten des Ankers: Verhaltensprobleme (Sicht des Ankers)"
label def conduct 0 "0 niedrig" 2 "2 hoch"
label val conduct conduct

****Emotional symptoms****

egen help=rownonmiss(sdq1i3 sdq1i8 sdq1i13 sdq1i16 sdq1i24)
* egen emotion=rowmean(sdq1i3 sdq1i8 sdq1i13 sdq1i16 sdq1i24) if inrange(help,3,5)
alpha sdq1i3 sdq1i8 sdq1i13 sdq1i16 sdq1i24, gen(emotion)
drop help
label var emotion "Anker: SDQ-Verhalten des Ankers: Emotionale Probleme (Sicht des Ankers)"
label def emotion 0 "0 niedrig" 2 "2 hoch"
label val emotion emotion

****Prosocial behaviour****
egen help=rownonmiss(sdq1i1 sdq1i4 sdq1i9 sdq1i17 sdq1i20)
* egen prosoc=rowmean(sdq1i1 sdq1i4 sdq1i9 sdq1i17 sdq1i20) if inrange(help,3,5)
alpha sdq1i1 sdq1i4 sdq1i9 sdq1i17 sdq1i20, gen(prosoc)
drop help
label var prosoc "Anker: SDQ-Verhalten des Ankers: Prosoziales Verhalten (Sicht des Ankers)"
label def prosoc 0 "0 niedrig" 2 "2 hoch"
label val prosoc prosoc

****Hyperactivity****
recode sdq1i21 (0=2) (1=1) (2=0), gen(sdq1i21_r)
label var sdq1i21_r "rekodiert (invertiert): Denke nach, bevor ich handele (Frage 197)"
label def sdq1i21_r 0 "0 trifft eindeutig zu" 1 "1 trifft teilweise zu" 2 "2 trifft nicht zu"  
label val sdq1i21_r sdq1i21_r

recode sdq1i25 (0=2) (1=1) (2=0), gen(sdq1i25_r)
label var sdq1i25_r "rekodiert (invertiert): Führe Aufgaben zu Ende; kann mich lange genug konzentrieren (Frage 197)"
label def sdq1i25_r 0 "0 trifft eindeutig zu" 1 "1 trifft teilweise zu" 2 "2 trifft nicht zu"  
label val sdq1i25_r sdq1i25_r

egen help=rownonmiss(sdq1i2 sdq1i10 sdq1i15 sdq1i21_r sdq1i25_r)
egen hyper=rowmean(sdq1i2 sdq1i10 sdq1i15 sdq1i21_r sdq1i25_r) if inrange(help,3,5)
drop help
label var hyper "Anker: SDQ-Verhalten des Ankers: Hyperaktivität (Sicht des Ankers)"
label def hyper 0 "0 niedrig" 2 "2 hoch"
label val hyper hyper

****Peer problems****

recode sdq1i11 (0=2) (1=1) (2=0), gen(sdq1i11_r)
label var sdq1i11_r "rekodiert (invertiert): Ich habe einen oder mehrere gute Freunde oder Freundinnen (Frage 197)"
label def sdq1i11_r 0 "0 trifft eindeutig zu" 1 "1 trifft teilweise zu" 2 "2 trifft nicht zu"  
label val sdq1i11_r sdq1i11_r

recode sdq1i14 (0=2) (1=1) (2=0), gen(sdq1i14_r)
label var sdq1i14_r "rekodiert (invertiert): Im Allgemeinen bin ich bei Gleichaltrigen beliebt (Frage 197)"
label def sdq1i14_r 0 "0 trifft eindeutig zu" 1 "1 trifft teilweise zu" 2 "2 trifft nicht zu"  
label val sdq1i14_r sdq1i14_r

egen help=rownonmiss(sdq1i6 sdq1i11_r sdq1i14_r sdq1i19 sdq1i23)
egen peerprob=rowmean(sdq1i6 sdq1i11_r sdq1i14_r sdq1i19 sdq1i23) if inrange(help,3,5)
drop help
label var peerprob "Anker: SDQ-Verhalten: Verhaltensprobleme mit Peers (Sicht des Ankers)"
label def peerprob 0 "0 niedrig" 2 "2 hoch"
label val peerprob peerprob


exit			// Since it takes some time, I do not run the following every round


*****Missing pattern
preserve
use "$data2/anchor11.dta", clear
drop demodiff-dobd
*6.a. Missings fuer die Determinante "Item-Nonresponse intime Fragen"
*(-2) und (-1) sind Verweigerungen
egen intimnr=anycount(sex* frt* inc*), v(-2 -1)
egen intim_3=anycount(sex* frt* inc*),  v(-3)
egen intimN=rownonmiss(sex* frt* inc*)
sum intim* 
gen intim_prop = (intimnr) / (intimN - intim_3)
label var intim_prop "Item-Nonresponse intime qu. - proportion"

twoway histogram intim_prop, frac recast(line) name(intim, replace) nodraw

*Missings fuer die Determinante "Item-Nonresponse alle Fragen"
*Systemvariablen und Event-History-Daten loeschen, um Anzahl der Variablen zu reduzieren

egen allnr1=anycount(id-rtr17k15e10ey), v(-2 -1)
egen allnr2=anycount(rtr19k1 - int10i3), v(-2 -1)
egen all_31=anycount(id-rtr17k15e10ey),  v(-3)
egen all_32=anycount(rtr19k1 - int10i3),  v(-3)
egen allN1=rownonmiss(id-rtr17k15e10ey)
egen allN2=rownonmiss(rtr19k1 - int10i3)

sum all* 
gen all_prop = (allnr1 + allnr2) / (allN1 + allN2 - all_31 - all_32)
label var all_prop "Item-Nonresponse all qu. - proportion"

twoway histogram all_prop, frac recast(line) name(all, replace) nodraw
graph combine intim all, ycomm

sum all_prop intim_prop
rename (all_prop intim_prop) (miss_all miss_intim)
keep id miss_all miss_intim
save "$temp/missings.dta", replace
restore





















